/* contacts-list-pane.c generated by valac 0.56.0, the Vala compiler
 * generated from contacts-list-pane.vala, do not modify */

/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "contacts.h"
#include <folks/folks.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTACTS_TYPE_LIST_PANE (contacts_list_pane_get_type ())
#define CONTACTS_LIST_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_LIST_PANE, ContactsListPane))
#define CONTACTS_LIST_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_LIST_PANE, ContactsListPaneClass))
#define CONTACTS_IS_LIST_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_LIST_PANE))
#define CONTACTS_IS_LIST_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_LIST_PANE))
#define CONTACTS_LIST_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_LIST_PANE, ContactsListPaneClass))

typedef struct _ContactsListPane ContactsListPane;
typedef struct _ContactsListPaneClass ContactsListPaneClass;
typedef struct _ContactsListPanePrivate ContactsListPanePrivate;

#define CONTACTS_TYPE_CONTACT_LIST (contacts_contact_list_get_type ())
#define CONTACTS_CONTACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_LIST, ContactsContactList))
#define CONTACTS_CONTACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_LIST, ContactsContactListClass))
#define CONTACTS_IS_CONTACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_LIST))
#define CONTACTS_IS_CONTACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_LIST))
#define CONTACTS_CONTACT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_LIST, ContactsContactListClass))

typedef struct _ContactsContactList ContactsContactList;
typedef struct _ContactsContactListClass ContactsContactListClass;
typedef enum  {
	CONTACTS_UI_STATE_NORMAL,
	CONTACTS_UI_STATE_SHOWING,
	CONTACTS_UI_STATE_SELECTING,
	CONTACTS_UI_STATE_UPDATING,
	CONTACTS_UI_STATE_CREATING
} ContactsUiState;

#define CONTACTS_TYPE_UI_STATE (contacts_ui_state_get_type ())
enum  {
	CONTACTS_LIST_PANE_0_PROPERTY,
	CONTACTS_LIST_PANE_STATE_PROPERTY,
	CONTACTS_LIST_PANE_NUM_PROPERTIES
};
static GParamSpec* contacts_list_pane_properties[CONTACTS_LIST_PANE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CONTACTS_TYPE_SETTINGS (contacts_settings_get_type ())
#define CONTACTS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_SETTINGS, ContactsSettings))
#define CONTACTS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_SETTINGS, ContactsSettingsClass))
#define CONTACTS_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_SETTINGS))
#define CONTACTS_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_SETTINGS))
#define CONTACTS_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_SETTINGS, ContactsSettingsClass))

typedef struct _ContactsSettings ContactsSettings;
typedef struct _ContactsSettingsClass ContactsSettingsClass;
enum  {
	CONTACTS_LIST_PANE_SELECTION_CHANGED_SIGNAL,
	CONTACTS_LIST_PANE_LINK_CONTACTS_SIGNAL,
	CONTACTS_LIST_PANE_DELETE_CONTACTS_SIGNAL,
	CONTACTS_LIST_PANE_CONTACTS_MARKED_SIGNAL,
	CONTACTS_LIST_PANE_NUM_SIGNALS
};
static guint contacts_list_pane_signals[CONTACTS_LIST_PANE_NUM_SIGNALS] = {0};

struct _ContactsListPane {
	AdwBin parent_instance;
	ContactsListPanePrivate * priv;
	GtkSearchEntry* filter_entry;
};

struct _ContactsListPaneClass {
	AdwBinClass parent_class;
};

struct _ContactsListPanePrivate {
	ContactsStore* store;
	AdwBin* contacts_list_container;
	ContactsContactList* contacts_list;
	FolksSimpleQuery* filter_query;
	GtkButton* link_button;
	GtkButton* delete_button;
	GtkActionBar* actions_bar;
	ContactsUiState _state;
};

static gint ContactsListPane_private_offset;
static gpointer contacts_list_pane_parent_class = NULL;

VALA_EXTERN GType contacts_list_pane_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsListPane, g_object_unref)
VALA_EXTERN GType contacts_contact_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactList, g_object_unref)
VALA_EXTERN GType contacts_ui_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType contacts_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsSettings, g_object_unref)
VALA_EXTERN ContactsListPane* contacts_list_pane_new (GtkWindow* window,
                                          ContactsSettings* settings,
                                          ContactsStore* contacts_store);
VALA_EXTERN ContactsListPane* contacts_list_pane_construct (GType object_type,
                                                GtkWindow* window,
                                                ContactsSettings* settings,
                                                ContactsStore* contacts_store);
static void contacts_list_pane_on_ui_state_changed (ContactsListPane* self,
                                             GObject* obj,
                                             GParamSpec* pspec);
static void _contacts_list_pane_on_ui_state_changed_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN ContactsContactList* contacts_contact_list_new (ContactsSettings* settings,
                                                ContactsStore* store,
                                                FolksQuery* query);
VALA_EXTERN ContactsContactList* contacts_contact_list_construct (GType object_type,
                                                      ContactsSettings* settings,
                                                      ContactsStore* store,
                                                      FolksQuery* query);
static void __lambda11_ (ContactsListPane* self,
                  ContactsContactList* l,
                  FolksIndividual* individual);
static void ___lambda11__contacts_contact_list_selection_changed (ContactsContactList* _sender,
                                                           FolksIndividual* individual,
                                                           gpointer self);
static void __lambda12_ (ContactsListPane* self,
                  gint nr_contacts_marked);
static void ___lambda12__contacts_contact_list_contacts_marked (ContactsContactList* _sender,
                                                         gint contacts_marked,
                                                         gpointer self);
VALA_EXTERN ContactsUiState contacts_list_pane_get_state (ContactsListPane* self);
VALA_EXTERN gboolean contacts_ui_state_editing (ContactsUiState self);
static void contacts_list_pane_filter_entry_changed (ContactsListPane* self,
                                              GtkEditable* editable);
static void _contacts_list_pane_filter_entry_changed_gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                               gpointer self);
VALA_EXTERN void contacts_list_pane_select_contact (ContactsListPane* self,
                                        FolksIndividual* individual);
VALA_EXTERN void contacts_contact_list_select_contact (ContactsContactList* self,
                                           FolksIndividual* individual);
VALA_EXTERN void contacts_list_pane_scroll_to_contact (ContactsListPane* self);
VALA_EXTERN void contacts_contact_list_scroll_to_contact (ContactsContactList* self,
                                              GtkListBoxRow* row);
VALA_EXTERN void contacts_list_pane_set_contact_visible (ContactsListPane* self,
                                             FolksIndividual* individual,
                                             gboolean visible);
VALA_EXTERN void contacts_contact_list_set_contact_visible (ContactsContactList* self,
                                                FolksIndividual* individual,
                                                gboolean visible);
static void contacts_list_pane_on_link_button_clicked (ContactsListPane* self,
                                                GtkButton* link_button);
VALA_EXTERN GeeLinkedList* contacts_contact_list_get_marked_contacts (ContactsContactList* self);
static void _contacts_list_pane_on_link_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                    gpointer self);
static void contacts_list_pane_on_delete_button_clicked (ContactsListPane* self,
                                                  GtkButton* delete_button);
VALA_EXTERN GeeLinkedList* contacts_contact_list_get_marked_contacts_and_hide (ContactsContactList* self);
static void _contacts_list_pane_on_delete_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                      gpointer self);
VALA_EXTERN void contacts_list_pane_set_state (ContactsListPane* self,
                                   ContactsUiState value);
static void contacts_list_pane_finalize (GObject * obj);
static GType contacts_list_pane_get_type_once (void);
static void _vala_contacts_list_pane_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_contacts_list_pane_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
contacts_list_pane_get_instance_private (ContactsListPane* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsListPane_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_contacts_list_pane_on_ui_state_changed_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self)
{
	contacts_list_pane_on_ui_state_changed ((ContactsListPane*) self, _sender, pspec);
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
__lambda11_ (ContactsListPane* self,
             ContactsContactList* l,
             FolksIndividual* individual)
{
	g_return_if_fail (l != NULL);
	g_signal_emit (self, contacts_list_pane_signals[CONTACTS_LIST_PANE_SELECTION_CHANGED_SIGNAL], 0, individual);
}

static void
___lambda11__contacts_contact_list_selection_changed (ContactsContactList* _sender,
                                                      FolksIndividual* individual,
                                                      gpointer self)
{
	__lambda11_ ((ContactsListPane*) self, _sender, individual);
}

static void
__lambda12_ (ContactsListPane* self,
             gint nr_contacts_marked)
{
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	_tmp0_ = self->priv->delete_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, nr_contacts_marked > 0);
	_tmp1_ = self->priv->link_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, nr_contacts_marked > 1);
	g_signal_emit (self, contacts_list_pane_signals[CONTACTS_LIST_PANE_CONTACTS_MARKED_SIGNAL], 0, nr_contacts_marked);
}

static void
___lambda12__contacts_contact_list_contacts_marked (ContactsContactList* _sender,
                                                    gint contacts_marked,
                                                    gpointer self)
{
	__lambda12_ ((ContactsListPane*) self, contacts_marked);
}

ContactsListPane*
contacts_list_pane_construct (GType object_type,
                              GtkWindow* window,
                              ContactsSettings* settings,
                              ContactsStore* contacts_store)
{
	ContactsListPane * self = NULL;
	ContactsStore* _tmp0_;
	GtkSearchEntry* _tmp1_;
	gchar** filtered_fields = NULL;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint filtered_fields_length1;
	gint _filtered_fields_size_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	FolksSimpleQuery* _tmp6_;
	ContactsContactList* contactslist = NULL;
	FolksSimpleQuery* _tmp7_;
	ContactsContactList* _tmp8_;
	AdwBin* _tmp9_;
	ContactsContactList* _tmp10_;
	ContactsContactList* _tmp11_;
	ContactsContactList* _tmp12_;
	g_return_val_if_fail (window != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	g_return_val_if_fail (contacts_store != NULL, NULL);
	self = (ContactsListPane*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (contacts_store);
	_g_object_unref0 (self->priv->store);
	self->priv->store = _tmp0_;
	g_signal_connect_object ((GObject*) self, "notify::state", (GCallback) _contacts_list_pane_on_ui_state_changed_g_object_notify, self, 0);
	_tmp1_ = self->filter_entry;
	gtk_search_entry_set_key_capture_widget (_tmp1_, (GtkWidget*) window);
	_tmp2_ = _vala_array_dup2 (FOLKS_QUERY_MATCH_FIELDS_NAMES, G_N_ELEMENTS (FOLKS_QUERY_MATCH_FIELDS_NAMES));
	_tmp2__length1 = G_N_ELEMENTS (FOLKS_QUERY_MATCH_FIELDS_NAMES);
	filtered_fields = _tmp2_;
	filtered_fields_length1 = _tmp2__length1;
	_filtered_fields_size_ = filtered_fields_length1;
	{
		const gchar** field_collection = NULL;
		gint field_collection_length1 = 0;
		gint _field_collection_size_ = 0;
		gint field_it = 0;
		field_collection = FOLKS_QUERY_MATCH_FIELDS_ADDRESSES;
		field_collection_length1 = G_N_ELEMENTS (FOLKS_QUERY_MATCH_FIELDS_ADDRESSES);
		for (field_it = 0; field_it < field_collection_length1; field_it = field_it + 1) {
			const gchar* field = NULL;
			field = field_collection[field_it];
			{
				const gchar* _tmp3_;
				gchar* _tmp4_;
				_tmp3_ = field;
				_tmp4_ = g_strdup (_tmp3_);
				_vala_array_add1 (&filtered_fields, &filtered_fields_length1, &_filtered_fields_size_, _tmp4_);
			}
		}
	}
	_tmp5_ = filtered_fields;
	_tmp5__length1 = filtered_fields_length1;
	_tmp6_ = folks_simple_query_new ("", _tmp5_, _tmp5__length1);
	_g_object_unref0 (self->priv->filter_query);
	self->priv->filter_query = _tmp6_;
	_tmp7_ = self->priv->filter_query;
	_tmp8_ = contacts_contact_list_new (settings, contacts_store, (FolksQuery*) _tmp7_);
	g_object_ref_sink (_tmp8_);
	contactslist = _tmp8_;
	self->priv->contacts_list = contactslist;
	_tmp9_ = self->priv->contacts_list_container;
	adw_bin_set_child (_tmp9_, (GtkWidget*) contactslist);
	_tmp10_ = self->priv->contacts_list;
	g_object_bind_property_with_closures ((GObject*) self, "state", (GObject*) _tmp10_, "state", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp11_ = self->priv->contacts_list;
	g_signal_connect_object (_tmp11_, "selection-changed", (GCallback) ___lambda11__contacts_contact_list_selection_changed, self, 0);
	_tmp12_ = self->priv->contacts_list;
	g_signal_connect_object (_tmp12_, "contacts-marked", (GCallback) ___lambda12__contacts_contact_list_contacts_marked, self, 0);
	_g_object_unref0 (contactslist);
	filtered_fields = (_vala_array_free (filtered_fields, filtered_fields_length1, (GDestroyNotify) g_free), NULL);
	return self;
}

ContactsListPane*
contacts_list_pane_new (GtkWindow* window,
                        ContactsSettings* settings,
                        ContactsStore* contacts_store)
{
	return contacts_list_pane_construct (CONTACTS_TYPE_LIST_PANE, window, settings, contacts_store);
}

static void
contacts_list_pane_on_ui_state_changed (ContactsListPane* self,
                                        GObject* obj,
                                        GParamSpec* pspec)
{
	GtkSearchEntry* _tmp0_;
	ContactsContactList* _tmp1_;
	ContactsUiState _tmp2_;
	GtkActionBar* _tmp3_;
	ContactsUiState _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->filter_entry;
	_tmp1_ = self->priv->contacts_list;
	_tmp2_ = self->priv->_state;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, !contacts_ui_state_editing (_tmp2_));
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, !contacts_ui_state_editing (_tmp2_));
	_tmp3_ = self->priv->actions_bar;
	_tmp4_ = self->priv->_state;
	gtk_action_bar_set_revealed (_tmp3_, _tmp4_ == CONTACTS_UI_STATE_SELECTING);
}

static void
contacts_list_pane_filter_entry_changed (ContactsListPane* self,
                                         GtkEditable* editable)
{
	FolksSimpleQuery* _tmp0_;
	GtkSearchEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editable != NULL);
	_tmp0_ = self->priv->filter_query;
	_tmp1_ = self->filter_entry;
	_tmp2_ = gtk_editable_get_text ((GtkEditable*) _tmp1_);
	_tmp3_ = _tmp2_;
	folks_simple_query_set_query_string (_tmp0_, _tmp3_);
}

static void
_contacts_list_pane_filter_entry_changed_gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                          gpointer self)
{
	contacts_list_pane_filter_entry_changed ((ContactsListPane*) self, _sender);
}

void
contacts_list_pane_select_contact (ContactsListPane* self,
                                   FolksIndividual* individual)
{
	ContactsContactList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->contacts_list;
	contacts_contact_list_select_contact (_tmp0_, individual);
}

void
contacts_list_pane_scroll_to_contact (ContactsListPane* self)
{
	ContactsContactList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->contacts_list;
	contacts_contact_list_scroll_to_contact (_tmp0_, NULL);
}

void
contacts_list_pane_set_contact_visible (ContactsListPane* self,
                                        FolksIndividual* individual,
                                        gboolean visible)
{
	ContactsContactList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->contacts_list;
	contacts_contact_list_set_contact_visible (_tmp0_, individual, visible);
}

static void
contacts_list_pane_on_link_button_clicked (ContactsListPane* self,
                                           GtkButton* link_button)
{
	ContactsContactList* _tmp0_;
	GeeLinkedList* _tmp1_;
	GeeLinkedList* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (link_button != NULL);
	_tmp0_ = self->priv->contacts_list;
	_tmp1_ = contacts_contact_list_get_marked_contacts (_tmp0_);
	_tmp2_ = _tmp1_;
	g_signal_emit (self, contacts_list_pane_signals[CONTACTS_LIST_PANE_LINK_CONTACTS_SIGNAL], 0, _tmp2_);
	_g_object_unref0 (_tmp2_);
}

static void
_contacts_list_pane_on_link_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                               gpointer self)
{
	contacts_list_pane_on_link_button_clicked ((ContactsListPane*) self, _sender);
}

static void
contacts_list_pane_on_delete_button_clicked (ContactsListPane* self,
                                             GtkButton* delete_button)
{
	ContactsContactList* _tmp0_;
	GeeLinkedList* _tmp1_;
	GeeLinkedList* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (delete_button != NULL);
	_tmp0_ = self->priv->contacts_list;
	_tmp1_ = contacts_contact_list_get_marked_contacts_and_hide (_tmp0_);
	_tmp2_ = _tmp1_;
	g_signal_emit (self, contacts_list_pane_signals[CONTACTS_LIST_PANE_DELETE_CONTACTS_SIGNAL], 0, _tmp2_);
	_g_object_unref0 (_tmp2_);
}

static void
_contacts_list_pane_on_delete_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self)
{
	contacts_list_pane_on_delete_button_clicked ((ContactsListPane*) self, _sender);
}

ContactsUiState
contacts_list_pane_get_state (ContactsListPane* self)
{
	ContactsUiState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

void
contacts_list_pane_set_state (ContactsListPane* self,
                              ContactsUiState value)
{
	ContactsUiState old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_list_pane_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, contacts_list_pane_properties[CONTACTS_LIST_PANE_STATE_PROPERTY]);
	}
}

static void
contacts_list_pane_class_init (ContactsListPaneClass * klass,
                               gpointer klass_data)
{
	contacts_list_pane_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsListPane_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_list_pane_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_list_pane_set_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_list_pane_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_LIST_PANE_STATE_PROPERTY, contacts_list_pane_properties[CONTACTS_LIST_PANE_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", CONTACTS_TYPE_UI_STATE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Contacts/ui/contacts-list-pane.ui");
	contacts_list_pane_signals[CONTACTS_LIST_PANE_SELECTION_CHANGED_SIGNAL] = g_signal_new ("selection-changed", CONTACTS_TYPE_LIST_PANE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, FOLKS_TYPE_INDIVIDUAL);
	contacts_list_pane_signals[CONTACTS_LIST_PANE_LINK_CONTACTS_SIGNAL] = g_signal_new ("link-contacts", CONTACTS_TYPE_LIST_PANE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_LINKED_LIST);
	contacts_list_pane_signals[CONTACTS_LIST_PANE_DELETE_CONTACTS_SIGNAL] = g_signal_new ("delete-contacts", CONTACTS_TYPE_LIST_PANE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_LINKED_LIST);
	contacts_list_pane_signals[CONTACTS_LIST_PANE_CONTACTS_MARKED_SIGNAL] = g_signal_new ("contacts-marked", CONTACTS_TYPE_LIST_PANE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "contacts_list_container", FALSE, ContactsListPane_private_offset + G_STRUCT_OFFSET (ContactsListPanePrivate, contacts_list_container));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "filter_entry", FALSE, G_STRUCT_OFFSET (ContactsListPane, filter_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "link_button", FALSE, ContactsListPane_private_offset + G_STRUCT_OFFSET (ContactsListPanePrivate, link_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "delete_button", FALSE, ContactsListPane_private_offset + G_STRUCT_OFFSET (ContactsListPanePrivate, delete_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "actions_bar", FALSE, ContactsListPane_private_offset + G_STRUCT_OFFSET (ContactsListPanePrivate, actions_bar));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "filter_entry_changed", G_CALLBACK(_contacts_list_pane_filter_entry_changed_gtk_search_entry_search_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_link_button_clicked", G_CALLBACK(_contacts_list_pane_on_link_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_delete_button_clicked", G_CALLBACK(_contacts_list_pane_on_delete_button_clicked_gtk_button_clicked));
}

static void
contacts_list_pane_instance_init (ContactsListPane * self,
                                  gpointer klass)
{
	self->priv = contacts_list_pane_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
contacts_list_pane_finalize (GObject * obj)
{
	ContactsListPane * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_LIST_PANE, ContactsListPane);
	_g_object_unref0 (self->priv->store);
	_g_object_unref0 (self->priv->filter_query);
	G_OBJECT_CLASS (contacts_list_pane_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
contacts_list_pane_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsListPaneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_list_pane_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsListPane), 0, (GInstanceInitFunc) contacts_list_pane_instance_init, NULL };
	GType contacts_list_pane_type_id;
	contacts_list_pane_type_id = g_type_register_static (adw_bin_get_type (), "ContactsListPane", &g_define_type_info, 0);
	ContactsListPane_private_offset = g_type_add_instance_private (contacts_list_pane_type_id, sizeof (ContactsListPanePrivate));
	return contacts_list_pane_type_id;
}

GType
contacts_list_pane_get_type (void)
{
	static volatile gsize contacts_list_pane_type_id__once = 0;
	if (g_once_init_enter (&contacts_list_pane_type_id__once)) {
		GType contacts_list_pane_type_id;
		contacts_list_pane_type_id = contacts_list_pane_get_type_once ();
		g_once_init_leave (&contacts_list_pane_type_id__once, contacts_list_pane_type_id);
	}
	return contacts_list_pane_type_id__once;
}

static void
_vala_contacts_list_pane_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	ContactsListPane * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_LIST_PANE, ContactsListPane);
	switch (property_id) {
		case CONTACTS_LIST_PANE_STATE_PROPERTY:
		g_value_set_enum (value, contacts_list_pane_get_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_list_pane_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	ContactsListPane * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_LIST_PANE, ContactsListPane);
	switch (property_id) {
		case CONTACTS_LIST_PANE_STATE_PROPERTY:
		contacts_list_pane_set_state (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

