
/* This file is generated by glib-mkenums, do not modify it. This code is licensed under the same license as the containing project. Note that it links to GLib, so must comply with the LGPL linking clauses. */

/*
 * Copyright (C) 2011  Google, Inc.
 *
 *  This is part of HarfBuzz, a text shaping library.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE COPYRIGHT HOLDER HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * THE COPYRIGHT HOLDER SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE COPYRIGHT HOLDER HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * Google Author(s): Behdad Esfahbod
 */

#include "hb.hh"

#ifdef HAVE_GOBJECT

/* g++ didn't like older gtype.h gcc-only code path. */
#include <glib.h>
#if !GLIB_CHECK_VERSION(2,29,16)
#undef __GNUC__
#undef __GNUC_MINOR__
#define __GNUC__ 2
#define __GNUC_MINOR__ 6
#endif

#include "hb-gobject.h"
/* enumerations from "hb-aat-layout.h" */
GType
hb_gobject_aat_layout_feature_type_get_type ()
{
  static gsize type_id = 0;

  if (g_once_init_enter (&type_id))
    {
      static const GEnumValue values[] = {
        { HB_AAT_LAYOUT_FEATURE_TYPE_INVALID, "HB_AAT_LAYOUT_FEATURE_TYPE_INVALID", "invalid" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_ALL_TYPOGRAPHIC, "HB_AAT_LAYOUT_FEATURE_TYPE_ALL_TYPOGRAPHIC", "all-typographic" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES, "HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES", "ligatures" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_CURISVE_CONNECTION, "HB_AAT_LAYOUT_FEATURE_TYPE_CURISVE_CONNECTION", "curisve-connection" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_LETTER_CASE, "HB_AAT_LAYOUT_FEATURE_TYPE_LETTER_CASE", "letter-case" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_VERTICAL_SUBSTITUTION, "HB_AAT_LAYOUT_FEATURE_TYPE_VERTICAL_SUBSTITUTION", "vertical-substitution" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_LINGUISTIC_REARRANGEMENT, "HB_AAT_LAYOUT_FEATURE_TYPE_LINGUISTIC_REARRANGEMENT", "linguistic-rearrangement" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_NUMBER_SPACING, "HB_AAT_LAYOUT_FEATURE_TYPE_NUMBER_SPACING", "number-spacing" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_SMART_SWASH_TYPE, "HB_AAT_LAYOUT_FEATURE_TYPE_SMART_SWASH_TYPE", "smart-swash-type" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_DIACRITICS_TYPE, "HB_AAT_LAYOUT_FEATURE_TYPE_DIACRITICS_TYPE", "diacritics-type" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_VERTICAL_POSITION, "HB_AAT_LAYOUT_FEATURE_TYPE_VERTICAL_POSITION", "vertical-position" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_FRACTIONS, "HB_AAT_LAYOUT_FEATURE_TYPE_FRACTIONS", "fractions" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_OVERLAPPING_CHARACTERS_TYPE, "HB_AAT_LAYOUT_FEATURE_TYPE_OVERLAPPING_CHARACTERS_TYPE", "overlapping-characters-type" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_TYPOGRAPHIC_EXTRAS, "HB_AAT_LAYOUT_FEATURE_TYPE_TYPOGRAPHIC_EXTRAS", "typographic-extras" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_MATHEMATICAL_EXTRAS, "HB_AAT_LAYOUT_FEATURE_TYPE_MATHEMATICAL_EXTRAS", "mathematical-extras" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_ORNAMENT_SETS_TYPE, "HB_AAT_LAYOUT_FEATURE_TYPE_ORNAMENT_SETS_TYPE", "ornament-sets-type" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_ALTERNATIVES, "HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_ALTERNATIVES", "character-alternatives" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_DESIGN_COMPLEXITY_TYPE, "HB_AAT_LAYOUT_FEATURE_TYPE_DESIGN_COMPLEXITY_TYPE", "design-complexity-type" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_STYLE_OPTIONS, "HB_AAT_LAYOUT_FEATURE_TYPE_STYLE_OPTIONS", "style-options" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE, "HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE", "character-shape" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_NUMBER_CASE, "HB_AAT_LAYOUT_FEATURE_TYPE_NUMBER_CASE", "number-case" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_TEXT_SPACING, "HB_AAT_LAYOUT_FEATURE_TYPE_TEXT_SPACING", "text-spacing" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_TRANSLITERATION, "HB_AAT_LAYOUT_FEATURE_TYPE_TRANSLITERATION", "transliteration" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_ANNOTATION_TYPE, "HB_AAT_LAYOUT_FEATURE_TYPE_ANNOTATION_TYPE", "annotation-type" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_KANA_SPACING_TYPE, "HB_AAT_LAYOUT_FEATURE_TYPE_KANA_SPACING_TYPE", "kana-spacing-type" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_SPACING_TYPE, "HB_AAT_LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_SPACING_TYPE", "ideographic-spacing-type" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_UNICODE_DECOMPOSITION_TYPE, "HB_AAT_LAYOUT_FEATURE_TYPE_UNICODE_DECOMPOSITION_TYPE", "unicode-decomposition-type" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_RUBY_KANA, "HB_AAT_LAYOUT_FEATURE_TYPE_RUBY_KANA", "ruby-kana" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_CJK_SYMBOL_ALTERNATIVES_TYPE, "HB_AAT_LAYOUT_FEATURE_TYPE_CJK_SYMBOL_ALTERNATIVES_TYPE", "cjk-symbol-alternatives-type" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_ALTERNATIVES_TYPE, "HB_AAT_LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_ALTERNATIVES_TYPE", "ideographic-alternatives-type" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_CJK_VERTICAL_ROMAN_PLACEMENT_TYPE, "HB_AAT_LAYOUT_FEATURE_TYPE_CJK_VERTICAL_ROMAN_PLACEMENT_TYPE", "cjk-vertical-roman-placement-type" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_ITALIC_CJK_ROMAN, "HB_AAT_LAYOUT_FEATURE_TYPE_ITALIC_CJK_ROMAN", "italic-cjk-roman" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_CASE_SENSITIVE_LAYOUT, "HB_AAT_LAYOUT_FEATURE_TYPE_CASE_SENSITIVE_LAYOUT", "case-sensitive-layout" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_ALTERNATE_KANA, "HB_AAT_LAYOUT_FEATURE_TYPE_ALTERNATE_KANA", "alternate-kana" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES, "HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES", "stylistic-alternatives" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_CONTEXTUAL_ALTERNATIVES, "HB_AAT_LAYOUT_FEATURE_TYPE_CONTEXTUAL_ALTERNATIVES", "contextual-alternatives" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_LOWER_CASE, "HB_AAT_LAYOUT_FEATURE_TYPE_LOWER_CASE", "lower-case" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_UPPER_CASE, "HB_AAT_LAYOUT_FEATURE_TYPE_UPPER_CASE", "upper-case" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_LANGUAGE_TAG_TYPE, "HB_AAT_LAYOUT_FEATURE_TYPE_LANGUAGE_TAG_TYPE", "language-tag-type" },
        { HB_AAT_LAYOUT_FEATURE_TYPE_CJK_ROMAN_SPACING_TYPE, "HB_AAT_LAYOUT_FEATURE_TYPE_CJK_ROMAN_SPACING_TYPE", "cjk-roman-spacing-type" },
        { 0, NULL, NULL }
      };
      GType id =
        g_enum_register_static (g_intern_static_string ("hb_aat_layout_feature_type_t"), values);
      g_once_init_leave (&type_id, id);
    }

  return type_id;
}
GType
hb_gobject_aat_layout_feature_selector_get_type ()
{
  static gsize type_id = 0;

  if (g_once_init_enter (&type_id))
    {
      static const GEnumValue values[] = {
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_INVALID, "HB_AAT_LAYOUT_FEATURE_SELECTOR_INVALID", "invalid" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_ALL_TYPE_FEATURES_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_ALL_TYPE_FEATURES_ON", "all-type-features-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_ALL_TYPE_FEATURES_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_ALL_TYPE_FEATURES_OFF", "all-type-features-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_REQUIRED_LIGATURES_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_REQUIRED_LIGATURES_ON", "required-ligatures-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_REQUIRED_LIGATURES_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_REQUIRED_LIGATURES_OFF", "required-ligatures-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_COMMON_LIGATURES_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_COMMON_LIGATURES_ON", "common-ligatures-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_COMMON_LIGATURES_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_COMMON_LIGATURES_OFF", "common-ligatures-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_RARE_LIGATURES_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_RARE_LIGATURES_ON", "rare-ligatures-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_RARE_LIGATURES_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_RARE_LIGATURES_OFF", "rare-ligatures-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_LOGOS_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_LOGOS_ON", "logos-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_LOGOS_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_LOGOS_OFF", "logos-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_REBUS_PICTURES_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_REBUS_PICTURES_ON", "rebus-pictures-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_REBUS_PICTURES_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_REBUS_PICTURES_OFF", "rebus-pictures-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_DIPHTHONG_LIGATURES_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_DIPHTHONG_LIGATURES_ON", "diphthong-ligatures-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_DIPHTHONG_LIGATURES_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_DIPHTHONG_LIGATURES_OFF", "diphthong-ligatures-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_SQUARED_LIGATURES_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_SQUARED_LIGATURES_ON", "squared-ligatures-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_SQUARED_LIGATURES_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_SQUARED_LIGATURES_OFF", "squared-ligatures-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_ABBREV_SQUARED_LIGATURES_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_ABBREV_SQUARED_LIGATURES_ON", "abbrev-squared-ligatures-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_ABBREV_SQUARED_LIGATURES_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_ABBREV_SQUARED_LIGATURES_OFF", "abbrev-squared-ligatures-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_SYMBOL_LIGATURES_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_SYMBOL_LIGATURES_ON", "symbol-ligatures-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_SYMBOL_LIGATURES_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_SYMBOL_LIGATURES_OFF", "symbol-ligatures-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_LIGATURES_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_LIGATURES_ON", "contextual-ligatures-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_LIGATURES_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_LIGATURES_OFF", "contextual-ligatures-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_HISTORICAL_LIGATURES_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_HISTORICAL_LIGATURES_ON", "historical-ligatures-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_HISTORICAL_LIGATURES_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_HISTORICAL_LIGATURES_OFF", "historical-ligatures-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_UNCONNECTED, "HB_AAT_LAYOUT_FEATURE_SELECTOR_UNCONNECTED", "unconnected" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_PARTIALLY_CONNECTED, "HB_AAT_LAYOUT_FEATURE_SELECTOR_PARTIALLY_CONNECTED", "partially-connected" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_CURSIVE, "HB_AAT_LAYOUT_FEATURE_SELECTOR_CURSIVE", "cursive" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_UPPER_AND_LOWER_CASE, "HB_AAT_LAYOUT_FEATURE_SELECTOR_UPPER_AND_LOWER_CASE", "upper-and-lower-case" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_ALL_CAPS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_ALL_CAPS", "all-caps" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_ALL_LOWER_CASE, "HB_AAT_LAYOUT_FEATURE_SELECTOR_ALL_LOWER_CASE", "all-lower-case" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_SMALL_CAPS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_SMALL_CAPS", "small-caps" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_INITIAL_CAPS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_INITIAL_CAPS", "initial-caps" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_INITIAL_CAPS_AND_SMALL_CAPS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_INITIAL_CAPS_AND_SMALL_CAPS", "initial-caps-and-small-caps" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_SUBSTITUTE_VERTICAL_FORMS_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_SUBSTITUTE_VERTICAL_FORMS_ON", "substitute-vertical-forms-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_SUBSTITUTE_VERTICAL_FORMS_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_SUBSTITUTE_VERTICAL_FORMS_OFF", "substitute-vertical-forms-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_LINGUISTIC_REARRANGEMENT_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_LINGUISTIC_REARRANGEMENT_ON", "linguistic-rearrangement-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_LINGUISTIC_REARRANGEMENT_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_LINGUISTIC_REARRANGEMENT_OFF", "linguistic-rearrangement-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_MONOSPACED_NUMBERS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_MONOSPACED_NUMBERS", "monospaced-numbers" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_NUMBERS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_NUMBERS", "proportional-numbers" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_THIRD_WIDTH_NUMBERS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_THIRD_WIDTH_NUMBERS", "third-width-numbers" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_QUARTER_WIDTH_NUMBERS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_QUARTER_WIDTH_NUMBERS", "quarter-width-numbers" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_WORD_INITIAL_SWASHES_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_WORD_INITIAL_SWASHES_ON", "word-initial-swashes-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_WORD_INITIAL_SWASHES_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_WORD_INITIAL_SWASHES_OFF", "word-initial-swashes-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_WORD_FINAL_SWASHES_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_WORD_FINAL_SWASHES_ON", "word-final-swashes-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_WORD_FINAL_SWASHES_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_WORD_FINAL_SWASHES_OFF", "word-final-swashes-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_LINE_INITIAL_SWASHES_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_LINE_INITIAL_SWASHES_ON", "line-initial-swashes-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_LINE_INITIAL_SWASHES_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_LINE_INITIAL_SWASHES_OFF", "line-initial-swashes-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_LINE_FINAL_SWASHES_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_LINE_FINAL_SWASHES_ON", "line-final-swashes-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_LINE_FINAL_SWASHES_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_LINE_FINAL_SWASHES_OFF", "line-final-swashes-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_NON_FINAL_SWASHES_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_NON_FINAL_SWASHES_ON", "non-final-swashes-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_NON_FINAL_SWASHES_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_NON_FINAL_SWASHES_OFF", "non-final-swashes-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_SHOW_DIACRITICS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_SHOW_DIACRITICS", "show-diacritics" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_HIDE_DIACRITICS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_HIDE_DIACRITICS", "hide-diacritics" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_DECOMPOSE_DIACRITICS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_DECOMPOSE_DIACRITICS", "decompose-diacritics" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_NORMAL_POSITION, "HB_AAT_LAYOUT_FEATURE_SELECTOR_NORMAL_POSITION", "normal-position" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_SUPERIORS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_SUPERIORS", "superiors" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_INFERIORS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_INFERIORS", "inferiors" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_ORDINALS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_ORDINALS", "ordinals" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_SCIENTIFIC_INFERIORS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_SCIENTIFIC_INFERIORS", "scientific-inferiors" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_FRACTIONS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_FRACTIONS", "no-fractions" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_VERTICAL_FRACTIONS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_VERTICAL_FRACTIONS", "vertical-fractions" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_DIAGONAL_FRACTIONS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_DIAGONAL_FRACTIONS", "diagonal-fractions" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_PREVENT_OVERLAP_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_PREVENT_OVERLAP_ON", "prevent-overlap-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_PREVENT_OVERLAP_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_PREVENT_OVERLAP_OFF", "prevent-overlap-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_HYPHENS_TO_EM_DASH_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_HYPHENS_TO_EM_DASH_ON", "hyphens-to-em-dash-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_HYPHENS_TO_EM_DASH_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_HYPHENS_TO_EM_DASH_OFF", "hyphens-to-em-dash-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_HYPHEN_TO_EN_DASH_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_HYPHEN_TO_EN_DASH_ON", "hyphen-to-en-dash-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_HYPHEN_TO_EN_DASH_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_HYPHEN_TO_EN_DASH_OFF", "hyphen-to-en-dash-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_SLASHED_ZERO_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_SLASHED_ZERO_ON", "slashed-zero-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_SLASHED_ZERO_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_SLASHED_ZERO_OFF", "slashed-zero-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_FORM_INTERROBANG_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_FORM_INTERROBANG_ON", "form-interrobang-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_FORM_INTERROBANG_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_FORM_INTERROBANG_OFF", "form-interrobang-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_SMART_QUOTES_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_SMART_QUOTES_ON", "smart-quotes-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_SMART_QUOTES_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_SMART_QUOTES_OFF", "smart-quotes-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_PERIODS_TO_ELLIPSIS_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_PERIODS_TO_ELLIPSIS_ON", "periods-to-ellipsis-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_PERIODS_TO_ELLIPSIS_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_PERIODS_TO_ELLIPSIS_OFF", "periods-to-ellipsis-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_HYPHEN_TO_MINUS_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_HYPHEN_TO_MINUS_ON", "hyphen-to-minus-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_HYPHEN_TO_MINUS_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_HYPHEN_TO_MINUS_OFF", "hyphen-to-minus-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_ASTERISK_TO_MULTIPLY_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_ASTERISK_TO_MULTIPLY_ON", "asterisk-to-multiply-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_ASTERISK_TO_MULTIPLY_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_ASTERISK_TO_MULTIPLY_OFF", "asterisk-to-multiply-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_SLASH_TO_DIVIDE_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_SLASH_TO_DIVIDE_ON", "slash-to-divide-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_SLASH_TO_DIVIDE_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_SLASH_TO_DIVIDE_OFF", "slash-to-divide-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_INEQUALITY_LIGATURES_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_INEQUALITY_LIGATURES_ON", "inequality-ligatures-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_INEQUALITY_LIGATURES_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_INEQUALITY_LIGATURES_OFF", "inequality-ligatures-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_EXPONENTS_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_EXPONENTS_ON", "exponents-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_EXPONENTS_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_EXPONENTS_OFF", "exponents-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_MATHEMATICAL_GREEK_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_MATHEMATICAL_GREEK_ON", "mathematical-greek-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_MATHEMATICAL_GREEK_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_MATHEMATICAL_GREEK_OFF", "mathematical-greek-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_ORNAMENTS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_ORNAMENTS", "no-ornaments" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_DINGBATS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_DINGBATS", "dingbats" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_PI_CHARACTERS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_PI_CHARACTERS", "pi-characters" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_FLEURONS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_FLEURONS", "fleurons" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_DECORATIVE_BORDERS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_DECORATIVE_BORDERS", "decorative-borders" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_INTERNATIONAL_SYMBOLS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_INTERNATIONAL_SYMBOLS", "international-symbols" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_MATH_SYMBOLS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_MATH_SYMBOLS", "math-symbols" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_ALTERNATES, "HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_ALTERNATES", "no-alternates" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL1, "HB_AAT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL1", "design-level1" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL2, "HB_AAT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL2", "design-level2" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL3, "HB_AAT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL3", "design-level3" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL4, "HB_AAT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL4", "design-level4" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL5, "HB_AAT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL5", "design-level5" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_STYLE_OPTIONS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_STYLE_OPTIONS", "no-style-options" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_DISPLAY_TEXT, "HB_AAT_LAYOUT_FEATURE_SELECTOR_DISPLAY_TEXT", "display-text" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_ENGRAVED_TEXT, "HB_AAT_LAYOUT_FEATURE_SELECTOR_ENGRAVED_TEXT", "engraved-text" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_ILLUMINATED_CAPS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_ILLUMINATED_CAPS", "illuminated-caps" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_TITLING_CAPS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_TITLING_CAPS", "titling-caps" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_TALL_CAPS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_TALL_CAPS", "tall-caps" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_CHARACTERS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_CHARACTERS", "traditional-characters" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_SIMPLIFIED_CHARACTERS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_SIMPLIFIED_CHARACTERS", "simplified-characters" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_JIS1978_CHARACTERS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_JIS1978_CHARACTERS", "jis1978-characters" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_JIS1983_CHARACTERS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_JIS1983_CHARACTERS", "jis1983-characters" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_JIS1990_CHARACTERS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_JIS1990_CHARACTERS", "jis1990-characters" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_ONE, "HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_ONE", "traditional-alt-one" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_TWO, "HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_TWO", "traditional-alt-two" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_THREE, "HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_THREE", "traditional-alt-three" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_FOUR, "HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_FOUR", "traditional-alt-four" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_FIVE, "HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_FIVE", "traditional-alt-five" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_EXPERT_CHARACTERS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_EXPERT_CHARACTERS", "expert-characters" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_JIS2004_CHARACTERS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_JIS2004_CHARACTERS", "jis2004-characters" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_HOJO_CHARACTERS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_HOJO_CHARACTERS", "hojo-characters" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_NLCCHARACTERS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_NLCCHARACTERS", "nlccharacters" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_NAMES_CHARACTERS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_NAMES_CHARACTERS", "traditional-names-characters" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_LOWER_CASE_NUMBERS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_LOWER_CASE_NUMBERS", "lower-case-numbers" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_UPPER_CASE_NUMBERS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_UPPER_CASE_NUMBERS", "upper-case-numbers" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_TEXT, "HB_AAT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_TEXT", "proportional-text" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_MONOSPACED_TEXT, "HB_AAT_LAYOUT_FEATURE_SELECTOR_MONOSPACED_TEXT", "monospaced-text" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_HALF_WIDTH_TEXT, "HB_AAT_LAYOUT_FEATURE_SELECTOR_HALF_WIDTH_TEXT", "half-width-text" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_THIRD_WIDTH_TEXT, "HB_AAT_LAYOUT_FEATURE_SELECTOR_THIRD_WIDTH_TEXT", "third-width-text" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_QUARTER_WIDTH_TEXT, "HB_AAT_LAYOUT_FEATURE_SELECTOR_QUARTER_WIDTH_TEXT", "quarter-width-text" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_ALT_PROPORTIONAL_TEXT, "HB_AAT_LAYOUT_FEATURE_SELECTOR_ALT_PROPORTIONAL_TEXT", "alt-proportional-text" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_ALT_HALF_WIDTH_TEXT, "HB_AAT_LAYOUT_FEATURE_SELECTOR_ALT_HALF_WIDTH_TEXT", "alt-half-width-text" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_TRANSLITERATION, "HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_TRANSLITERATION", "no-transliteration" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_HANJA_TO_HANGUL, "HB_AAT_LAYOUT_FEATURE_SELECTOR_HANJA_TO_HANGUL", "hanja-to-hangul" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_HIRAGANA_TO_KATAKANA, "HB_AAT_LAYOUT_FEATURE_SELECTOR_HIRAGANA_TO_KATAKANA", "hiragana-to-katakana" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_KATAKANA_TO_HIRAGANA, "HB_AAT_LAYOUT_FEATURE_SELECTOR_KATAKANA_TO_HIRAGANA", "katakana-to-hiragana" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_KANA_TO_ROMANIZATION, "HB_AAT_LAYOUT_FEATURE_SELECTOR_KANA_TO_ROMANIZATION", "kana-to-romanization" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_ROMANIZATION_TO_HIRAGANA, "HB_AAT_LAYOUT_FEATURE_SELECTOR_ROMANIZATION_TO_HIRAGANA", "romanization-to-hiragana" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_ROMANIZATION_TO_KATAKANA, "HB_AAT_LAYOUT_FEATURE_SELECTOR_ROMANIZATION_TO_KATAKANA", "romanization-to-katakana" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_HANJA_TO_HANGUL_ALT_ONE, "HB_AAT_LAYOUT_FEATURE_SELECTOR_HANJA_TO_HANGUL_ALT_ONE", "hanja-to-hangul-alt-one" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_HANJA_TO_HANGUL_ALT_TWO, "HB_AAT_LAYOUT_FEATURE_SELECTOR_HANJA_TO_HANGUL_ALT_TWO", "hanja-to-hangul-alt-two" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_HANJA_TO_HANGUL_ALT_THREE, "HB_AAT_LAYOUT_FEATURE_SELECTOR_HANJA_TO_HANGUL_ALT_THREE", "hanja-to-hangul-alt-three" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_ANNOTATION, "HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_ANNOTATION", "no-annotation" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_BOX_ANNOTATION, "HB_AAT_LAYOUT_FEATURE_SELECTOR_BOX_ANNOTATION", "box-annotation" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_ROUNDED_BOX_ANNOTATION, "HB_AAT_LAYOUT_FEATURE_SELECTOR_ROUNDED_BOX_ANNOTATION", "rounded-box-annotation" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_CIRCLE_ANNOTATION, "HB_AAT_LAYOUT_FEATURE_SELECTOR_CIRCLE_ANNOTATION", "circle-annotation" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_INVERTED_CIRCLE_ANNOTATION, "HB_AAT_LAYOUT_FEATURE_SELECTOR_INVERTED_CIRCLE_ANNOTATION", "inverted-circle-annotation" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_PARENTHESIS_ANNOTATION, "HB_AAT_LAYOUT_FEATURE_SELECTOR_PARENTHESIS_ANNOTATION", "parenthesis-annotation" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_PERIOD_ANNOTATION, "HB_AAT_LAYOUT_FEATURE_SELECTOR_PERIOD_ANNOTATION", "period-annotation" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_ROMAN_NUMERAL_ANNOTATION, "HB_AAT_LAYOUT_FEATURE_SELECTOR_ROMAN_NUMERAL_ANNOTATION", "roman-numeral-annotation" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_DIAMOND_ANNOTATION, "HB_AAT_LAYOUT_FEATURE_SELECTOR_DIAMOND_ANNOTATION", "diamond-annotation" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_INVERTED_BOX_ANNOTATION, "HB_AAT_LAYOUT_FEATURE_SELECTOR_INVERTED_BOX_ANNOTATION", "inverted-box-annotation" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_INVERTED_ROUNDED_BOX_ANNOTATION, "HB_AAT_LAYOUT_FEATURE_SELECTOR_INVERTED_ROUNDED_BOX_ANNOTATION", "inverted-rounded-box-annotation" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_FULL_WIDTH_KANA, "HB_AAT_LAYOUT_FEATURE_SELECTOR_FULL_WIDTH_KANA", "full-width-kana" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_KANA, "HB_AAT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_KANA", "proportional-kana" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_FULL_WIDTH_IDEOGRAPHS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_FULL_WIDTH_IDEOGRAPHS", "full-width-ideographs" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_IDEOGRAPHS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_IDEOGRAPHS", "proportional-ideographs" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_HALF_WIDTH_IDEOGRAPHS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_HALF_WIDTH_IDEOGRAPHS", "half-width-ideographs" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_CANONICAL_COMPOSITION_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_CANONICAL_COMPOSITION_ON", "canonical-composition-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_CANONICAL_COMPOSITION_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_CANONICAL_COMPOSITION_OFF", "canonical-composition-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_COMPATIBILITY_COMPOSITION_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_COMPATIBILITY_COMPOSITION_ON", "compatibility-composition-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_COMPATIBILITY_COMPOSITION_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_COMPATIBILITY_COMPOSITION_OFF", "compatibility-composition-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_TRANSCODING_COMPOSITION_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_TRANSCODING_COMPOSITION_ON", "transcoding-composition-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_TRANSCODING_COMPOSITION_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_TRANSCODING_COMPOSITION_OFF", "transcoding-composition-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_RUBY_KANA, "HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_RUBY_KANA", "no-ruby-kana" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_RUBY_KANA, "HB_AAT_LAYOUT_FEATURE_SELECTOR_RUBY_KANA", "ruby-kana" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_RUBY_KANA_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_RUBY_KANA_ON", "ruby-kana-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_RUBY_KANA_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_RUBY_KANA_OFF", "ruby-kana-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_CJK_SYMBOL_ALTERNATIVES, "HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_CJK_SYMBOL_ALTERNATIVES", "no-cjk-symbol-alternatives" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_ONE, "HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_ONE", "cjk-symbol-alt-one" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_TWO, "HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_TWO", "cjk-symbol-alt-two" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_THREE, "HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_THREE", "cjk-symbol-alt-three" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_FOUR, "HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_FOUR", "cjk-symbol-alt-four" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_FIVE, "HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_FIVE", "cjk-symbol-alt-five" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_IDEOGRAPHIC_ALTERNATIVES, "HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_IDEOGRAPHIC_ALTERNATIVES", "no-ideographic-alternatives" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_ONE, "HB_AAT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_ONE", "ideographic-alt-one" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_TWO, "HB_AAT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_TWO", "ideographic-alt-two" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_THREE, "HB_AAT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_THREE", "ideographic-alt-three" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_FOUR, "HB_AAT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_FOUR", "ideographic-alt-four" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_FIVE, "HB_AAT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_FIVE", "ideographic-alt-five" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_VERTICAL_ROMAN_CENTERED, "HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_VERTICAL_ROMAN_CENTERED", "cjk-vertical-roman-centered" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_VERTICAL_ROMAN_HBASELINE, "HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_VERTICAL_ROMAN_HBASELINE", "cjk-vertical-roman-hbaseline" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_CJK_ITALIC_ROMAN, "HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_CJK_ITALIC_ROMAN", "no-cjk-italic-roman" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_ITALIC_ROMAN, "HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_ITALIC_ROMAN", "cjk-italic-roman" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_ITALIC_ROMAN_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_ITALIC_ROMAN_ON", "cjk-italic-roman-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_ITALIC_ROMAN_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_ITALIC_ROMAN_OFF", "cjk-italic-roman-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_CASE_SENSITIVE_LAYOUT_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_CASE_SENSITIVE_LAYOUT_ON", "case-sensitive-layout-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_CASE_SENSITIVE_LAYOUT_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_CASE_SENSITIVE_LAYOUT_OFF", "case-sensitive-layout-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_CASE_SENSITIVE_SPACING_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_CASE_SENSITIVE_SPACING_ON", "case-sensitive-spacing-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_CASE_SENSITIVE_SPACING_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_CASE_SENSITIVE_SPACING_OFF", "case-sensitive-spacing-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_ALTERNATE_HORIZ_KANA_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_ALTERNATE_HORIZ_KANA_ON", "alternate-horiz-kana-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_ALTERNATE_HORIZ_KANA_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_ALTERNATE_HORIZ_KANA_OFF", "alternate-horiz-kana-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_ALTERNATE_VERT_KANA_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_ALTERNATE_VERT_KANA_ON", "alternate-vert-kana-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_ALTERNATE_VERT_KANA_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_ALTERNATE_VERT_KANA_OFF", "alternate-vert-kana-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_STYLISTIC_ALTERNATES, "HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_STYLISTIC_ALTERNATES", "no-stylistic-alternates" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_ONE_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_ONE_ON", "stylistic-alt-one-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_ONE_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_ONE_OFF", "stylistic-alt-one-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWO_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWO_ON", "stylistic-alt-two-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWO_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWO_OFF", "stylistic-alt-two-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_THREE_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_THREE_ON", "stylistic-alt-three-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_THREE_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_THREE_OFF", "stylistic-alt-three-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FOUR_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FOUR_ON", "stylistic-alt-four-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FOUR_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FOUR_OFF", "stylistic-alt-four-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FIVE_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FIVE_ON", "stylistic-alt-five-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FIVE_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FIVE_OFF", "stylistic-alt-five-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SIX_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SIX_ON", "stylistic-alt-six-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SIX_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SIX_OFF", "stylistic-alt-six-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SEVEN_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SEVEN_ON", "stylistic-alt-seven-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SEVEN_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SEVEN_OFF", "stylistic-alt-seven-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_EIGHT_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_EIGHT_ON", "stylistic-alt-eight-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_EIGHT_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_EIGHT_OFF", "stylistic-alt-eight-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_NINE_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_NINE_ON", "stylistic-alt-nine-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_NINE_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_NINE_OFF", "stylistic-alt-nine-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TEN_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TEN_ON", "stylistic-alt-ten-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TEN_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TEN_OFF", "stylistic-alt-ten-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_ELEVEN_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_ELEVEN_ON", "stylistic-alt-eleven-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_ELEVEN_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_ELEVEN_OFF", "stylistic-alt-eleven-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWELVE_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWELVE_ON", "stylistic-alt-twelve-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWELVE_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWELVE_OFF", "stylistic-alt-twelve-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_THIRTEEN_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_THIRTEEN_ON", "stylistic-alt-thirteen-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_THIRTEEN_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_THIRTEEN_OFF", "stylistic-alt-thirteen-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FOURTEEN_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FOURTEEN_ON", "stylistic-alt-fourteen-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FOURTEEN_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FOURTEEN_OFF", "stylistic-alt-fourteen-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FIFTEEN_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FIFTEEN_ON", "stylistic-alt-fifteen-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FIFTEEN_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FIFTEEN_OFF", "stylistic-alt-fifteen-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SIXTEEN_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SIXTEEN_ON", "stylistic-alt-sixteen-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SIXTEEN_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SIXTEEN_OFF", "stylistic-alt-sixteen-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SEVENTEEN_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SEVENTEEN_ON", "stylistic-alt-seventeen-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SEVENTEEN_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SEVENTEEN_OFF", "stylistic-alt-seventeen-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_EIGHTEEN_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_EIGHTEEN_ON", "stylistic-alt-eighteen-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_EIGHTEEN_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_EIGHTEEN_OFF", "stylistic-alt-eighteen-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_NINETEEN_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_NINETEEN_ON", "stylistic-alt-nineteen-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_NINETEEN_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_NINETEEN_OFF", "stylistic-alt-nineteen-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWENTY_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWENTY_ON", "stylistic-alt-twenty-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWENTY_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWENTY_OFF", "stylistic-alt-twenty-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_ALTERNATES_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_ALTERNATES_ON", "contextual-alternates-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_ALTERNATES_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_ALTERNATES_OFF", "contextual-alternates-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_SWASH_ALTERNATES_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_SWASH_ALTERNATES_ON", "swash-alternates-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_SWASH_ALTERNATES_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_SWASH_ALTERNATES_OFF", "swash-alternates-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_SWASH_ALTERNATES_ON, "HB_AAT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_SWASH_ALTERNATES_ON", "contextual-swash-alternates-on" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_SWASH_ALTERNATES_OFF, "HB_AAT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_SWASH_ALTERNATES_OFF", "contextual-swash-alternates-off" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_DEFAULT_LOWER_CASE, "HB_AAT_LAYOUT_FEATURE_SELECTOR_DEFAULT_LOWER_CASE", "default-lower-case" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_LOWER_CASE_SMALL_CAPS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_LOWER_CASE_SMALL_CAPS", "lower-case-small-caps" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_LOWER_CASE_PETITE_CAPS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_LOWER_CASE_PETITE_CAPS", "lower-case-petite-caps" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_DEFAULT_UPPER_CASE, "HB_AAT_LAYOUT_FEATURE_SELECTOR_DEFAULT_UPPER_CASE", "default-upper-case" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_UPPER_CASE_SMALL_CAPS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_UPPER_CASE_SMALL_CAPS", "upper-case-small-caps" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_UPPER_CASE_PETITE_CAPS, "HB_AAT_LAYOUT_FEATURE_SELECTOR_UPPER_CASE_PETITE_CAPS", "upper-case-petite-caps" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_HALF_WIDTH_CJK_ROMAN, "HB_AAT_LAYOUT_FEATURE_SELECTOR_HALF_WIDTH_CJK_ROMAN", "half-width-cjk-roman" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_CJK_ROMAN, "HB_AAT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_CJK_ROMAN", "proportional-cjk-roman" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_DEFAULT_CJK_ROMAN, "HB_AAT_LAYOUT_FEATURE_SELECTOR_DEFAULT_CJK_ROMAN", "default-cjk-roman" },
        { HB_AAT_LAYOUT_FEATURE_SELECTOR_FULL_WIDTH_CJK_ROMAN, "HB_AAT_LAYOUT_FEATURE_SELECTOR_FULL_WIDTH_CJK_ROMAN", "full-width-cjk-roman" },
        { 0, NULL, NULL }
      };
      GType id =
        g_enum_register_static (g_intern_static_string ("hb_aat_layout_feature_selector_t"), values);
      g_once_init_leave (&type_id, id);
    }

  return type_id;
}
/* enumerations from "hb-blob.h" */
GType
hb_gobject_memory_mode_get_type ()
{
  static gsize type_id = 0;

  if (g_once_init_enter (&type_id))
    {
      static const GEnumValue values[] = {
        { HB_MEMORY_MODE_DUPLICATE, "HB_MEMORY_MODE_DUPLICATE", "duplicate" },
        { HB_MEMORY_MODE_READONLY, "HB_MEMORY_MODE_READONLY", "readonly" },
        { HB_MEMORY_MODE_WRITABLE, "HB_MEMORY_MODE_WRITABLE", "writable" },
        { HB_MEMORY_MODE_READONLY_MAY_MAKE_WRITABLE, "HB_MEMORY_MODE_READONLY_MAY_MAKE_WRITABLE", "readonly-may-make-writable" },
        { 0, NULL, NULL }
      };
      GType id =
        g_enum_register_static (g_intern_static_string ("hb_memory_mode_t"), values);
      g_once_init_leave (&type_id, id);
    }

  return type_id;
}
/* enumerations from "hb-buffer.h" */
GType
hb_gobject_glyph_flags_get_type ()
{
  static gsize type_id = 0;

  if (g_once_init_enter (&type_id))
    {
      static const GFlagsValue values[] = {
        { HB_GLYPH_FLAG_UNSAFE_TO_BREAK, "HB_GLYPH_FLAG_UNSAFE_TO_BREAK", "unsafe-to-break" },
        { HB_GLYPH_FLAG_UNSAFE_TO_CONCAT, "HB_GLYPH_FLAG_UNSAFE_TO_CONCAT", "unsafe-to-concat" },
        { HB_GLYPH_FLAG_SAFE_TO_INSERT_TATWEEL, "HB_GLYPH_FLAG_SAFE_TO_INSERT_TATWEEL", "safe-to-insert-tatweel" },
        { HB_GLYPH_FLAG_DEFINED, "HB_GLYPH_FLAG_DEFINED", "defined" },
        { 0, NULL, NULL }
      };
      GType id =
        g_flags_register_static (g_intern_static_string ("hb_glyph_flags_t"), values);
      g_once_init_leave (&type_id, id);
    }

  return type_id;
}
GType
hb_gobject_buffer_content_type_get_type ()
{
  static gsize type_id = 0;

  if (g_once_init_enter (&type_id))
    {
      static const GEnumValue values[] = {
        { HB_BUFFER_CONTENT_TYPE_INVALID, "HB_BUFFER_CONTENT_TYPE_INVALID", "invalid" },
        { HB_BUFFER_CONTENT_TYPE_UNICODE, "HB_BUFFER_CONTENT_TYPE_UNICODE", "unicode" },
        { HB_BUFFER_CONTENT_TYPE_GLYPHS, "HB_BUFFER_CONTENT_TYPE_GLYPHS", "glyphs" },
        { 0, NULL, NULL }
      };
      GType id =
        g_enum_register_static (g_intern_static_string ("hb_buffer_content_type_t"), values);
      g_once_init_leave (&type_id, id);
    }

  return type_id;
}
GType
hb_gobject_buffer_flags_get_type ()
{
  static gsize type_id = 0;

  if (g_once_init_enter (&type_id))
    {
      static const GFlagsValue values[] = {
        { HB_BUFFER_FLAG_DEFAULT, "HB_BUFFER_FLAG_DEFAULT", "default" },
        { HB_BUFFER_FLAG_BOT, "HB_BUFFER_FLAG_BOT", "bot" },
        { HB_BUFFER_FLAG_EOT, "HB_BUFFER_FLAG_EOT", "eot" },
        { HB_BUFFER_FLAG_PRESERVE_DEFAULT_IGNORABLES, "HB_BUFFER_FLAG_PRESERVE_DEFAULT_IGNORABLES", "preserve-default-ignorables" },
        { HB_BUFFER_FLAG_REMOVE_DEFAULT_IGNORABLES, "HB_BUFFER_FLAG_REMOVE_DEFAULT_IGNORABLES", "remove-default-ignorables" },
        { HB_BUFFER_FLAG_DO_NOT_INSERT_DOTTED_CIRCLE, "HB_BUFFER_FLAG_DO_NOT_INSERT_DOTTED_CIRCLE", "do-not-insert-dotted-circle" },
        { HB_BUFFER_FLAG_VERIFY, "HB_BUFFER_FLAG_VERIFY", "verify" },
        { HB_BUFFER_FLAG_PRODUCE_UNSAFE_TO_CONCAT, "HB_BUFFER_FLAG_PRODUCE_UNSAFE_TO_CONCAT", "produce-unsafe-to-concat" },
        { HB_BUFFER_FLAG_PRODUCE_SAFE_TO_INSERT_TATWEEL, "HB_BUFFER_FLAG_PRODUCE_SAFE_TO_INSERT_TATWEEL", "produce-safe-to-insert-tatweel" },
        { HB_BUFFER_FLAG_DEFINED, "HB_BUFFER_FLAG_DEFINED", "defined" },
        { 0, NULL, NULL }
      };
      GType id =
        g_flags_register_static (g_intern_static_string ("hb_buffer_flags_t"), values);
      g_once_init_leave (&type_id, id);
    }

  return type_id;
}
GType
hb_gobject_buffer_cluster_level_get_type ()
{
  static gsize type_id = 0;

  if (g_once_init_enter (&type_id))
    {
      static const GEnumValue values[] = {
        { HB_BUFFER_CLUSTER_LEVEL_MONOTONE_GRAPHEMES, "HB_BUFFER_CLUSTER_LEVEL_MONOTONE_GRAPHEMES", "monotone-graphemes" },
        { HB_BUFFER_CLUSTER_LEVEL_MONOTONE_CHARACTERS, "HB_BUFFER_CLUSTER_LEVEL_MONOTONE_CHARACTERS", "monotone-characters" },
        { HB_BUFFER_CLUSTER_LEVEL_CHARACTERS, "HB_BUFFER_CLUSTER_LEVEL_CHARACTERS", "characters" },
        { HB_BUFFER_CLUSTER_LEVEL_DEFAULT, "HB_BUFFER_CLUSTER_LEVEL_DEFAULT", "default" },
        { 0, NULL, NULL }
      };
      GType id =
        g_enum_register_static (g_intern_static_string ("hb_buffer_cluster_level_t"), values);
      g_once_init_leave (&type_id, id);
    }

  return type_id;
}
GType
hb_gobject_buffer_serialize_flags_get_type ()
{
  static gsize type_id = 0;

  if (g_once_init_enter (&type_id))
    {
      static const GFlagsValue values[] = {
        { HB_BUFFER_SERIALIZE_FLAG_DEFAULT, "HB_BUFFER_SERIALIZE_FLAG_DEFAULT", "default" },
        { HB_BUFFER_SERIALIZE_FLAG_NO_CLUSTERS, "HB_BUFFER_SERIALIZE_FLAG_NO_CLUSTERS", "no-clusters" },
        { HB_BUFFER_SERIALIZE_FLAG_NO_POSITIONS, "HB_BUFFER_SERIALIZE_FLAG_NO_POSITIONS", "no-positions" },
        { HB_BUFFER_SERIALIZE_FLAG_NO_GLYPH_NAMES, "HB_BUFFER_SERIALIZE_FLAG_NO_GLYPH_NAMES", "no-glyph-names" },
        { HB_BUFFER_SERIALIZE_FLAG_GLYPH_EXTENTS, "HB_BUFFER_SERIALIZE_FLAG_GLYPH_EXTENTS", "glyph-extents" },
        { HB_BUFFER_SERIALIZE_FLAG_GLYPH_FLAGS, "HB_BUFFER_SERIALIZE_FLAG_GLYPH_FLAGS", "glyph-flags" },
        { HB_BUFFER_SERIALIZE_FLAG_NO_ADVANCES, "HB_BUFFER_SERIALIZE_FLAG_NO_ADVANCES", "no-advances" },
        { HB_BUFFER_SERIALIZE_FLAG_DEFINED, "HB_BUFFER_SERIALIZE_FLAG_DEFINED", "defined" },
        { 0, NULL, NULL }
      };
      GType id =
        g_flags_register_static (g_intern_static_string ("hb_buffer_serialize_flags_t"), values);
      g_once_init_leave (&type_id, id);
    }

  return type_id;
}
GType
hb_gobject_buffer_serialize_format_get_type ()
{
  static gsize type_id = 0;

  if (g_once_init_enter (&type_id))
    {
      static const GEnumValue values[] = {
        { HB_BUFFER_SERIALIZE_FORMAT_TEXT, "HB_BUFFER_SERIALIZE_FORMAT_TEXT", "text" },
        { HB_BUFFER_SERIALIZE_FORMAT_JSON, "HB_BUFFER_SERIALIZE_FORMAT_JSON", "json" },
        { HB_BUFFER_SERIALIZE_FORMAT_INVALID, "HB_BUFFER_SERIALIZE_FORMAT_INVALID", "invalid" },
        { 0, NULL, NULL }
      };
      GType id =
        g_enum_register_static (g_intern_static_string ("hb_buffer_serialize_format_t"), values);
      g_once_init_leave (&type_id, id);
    }

  return type_id;
}
GType
hb_gobject_buffer_diff_flags_get_type ()
{
  static gsize type_id = 0;

  if (g_once_init_enter (&type_id))
    {
      static const GFlagsValue values[] = {
        { HB_BUFFER_DIFF_FLAG_EQUAL, "HB_BUFFER_DIFF_FLAG_EQUAL", "equal" },
        { HB_BUFFER_DIFF_FLAG_CONTENT_TYPE_MISMATCH, "HB_BUFFER_DIFF_FLAG_CONTENT_TYPE_MISMATCH", "content-type-mismatch" },
        { HB_BUFFER_DIFF_FLAG_LENGTH_MISMATCH, "HB_BUFFER_DIFF_FLAG_LENGTH_MISMATCH", "length-mismatch" },
        { HB_BUFFER_DIFF_FLAG_NOTDEF_PRESENT, "HB_BUFFER_DIFF_FLAG_NOTDEF_PRESENT", "notdef-present" },
        { HB_BUFFER_DIFF_FLAG_DOTTED_CIRCLE_PRESENT, "HB_BUFFER_DIFF_FLAG_DOTTED_CIRCLE_PRESENT", "dotted-circle-present" },
        { HB_BUFFER_DIFF_FLAG_CODEPOINT_MISMATCH, "HB_BUFFER_DIFF_FLAG_CODEPOINT_MISMATCH", "codepoint-mismatch" },
        { HB_BUFFER_DIFF_FLAG_CLUSTER_MISMATCH, "HB_BUFFER_DIFF_FLAG_CLUSTER_MISMATCH", "cluster-mismatch" },
        { HB_BUFFER_DIFF_FLAG_GLYPH_FLAGS_MISMATCH, "HB_BUFFER_DIFF_FLAG_GLYPH_FLAGS_MISMATCH", "glyph-flags-mismatch" },
        { HB_BUFFER_DIFF_FLAG_POSITION_MISMATCH, "HB_BUFFER_DIFF_FLAG_POSITION_MISMATCH", "position-mismatch" },
        { 0, NULL, NULL }
      };
      GType id =
        g_flags_register_static (g_intern_static_string ("hb_buffer_diff_flags_t"), values);
      g_once_init_leave (&type_id, id);
    }

  return type_id;
}
/* enumerations from "hb-common.h" */
GType
hb_gobject_direction_get_type ()
{
  static gsize type_id = 0;

  if (g_once_init_enter (&type_id))
    {
      static const GEnumValue values[] = {
        { HB_DIRECTION_INVALID, "HB_DIRECTION_INVALID", "invalid" },
        { HB_DIRECTION_LTR, "HB_DIRECTION_LTR", "ltr" },
        { HB_DIRECTION_RTL, "HB_DIRECTION_RTL", "rtl" },
        { HB_DIRECTION_TTB, "HB_DIRECTION_TTB", "ttb" },
        { HB_DIRECTION_BTT, "HB_DIRECTION_BTT", "btt" },
        { 0, NULL, NULL }
      };
      GType id =
        g_enum_register_static (g_intern_static_string ("hb_direction_t"), values);
      g_once_init_leave (&type_id, id);
    }

  return type_id;
}
GType
hb_gobject_script_get_type ()
{
  static gsize type_id = 0;

  if (g_once_init_enter (&type_id))
    {
      static const GEnumValue values[] = {
        { HB_SCRIPT_COMMON, "HB_SCRIPT_COMMON", "common" },
        { HB_SCRIPT_INHERITED, "HB_SCRIPT_INHERITED", "inherited" },
        { HB_SCRIPT_UNKNOWN, "HB_SCRIPT_UNKNOWN", "unknown" },
        { HB_SCRIPT_ARABIC, "HB_SCRIPT_ARABIC", "arabic" },
        { HB_SCRIPT_ARMENIAN, "HB_SCRIPT_ARMENIAN", "armenian" },
        { HB_SCRIPT_BENGALI, "HB_SCRIPT_BENGALI", "bengali" },
        { HB_SCRIPT_CYRILLIC, "HB_SCRIPT_CYRILLIC", "cyrillic" },
        { HB_SCRIPT_DEVANAGARI, "HB_SCRIPT_DEVANAGARI", "devanagari" },
        { HB_SCRIPT_GEORGIAN, "HB_SCRIPT_GEORGIAN", "georgian" },
        { HB_SCRIPT_GREEK, "HB_SCRIPT_GREEK", "greek" },
        { HB_SCRIPT_GUJARATI, "HB_SCRIPT_GUJARATI", "gujarati" },
        { HB_SCRIPT_GURMUKHI, "HB_SCRIPT_GURMUKHI", "gurmukhi" },
        { HB_SCRIPT_HANGUL, "HB_SCRIPT_HANGUL", "hangul" },
        { HB_SCRIPT_HAN, "HB_SCRIPT_HAN", "han" },
        { HB_SCRIPT_HEBREW, "HB_SCRIPT_HEBREW", "hebrew" },
        { HB_SCRIPT_HIRAGANA, "HB_SCRIPT_HIRAGANA", "hiragana" },
        { HB_SCRIPT_KANNADA, "HB_SCRIPT_KANNADA", "kannada" },
        { HB_SCRIPT_KATAKANA, "HB_SCRIPT_KATAKANA", "katakana" },
        { HB_SCRIPT_LAO, "HB_SCRIPT_LAO", "lao" },
        { HB_SCRIPT_LATIN, "HB_SCRIPT_LATIN", "latin" },
        { HB_SCRIPT_MALAYALAM, "HB_SCRIPT_MALAYALAM", "malayalam" },
        { HB_SCRIPT_ORIYA, "HB_SCRIPT_ORIYA", "oriya" },
        { HB_SCRIPT_TAMIL, "HB_SCRIPT_TAMIL", "tamil" },
        { HB_SCRIPT_TELUGU, "HB_SCRIPT_TELUGU", "telugu" },
        { HB_SCRIPT_THAI, "HB_SCRIPT_THAI", "thai" },
        { HB_SCRIPT_TIBETAN, "HB_SCRIPT_TIBETAN", "tibetan" },
        { HB_SCRIPT_BOPOMOFO, "HB_SCRIPT_BOPOMOFO", "bopomofo" },
        { HB_SCRIPT_BRAILLE, "HB_SCRIPT_BRAILLE", "braille" },
        { HB_SCRIPT_CANADIAN_SYLLABICS, "HB_SCRIPT_CANADIAN_SYLLABICS", "canadian-syllabics" },
        { HB_SCRIPT_CHEROKEE, "HB_SCRIPT_CHEROKEE", "cherokee" },
        { HB_SCRIPT_ETHIOPIC, "HB_SCRIPT_ETHIOPIC", "ethiopic" },
        { HB_SCRIPT_KHMER, "HB_SCRIPT_KHMER", "khmer" },
        { HB_SCRIPT_MONGOLIAN, "HB_SCRIPT_MONGOLIAN", "mongolian" },
        { HB_SCRIPT_MYANMAR, "HB_SCRIPT_MYANMAR", "myanmar" },
        { HB_SCRIPT_OGHAM, "HB_SCRIPT_OGHAM", "ogham" },
        { HB_SCRIPT_RUNIC, "HB_SCRIPT_RUNIC", "runic" },
        { HB_SCRIPT_SINHALA, "HB_SCRIPT_SINHALA", "sinhala" },
        { HB_SCRIPT_SYRIAC, "HB_SCRIPT_SYRIAC", "syriac" },
        { HB_SCRIPT_THAANA, "HB_SCRIPT_THAANA", "thaana" },
        { HB_SCRIPT_YI, "HB_SCRIPT_YI", "yi" },
        { HB_SCRIPT_DESERET, "HB_SCRIPT_DESERET", "deseret" },
        { HB_SCRIPT_GOTHIC, "HB_SCRIPT_GOTHIC", "gothic" },
        { HB_SCRIPT_OLD_ITALIC, "HB_SCRIPT_OLD_ITALIC", "old-italic" },
        { HB_SCRIPT_BUHID, "HB_SCRIPT_BUHID", "buhid" },
        { HB_SCRIPT_HANUNOO, "HB_SCRIPT_HANUNOO", "hanunoo" },
        { HB_SCRIPT_TAGALOG, "HB_SCRIPT_TAGALOG", "tagalog" },
        { HB_SCRIPT_TAGBANWA, "HB_SCRIPT_TAGBANWA", "tagbanwa" },
        { HB_SCRIPT_CYPRIOT, "HB_SCRIPT_CYPRIOT", "cypriot" },
        { HB_SCRIPT_LIMBU, "HB_SCRIPT_LIMBU", "limbu" },
        { HB_SCRIPT_LINEAR_B, "HB_SCRIPT_LINEAR_B", "linear-b" },
        { HB_SCRIPT_OSMANYA, "HB_SCRIPT_OSMANYA", "osmanya" },
        { HB_SCRIPT_SHAVIAN, "HB_SCRIPT_SHAVIAN", "shavian" },
        { HB_SCRIPT_TAI_LE, "HB_SCRIPT_TAI_LE", "tai-le" },
        { HB_SCRIPT_UGARITIC, "HB_SCRIPT_UGARITIC", "ugaritic" },
        { HB_SCRIPT_BUGINESE, "HB_SCRIPT_BUGINESE", "buginese" },
        { HB_SCRIPT_COPTIC, "HB_SCRIPT_COPTIC", "coptic" },
        { HB_SCRIPT_GLAGOLITIC, "HB_SCRIPT_GLAGOLITIC", "glagolitic" },
        { HB_SCRIPT_KHAROSHTHI, "HB_SCRIPT_KHAROSHTHI", "kharoshthi" },
        { HB_SCRIPT_NEW_TAI_LUE, "HB_SCRIPT_NEW_TAI_LUE", "new-tai-lue" },
        { HB_SCRIPT_OLD_PERSIAN, "HB_SCRIPT_OLD_PERSIAN", "old-persian" },
        { HB_SCRIPT_SYLOTI_NAGRI, "HB_SCRIPT_SYLOTI_NAGRI", "syloti-nagri" },
        { HB_SCRIPT_TIFINAGH, "HB_SCRIPT_TIFINAGH", "tifinagh" },
        { HB_SCRIPT_BALINESE, "HB_SCRIPT_BALINESE", "balinese" },
        { HB_SCRIPT_CUNEIFORM, "HB_SCRIPT_CUNEIFORM", "cuneiform" },
        { HB_SCRIPT_NKO, "HB_SCRIPT_NKO", "nko" },
        { HB_SCRIPT_PHAGS_PA, "HB_SCRIPT_PHAGS_PA", "phags-pa" },
        { HB_SCRIPT_PHOENICIAN, "HB_SCRIPT_PHOENICIAN", "phoenician" },
        { HB_SCRIPT_CARIAN, "HB_SCRIPT_CARIAN", "carian" },
        { HB_SCRIPT_CHAM, "HB_SCRIPT_CHAM", "cham" },
        { HB_SCRIPT_KAYAH_LI, "HB_SCRIPT_KAYAH_LI", "kayah-li" },
        { HB_SCRIPT_LEPCHA, "HB_SCRIPT_LEPCHA", "lepcha" },
        { HB_SCRIPT_LYCIAN, "HB_SCRIPT_LYCIAN", "lycian" },
        { HB_SCRIPT_LYDIAN, "HB_SCRIPT_LYDIAN", "lydian" },
        { HB_SCRIPT_OL_CHIKI, "HB_SCRIPT_OL_CHIKI", "ol-chiki" },
        { HB_SCRIPT_REJANG, "HB_SCRIPT_REJANG", "rejang" },
        { HB_SCRIPT_SAURASHTRA, "HB_SCRIPT_SAURASHTRA", "saurashtra" },
        { HB_SCRIPT_SUNDANESE, "HB_SCRIPT_SUNDANESE", "sundanese" },
        { HB_SCRIPT_VAI, "HB_SCRIPT_VAI", "vai" },
        { HB_SCRIPT_AVESTAN, "HB_SCRIPT_AVESTAN", "avestan" },
        { HB_SCRIPT_BAMUM, "HB_SCRIPT_BAMUM", "bamum" },
        { HB_SCRIPT_EGYPTIAN_HIEROGLYPHS, "HB_SCRIPT_EGYPTIAN_HIEROGLYPHS", "egyptian-hieroglyphs" },
        { HB_SCRIPT_IMPERIAL_ARAMAIC, "HB_SCRIPT_IMPERIAL_ARAMAIC", "imperial-aramaic" },
        { HB_SCRIPT_INSCRIPTIONAL_PAHLAVI, "HB_SCRIPT_INSCRIPTIONAL_PAHLAVI", "inscriptional-pahlavi" },
        { HB_SCRIPT_INSCRIPTIONAL_PARTHIAN, "HB_SCRIPT_INSCRIPTIONAL_PARTHIAN", "inscriptional-parthian" },
        { HB_SCRIPT_JAVANESE, "HB_SCRIPT_JAVANESE", "javanese" },
        { HB_SCRIPT_KAITHI, "HB_SCRIPT_KAITHI", "kaithi" },
        { HB_SCRIPT_LISU, "HB_SCRIPT_LISU", "lisu" },
        { HB_SCRIPT_MEETEI_MAYEK, "HB_SCRIPT_MEETEI_MAYEK", "meetei-mayek" },
        { HB_SCRIPT_OLD_SOUTH_ARABIAN, "HB_SCRIPT_OLD_SOUTH_ARABIAN", "old-south-arabian" },
        { HB_SCRIPT_OLD_TURKIC, "HB_SCRIPT_OLD_TURKIC", "old-turkic" },
        { HB_SCRIPT_SAMARITAN, "HB_SCRIPT_SAMARITAN", "samaritan" },
        { HB_SCRIPT_TAI_THAM, "HB_SCRIPT_TAI_THAM", "tai-tham" },
        { HB_SCRIPT_TAI_VIET, "HB_SCRIPT_TAI_VIET", "tai-viet" },
        { HB_SCRIPT_BATAK, "HB_SCRIPT_BATAK", "batak" },
        { HB_SCRIPT_BRAHMI, "HB_SCRIPT_BRAHMI", "brahmi" },
        { HB_SCRIPT_MANDAIC, "HB_SCRIPT_MANDAIC", "mandaic" },
        { HB_SCRIPT_CHAKMA, "HB_SCRIPT_CHAKMA", "chakma" },
        { HB_SCRIPT_MEROITIC_CURSIVE, "HB_SCRIPT_MEROITIC_CURSIVE", "meroitic-cursive" },
        { HB_SCRIPT_MEROITIC_HIEROGLYPHS, "HB_SCRIPT_MEROITIC_HIEROGLYPHS", "meroitic-hieroglyphs" },
        { HB_SCRIPT_MIAO, "HB_SCRIPT_MIAO", "miao" },
        { HB_SCRIPT_SHARADA, "HB_SCRIPT_SHARADA", "sharada" },
        { HB_SCRIPT_SORA_SOMPENG, "HB_SCRIPT_SORA_SOMPENG", "sora-sompeng" },
        { HB_SCRIPT_TAKRI, "HB_SCRIPT_TAKRI", "takri" },
        { HB_SCRIPT_BASSA_VAH, "HB_SCRIPT_BASSA_VAH", "bassa-vah" },
        { HB_SCRIPT_CAUCASIAN_ALBANIAN, "HB_SCRIPT_CAUCASIAN_ALBANIAN", "caucasian-albanian" },
        { HB_SCRIPT_DUPLOYAN, "HB_SCRIPT_DUPLOYAN", "duployan" },
        { HB_SCRIPT_ELBASAN, "HB_SCRIPT_ELBASAN", "elbasan" },
        { HB_SCRIPT_GRANTHA, "HB_SCRIPT_GRANTHA", "grantha" },
        { HB_SCRIPT_KHOJKI, "HB_SCRIPT_KHOJKI", "khojki" },
        { HB_SCRIPT_KHUDAWADI, "HB_SCRIPT_KHUDAWADI", "khudawadi" },
        { HB_SCRIPT_LINEAR_A, "HB_SCRIPT_LINEAR_A", "linear-a" },
        { HB_SCRIPT_MAHAJANI, "HB_SCRIPT_MAHAJANI", "mahajani" },
        { HB_SCRIPT_MANICHAEAN, "HB_SCRIPT_MANICHAEAN", "manichaean" },
        { HB_SCRIPT_MENDE_KIKAKUI, "HB_SCRIPT_MENDE_KIKAKUI", "mende-kikakui" },
        { HB_SCRIPT_MODI, "HB_SCRIPT_MODI", "modi" },
        { HB_SCRIPT_MRO, "HB_SCRIPT_MRO", "mro" },
        { HB_SCRIPT_NABATAEAN, "HB_SCRIPT_NABATAEAN", "nabataean" },
        { HB_SCRIPT_OLD_NORTH_ARABIAN, "HB_SCRIPT_OLD_NORTH_ARABIAN", "old-north-arabian" },
        { HB_SCRIPT_OLD_PERMIC, "HB_SCRIPT_OLD_PERMIC", "old-permic" },
        { HB_SCRIPT_PAHAWH_HMONG, "HB_SCRIPT_PAHAWH_HMONG", "pahawh-hmong" },
        { HB_SCRIPT_PALMYRENE, "HB_SCRIPT_PALMYRENE", "palmyrene" },
        { HB_SCRIPT_PAU_CIN_HAU, "HB_SCRIPT_PAU_CIN_HAU", "pau-cin-hau" },
        { HB_SCRIPT_PSALTER_PAHLAVI, "HB_SCRIPT_PSALTER_PAHLAVI", "psalter-pahlavi" },
        { HB_SCRIPT_SIDDHAM, "HB_SCRIPT_SIDDHAM", "siddham" },
        { HB_SCRIPT_TIRHUTA, "HB_SCRIPT_TIRHUTA", "tirhuta" },
        { HB_SCRIPT_WARANG_CITI, "HB_SCRIPT_WARANG_CITI", "warang-citi" },
        { HB_SCRIPT_AHOM, "HB_SCRIPT_AHOM", "ahom" },
        { HB_SCRIPT_ANATOLIAN_HIEROGLYPHS, "HB_SCRIPT_ANATOLIAN_HIEROGLYPHS", "anatolian-hieroglyphs" },
        { HB_SCRIPT_HATRAN, "HB_SCRIPT_HATRAN", "hatran" },
        { HB_SCRIPT_MULTANI, "HB_SCRIPT_MULTANI", "multani" },
        { HB_SCRIPT_OLD_HUNGARIAN, "HB_SCRIPT_OLD_HUNGARIAN", "old-hungarian" },
        { HB_SCRIPT_SIGNWRITING, "HB_SCRIPT_SIGNWRITING", "signwriting" },
        { HB_SCRIPT_ADLAM, "HB_SCRIPT_ADLAM", "adlam" },
        { HB_SCRIPT_BHAIKSUKI, "HB_SCRIPT_BHAIKSUKI", "bhaiksuki" },
        { HB_SCRIPT_MARCHEN, "HB_SCRIPT_MARCHEN", "marchen" },
        { HB_SCRIPT_OSAGE, "HB_SCRIPT_OSAGE", "osage" },
        { HB_SCRIPT_TANGUT, "HB_SCRIPT_TANGUT", "tangut" },
        { HB_SCRIPT_NEWA, "HB_SCRIPT_NEWA", "newa" },
        { HB_SCRIPT_MASARAM_GONDI, "HB_SCRIPT_MASARAM_GONDI", "masaram-gondi" },
        { HB_SCRIPT_NUSHU, "HB_SCRIPT_NUSHU", "nushu" },
        { HB_SCRIPT_SOYOMBO, "HB_SCRIPT_SOYOMBO", "soyombo" },
        { HB_SCRIPT_ZANABAZAR_SQUARE, "HB_SCRIPT_ZANABAZAR_SQUARE", "zanabazar-square" },
        { HB_SCRIPT_DOGRA, "HB_SCRIPT_DOGRA", "dogra" },
        { HB_SCRIPT_GUNJALA_GONDI, "HB_SCRIPT_GUNJALA_GONDI", "gunjala-gondi" },
        { HB_SCRIPT_HANIFI_ROHINGYA, "HB_SCRIPT_HANIFI_ROHINGYA", "hanifi-rohingya" },
        { HB_SCRIPT_MAKASAR, "HB_SCRIPT_MAKASAR", "makasar" },
        { HB_SCRIPT_MEDEFAIDRIN, "HB_SCRIPT_MEDEFAIDRIN", "medefaidrin" },
        { HB_SCRIPT_OLD_SOGDIAN, "HB_SCRIPT_OLD_SOGDIAN", "old-sogdian" },
        { HB_SCRIPT_SOGDIAN, "HB_SCRIPT_SOGDIAN", "sogdian" },
        { HB_SCRIPT_ELYMAIC, "HB_SCRIPT_ELYMAIC", "elymaic" },
        { HB_SCRIPT_NANDINAGARI, "HB_SCRIPT_NANDINAGARI", "nandinagari" },
        { HB_SCRIPT_NYIAKENG_PUACHUE_HMONG, "HB_SCRIPT_NYIAKENG_PUACHUE_HMONG", "nyiakeng-puachue-hmong" },
        { HB_SCRIPT_WANCHO, "HB_SCRIPT_WANCHO", "wancho" },
        { HB_SCRIPT_CHORASMIAN, "HB_SCRIPT_CHORASMIAN", "chorasmian" },
        { HB_SCRIPT_DIVES_AKURU, "HB_SCRIPT_DIVES_AKURU", "dives-akuru" },
        { HB_SCRIPT_KHITAN_SMALL_SCRIPT, "HB_SCRIPT_KHITAN_SMALL_SCRIPT", "khitan-small-script" },
        { HB_SCRIPT_YEZIDI, "HB_SCRIPT_YEZIDI", "yezidi" },
        { HB_SCRIPT_CYPRO_MINOAN, "HB_SCRIPT_CYPRO_MINOAN", "cypro-minoan" },
        { HB_SCRIPT_OLD_UYGHUR, "HB_SCRIPT_OLD_UYGHUR", "old-uyghur" },
        { HB_SCRIPT_TANGSA, "HB_SCRIPT_TANGSA", "tangsa" },
        { HB_SCRIPT_TOTO, "HB_SCRIPT_TOTO", "toto" },
        { HB_SCRIPT_VITHKUQI, "HB_SCRIPT_VITHKUQI", "vithkuqi" },
        { HB_SCRIPT_MATH, "HB_SCRIPT_MATH", "math" },
        { HB_SCRIPT_KAWI, "HB_SCRIPT_KAWI", "kawi" },
        { HB_SCRIPT_NAG_MUNDARI, "HB_SCRIPT_NAG_MUNDARI", "nag-mundari" },
        { HB_SCRIPT_INVALID, "HB_SCRIPT_INVALID", "invalid" },
        { 0, NULL, NULL }
      };
      GType id =
        g_enum_register_static (g_intern_static_string ("hb_script_t"), values);
      g_once_init_leave (&type_id, id);
    }

  return type_id;
}
/* enumerations from "hb-ot-color.h" */
GType
hb_gobject_ot_color_palette_flags_get_type ()
{
  static gsize type_id = 0;

  if (g_once_init_enter (&type_id))
    {
      static const GFlagsValue values[] = {
        { HB_OT_COLOR_PALETTE_FLAG_DEFAULT, "HB_OT_COLOR_PALETTE_FLAG_DEFAULT", "default" },
        { HB_OT_COLOR_PALETTE_FLAG_USABLE_WITH_LIGHT_BACKGROUND, "HB_OT_COLOR_PALETTE_FLAG_USABLE_WITH_LIGHT_BACKGROUND", "usable-with-light-background" },
        { HB_OT_COLOR_PALETTE_FLAG_USABLE_WITH_DARK_BACKGROUND, "HB_OT_COLOR_PALETTE_FLAG_USABLE_WITH_DARK_BACKGROUND", "usable-with-dark-background" },
        { 0, NULL, NULL }
      };
      GType id =
        g_flags_register_static (g_intern_static_string ("hb_ot_color_palette_flags_t"), values);
      g_once_init_leave (&type_id, id);
    }

  return type_id;
}
/* enumerations from "hb-ot-layout.h" */
GType
hb_gobject_ot_layout_glyph_class_get_type ()
{
  static gsize type_id = 0;

  if (g_once_init_enter (&type_id))
    {
      static const GEnumValue values[] = {
        { HB_OT_LAYOUT_GLYPH_CLASS_UNCLASSIFIED, "HB_OT_LAYOUT_GLYPH_CLASS_UNCLASSIFIED", "unclassified" },
        { HB_OT_LAYOUT_GLYPH_CLASS_BASE_GLYPH, "HB_OT_LAYOUT_GLYPH_CLASS_BASE_GLYPH", "base-glyph" },
        { HB_OT_LAYOUT_GLYPH_CLASS_LIGATURE, "HB_OT_LAYOUT_GLYPH_CLASS_LIGATURE", "ligature" },
        { HB_OT_LAYOUT_GLYPH_CLASS_MARK, "HB_OT_LAYOUT_GLYPH_CLASS_MARK", "mark" },
        { HB_OT_LAYOUT_GLYPH_CLASS_COMPONENT, "HB_OT_LAYOUT_GLYPH_CLASS_COMPONENT", "component" },
        { 0, NULL, NULL }
      };
      GType id =
        g_enum_register_static (g_intern_static_string ("hb_ot_layout_glyph_class_t"), values);
      g_once_init_leave (&type_id, id);
    }

  return type_id;
}
GType
hb_gobject_ot_layout_baseline_tag_get_type ()
{
  static gsize type_id = 0;

  if (g_once_init_enter (&type_id))
    {
      static const GEnumValue values[] = {
        { HB_OT_LAYOUT_BASELINE_TAG_ROMAN, "HB_OT_LAYOUT_BASELINE_TAG_ROMAN", "roman" },
        { HB_OT_LAYOUT_BASELINE_TAG_HANGING, "HB_OT_LAYOUT_BASELINE_TAG_HANGING", "hanging" },
        { HB_OT_LAYOUT_BASELINE_TAG_IDEO_FACE_BOTTOM_OR_LEFT, "HB_OT_LAYOUT_BASELINE_TAG_IDEO_FACE_BOTTOM_OR_LEFT", "ideo-face-bottom-or-left" },
        { HB_OT_LAYOUT_BASELINE_TAG_IDEO_FACE_TOP_OR_RIGHT, "HB_OT_LAYOUT_BASELINE_TAG_IDEO_FACE_TOP_OR_RIGHT", "ideo-face-top-or-right" },
        { HB_OT_LAYOUT_BASELINE_TAG_IDEO_FACE_CENTRAL, "HB_OT_LAYOUT_BASELINE_TAG_IDEO_FACE_CENTRAL", "ideo-face-central" },
        { HB_OT_LAYOUT_BASELINE_TAG_IDEO_EMBOX_BOTTOM_OR_LEFT, "HB_OT_LAYOUT_BASELINE_TAG_IDEO_EMBOX_BOTTOM_OR_LEFT", "ideo-embox-bottom-or-left" },
        { HB_OT_LAYOUT_BASELINE_TAG_IDEO_EMBOX_TOP_OR_RIGHT, "HB_OT_LAYOUT_BASELINE_TAG_IDEO_EMBOX_TOP_OR_RIGHT", "ideo-embox-top-or-right" },
        { HB_OT_LAYOUT_BASELINE_TAG_IDEO_EMBOX_CENTRAL, "HB_OT_LAYOUT_BASELINE_TAG_IDEO_EMBOX_CENTRAL", "ideo-embox-central" },
        { HB_OT_LAYOUT_BASELINE_TAG_MATH, "HB_OT_LAYOUT_BASELINE_TAG_MATH", "math" },
        { 0, NULL, NULL }
      };
      GType id =
        g_enum_register_static (g_intern_static_string ("hb_ot_layout_baseline_tag_t"), values);
      g_once_init_leave (&type_id, id);
    }

  return type_id;
}
/* enumerations from "hb-ot-math.h" */
GType
hb_gobject_ot_math_constant_get_type ()
{
  static gsize type_id = 0;

  if (g_once_init_enter (&type_id))
    {
      static const GEnumValue values[] = {
        { HB_OT_MATH_CONSTANT_SCRIPT_PERCENT_SCALE_DOWN, "HB_OT_MATH_CONSTANT_SCRIPT_PERCENT_SCALE_DOWN", "script-percent-scale-down" },
        { HB_OT_MATH_CONSTANT_SCRIPT_SCRIPT_PERCENT_SCALE_DOWN, "HB_OT_MATH_CONSTANT_SCRIPT_SCRIPT_PERCENT_SCALE_DOWN", "script-script-percent-scale-down" },
        { HB_OT_MATH_CONSTANT_DELIMITED_SUB_FORMULA_MIN_HEIGHT, "HB_OT_MATH_CONSTANT_DELIMITED_SUB_FORMULA_MIN_HEIGHT", "delimited-sub-formula-min-height" },
        { HB_OT_MATH_CONSTANT_DISPLAY_OPERATOR_MIN_HEIGHT, "HB_OT_MATH_CONSTANT_DISPLAY_OPERATOR_MIN_HEIGHT", "display-operator-min-height" },
        { HB_OT_MATH_CONSTANT_MATH_LEADING, "HB_OT_MATH_CONSTANT_MATH_LEADING", "math-leading" },
        { HB_OT_MATH_CONSTANT_AXIS_HEIGHT, "HB_OT_MATH_CONSTANT_AXIS_HEIGHT", "axis-height" },
        { HB_OT_MATH_CONSTANT_ACCENT_BASE_HEIGHT, "HB_OT_MATH_CONSTANT_ACCENT_BASE_HEIGHT", "accent-base-height" },
        { HB_OT_MATH_CONSTANT_FLATTENED_ACCENT_BASE_HEIGHT, "HB_OT_MATH_CONSTANT_FLATTENED_ACCENT_BASE_HEIGHT", "flattened-accent-base-height" },
        { HB_OT_MATH_CONSTANT_SUBSCRIPT_SHIFT_DOWN, "HB_OT_MATH_CONSTANT_SUBSCRIPT_SHIFT_DOWN", "subscript-shift-down" },
        { HB_OT_MATH_CONSTANT_SUBSCRIPT_TOP_MAX, "HB_OT_MATH_CONSTANT_SUBSCRIPT_TOP_MAX", "subscript-top-max" },
        { HB_OT_MATH_CONSTANT_SUBSCRIPT_BASELINE_DROP_MIN, "HB_OT_MATH_CONSTANT_SUBSCRIPT_BASELINE_DROP_MIN", "subscript-baseline-drop-min" },
        { HB_OT_MATH_CONSTANT_SUPERSCRIPT_SHIFT_UP, "HB_OT_MATH_CONSTANT_SUPERSCRIPT_SHIFT_UP", "superscript-shift-up" },
        { HB_OT_MATH_CONSTANT_SUPERSCRIPT_SHIFT_UP_CRAMPED, "HB_OT_MATH_CONSTANT_SUPERSCRIPT_SHIFT_UP_CRAMPED", "superscript-shift-up-cramped" },
        { HB_OT_MATH_CONSTANT_SUPERSCRIPT_BOTTOM_MIN, "HB_OT_MATH_CONSTANT_SUPERSCRIPT_BOTTOM_MIN", "superscript-bottom-min" },
        { HB_OT_MATH_CONSTANT_SUPERSCRIPT_BASELINE_DROP_MAX, "HB_OT_MATH_CONSTANT_SUPERSCRIPT_BASELINE_DROP_MAX", "superscript-baseline-drop-max" },
        { HB_OT_MATH_CONSTANT_SUB_SUPERSCRIPT_GAP_MIN, "HB_OT_MATH_CONSTANT_SUB_SUPERSCRIPT_GAP_MIN", "sub-superscript-gap-min" },
        { HB_OT_MATH_CONSTANT_SUPERSCRIPT_BOTTOM_MAX_WITH_SUBSCRIPT, "HB_OT_MATH_CONSTANT_SUPERSCRIPT_BOTTOM_MAX_WITH_SUBSCRIPT", "superscript-bottom-max-with-subscript" },
        { HB_OT_MATH_CONSTANT_SPACE_AFTER_SCRIPT, "HB_OT_MATH_CONSTANT_SPACE_AFTER_SCRIPT", "space-after-script" },
        { HB_OT_MATH_CONSTANT_UPPER_LIMIT_GAP_MIN, "HB_OT_MATH_CONSTANT_UPPER_LIMIT_GAP_MIN", "upper-limit-gap-min" },
        { HB_OT_MATH_CONSTANT_UPPER_LIMIT_BASELINE_RISE_MIN, "HB_OT_MATH_CONSTANT_UPPER_LIMIT_BASELINE_RISE_MIN", "upper-limit-baseline-rise-min" },
        { HB_OT_MATH_CONSTANT_LOWER_LIMIT_GAP_MIN, "HB_OT_MATH_CONSTANT_LOWER_LIMIT_GAP_MIN", "lower-limit-gap-min" },
        { HB_OT_MATH_CONSTANT_LOWER_LIMIT_BASELINE_DROP_MIN, "HB_OT_MATH_CONSTANT_LOWER_LIMIT_BASELINE_DROP_MIN", "lower-limit-baseline-drop-min" },
        { HB_OT_MATH_CONSTANT_STACK_TOP_SHIFT_UP, "HB_OT_MATH_CONSTANT_STACK_TOP_SHIFT_UP", "stack-top-shift-up" },
        { HB_OT_MATH_CONSTANT_STACK_TOP_DISPLAY_STYLE_SHIFT_UP, "HB_OT_MATH_CONSTANT_STACK_TOP_DISPLAY_STYLE_SHIFT_UP", "stack-top-display-style-shift-up" },
        { HB_OT_MATH_CONSTANT_STACK_BOTTOM_SHIFT_DOWN, "HB_OT_MATH_CONSTANT_STACK_BOTTOM_SHIFT_DOWN", "stack-bottom-shift-down" },
        { HB_OT_MATH_CONSTANT_STACK_BOTTOM_DISPLAY_STYLE_SHIFT_DOWN, "HB_OT_MATH_CONSTANT_STACK_BOTTOM_DISPLAY_STYLE_SHIFT_DOWN", "stack-bottom-display-style-shift-down" },
        { HB_OT_MATH_CONSTANT_STACK_GAP_MIN, "HB_OT_MATH_CONSTANT_STACK_GAP_MIN", "stack-gap-min" },
        { HB_OT_MATH_CONSTANT_STACK_DISPLAY_STYLE_GAP_MIN, "HB_OT_MATH_CONSTANT_STACK_DISPLAY_STYLE_GAP_MIN", "stack-display-style-gap-min" },
        { HB_OT_MATH_CONSTANT_STRETCH_STACK_TOP_SHIFT_UP, "HB_OT_MATH_CONSTANT_STRETCH_STACK_TOP_SHIFT_UP", "stretch-stack-top-shift-up" },
        { HB_OT_MATH_CONSTANT_STRETCH_STACK_BOTTOM_SHIFT_DOWN, "HB_OT_MATH_CONSTANT_STRETCH_STACK_BOTTOM_SHIFT_DOWN", "stretch-stack-bottom-shift-down" },
        { HB_OT_MATH_CONSTANT_STRETCH_STACK_GAP_ABOVE_MIN, "HB_OT_MATH_CONSTANT_STRETCH_STACK_GAP_ABOVE_MIN", "stretch-stack-gap-above-min" },
        { HB_OT_MATH_CONSTANT_STRETCH_STACK_GAP_BELOW_MIN, "HB_OT_MATH_CONSTANT_STRETCH_STACK_GAP_BELOW_MIN", "stretch-stack-gap-below-min" },
        { HB_OT_MATH_CONSTANT_FRACTION_NUMERATOR_SHIFT_UP, "HB_OT_MATH_CONSTANT_FRACTION_NUMERATOR_SHIFT_UP", "fraction-numerator-shift-up" },
        { HB_OT_MATH_CONSTANT_FRACTION_NUMERATOR_DISPLAY_STYLE_SHIFT_UP, "HB_OT_MATH_CONSTANT_FRACTION_NUMERATOR_DISPLAY_STYLE_SHIFT_UP", "fraction-numerator-display-style-shift-up" },
        { HB_OT_MATH_CONSTANT_FRACTION_DENOMINATOR_SHIFT_DOWN, "HB_OT_MATH_CONSTANT_FRACTION_DENOMINATOR_SHIFT_DOWN", "fraction-denominator-shift-down" },
        { HB_OT_MATH_CONSTANT_FRACTION_DENOMINATOR_DISPLAY_STYLE_SHIFT_DOWN, "HB_OT_MATH_CONSTANT_FRACTION_DENOMINATOR_DISPLAY_STYLE_SHIFT_DOWN", "fraction-denominator-display-style-shift-down" },
        { HB_OT_MATH_CONSTANT_FRACTION_NUMERATOR_GAP_MIN, "HB_OT_MATH_CONSTANT_FRACTION_NUMERATOR_GAP_MIN", "fraction-numerator-gap-min" },
        { HB_OT_MATH_CONSTANT_FRACTION_NUM_DISPLAY_STYLE_GAP_MIN, "HB_OT_MATH_CONSTANT_FRACTION_NUM_DISPLAY_STYLE_GAP_MIN", "fraction-num-display-style-gap-min" },
        { HB_OT_MATH_CONSTANT_FRACTION_RULE_THICKNESS, "HB_OT_MATH_CONSTANT_FRACTION_RULE_THICKNESS", "fraction-rule-thickness" },
        { HB_OT_MATH_CONSTANT_FRACTION_DENOMINATOR_GAP_MIN, "HB_OT_MATH_CONSTANT_FRACTION_DENOMINATOR_GAP_MIN", "fraction-denominator-gap-min" },
        { HB_OT_MATH_CONSTANT_FRACTION_DENOM_DISPLAY_STYLE_GAP_MIN, "HB_OT_MATH_CONSTANT_FRACTION_DENOM_DISPLAY_STYLE_GAP_MIN", "fraction-denom-display-style-gap-min" },
        { HB_OT_MATH_CONSTANT_SKEWED_FRACTION_HORIZONTAL_GAP, "HB_OT_MATH_CONSTANT_SKEWED_FRACTION_HORIZONTAL_GAP", "skewed-fraction-horizontal-gap" },
        { HB_OT_MATH_CONSTANT_SKEWED_FRACTION_VERTICAL_GAP, "HB_OT_MATH_CONSTANT_SKEWED_FRACTION_VERTICAL_GAP", "skewed-fraction-vertical-gap" },
        { HB_OT_MATH_CONSTANT_OVERBAR_VERTICAL_GAP, "HB_OT_MATH_CONSTANT_OVERBAR_VERTICAL_GAP", "overbar-vertical-gap" },
        { HB_OT_MATH_CONSTANT_OVERBAR_RULE_THICKNESS, "HB_OT_MATH_CONSTANT_OVERBAR_RULE_THICKNESS", "overbar-rule-thickness" },
        { HB_OT_MATH_CONSTANT_OVERBAR_EXTRA_ASCENDER, "HB_OT_MATH_CONSTANT_OVERBAR_EXTRA_ASCENDER", "overbar-extra-ascender" },
        { HB_OT_MATH_CONSTANT_UNDERBAR_VERTICAL_GAP, "HB_OT_MATH_CONSTANT_UNDERBAR_VERTICAL_GAP", "underbar-vertical-gap" },
        { HB_OT_MATH_CONSTANT_UNDERBAR_RULE_THICKNESS, "HB_OT_MATH_CONSTANT_UNDERBAR_RULE_THICKNESS", "underbar-rule-thickness" },
        { HB_OT_MATH_CONSTANT_UNDERBAR_EXTRA_DESCENDER, "HB_OT_MATH_CONSTANT_UNDERBAR_EXTRA_DESCENDER", "underbar-extra-descender" },
        { HB_OT_MATH_CONSTANT_RADICAL_VERTICAL_GAP, "HB_OT_MATH_CONSTANT_RADICAL_VERTICAL_GAP", "radical-vertical-gap" },
        { HB_OT_MATH_CONSTANT_RADICAL_DISPLAY_STYLE_VERTICAL_GAP, "HB_OT_MATH_CONSTANT_RADICAL_DISPLAY_STYLE_VERTICAL_GAP", "radical-display-style-vertical-gap" },
        { HB_OT_MATH_CONSTANT_RADICAL_RULE_THICKNESS, "HB_OT_MATH_CONSTANT_RADICAL_RULE_THICKNESS", "radical-rule-thickness" },
        { HB_OT_MATH_CONSTANT_RADICAL_EXTRA_ASCENDER, "HB_OT_MATH_CONSTANT_RADICAL_EXTRA_ASCENDER", "radical-extra-ascender" },
        { HB_OT_MATH_CONSTANT_RADICAL_KERN_BEFORE_DEGREE, "HB_OT_MATH_CONSTANT_RADICAL_KERN_BEFORE_DEGREE", "radical-kern-before-degree" },
        { HB_OT_MATH_CONSTANT_RADICAL_KERN_AFTER_DEGREE, "HB_OT_MATH_CONSTANT_RADICAL_KERN_AFTER_DEGREE", "radical-kern-after-degree" },
        { HB_OT_MATH_CONSTANT_RADICAL_DEGREE_BOTTOM_RAISE_PERCENT, "HB_OT_MATH_CONSTANT_RADICAL_DEGREE_BOTTOM_RAISE_PERCENT", "radical-degree-bottom-raise-percent" },
        { 0, NULL, NULL }
      };
      GType id =
        g_enum_register_static (g_intern_static_string ("hb_ot_math_constant_t"), values);
      g_once_init_leave (&type_id, id);
    }

  return type_id;
}
GType
hb_gobject_ot_math_kern_get_type ()
{
  static gsize type_id = 0;

  if (g_once_init_enter (&type_id))
    {
      static const GEnumValue values[] = {
        { HB_OT_MATH_KERN_TOP_RIGHT, "HB_OT_MATH_KERN_TOP_RIGHT", "top-right" },
        { HB_OT_MATH_KERN_TOP_LEFT, "HB_OT_MATH_KERN_TOP_LEFT", "top-left" },
        { HB_OT_MATH_KERN_BOTTOM_RIGHT, "HB_OT_MATH_KERN_BOTTOM_RIGHT", "bottom-right" },
        { HB_OT_MATH_KERN_BOTTOM_LEFT, "HB_OT_MATH_KERN_BOTTOM_LEFT", "bottom-left" },
        { 0, NULL, NULL }
      };
      GType id =
        g_enum_register_static (g_intern_static_string ("hb_ot_math_kern_t"), values);
      g_once_init_leave (&type_id, id);
    }

  return type_id;
}
GType
hb_gobject_ot_math_glyph_part_flags_get_type ()
{
  static gsize type_id = 0;

  if (g_once_init_enter (&type_id))
    {
      static const GFlagsValue values[] = {
        { HB_OT_MATH_GLYPH_PART_FLAG_EXTENDER, "HB_OT_MATH_GLYPH_PART_FLAG_EXTENDER", "extender" },
        { 0, NULL, NULL }
      };
      GType id =
        g_flags_register_static (g_intern_static_string ("hb_ot_math_glyph_part_flags_t"), values);
      g_once_init_leave (&type_id, id);
    }

  return type_id;
}
/* enumerations from "hb-ot-meta.h" */
GType
hb_gobject_ot_meta_tag_get_type ()
{
  static gsize type_id = 0;

  if (g_once_init_enter (&type_id))
    {
      static const GEnumValue values[] = {
        { HB_OT_META_TAG_DESIGN_LANGUAGES, "HB_OT_META_TAG_DESIGN_LANGUAGES", "design-languages" },
        { HB_OT_META_TAG_SUPPORTED_LANGUAGES, "HB_OT_META_TAG_SUPPORTED_LANGUAGES", "supported-languages" },
        { 0, NULL, NULL }
      };
      GType id =
        g_enum_register_static (g_intern_static_string ("hb_ot_meta_tag_t"), values);
      g_once_init_leave (&type_id, id);
    }

  return type_id;
}
/* enumerations from "hb-ot-metrics.h" */
GType
hb_gobject_ot_metrics_tag_get_type ()
{
  static gsize type_id = 0;

  if (g_once_init_enter (&type_id))
    {
      static const GEnumValue values[] = {
        { HB_OT_METRICS_TAG_HORIZONTAL_ASCENDER, "HB_OT_METRICS_TAG_HORIZONTAL_ASCENDER", "horizontal-ascender" },
        { HB_OT_METRICS_TAG_HORIZONTAL_DESCENDER, "HB_OT_METRICS_TAG_HORIZONTAL_DESCENDER", "horizontal-descender" },
        { HB_OT_METRICS_TAG_HORIZONTAL_LINE_GAP, "HB_OT_METRICS_TAG_HORIZONTAL_LINE_GAP", "horizontal-line-gap" },
        { HB_OT_METRICS_TAG_HORIZONTAL_CLIPPING_ASCENT, "HB_OT_METRICS_TAG_HORIZONTAL_CLIPPING_ASCENT", "horizontal-clipping-ascent" },
        { HB_OT_METRICS_TAG_HORIZONTAL_CLIPPING_DESCENT, "HB_OT_METRICS_TAG_HORIZONTAL_CLIPPING_DESCENT", "horizontal-clipping-descent" },
        { HB_OT_METRICS_TAG_VERTICAL_ASCENDER, "HB_OT_METRICS_TAG_VERTICAL_ASCENDER", "vertical-ascender" },
        { HB_OT_METRICS_TAG_VERTICAL_DESCENDER, "HB_OT_METRICS_TAG_VERTICAL_DESCENDER", "vertical-descender" },
        { HB_OT_METRICS_TAG_VERTICAL_LINE_GAP, "HB_OT_METRICS_TAG_VERTICAL_LINE_GAP", "vertical-line-gap" },
        { HB_OT_METRICS_TAG_HORIZONTAL_CARET_RISE, "HB_OT_METRICS_TAG_HORIZONTAL_CARET_RISE", "horizontal-caret-rise" },
        { HB_OT_METRICS_TAG_HORIZONTAL_CARET_RUN, "HB_OT_METRICS_TAG_HORIZONTAL_CARET_RUN", "horizontal-caret-run" },
        { HB_OT_METRICS_TAG_HORIZONTAL_CARET_OFFSET, "HB_OT_METRICS_TAG_HORIZONTAL_CARET_OFFSET", "horizontal-caret-offset" },
        { HB_OT_METRICS_TAG_VERTICAL_CARET_RISE, "HB_OT_METRICS_TAG_VERTICAL_CARET_RISE", "vertical-caret-rise" },
        { HB_OT_METRICS_TAG_VERTICAL_CARET_RUN, "HB_OT_METRICS_TAG_VERTICAL_CARET_RUN", "vertical-caret-run" },
        { HB_OT_METRICS_TAG_VERTICAL_CARET_OFFSET, "HB_OT_METRICS_TAG_VERTICAL_CARET_OFFSET", "vertical-caret-offset" },
        { HB_OT_METRICS_TAG_X_HEIGHT, "HB_OT_METRICS_TAG_X_HEIGHT", "x-height" },
        { HB_OT_METRICS_TAG_CAP_HEIGHT, "HB_OT_METRICS_TAG_CAP_HEIGHT", "cap-height" },
        { HB_OT_METRICS_TAG_SUBSCRIPT_EM_X_SIZE, "HB_OT_METRICS_TAG_SUBSCRIPT_EM_X_SIZE", "subscript-em-x-size" },
        { HB_OT_METRICS_TAG_SUBSCRIPT_EM_Y_SIZE, "HB_OT_METRICS_TAG_SUBSCRIPT_EM_Y_SIZE", "subscript-em-y-size" },
        { HB_OT_METRICS_TAG_SUBSCRIPT_EM_X_OFFSET, "HB_OT_METRICS_TAG_SUBSCRIPT_EM_X_OFFSET", "subscript-em-x-offset" },
        { HB_OT_METRICS_TAG_SUBSCRIPT_EM_Y_OFFSET, "HB_OT_METRICS_TAG_SUBSCRIPT_EM_Y_OFFSET", "subscript-em-y-offset" },
        { HB_OT_METRICS_TAG_SUPERSCRIPT_EM_X_SIZE, "HB_OT_METRICS_TAG_SUPERSCRIPT_EM_X_SIZE", "superscript-em-x-size" },
        { HB_OT_METRICS_TAG_SUPERSCRIPT_EM_Y_SIZE, "HB_OT_METRICS_TAG_SUPERSCRIPT_EM_Y_SIZE", "superscript-em-y-size" },
        { HB_OT_METRICS_TAG_SUPERSCRIPT_EM_X_OFFSET, "HB_OT_METRICS_TAG_SUPERSCRIPT_EM_X_OFFSET", "superscript-em-x-offset" },
        { HB_OT_METRICS_TAG_SUPERSCRIPT_EM_Y_OFFSET, "HB_OT_METRICS_TAG_SUPERSCRIPT_EM_Y_OFFSET", "superscript-em-y-offset" },
        { HB_OT_METRICS_TAG_STRIKEOUT_SIZE, "HB_OT_METRICS_TAG_STRIKEOUT_SIZE", "strikeout-size" },
        { HB_OT_METRICS_TAG_STRIKEOUT_OFFSET, "HB_OT_METRICS_TAG_STRIKEOUT_OFFSET", "strikeout-offset" },
        { HB_OT_METRICS_TAG_UNDERLINE_SIZE, "HB_OT_METRICS_TAG_UNDERLINE_SIZE", "underline-size" },
        { HB_OT_METRICS_TAG_UNDERLINE_OFFSET, "HB_OT_METRICS_TAG_UNDERLINE_OFFSET", "underline-offset" },
        { 0, NULL, NULL }
      };
      GType id =
        g_enum_register_static (g_intern_static_string ("hb_ot_metrics_tag_t"), values);
      g_once_init_leave (&type_id, id);
    }

  return type_id;
}
/* enumerations from "hb-ot-var.h" */
GType
hb_gobject_ot_var_axis_flags_get_type ()
{
  static gsize type_id = 0;

  if (g_once_init_enter (&type_id))
    {
      static const GFlagsValue values[] = {
        { HB_OT_VAR_AXIS_FLAG_HIDDEN, "HB_OT_VAR_AXIS_FLAG_HIDDEN", "hidden" },
        { 0, NULL, NULL }
      };
      GType id =
        g_flags_register_static (g_intern_static_string ("hb_ot_var_axis_flags_t"), values);
      g_once_init_leave (&type_id, id);
    }

  return type_id;
}
/* enumerations from "hb-style.h" */
GType
hb_gobject_style_tag_get_type ()
{
  static gsize type_id = 0;

  if (g_once_init_enter (&type_id))
    {
      static const GEnumValue values[] = {
        { HB_STYLE_TAG_ITALIC, "HB_STYLE_TAG_ITALIC", "italic" },
        { HB_STYLE_TAG_OPTICAL_SIZE, "HB_STYLE_TAG_OPTICAL_SIZE", "optical-size" },
        { HB_STYLE_TAG_SLANT_ANGLE, "HB_STYLE_TAG_SLANT_ANGLE", "slant-angle" },
        { HB_STYLE_TAG_SLANT_RATIO, "HB_STYLE_TAG_SLANT_RATIO", "slant-ratio" },
        { HB_STYLE_TAG_WIDTH, "HB_STYLE_TAG_WIDTH", "width" },
        { HB_STYLE_TAG_WEIGHT, "HB_STYLE_TAG_WEIGHT", "weight" },
        { 0, NULL, NULL }
      };
      GType id =
        g_enum_register_static (g_intern_static_string ("hb_style_tag_t"), values);
      g_once_init_leave (&type_id, id);
    }

  return type_id;
}
/* enumerations from "hb-unicode.h" */
GType
hb_gobject_unicode_general_category_get_type ()
{
  static gsize type_id = 0;

  if (g_once_init_enter (&type_id))
    {
      static const GEnumValue values[] = {
        { HB_UNICODE_GENERAL_CATEGORY_CONTROL, "HB_UNICODE_GENERAL_CATEGORY_CONTROL", "control" },
        { HB_UNICODE_GENERAL_CATEGORY_FORMAT, "HB_UNICODE_GENERAL_CATEGORY_FORMAT", "format" },
        { HB_UNICODE_GENERAL_CATEGORY_UNASSIGNED, "HB_UNICODE_GENERAL_CATEGORY_UNASSIGNED", "unassigned" },
        { HB_UNICODE_GENERAL_CATEGORY_PRIVATE_USE, "HB_UNICODE_GENERAL_CATEGORY_PRIVATE_USE", "private-use" },
        { HB_UNICODE_GENERAL_CATEGORY_SURROGATE, "HB_UNICODE_GENERAL_CATEGORY_SURROGATE", "surrogate" },
        { HB_UNICODE_GENERAL_CATEGORY_LOWERCASE_LETTER, "HB_UNICODE_GENERAL_CATEGORY_LOWERCASE_LETTER", "lowercase-letter" },
        { HB_UNICODE_GENERAL_CATEGORY_MODIFIER_LETTER, "HB_UNICODE_GENERAL_CATEGORY_MODIFIER_LETTER", "modifier-letter" },
        { HB_UNICODE_GENERAL_CATEGORY_OTHER_LETTER, "HB_UNICODE_GENERAL_CATEGORY_OTHER_LETTER", "other-letter" },
        { HB_UNICODE_GENERAL_CATEGORY_TITLECASE_LETTER, "HB_UNICODE_GENERAL_CATEGORY_TITLECASE_LETTER", "titlecase-letter" },
        { HB_UNICODE_GENERAL_CATEGORY_UPPERCASE_LETTER, "HB_UNICODE_GENERAL_CATEGORY_UPPERCASE_LETTER", "uppercase-letter" },
        { HB_UNICODE_GENERAL_CATEGORY_SPACING_MARK, "HB_UNICODE_GENERAL_CATEGORY_SPACING_MARK", "spacing-mark" },
        { HB_UNICODE_GENERAL_CATEGORY_ENCLOSING_MARK, "HB_UNICODE_GENERAL_CATEGORY_ENCLOSING_MARK", "enclosing-mark" },
        { HB_UNICODE_GENERAL_CATEGORY_NON_SPACING_MARK, "HB_UNICODE_GENERAL_CATEGORY_NON_SPACING_MARK", "non-spacing-mark" },
        { HB_UNICODE_GENERAL_CATEGORY_DECIMAL_NUMBER, "HB_UNICODE_GENERAL_CATEGORY_DECIMAL_NUMBER", "decimal-number" },
        { HB_UNICODE_GENERAL_CATEGORY_LETTER_NUMBER, "HB_UNICODE_GENERAL_CATEGORY_LETTER_NUMBER", "letter-number" },
        { HB_UNICODE_GENERAL_CATEGORY_OTHER_NUMBER, "HB_UNICODE_GENERAL_CATEGORY_OTHER_NUMBER", "other-number" },
        { HB_UNICODE_GENERAL_CATEGORY_CONNECT_PUNCTUATION, "HB_UNICODE_GENERAL_CATEGORY_CONNECT_PUNCTUATION", "connect-punctuation" },
        { HB_UNICODE_GENERAL_CATEGORY_DASH_PUNCTUATION, "HB_UNICODE_GENERAL_CATEGORY_DASH_PUNCTUATION", "dash-punctuation" },
        { HB_UNICODE_GENERAL_CATEGORY_CLOSE_PUNCTUATION, "HB_UNICODE_GENERAL_CATEGORY_CLOSE_PUNCTUATION", "close-punctuation" },
        { HB_UNICODE_GENERAL_CATEGORY_FINAL_PUNCTUATION, "HB_UNICODE_GENERAL_CATEGORY_FINAL_PUNCTUATION", "final-punctuation" },
        { HB_UNICODE_GENERAL_CATEGORY_INITIAL_PUNCTUATION, "HB_UNICODE_GENERAL_CATEGORY_INITIAL_PUNCTUATION", "initial-punctuation" },
        { HB_UNICODE_GENERAL_CATEGORY_OTHER_PUNCTUATION, "HB_UNICODE_GENERAL_CATEGORY_OTHER_PUNCTUATION", "other-punctuation" },
        { HB_UNICODE_GENERAL_CATEGORY_OPEN_PUNCTUATION, "HB_UNICODE_GENERAL_CATEGORY_OPEN_PUNCTUATION", "open-punctuation" },
        { HB_UNICODE_GENERAL_CATEGORY_CURRENCY_SYMBOL, "HB_UNICODE_GENERAL_CATEGORY_CURRENCY_SYMBOL", "currency-symbol" },
        { HB_UNICODE_GENERAL_CATEGORY_MODIFIER_SYMBOL, "HB_UNICODE_GENERAL_CATEGORY_MODIFIER_SYMBOL", "modifier-symbol" },
        { HB_UNICODE_GENERAL_CATEGORY_MATH_SYMBOL, "HB_UNICODE_GENERAL_CATEGORY_MATH_SYMBOL", "math-symbol" },
        { HB_UNICODE_GENERAL_CATEGORY_OTHER_SYMBOL, "HB_UNICODE_GENERAL_CATEGORY_OTHER_SYMBOL", "other-symbol" },
        { HB_UNICODE_GENERAL_CATEGORY_LINE_SEPARATOR, "HB_UNICODE_GENERAL_CATEGORY_LINE_SEPARATOR", "line-separator" },
        { HB_UNICODE_GENERAL_CATEGORY_PARAGRAPH_SEPARATOR, "HB_UNICODE_GENERAL_CATEGORY_PARAGRAPH_SEPARATOR", "paragraph-separator" },
        { HB_UNICODE_GENERAL_CATEGORY_SPACE_SEPARATOR, "HB_UNICODE_GENERAL_CATEGORY_SPACE_SEPARATOR", "space-separator" },
        { 0, NULL, NULL }
      };
      GType id =
        g_enum_register_static (g_intern_static_string ("hb_unicode_general_category_t"), values);
      g_once_init_leave (&type_id, id);
    }

  return type_id;
}
GType
hb_gobject_unicode_combining_class_get_type ()
{
  static gsize type_id = 0;

  if (g_once_init_enter (&type_id))
    {
      static const GEnumValue values[] = {
        { HB_UNICODE_COMBINING_CLASS_NOT_REORDERED, "HB_UNICODE_COMBINING_CLASS_NOT_REORDERED", "not-reordered" },
        { HB_UNICODE_COMBINING_CLASS_OVERLAY, "HB_UNICODE_COMBINING_CLASS_OVERLAY", "overlay" },
        { HB_UNICODE_COMBINING_CLASS_NUKTA, "HB_UNICODE_COMBINING_CLASS_NUKTA", "nukta" },
        { HB_UNICODE_COMBINING_CLASS_KANA_VOICING, "HB_UNICODE_COMBINING_CLASS_KANA_VOICING", "kana-voicing" },
        { HB_UNICODE_COMBINING_CLASS_VIRAMA, "HB_UNICODE_COMBINING_CLASS_VIRAMA", "virama" },
        { HB_UNICODE_COMBINING_CLASS_CCC10, "HB_UNICODE_COMBINING_CLASS_CCC10", "ccc10" },
        { HB_UNICODE_COMBINING_CLASS_CCC11, "HB_UNICODE_COMBINING_CLASS_CCC11", "ccc11" },
        { HB_UNICODE_COMBINING_CLASS_CCC12, "HB_UNICODE_COMBINING_CLASS_CCC12", "ccc12" },
        { HB_UNICODE_COMBINING_CLASS_CCC13, "HB_UNICODE_COMBINING_CLASS_CCC13", "ccc13" },
        { HB_UNICODE_COMBINING_CLASS_CCC14, "HB_UNICODE_COMBINING_CLASS_CCC14", "ccc14" },
        { HB_UNICODE_COMBINING_CLASS_CCC15, "HB_UNICODE_COMBINING_CLASS_CCC15", "ccc15" },
        { HB_UNICODE_COMBINING_CLASS_CCC16, "HB_UNICODE_COMBINING_CLASS_CCC16", "ccc16" },
        { HB_UNICODE_COMBINING_CLASS_CCC17, "HB_UNICODE_COMBINING_CLASS_CCC17", "ccc17" },
        { HB_UNICODE_COMBINING_CLASS_CCC18, "HB_UNICODE_COMBINING_CLASS_CCC18", "ccc18" },
        { HB_UNICODE_COMBINING_CLASS_CCC19, "HB_UNICODE_COMBINING_CLASS_CCC19", "ccc19" },
        { HB_UNICODE_COMBINING_CLASS_CCC20, "HB_UNICODE_COMBINING_CLASS_CCC20", "ccc20" },
        { HB_UNICODE_COMBINING_CLASS_CCC21, "HB_UNICODE_COMBINING_CLASS_CCC21", "ccc21" },
        { HB_UNICODE_COMBINING_CLASS_CCC22, "HB_UNICODE_COMBINING_CLASS_CCC22", "ccc22" },
        { HB_UNICODE_COMBINING_CLASS_CCC23, "HB_UNICODE_COMBINING_CLASS_CCC23", "ccc23" },
        { HB_UNICODE_COMBINING_CLASS_CCC24, "HB_UNICODE_COMBINING_CLASS_CCC24", "ccc24" },
        { HB_UNICODE_COMBINING_CLASS_CCC25, "HB_UNICODE_COMBINING_CLASS_CCC25", "ccc25" },
        { HB_UNICODE_COMBINING_CLASS_CCC26, "HB_UNICODE_COMBINING_CLASS_CCC26", "ccc26" },
        { HB_UNICODE_COMBINING_CLASS_CCC27, "HB_UNICODE_COMBINING_CLASS_CCC27", "ccc27" },
        { HB_UNICODE_COMBINING_CLASS_CCC28, "HB_UNICODE_COMBINING_CLASS_CCC28", "ccc28" },
        { HB_UNICODE_COMBINING_CLASS_CCC29, "HB_UNICODE_COMBINING_CLASS_CCC29", "ccc29" },
        { HB_UNICODE_COMBINING_CLASS_CCC30, "HB_UNICODE_COMBINING_CLASS_CCC30", "ccc30" },
        { HB_UNICODE_COMBINING_CLASS_CCC31, "HB_UNICODE_COMBINING_CLASS_CCC31", "ccc31" },
        { HB_UNICODE_COMBINING_CLASS_CCC32, "HB_UNICODE_COMBINING_CLASS_CCC32", "ccc32" },
        { HB_UNICODE_COMBINING_CLASS_CCC33, "HB_UNICODE_COMBINING_CLASS_CCC33", "ccc33" },
        { HB_UNICODE_COMBINING_CLASS_CCC34, "HB_UNICODE_COMBINING_CLASS_CCC34", "ccc34" },
        { HB_UNICODE_COMBINING_CLASS_CCC35, "HB_UNICODE_COMBINING_CLASS_CCC35", "ccc35" },
        { HB_UNICODE_COMBINING_CLASS_CCC36, "HB_UNICODE_COMBINING_CLASS_CCC36", "ccc36" },
        { HB_UNICODE_COMBINING_CLASS_CCC84, "HB_UNICODE_COMBINING_CLASS_CCC84", "ccc84" },
        { HB_UNICODE_COMBINING_CLASS_CCC91, "HB_UNICODE_COMBINING_CLASS_CCC91", "ccc91" },
        { HB_UNICODE_COMBINING_CLASS_CCC103, "HB_UNICODE_COMBINING_CLASS_CCC103", "ccc103" },
        { HB_UNICODE_COMBINING_CLASS_CCC107, "HB_UNICODE_COMBINING_CLASS_CCC107", "ccc107" },
        { HB_UNICODE_COMBINING_CLASS_CCC118, "HB_UNICODE_COMBINING_CLASS_CCC118", "ccc118" },
        { HB_UNICODE_COMBINING_CLASS_CCC122, "HB_UNICODE_COMBINING_CLASS_CCC122", "ccc122" },
        { HB_UNICODE_COMBINING_CLASS_CCC129, "HB_UNICODE_COMBINING_CLASS_CCC129", "ccc129" },
        { HB_UNICODE_COMBINING_CLASS_CCC130, "HB_UNICODE_COMBINING_CLASS_CCC130", "ccc130" },
        { HB_UNICODE_COMBINING_CLASS_CCC133, "HB_UNICODE_COMBINING_CLASS_CCC133", "ccc133" },
        { HB_UNICODE_COMBINING_CLASS_ATTACHED_BELOW_LEFT, "HB_UNICODE_COMBINING_CLASS_ATTACHED_BELOW_LEFT", "attached-below-left" },
        { HB_UNICODE_COMBINING_CLASS_ATTACHED_BELOW, "HB_UNICODE_COMBINING_CLASS_ATTACHED_BELOW", "attached-below" },
        { HB_UNICODE_COMBINING_CLASS_ATTACHED_ABOVE, "HB_UNICODE_COMBINING_CLASS_ATTACHED_ABOVE", "attached-above" },
        { HB_UNICODE_COMBINING_CLASS_ATTACHED_ABOVE_RIGHT, "HB_UNICODE_COMBINING_CLASS_ATTACHED_ABOVE_RIGHT", "attached-above-right" },
        { HB_UNICODE_COMBINING_CLASS_BELOW_LEFT, "HB_UNICODE_COMBINING_CLASS_BELOW_LEFT", "below-left" },
        { HB_UNICODE_COMBINING_CLASS_BELOW, "HB_UNICODE_COMBINING_CLASS_BELOW", "below" },
        { HB_UNICODE_COMBINING_CLASS_BELOW_RIGHT, "HB_UNICODE_COMBINING_CLASS_BELOW_RIGHT", "below-right" },
        { HB_UNICODE_COMBINING_CLASS_LEFT, "HB_UNICODE_COMBINING_CLASS_LEFT", "left" },
        { HB_UNICODE_COMBINING_CLASS_RIGHT, "HB_UNICODE_COMBINING_CLASS_RIGHT", "right" },
        { HB_UNICODE_COMBINING_CLASS_ABOVE_LEFT, "HB_UNICODE_COMBINING_CLASS_ABOVE_LEFT", "above-left" },
        { HB_UNICODE_COMBINING_CLASS_ABOVE, "HB_UNICODE_COMBINING_CLASS_ABOVE", "above" },
        { HB_UNICODE_COMBINING_CLASS_ABOVE_RIGHT, "HB_UNICODE_COMBINING_CLASS_ABOVE_RIGHT", "above-right" },
        { HB_UNICODE_COMBINING_CLASS_DOUBLE_BELOW, "HB_UNICODE_COMBINING_CLASS_DOUBLE_BELOW", "double-below" },
        { HB_UNICODE_COMBINING_CLASS_DOUBLE_ABOVE, "HB_UNICODE_COMBINING_CLASS_DOUBLE_ABOVE", "double-above" },
        { HB_UNICODE_COMBINING_CLASS_IOTA_SUBSCRIPT, "HB_UNICODE_COMBINING_CLASS_IOTA_SUBSCRIPT", "iota-subscript" },
        { HB_UNICODE_COMBINING_CLASS_INVALID, "HB_UNICODE_COMBINING_CLASS_INVALID", "invalid" },
        { 0, NULL, NULL }
      };
      GType id =
        g_enum_register_static (g_intern_static_string ("hb_unicode_combining_class_t"), values);
      g_once_init_leave (&type_id, id);
    }

  return type_id;
}

#endif

/* Generated data ends here */

