/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.map;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import net.osmand.data.LatLon;
import net.osmand.util.Algorithms;

public class WorldRegion
implements Serializable {
    public static final String WORLD_BASEMAP = "world_basemap";
    public static final String AFRICA_REGION_ID = "africa";
    public static final String ASIA_REGION_ID = "asia";
    public static final String AUSTRALIA_AND_OCEANIA_REGION_ID = "australia-oceania";
    public static final String CENTRAL_AMERICA_REGION_ID = "centralamerica";
    public static final String EUROPE_REGION_ID = "europe";
    public static final String NORTH_AMERICA_REGION_ID = "northamerica";
    public static final String RUSSIA_REGION_ID = "russia";
    public static final String JAPAN_REGION_ID = "japan_asia";
    public static final String SOUTH_AMERICA_REGION_ID = "southamerica";
    protected static final String WORLD = "world";
    public static final String UNITED_KINGDOM_REGION_ID = "gb_europe";
    protected WorldRegion superregion;
    protected List<WorldRegion> subregions;
    protected RegionParams params = new RegionParams();
    protected String regionFullName;
    protected String regionParentFullName;
    protected String regionName;
    protected String regionNameEn;
    protected String regionNameLocale;
    protected String regionSearchText;
    protected String regionDownloadName;
    protected boolean regionMapDownload;
    protected LatLon regionCenter;

    public boolean isRegionMapDownload() {
        return this.regionMapDownload;
    }

    public String getLocaleName() {
        if (!Algorithms.isEmpty(this.regionNameLocale)) {
            return this.regionNameLocale;
        }
        if (!Algorithms.isEmpty(this.regionNameEn)) {
            return this.regionNameEn;
        }
        if (!Algorithms.isEmpty(this.regionName)) {
            return this.regionName;
        }
        return this.capitalize(this.regionFullName.replace('_', ' '));
    }

    public String getRegionDownloadName() {
        return this.regionDownloadName;
    }

    public String getRegionDownloadNameLC() {
        return this.regionDownloadName == null ? null : this.regionDownloadName.toLowerCase();
    }

    public RegionParams getParams() {
        return this.params;
    }

    public LatLon getRegionCenter() {
        return this.regionCenter;
    }

    public String getRegionSearchText() {
        return this.regionSearchText;
    }

    public WorldRegion getSuperregion() {
        return this.superregion;
    }

    public List<WorldRegion> getSubregions() {
        return this.subregions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorldRegion that = (WorldRegion)o;
        return !(this.regionFullName == null ? that.regionFullName != null : !this.regionFullName.toLowerCase().equals(that.regionFullName.toLowerCase()));
    }

    public int hashCode() {
        return this.regionFullName != null ? this.regionFullName.hashCode() : 0;
    }

    public WorldRegion(String regionFullName, String downloadName) {
        this.regionFullName = regionFullName;
        this.regionDownloadName = downloadName;
        this.superregion = null;
        this.subregions = new LinkedList<WorldRegion>();
    }

    public WorldRegion(String id2) {
        this(id2, null);
    }

    public String getRegionId() {
        return this.regionFullName;
    }

    private String capitalize(String s) {
        String[] words = s.split(" ");
        if (words[0].length() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(Algorithms.capitalizeFirstLetterAndLowercase(words[0]));
            for (int i = 1; i < words.length; ++i) {
                sb.append(" ");
                sb.append(Algorithms.capitalizeFirstLetterAndLowercase(words[i]));
            }
            return sb.toString();
        }
        return s;
    }

    public void addSubregion(WorldRegion rd) {
        this.subregions.add(rd);
        rd.superregion = this;
    }

    public int getLevel() {
        int res = 0;
        WorldRegion parent = this.superregion;
        while (parent != null) {
            parent = parent.superregion;
            ++res;
        }
        return res;
    }

    public static class RegionParams {
        protected String regionLeftHandDriving;
        protected String regionLang;
        protected String regionMetric;
        protected String regionRoadSigns;
        protected String wikiLink;
        protected String population;

        public String getRegionLeftHandDriving() {
            return this.regionLeftHandDriving;
        }

        public String getRegionLang() {
            return this.regionLang;
        }

        public String getRegionMetric() {
            return this.regionMetric;
        }

        public String getRegionRoadSigns() {
            return this.regionRoadSigns;
        }

        public String getWikiLink() {
            return this.wikiLink;
        }

        public String getPopulation() {
            return this.population;
        }
    }
}

