"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JwtAuthentication = void 0;

var _authentication_type = require("../authentication_type");

var _routes = require("./routes");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class JwtAuthentication extends _authentication_type.AuthenticationType {
  constructor(config, sessionStorageFactory, router, esClient, coreSetup, logger) {
    var _this$config$jwt;

    super(config, sessionStorageFactory, router, esClient, coreSetup, logger);

    _defineProperty(this, "type", 'jwt');

    _defineProperty(this, "authHeaderName", void 0);

    this.authHeaderName = ((_this$config$jwt = this.config.jwt) === null || _this$config$jwt === void 0 ? void 0 : _this$config$jwt.header.toLowerCase()) || 'authorization';
    this.init();
  }

  async init() {
    const routes = new _routes.JwtAuthRoutes(this.router, this.sessionStorageFactory);
    routes.setupRoutes();
  }

  getTokenFromUrlParam(request) {
    var _this$config$jwt2;

    const urlParamName = (_this$config$jwt2 = this.config.jwt) === null || _this$config$jwt2 === void 0 ? void 0 : _this$config$jwt2.url_param;

    if (urlParamName) {
      const token = request.url.searchParams.get(urlParamName);
      return token || undefined;
    }

    return undefined;
  }

  getBearerToken(request) {
    const token = this.getTokenFromUrlParam(request);

    if (token) {
      return `Bearer ${token}`;
    } // no token in url parameter, try to get token from header


    return request.headers[this.authHeaderName] || undefined;
  }

  requestIncludesAuthInfo(request) {
    var _this$config$jwt3;

    if (request.headers[this.authHeaderName]) {
      return true;
    }

    const urlParamName = (_this$config$jwt3 = this.config.jwt) === null || _this$config$jwt3 === void 0 ? void 0 : _this$config$jwt3.url_param;

    if (urlParamName && request.url.searchParams.get(urlParamName)) {
      return true;
    }

    return false;
  }

  getAdditionalAuthHeader(request) {
    const header = {};
    const token = this.getTokenFromUrlParam(request);

    if (token) {
      header[this.authHeaderName] = `Bearer ${token}`;
    }

    return header;
  }

  getCookie(request, authInfo) {
    return {
      username: authInfo.user_name,
      credentials: {
        authHeaderValue: this.getBearerToken(request)
      },
      authType: this.type,
      expiryTime: Date.now() + this.config.session.ttl
    };
  }

  async isValidCookie(cookie) {
    var _cookie$credentials;

    return cookie.authType === this.type && cookie.username && cookie.expiryTime && ((_cookie$credentials = cookie.credentials) === null || _cookie$credentials === void 0 ? void 0 : _cookie$credentials.authHeaderValue);
  }

  handleUnauthedRequest(request, response, toolkit) {
    return response.unauthorized();
  }

  buildAuthHeaderFromCookie(cookie) {
    var _cookie$credentials2;

    const header = {};
    const authHeaderValue = (_cookie$credentials2 = cookie.credentials) === null || _cookie$credentials2 === void 0 ? void 0 : _cookie$credentials2.authHeaderValue;

    if (authHeaderValue) {
      header[this.authHeaderName] = authHeaderValue;
    }

    return header;
  }

}

exports.JwtAuthentication = JwtAuthentication;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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