//go:build m5stack
// +build m5stack

package machine

const (
	//     GND     | ADC     G35
	//     GND     | ADC     G36
	//     GND     | RST     EN
	// G23 MOSI    | DAC/SPK G25
	// G19 MISO    | DAC     G26
	// G18 SCK     | 3.3V
	// G3  RXD1    | TXD1    G1
	// G16 RXD2    | TXD2    G17
	// G21 SDA     | DCL     G22
	// G2  GPIO    | GPIO    G5
	// G12 IIS_SK  | IIS_WS  G13
	// G15 IIS_OUT | IIS_MK  G0
	//     HPWR    | IIS_IN  G34
	//     HPWR    | 5V
	//     HPWR    | BATTERY

	IO0  = GPIO0
	IO1  = GPIO1
	IO2  = GPIO2
	IO3  = GPIO3
	IO4  = GPIO4
	IO5  = GPIO5
	IO6  = GPIO6
	IO7  = GPIO7
	IO8  = GPIO8
	IO9  = GPIO9
	IO10 = GPIO10
	IO11 = GPIO11
	IO12 = GPIO12
	IO13 = GPIO13
	IO14 = GPIO14
	IO15 = GPIO15
	IO16 = GPIO16
	IO17 = GPIO17
	IO18 = GPIO18
	IO19 = GPIO19
	IO21 = GPIO21
	IO22 = GPIO22
	IO23 = GPIO23
	IO25 = GPIO25
	IO26 = GPIO26
	IO27 = GPIO27
	IO32 = GPIO32
	IO33 = GPIO33
	IO34 = GPIO34
	IO35 = GPIO35
	IO36 = GPIO36
	IO37 = GPIO37
	IO38 = GPIO38
	IO39 = GPIO39
)

const (
	// Buttons
	BUTTON_A = IO39
	BUTTON_B = IO38
	BUTTON_C = IO37
	BUTTON   = BUTTON_A

	// Speaker
	SPEAKER_PIN = IO25
)

// SPI pins
const (
	SPI0_SCK_PIN = IO18
	SPI0_SDO_PIN = IO23
	SPI0_SDI_PIN = IO19
	SPI0_CS0_PIN = IO14

	// LCD (ILI9342C)
	LCD_SCK_PIN = SPI0_SCK_PIN
	LCD_SDO_PIN = SPI0_SDO_PIN
	LCD_SDI_PIN = SPI0_SDI_PIN // NoPin ?
	LCD_SS_PIN  = SPI0_CS0_PIN
	LCD_DC_PIN  = IO27
	LCD_RST_PIN = IO33
	LCD_BL_PIN  = IO32

	// SD CARD
	SDCARD_SCK_PIN = SPI0_SCK_PIN
	SDCARD_SDO_PIN = SPI0_SDO_PIN
	SDCARD_SDI_PIN = SPI0_SDI_PIN
	SDCARD_SS_PIN  = IO4
)

// I2C pins
const (
	SDA0_PIN = IO21
	SCL0_PIN = IO22

	SDA_PIN = SDA0_PIN
	SCL_PIN = SCL0_PIN
)

// ADC pins
const (
	ADC1 Pin = IO35
	ADC2 Pin = IO36
)

// DAC pins
const (
	DAC1 Pin = IO25
	DAC2 Pin = IO26
)

// UART pins
const (
	// UART0 (CP2104)
	UART0_TX_PIN = IO1
	UART0_RX_PIN = IO3

	UART1_TX_PIN = IO17
	UART1_RX_PIN = IO16

	UART_TX_PIN = UART0_TX_PIN
	UART_RX_PIN = UART0_RX_PIN
)
