import type tsp from 'typescript/lib/protocol.d.js';
export declare enum RequestQueueingType {
    /**
     * Normal request that is executed in order.
     */
    Normal = 1,
    /**
     * Request that normal requests jump in front of in the queue.
     */
    LowPriority = 2,
    /**
     * A fence that blocks request reordering.
     *
     * Fences are not reordered. Unlike a normal request, a fence will never jump in front of a low priority request
     * in the request queue.
     */
    Fence = 3
}
export interface RequestItem {
    readonly request: tsp.Request;
    readonly expectsResponse: boolean;
    readonly isAsync: boolean;
    readonly queueingType: RequestQueueingType;
}
export declare class RequestQueue {
    private readonly queue;
    private sequenceNumber;
    get length(): number;
    enqueue(item: RequestItem): void;
    dequeue(): RequestItem | undefined;
    tryDeletePendingRequest(seq: number): boolean;
    createRequest(command: string, args: any): tsp.Request;
}
//# sourceMappingURL=requestQueue.d.ts.map