/// <reference types="node" resolution-mode="require"/>
import type tsp from 'typescript/lib/protocol.d.js';
import { CancellationToken } from 'vscode-jsonrpc';
import { ServerResponse, ServerType, TypeScriptRequestTypes } from './requests.js';
import type { TspClientOptions } from '../tsp-client.js';
import { OngoingRequestCanceller } from './cancellation.js';
import type { TypeScriptVersion } from './versionProvider.js';
export declare enum ExecutionTarget {
    Semantic = 0,
    Syntax = 1
}
export interface TypeScriptServerExitEvent {
    readonly code: number | null;
    readonly signal: NodeJS.Signals | null;
}
declare type OnEventHandler = (e: tsp.Event) => any;
declare type OnExitHandler = (e: TypeScriptServerExitEvent) => any;
declare type OnErrorHandler = (e: any) => any;
export interface ITypeScriptServer {
    onEvent(handler: OnEventHandler): void;
    onExit(handler: OnExitHandler): void;
    onError(handler: OnErrorHandler): void;
    readonly tsServerLogFile: string | undefined;
    kill(): void;
    /**
     * @return A list of all execute requests. If there are multiple entries, the first item is the primary
     * request while the rest are secondary ones.
     */
    executeImpl(command: keyof TypeScriptRequestTypes, args: any, executeInfo: {
        isAsync: boolean;
        token?: CancellationToken;
        expectsResult: boolean;
        lowPriority?: boolean;
        executionTarget?: ExecutionTarget;
    }): Array<Promise<ServerResponse.Response<tsp.Response>> | undefined>;
    dispose(): void;
}
export declare const enum TsServerProcessKind {
    Main = "main",
    Syntax = "syntax",
    Semantic = "semantic",
    Diagnostics = "diagnostics"
}
export interface TsServerProcessFactory {
    fork(version: TypeScriptVersion, args: readonly string[], kind: TsServerProcessKind, configuration: TspClientOptions): TsServerProcess;
}
export interface TsServerProcess {
    write(serverRequest: tsp.Request): void;
    onData(handler: (data: tsp.Response) => void): void;
    onExit(handler: (code: number | null, signal: NodeJS.Signals | null) => void): void;
    onError(handler: (error: Error) => void): void;
    kill(): void;
}
export declare class ProcessBasedTsServer implements ITypeScriptServer {
    private readonly _serverId;
    private readonly _serverSource;
    private readonly _process;
    private readonly _tsServerLogFile;
    private readonly _requestCanceller;
    private readonly _version;
    private readonly _requestQueue;
    private readonly _callbacks;
    private readonly _pendingResponses;
    private readonly _eventHandlers;
    private readonly _exitHandlers;
    private readonly _errorHandlers;
    constructor(_serverId: string, _serverSource: ServerType, _process: TsServerProcess, _tsServerLogFile: string | undefined, _requestCanceller: OngoingRequestCanceller, _version: TypeScriptVersion);
    onEvent(handler: OnEventHandler): void;
    onExit(handler: OnExitHandler): void;
    onError(handler: OnErrorHandler): void;
    get tsServerLogFile(): string | undefined;
    private write;
    dispose(): void;
    kill(): void;
    private dispatchMessage;
    private tryCancelRequest;
    private dispatchResponse;
    executeImpl(command: keyof TypeScriptRequestTypes, args: any, executeInfo: {
        isAsync: boolean;
        token?: CancellationToken;
        expectsResult: boolean;
        lowPriority?: boolean;
        executionTarget?: ExecutionTarget;
    }): Array<Promise<ServerResponse.Response<tsp.Response>> | undefined>;
    private sendNextRequests;
    private sendRequest;
    private fetchCallback;
    private logTrace;
    private static readonly fenceCommands;
    private static getQueueingType;
}
export {};
//# sourceMappingURL=server.d.ts.map