/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MarkerAnnotation;
import org.eclipse.jdt.internal.compiler.ast.NormalAnnotation;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.RecordComponent;
import org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.codegen.AnnotationContext;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.RecordComponentBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public abstract class TypeReference
extends Expression {
    public static final TypeReference[] NO_TYPE_ARGUMENTS = new TypeReference[0];
    public Annotation[][] annotations = null;

    public static final TypeReference baseTypeReference(int n, int n2, Annotation[][] annotationArray) {
        if (n2 == 0) {
            switch (n) {
                case 6: {
                    return new SingleTypeReference(TypeBinding.VOID.simpleName, 0L);
                }
                case 5: {
                    return new SingleTypeReference(TypeBinding.BOOLEAN.simpleName, 0L);
                }
                case 2: {
                    return new SingleTypeReference(TypeBinding.CHAR.simpleName, 0L);
                }
                case 9: {
                    return new SingleTypeReference(TypeBinding.FLOAT.simpleName, 0L);
                }
                case 8: {
                    return new SingleTypeReference(TypeBinding.DOUBLE.simpleName, 0L);
                }
                case 3: {
                    return new SingleTypeReference(TypeBinding.BYTE.simpleName, 0L);
                }
                case 4: {
                    return new SingleTypeReference(TypeBinding.SHORT.simpleName, 0L);
                }
                case 10: {
                    return new SingleTypeReference(TypeBinding.INT.simpleName, 0L);
                }
            }
            return new SingleTypeReference(TypeBinding.LONG.simpleName, 0L);
        }
        switch (n) {
            case 6: {
                return new ArrayTypeReference(TypeBinding.VOID.simpleName, n2, annotationArray, 0L);
            }
            case 5: {
                return new ArrayTypeReference(TypeBinding.BOOLEAN.simpleName, n2, annotationArray, 0L);
            }
            case 2: {
                return new ArrayTypeReference(TypeBinding.CHAR.simpleName, n2, annotationArray, 0L);
            }
            case 9: {
                return new ArrayTypeReference(TypeBinding.FLOAT.simpleName, n2, annotationArray, 0L);
            }
            case 8: {
                return new ArrayTypeReference(TypeBinding.DOUBLE.simpleName, n2, annotationArray, 0L);
            }
            case 3: {
                return new ArrayTypeReference(TypeBinding.BYTE.simpleName, n2, annotationArray, 0L);
            }
            case 4: {
                return new ArrayTypeReference(TypeBinding.SHORT.simpleName, n2, annotationArray, 0L);
            }
            case 10: {
                return new ArrayTypeReference(TypeBinding.INT.simpleName, n2, annotationArray, 0L);
            }
        }
        return new ArrayTypeReference(TypeBinding.LONG.simpleName, n2, annotationArray, 0L);
    }

    public static final TypeReference baseTypeReference(int n, int n2) {
        return TypeReference.baseTypeReference(n, n2, null);
    }

    public void aboutToResolve(Scope scope) {
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        return flowInfo;
    }

    public void checkBounds(Scope scope) {
    }

    public abstract TypeReference augmentTypeWithAdditionalDimensions(int var1, Annotation[][] var2, boolean var3);

    protected Annotation[][] getMergedAnnotationsOnDimensions(int n, Annotation[][] annotationArray) {
        Annotation[][] annotationArray2 = this.getAnnotationsOnDimensions(true);
        int n2 = this.dimensions();
        if (annotationArray2 == null && annotationArray == null) {
            return null;
        }
        int n3 = n2 + n;
        Annotation[][] annotationArray3 = new Annotation[n3][];
        if (annotationArray2 != null) {
            System.arraycopy(annotationArray2, 0, annotationArray3, 0, n2);
        }
        if (annotationArray != null) {
            int n4 = n2;
            int n5 = 0;
            while (n4 < n3) {
                annotationArray3[n4] = annotationArray[n5];
                ++n4;
                ++n5;
            }
        }
        return annotationArray3;
    }

    public int dimensions() {
        return 0;
    }

    public int extraDimensions() {
        return 0;
    }

    public AnnotationContext[] getAllAnnotationContexts(int n) {
        ArrayList<AnnotationContext> arrayList = new ArrayList<AnnotationContext>();
        AnnotationCollector annotationCollector = new AnnotationCollector(this, n, arrayList);
        this.traverse((ASTVisitor)annotationCollector, (BlockScope)null);
        return arrayList.toArray(new AnnotationContext[arrayList.size()]);
    }

    public void getAllAnnotationContexts(int n, int n2, List<AnnotationContext> list) {
        AnnotationCollector annotationCollector = new AnnotationCollector(this, n, n2, list);
        this.traverse((ASTVisitor)annotationCollector, (BlockScope)null);
    }

    public void getAllAnnotationContexts(int n, int n2, List<AnnotationContext> list, Annotation[] annotationArray) {
        int n3;
        AnnotationCollector annotationCollector = new AnnotationCollector(this, n, n2, list);
        int n4 = n3 = annotationArray == null ? 0 : annotationArray.length;
        for (int i = 0; i < n3; ++i) {
            Annotation annotation = annotationArray[i];
            annotation.traverse((ASTVisitor)annotationCollector, (BlockScope)null);
        }
        this.traverse((ASTVisitor)annotationCollector, (BlockScope)null);
    }

    public void getAllAnnotationContexts(int n, int n2, List<AnnotationContext> list, Annotation[][] annotationArray, int n3) {
        AnnotationCollector annotationCollector = new AnnotationCollector(this, n, n2, list, annotationArray, n3);
        this.traverse((ASTVisitor)annotationCollector, (BlockScope)null);
        if (annotationArray != null) {
            for (Annotation[] annotationArray2 : annotationArray) {
                if (annotationArray2 == null) continue;
                int n4 = annotationArray2.length;
                for (int i = 0; i < n4; ++i) {
                    annotationArray2[i].traverse((ASTVisitor)annotationCollector, (BlockScope)null);
                }
            }
        }
    }

    public void getAllAnnotationContexts(int n, int n2, int n3, List<AnnotationContext> list) {
        AnnotationCollector annotationCollector = new AnnotationCollector(this, n, n2, n3, list);
        this.traverse((ASTVisitor)annotationCollector, (BlockScope)null);
    }

    public void getAllAnnotationContexts(int n, List<AnnotationContext> list) {
        AnnotationCollector annotationCollector = new AnnotationCollector(this, n, list);
        this.traverse((ASTVisitor)annotationCollector, (BlockScope)null);
    }

    public Annotation[][] getAnnotationsOnDimensions() {
        return this.getAnnotationsOnDimensions(false);
    }

    public TypeReference[][] getTypeArguments() {
        return null;
    }

    public Annotation[][] getAnnotationsOnDimensions(boolean bl) {
        return null;
    }

    public void setAnnotationsOnDimensions(Annotation[][] annotationArray) {
    }

    public abstract char[] getLastToken();

    public char[][] getParameterizedTypeName() {
        return this.getTypeName();
    }

    protected abstract TypeBinding getTypeBinding(Scope var1);

    public abstract char[][] getTypeName();

    protected TypeBinding internalResolveType(Scope scope, int n) {
        TypeBinding typeBinding;
        boolean bl;
        block19: {
            block18: {
                this.constant = Constant.NotAConstant;
                if (this.resolvedType != null) {
                    if (this.resolvedType.isValidBinding()) {
                        return this.resolvedType;
                    }
                    switch (this.resolvedType.problemId()) {
                        case 1: 
                        case 2: 
                        case 5: {
                            TypeBinding typeBinding2 = this.resolvedType.closestMatch();
                            if (typeBinding2 == null) {
                                return null;
                            }
                            return scope.environment().convertToRawType(typeBinding2, false);
                        }
                    }
                    return null;
                }
                bl = false;
                this.resolvedType = this.getTypeBinding(scope);
                typeBinding = this.resolvedType;
                if (typeBinding == null) {
                    return null;
                }
                bl = !typeBinding.isValidBinding();
                if (!bl) break block18;
                if (this.isTypeNameVar(scope)) {
                    this.reportVarIsNotAllowedHere(scope);
                } else if (!scope.problemReporter().validateRestrictedKeywords(this.getLastToken(), this)) {
                    this.reportInvalidType(scope);
                }
                switch (typeBinding.problemId()) {
                    case 1: 
                    case 2: 
                    case 5: {
                        typeBinding = typeBinding.closestMatch();
                        if (typeBinding == null) {
                            return null;
                        }
                        break block19;
                    }
                    default: {
                        return null;
                    }
                }
            }
            scope.problemReporter().validateRestrictedKeywords(this.getLastToken(), this);
        }
        if (typeBinding.isArrayType() && ((ArrayBinding)typeBinding).leafComponentType == TypeBinding.VOID) {
            scope.problemReporter().cannotAllocateVoidArray(this);
            return null;
        }
        if (!(this instanceof QualifiedTypeReference) && this.isTypeUseDeprecated(typeBinding, scope)) {
            this.reportDeprecatedType(typeBinding, scope);
        }
        if ((typeBinding = scope.environment().convertToRawType(typeBinding, false)).leafComponentType().isRawType() && (this.bits & 0x40000000) == 0 && scope.compilerOptions().getSeverity(0x20010000) != 256) {
            scope.problemReporter().rawTypeReference(this, typeBinding);
        }
        if (bl) {
            this.resolveAnnotations(scope, 0);
            return typeBinding;
        }
        this.resolvedType = typeBinding;
        this.resolveAnnotations(scope, n);
        return this.resolvedType;
    }

    @Override
    public boolean isTypeReference() {
        return true;
    }

    public boolean isWildcard() {
        return false;
    }

    public boolean isUnionType() {
        return false;
    }

    public boolean isVarargs() {
        return (this.bits & 0x4000) != 0;
    }

    public boolean isParameterizedTypeReference() {
        return false;
    }

    protected void reportDeprecatedType(TypeBinding typeBinding, Scope scope, int n) {
        scope.problemReporter().deprecatedType(typeBinding, this, n);
    }

    protected void reportDeprecatedType(TypeBinding typeBinding, Scope scope) {
        scope.problemReporter().deprecatedType(typeBinding, this, Integer.MAX_VALUE);
    }

    protected void reportInvalidType(Scope scope) {
        scope.problemReporter().invalidType(this, this.resolvedType);
    }

    protected void reportVarIsNotAllowedHere(Scope scope) {
        scope.problemReporter().varIsNotAllowedHere(this);
    }

    public TypeBinding resolveSuperType(ClassScope classScope) {
        TypeBinding typeBinding = this.resolveType(classScope);
        if (typeBinding == null) {
            return null;
        }
        if (typeBinding.isTypeVariable()) {
            if (this.resolvedType.isValidBinding()) {
                this.resolvedType = new ProblemReferenceBinding(this.getTypeName(), (ReferenceBinding)this.resolvedType, 9);
                this.reportInvalidType(classScope);
            }
            return null;
        }
        return typeBinding;
    }

    @Override
    public final TypeBinding resolveType(BlockScope blockScope) {
        return this.resolveType(blockScope, true);
    }

    public TypeBinding resolveType(BlockScope blockScope, boolean bl) {
        return this.resolveType(blockScope, bl, 0);
    }

    public TypeBinding resolveType(BlockScope blockScope, boolean bl, int n) {
        return this.internalResolveType(blockScope, n);
    }

    @Override
    public TypeBinding resolveType(ClassScope classScope) {
        return this.resolveType(classScope, 0);
    }

    public TypeBinding resolveType(ClassScope classScope, int n) {
        return this.internalResolveType(classScope, n);
    }

    public TypeBinding resolveTypeArgument(BlockScope blockScope, ReferenceBinding referenceBinding, int n) {
        return this.resolveType(blockScope, true, 64);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeBinding resolveTypeArgument(ClassScope classScope, ReferenceBinding referenceBinding, int n) {
        SourceTypeBinding sourceTypeBinding = classScope.referenceContext.binding;
        boolean bl = false;
        try {
            if (sourceTypeBinding.isHierarchyBeingConnected()) {
                bl = (sourceTypeBinding.tagBits & 0x80000L) == 0L;
                sourceTypeBinding.tagBits |= 0x80000L;
            }
            TypeBinding typeBinding = this.resolveType(classScope, 64);
            return typeBinding;
        }
        finally {
            if (bl) {
                sourceTypeBinding.tagBits &= 0xFFFFFFFFFFF7FFFFL;
            }
        }
    }

    @Override
    public abstract void traverse(ASTVisitor var1, BlockScope var2);

    @Override
    public abstract void traverse(ASTVisitor var1, ClassScope var2);

    protected void resolveAnnotations(Scope scope, int n) {
        Object object;
        Annotation[][] annotationArray = this.getAnnotationsOnDimensions();
        if ((this.annotations != null || annotationArray != null) && (object = Scope.typeAnnotationsResolutionScope(scope)) != null) {
            Object object2;
            int n2 = this.dimensions();
            if (this.annotations != null) {
                object2 = this.resolvedType.leafComponentType();
                object2 = TypeReference.resolveAnnotations((BlockScope)object, this.annotations, (TypeBinding)object2);
                TypeBinding typeBinding = this.resolvedType = n2 > 0 ? scope.environment().createArrayType((TypeBinding)object2, n2) : object2;
            }
            if (annotationArray != null) {
                this.resolvedType = TypeReference.resolveAnnotations((BlockScope)object, annotationArray, this.resolvedType);
                if (this.resolvedType instanceof ArrayBinding && (object2 = (Object)((ArrayBinding)this.resolvedType).nullTagBitsPerDimension) != null) {
                    for (int i = 0; i < n2; ++i) {
                        if ((object2[i] & 0x180000000000000L) != 0x180000000000000L) continue;
                        scope.problemReporter().contradictoryNullAnnotations(annotationArray[i]);
                        object2[i] = 0L;
                    }
                }
            }
        }
        if (scope.compilerOptions().isAnnotationBasedNullAnalysisEnabled && this.resolvedType != null && (this.resolvedType.tagBits & 0x180000000000000L) == 0L && !this.resolvedType.isTypeVariable() && !this.resolvedType.isWildcard() && n != 0 && scope.hasDefaultNullnessFor(n, this.sourceStart)) {
            if (n == 256 && this.resolvedType.id == 1) {
                scope.problemReporter().implicitObjectBoundNoNullDefault(this);
            } else {
                object = scope.environment();
                AnnotationBinding[] annotationBindingArray = new AnnotationBinding[]{((LookupEnvironment)object).getNonNullAnnotation()};
                this.resolvedType = ((LookupEnvironment)object).createAnnotatedType(this.resolvedType, annotationBindingArray);
            }
        }
    }

    public int getAnnotatableLevels() {
        return 1;
    }

    protected void checkIllegalNullAnnotations(Scope scope, TypeReference[] typeReferenceArray) {
        if (scope.environment().usesNullTypeAnnotations() && typeReferenceArray != null) {
            for (int i = 0; i < typeReferenceArray.length; ++i) {
                TypeReference typeReference = typeReferenceArray[i];
                if (typeReference.resolvedType == null) continue;
                typeReference.checkIllegalNullAnnotation(scope);
            }
        }
    }

    protected void checkNullConstraints(Scope scope, Substitution substitution, TypeBinding[] typeBindingArray, int n) {
        TypeBinding typeBinding;
        if (typeBindingArray != null && typeBindingArray.length > n && (typeBinding = typeBindingArray[n]).hasNullTypeAnnotations() && NullAnnotationMatching.analyse(typeBinding, this.resolvedType, null, substitution, -1, null, NullAnnotationMatching.CheckMode.BOUND_CHECK).isAnyMismatch()) {
            scope.problemReporter().nullityMismatchTypeArgument(typeBinding, this.resolvedType, this);
        }
        this.checkIllegalNullAnnotation(scope);
    }

    protected void checkIllegalNullAnnotation(Scope scope) {
        if (this.resolvedType.leafComponentType().isBaseType() && this.hasNullTypeAnnotation(AnnotationPosition.LEAF_TYPE)) {
            scope.problemReporter().illegalAnnotationForBaseType(this, this.annotations[0], this.resolvedType.tagBits & 0x180000000000000L);
        }
    }

    public Annotation findAnnotation(long l) {
        Annotation[] annotationArray;
        if (this.annotations != null && (annotationArray = this.annotations[this.annotations.length - 1]) != null) {
            int n = l == 0x100000000000000L ? 32 : 64;
            for (int i = 0; i < annotationArray.length; ++i) {
                if (annotationArray[i] == null || !annotationArray[i].hasNullBit(n)) continue;
                return annotationArray[i];
            }
        }
        return null;
    }

    public boolean hasNullTypeAnnotation(AnnotationPosition annotationPosition) {
        if (this.annotations != null) {
            if (annotationPosition == AnnotationPosition.MAIN_TYPE) {
                Annotation[] annotationArray = this.annotations[this.annotations.length - 1];
                return TypeReference.containsNullAnnotation(annotationArray);
            }
            for (Annotation[] annotationArray : this.annotations) {
                if (!TypeReference.containsNullAnnotation(annotationArray)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsNullAnnotation(Annotation[] annotationArray) {
        if (annotationArray != null) {
            for (int i = 0; i < annotationArray.length; ++i) {
                if (annotationArray[i] == null || !annotationArray[i].hasNullBit(96)) continue;
                return true;
            }
        }
        return false;
    }

    public TypeReference[] getTypeReferences() {
        return new TypeReference[]{this};
    }

    public boolean isBaseTypeReference() {
        return false;
    }

    private char[] getTypeName(int n) {
        char[][] cArray = this.getTypeName();
        return cArray != null && cArray.length > n ? cArray[n] : CharOperation.NO_CHAR;
    }

    public boolean isTypeNameVar(Scope scope) {
        CompilerOptions compilerOptions;
        CompilerOptions compilerOptions2 = compilerOptions = scope != null ? scope.compilerOptions() : null;
        if (compilerOptions != null && compilerOptions.sourceLevel < 0x360000L) {
            return false;
        }
        return CharOperation.equals(this.getTypeName(0), TypeConstants.VAR);
    }

    static class AnnotationCollector
    extends ASTVisitor {
        List<AnnotationContext> annotationContexts;
        Expression typeReference;
        int targetType;
        int info = 0;
        int info2 = 0;
        LocalVariableBinding localVariable;
        Annotation[][] annotationsOnDimensions;
        int dimensions;
        Wildcard currentWildcard;
        RecordComponentBinding recordComponentBinding;

        public AnnotationCollector(TypeParameter typeParameter, int n, int n2, List<AnnotationContext> list) {
            this.annotationContexts = list;
            this.typeReference = typeParameter.type;
            this.targetType = n;
            this.info = n2;
        }

        public AnnotationCollector(LocalDeclaration localDeclaration, int n, LocalVariableBinding localVariableBinding, List<AnnotationContext> list) {
            this.annotationContexts = list;
            this.typeReference = localDeclaration.type;
            this.targetType = n;
            this.localVariable = localVariableBinding;
        }

        public AnnotationCollector(LocalDeclaration localDeclaration, int n, int n2, List<AnnotationContext> list) {
            this.annotationContexts = list;
            this.typeReference = localDeclaration.type;
            this.targetType = n;
            this.info = n2;
        }

        public AnnotationCollector(TypeReference typeReference, int n, List<AnnotationContext> list) {
            this.annotationContexts = list;
            this.typeReference = typeReference;
            this.targetType = n;
        }

        public AnnotationCollector(Expression expression, int n, int n2, List<AnnotationContext> list) {
            this.annotationContexts = list;
            this.typeReference = expression;
            this.info = n2;
            this.targetType = n;
        }

        public AnnotationCollector(TypeReference typeReference, int n, int n2, int n3, List<AnnotationContext> list) {
            this.annotationContexts = list;
            this.typeReference = typeReference;
            this.info = n2;
            this.targetType = n;
            this.info2 = n3;
        }

        public AnnotationCollector(TypeReference typeReference, int n, int n2, List<AnnotationContext> list, Annotation[][] annotationArray, int n3) {
            this.annotationContexts = list;
            this.typeReference = typeReference;
            this.info = n2;
            this.targetType = n;
            this.annotationsOnDimensions = annotationArray;
            this.dimensions = n3;
        }

        public AnnotationCollector(RecordComponent recordComponent, int n, List<AnnotationContext> list) {
            this.annotationContexts = list;
            this.typeReference = recordComponent.type;
            this.targetType = n;
            this.recordComponentBinding = recordComponent.binding;
        }

        private boolean internalVisit(Annotation annotation) {
            AnnotationContext annotationContext = null;
            if (annotation.isRuntimeTypeInvisible()) {
                annotationContext = new AnnotationContext(annotation, this.typeReference, this.targetType, 2);
            } else if (annotation.isRuntimeTypeVisible()) {
                annotationContext = new AnnotationContext(annotation, this.typeReference, this.targetType, 1);
            }
            if (annotationContext != null) {
                annotationContext.wildcard = this.currentWildcard;
                switch (this.targetType) {
                    case 0: 
                    case 1: 
                    case 16: 
                    case 22: 
                    case 23: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: {
                        annotationContext.info = this.info;
                        break;
                    }
                    case 64: 
                    case 65: {
                        annotationContext.variableBinding = this.localVariable;
                        break;
                    }
                    case 17: 
                    case 18: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: {
                        annotationContext.info2 = this.info2;
                        annotationContext.info = this.info;
                        break;
                    }
                }
                this.annotationContexts.add(annotationContext);
            }
            return true;
        }

        @Override
        public boolean visit(MarkerAnnotation markerAnnotation, BlockScope blockScope) {
            return this.internalVisit(markerAnnotation);
        }

        @Override
        public boolean visit(NormalAnnotation normalAnnotation, BlockScope blockScope) {
            return this.internalVisit(normalAnnotation);
        }

        @Override
        public boolean visit(SingleMemberAnnotation singleMemberAnnotation, BlockScope blockScope) {
            return this.internalVisit(singleMemberAnnotation);
        }

        @Override
        public boolean visit(Wildcard wildcard, BlockScope blockScope) {
            this.currentWildcard = wildcard;
            return true;
        }

        @Override
        public boolean visit(Argument argument, BlockScope blockScope) {
            if ((argument.bits & 0x20000000) == 0) {
                return true;
            }
            int n = this.localVariable.initializationCount;
            for (int i = 0; i < n; ++i) {
                int n2 = this.localVariable.initializationPCs[i << 1];
                int n3 = this.localVariable.initializationPCs[(i << 1) + 1];
                if (n2 == n3) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean visit(Argument argument, ClassScope classScope) {
            if ((argument.bits & 0x20000000) == 0) {
                return true;
            }
            int n = this.localVariable.initializationCount;
            for (int i = 0; i < n; ++i) {
                int n2 = this.localVariable.initializationPCs[i << 1];
                int n3 = this.localVariable.initializationPCs[(i << 1) + 1];
                if (n2 == n3) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean visit(LocalDeclaration localDeclaration, BlockScope blockScope) {
            int n = this.localVariable.initializationCount;
            for (int i = 0; i < n; ++i) {
                int n2 = this.localVariable.initializationPCs[i << 1];
                int n3 = this.localVariable.initializationPCs[(i << 1) + 1];
                if (n2 == n3) continue;
                return true;
            }
            return false;
        }

        @Override
        public void endVisit(Wildcard wildcard, BlockScope blockScope) {
            this.currentWildcard = null;
        }
    }

    public static enum AnnotationPosition {
        MAIN_TYPE,
        LEAF_TYPE,
        ANY;

    }
}

