// This file is generated by kconfig_compiler_kf5 from elisa_core.kcfg.
// All changes you do to this file will be lost.

#include "elisa_settings.h"

#include <qglobal.h>
#include <QFile>

#include <QDebug>

using namespace Elisa;

namespace Elisa {

class ElisaConfigurationPrivate
{
  public:

    // ElisaFileIndexer
    QStringList rootPath;
    bool forceUsageOfFastFileSearch;

    // PlayerSettings
    bool showNowPlayingBackground;
    bool showProgressOnTaskBar;
    bool showSystemTrayIcon;
    bool playAtStartup;
    bool scanAtStartup;
    bool useFavoriteStyleRatings;

    // Views
    int embeddedView;
    int initialView;
    QString colorScheme;
    QStringList sortRolePreferences;
    QStringList sortOrderPreferences;

    // items
    KConfigCompilerSignallingItem *itemRootPath;
    KConfigCompilerSignallingItem *itemForceUsageOfFastFileSearch;
    KConfigCompilerSignallingItem *itemShowNowPlayingBackground;
    KConfigCompilerSignallingItem *itemShowProgressOnTaskBar;
    KConfigCompilerSignallingItem *itemShowSystemTrayIcon;
    KConfigCompilerSignallingItem *itemPlayAtStartup;
    KConfigCompilerSignallingItem *itemScanAtStartup;
    KConfigCompilerSignallingItem *itemUseFavoriteStyleRatings;
    KConfigCompilerSignallingItem *itemEmbeddedView;
    KConfigCompilerSignallingItem *itemInitialView;
    KConfigCompilerSignallingItem *itemColorScheme;
    KConfigCompilerSignallingItem *itemSortRolePreferences;
    KConfigCompilerSignallingItem *itemSortOrderPreferences;
};


}
namespace Elisa {

class ElisaConfigurationHelper
{
  public:
    ElisaConfigurationHelper() : q(nullptr) {}
    ~ElisaConfigurationHelper() { delete q; q = nullptr; }
    ElisaConfigurationHelper(const ElisaConfigurationHelper&) = delete;
    ElisaConfigurationHelper& operator=(const ElisaConfigurationHelper&) = delete;
    ElisaConfiguration *q;
};

}
Q_GLOBAL_STATIC(ElisaConfigurationHelper, s_globalElisaConfiguration)
ElisaConfiguration *ElisaConfiguration::self()
{
  if (!s_globalElisaConfiguration()->q)
     qFatal("you need to call ElisaConfiguration::instance before using");
  return s_globalElisaConfiguration()->q;
}

void ElisaConfiguration::instance(const QString& cfgfilename)
{
  if (s_globalElisaConfiguration()->q) {
     qDebug() << "ElisaConfiguration::instance called after the first use - ignoring";
     return;
  }
  new ElisaConfiguration(KSharedConfig::openConfig(cfgfilename));
  s_globalElisaConfiguration()->q->read();
}

void ElisaConfiguration::instance(KSharedConfig::Ptr config)
{
  if (s_globalElisaConfiguration()->q) {
     qDebug() << "ElisaConfiguration::instance called after the first use - ignoring";
     return;
  }
  new ElisaConfiguration(std::move(config));
  s_globalElisaConfiguration()->q->read();
}

ElisaConfiguration::ElisaConfiguration( KSharedConfig::Ptr config )
  : KConfigSkeleton( std::move( config ) )
{
  d = new ElisaConfigurationPrivate;
  Q_ASSERT(!s_globalElisaConfiguration()->q);
  s_globalElisaConfiguration()->q = this;
  KConfigCompilerSignallingItem::NotifyFunction notifyFunction = static_cast<KConfigCompilerSignallingItem::NotifyFunction>(&ElisaConfiguration::itemChanged);

  setCurrentGroup( QStringLiteral( "ElisaFileIndexer" ) );

  KConfigSkeleton::ItemPathList  *innerItemRootPath;
  innerItemRootPath = new KConfigSkeleton::ItemPathList( currentGroup(), QStringLiteral( "RootPath" ), d->rootPath );
  d->itemRootPath = new KConfigCompilerSignallingItem(innerItemRootPath, this, notifyFunction, signalRootPathChanged);
  d->itemRootPath->setWriteFlags(KConfigBase::Notify);
  addItem( d->itemRootPath, QStringLiteral( "RootPath" ) );
  KConfigSkeleton::ItemBool  *innerItemForceUsageOfFastFileSearch;
  innerItemForceUsageOfFastFileSearch = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ForceUsageOfFastFileSearch" ), d->forceUsageOfFastFileSearch );
  d->itemForceUsageOfFastFileSearch = new KConfigCompilerSignallingItem(innerItemForceUsageOfFastFileSearch, this, notifyFunction, signalForceUsageOfFastFileSearchChanged);
  d->itemForceUsageOfFastFileSearch->setWriteFlags(KConfigBase::Notify);
  addItem( d->itemForceUsageOfFastFileSearch, QStringLiteral( "ForceUsageOfFastFileSearch" ) );

  setCurrentGroup( QStringLiteral( "PlayerSettings" ) );

  KConfigSkeleton::ItemBool  *innerItemShowNowPlayingBackground;
  innerItemShowNowPlayingBackground = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ShowNowPlayingBackground" ), d->showNowPlayingBackground, 
         true
      );
  d->itemShowNowPlayingBackground = new KConfigCompilerSignallingItem(innerItemShowNowPlayingBackground, this, notifyFunction, signalShowNowPlayingBackgroundChanged);
  d->itemShowNowPlayingBackground->setWriteFlags(KConfigBase::Notify);
  addItem( d->itemShowNowPlayingBackground, QStringLiteral( "ShowNowPlayingBackground" ) );
  KConfigSkeleton::ItemBool  *innerItemShowProgressOnTaskBar;
  innerItemShowProgressOnTaskBar = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ShowProgressOnTaskBar" ), d->showProgressOnTaskBar, 
      true
     );
  d->itemShowProgressOnTaskBar = new KConfigCompilerSignallingItem(innerItemShowProgressOnTaskBar, this, notifyFunction, signalShowProgressOnTaskBarChanged);
  d->itemShowProgressOnTaskBar->setWriteFlags(KConfigBase::Notify);
  addItem( d->itemShowProgressOnTaskBar, QStringLiteral( "ShowProgressOnTaskBar" ) );
  KConfigSkeleton::ItemBool  *innerItemShowSystemTrayIcon;
  innerItemShowSystemTrayIcon = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ShowSystemTrayIcon" ), d->showSystemTrayIcon, 
      false
     );
  d->itemShowSystemTrayIcon = new KConfigCompilerSignallingItem(innerItemShowSystemTrayIcon, this, notifyFunction, signalShowSystemTrayIconChanged);
  d->itemShowSystemTrayIcon->setWriteFlags(KConfigBase::Notify);
  addItem( d->itemShowSystemTrayIcon, QStringLiteral( "ShowSystemTrayIcon" ) );
  KConfigSkeleton::ItemBool  *innerItemPlayAtStartup;
  innerItemPlayAtStartup = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "PlayAtStartup" ), d->playAtStartup, 
      false
     );
  d->itemPlayAtStartup = new KConfigCompilerSignallingItem(innerItemPlayAtStartup, this, notifyFunction, signalPlayAtStartupChanged);
  d->itemPlayAtStartup->setWriteFlags(KConfigBase::Notify);
  addItem( d->itemPlayAtStartup, QStringLiteral( "PlayAtStartup" ) );
  KConfigSkeleton::ItemBool  *innerItemScanAtStartup;
  innerItemScanAtStartup = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ScanAtStartup" ), d->scanAtStartup, 
      true
     );
  d->itemScanAtStartup = new KConfigCompilerSignallingItem(innerItemScanAtStartup, this, notifyFunction, signalScanAtStartupChanged);
  d->itemScanAtStartup->setWriteFlags(KConfigBase::Notify);
  addItem( d->itemScanAtStartup, QStringLiteral( "ScanAtStartup" ) );
  KConfigSkeleton::ItemBool  *innerItemUseFavoriteStyleRatings;
  innerItemUseFavoriteStyleRatings = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "UseFavoriteStyleRatings" ), d->useFavoriteStyleRatings, 
      false
     );
  d->itemUseFavoriteStyleRatings = new KConfigCompilerSignallingItem(innerItemUseFavoriteStyleRatings, this, notifyFunction, signalUseFavoriteStyleRatingsChanged);
  d->itemUseFavoriteStyleRatings->setWriteFlags(KConfigBase::Notify);
  addItem( d->itemUseFavoriteStyleRatings, QStringLiteral( "UseFavoriteStyleRatings" ) );

  setCurrentGroup( QStringLiteral( "Views" ) );

  QList<KConfigSkeleton::ItemEnum::Choice> valuesEmbeddedView;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("NoView");
    valuesEmbeddedView.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("AllAlbums");
    valuesEmbeddedView.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("AllArtists");
    valuesEmbeddedView.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("AllGenres");
    valuesEmbeddedView.append( choice );
  }
  KConfigSkeleton::ItemEnum  *innerItemEmbeddedView;
  innerItemEmbeddedView = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "EmbeddedView" ), d->embeddedView, valuesEmbeddedView );
  d->itemEmbeddedView = new KConfigCompilerSignallingItem(innerItemEmbeddedView, this, notifyFunction, signalEmbeddedViewChanged);
  d->itemEmbeddedView->setWriteFlags(KConfigBase::Notify);
  addItem( d->itemEmbeddedView, QStringLiteral( "EmbeddedView" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesInitialView;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("ContextView");
    valuesInitialView.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("RecentlyPlayed");
    valuesInitialView.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("FrequentlyPlayed");
    valuesInitialView.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("AllAlbums");
    valuesInitialView.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("AllArtists");
    valuesInitialView.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("AllTracks");
    valuesInitialView.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("AllGenres");
    valuesInitialView.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Files");
    valuesInitialView.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Radios");
    valuesInitialView.append( choice );
  }
  KConfigSkeleton::ItemEnum  *innerItemInitialView;
  innerItemInitialView = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "InitialView" ), d->initialView, valuesInitialView );
  d->itemInitialView = new KConfigCompilerSignallingItem(innerItemInitialView, this, notifyFunction, signalInitialViewChanged);
  d->itemInitialView->setWriteFlags(KConfigBase::Notify);
  addItem( d->itemInitialView, QStringLiteral( "InitialView" ) );
  KConfigSkeleton::ItemString  *innerItemColorScheme;
  innerItemColorScheme = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "ColorScheme" ), d->colorScheme );
  d->itemColorScheme = new KConfigCompilerSignallingItem(innerItemColorScheme, this, notifyFunction, signalColorSchemeChanged);
  d->itemColorScheme->setWriteFlags(KConfigBase::Notify);
  addItem( d->itemColorScheme, QStringLiteral( "ColorScheme" ) );
  KConfigSkeleton::ItemStringList  *innerItemSortRolePreferences;
  innerItemSortRolePreferences = new KConfigSkeleton::ItemStringList( currentGroup(), QStringLiteral( "SortRolePreferences" ), d->sortRolePreferences );
  d->itemSortRolePreferences = new KConfigCompilerSignallingItem(innerItemSortRolePreferences, this, notifyFunction, signalSortRolePreferencesChanged);
  d->itemSortRolePreferences->setWriteFlags(KConfigBase::Notify);
  addItem( d->itemSortRolePreferences, QStringLiteral( "SortRolePreferences" ) );
  KConfigSkeleton::ItemStringList  *innerItemSortOrderPreferences;
  innerItemSortOrderPreferences = new KConfigSkeleton::ItemStringList( currentGroup(), QStringLiteral( "SortOrderPreferences" ), d->sortOrderPreferences );
  d->itemSortOrderPreferences = new KConfigCompilerSignallingItem(innerItemSortOrderPreferences, this, notifyFunction, signalSortOrderPreferencesChanged);
  d->itemSortOrderPreferences->setWriteFlags(KConfigBase::Notify);
  addItem( d->itemSortOrderPreferences, QStringLiteral( "SortOrderPreferences" ) );
}

void ElisaConfiguration::setRootPath( const QStringList & v )
{
    if (v != self()->d->rootPath && !self()->ElisaConfiguration::isRootPathImmutable()) {
      self()->d->rootPath = v;
      Q_EMIT self()->RootPathChanged();
    }
}

QStringList ElisaConfiguration::rootPath()
{
  return self()->d->rootPath;
}

bool  ElisaConfiguration::isRootPathImmutable()
{
    return self()->isImmutable( QStringLiteral( "RootPath" ) );
}


void ElisaConfiguration::setForceUsageOfFastFileSearch( bool v )
{
    if (v != self()->d->forceUsageOfFastFileSearch && !self()->ElisaConfiguration::isForceUsageOfFastFileSearchImmutable()) {
      self()->d->forceUsageOfFastFileSearch = v;
      Q_EMIT self()->ForceUsageOfFastFileSearchChanged();
    }
}

bool ElisaConfiguration::forceUsageOfFastFileSearch()
{
  return self()->d->forceUsageOfFastFileSearch;
}

bool  ElisaConfiguration::isForceUsageOfFastFileSearchImmutable()
{
    return self()->isImmutable( QStringLiteral( "ForceUsageOfFastFileSearch" ) );
}


void ElisaConfiguration::setShowNowPlayingBackground( bool v )
{
    if (v != self()->d->showNowPlayingBackground && !self()->ElisaConfiguration::isShowNowPlayingBackgroundImmutable()) {
      self()->d->showNowPlayingBackground = v;
      Q_EMIT self()->ShowNowPlayingBackgroundChanged();
    }
}

bool ElisaConfiguration::showNowPlayingBackground()
{
  return self()->d->showNowPlayingBackground;
}

bool  ElisaConfiguration::isShowNowPlayingBackgroundImmutable()
{
    return self()->isImmutable( QStringLiteral( "ShowNowPlayingBackground" ) );
}


void ElisaConfiguration::setShowProgressOnTaskBar( bool v )
{
    if (v != self()->d->showProgressOnTaskBar && !self()->ElisaConfiguration::isShowProgressOnTaskBarImmutable()) {
      self()->d->showProgressOnTaskBar = v;
      Q_EMIT self()->ShowProgressOnTaskBarChanged();
    }
}

bool ElisaConfiguration::showProgressOnTaskBar()
{
  return self()->d->showProgressOnTaskBar;
}

bool  ElisaConfiguration::isShowProgressOnTaskBarImmutable()
{
    return self()->isImmutable( QStringLiteral( "ShowProgressOnTaskBar" ) );
}


void ElisaConfiguration::setShowSystemTrayIcon( bool v )
{
    if (v != self()->d->showSystemTrayIcon && !self()->ElisaConfiguration::isShowSystemTrayIconImmutable()) {
      self()->d->showSystemTrayIcon = v;
      Q_EMIT self()->ShowSystemTrayIconChanged();
    }
}

bool ElisaConfiguration::showSystemTrayIcon()
{
  return self()->d->showSystemTrayIcon;
}

bool  ElisaConfiguration::isShowSystemTrayIconImmutable()
{
    return self()->isImmutable( QStringLiteral( "ShowSystemTrayIcon" ) );
}


void ElisaConfiguration::setPlayAtStartup( bool v )
{
    if (v != self()->d->playAtStartup && !self()->ElisaConfiguration::isPlayAtStartupImmutable()) {
      self()->d->playAtStartup = v;
      Q_EMIT self()->PlayAtStartupChanged();
    }
}

bool ElisaConfiguration::playAtStartup()
{
  return self()->d->playAtStartup;
}

bool  ElisaConfiguration::isPlayAtStartupImmutable()
{
    return self()->isImmutable( QStringLiteral( "PlayAtStartup" ) );
}


void ElisaConfiguration::setScanAtStartup( bool v )
{
    if (v != self()->d->scanAtStartup && !self()->ElisaConfiguration::isScanAtStartupImmutable()) {
      self()->d->scanAtStartup = v;
      Q_EMIT self()->ScanAtStartupChanged();
    }
}

bool ElisaConfiguration::scanAtStartup()
{
  return self()->d->scanAtStartup;
}

bool  ElisaConfiguration::isScanAtStartupImmutable()
{
    return self()->isImmutable( QStringLiteral( "ScanAtStartup" ) );
}


void ElisaConfiguration::setUseFavoriteStyleRatings( bool v )
{
    if (v != self()->d->useFavoriteStyleRatings && !self()->ElisaConfiguration::isUseFavoriteStyleRatingsImmutable()) {
      self()->d->useFavoriteStyleRatings = v;
      Q_EMIT self()->UseFavoriteStyleRatingsChanged();
    }
}

bool ElisaConfiguration::useFavoriteStyleRatings()
{
  return self()->d->useFavoriteStyleRatings;
}

bool  ElisaConfiguration::isUseFavoriteStyleRatingsImmutable()
{
    return self()->isImmutable( QStringLiteral( "UseFavoriteStyleRatings" ) );
}


void ElisaConfiguration::setEmbeddedView( int v )
{
    if (v != self()->d->embeddedView && !self()->ElisaConfiguration::isEmbeddedViewImmutable()) {
      self()->d->embeddedView = v;
      Q_EMIT self()->EmbeddedViewChanged();
    }
}

int ElisaConfiguration::embeddedView()
{
  return self()->d->embeddedView;
}

bool  ElisaConfiguration::isEmbeddedViewImmutable()
{
    return self()->isImmutable( QStringLiteral( "EmbeddedView" ) );
}


void ElisaConfiguration::setInitialView( int v )
{
    if (v != self()->d->initialView && !self()->ElisaConfiguration::isInitialViewImmutable()) {
      self()->d->initialView = v;
      Q_EMIT self()->InitialViewChanged();
    }
}

int ElisaConfiguration::initialView()
{
  return self()->d->initialView;
}

bool  ElisaConfiguration::isInitialViewImmutable()
{
    return self()->isImmutable( QStringLiteral( "InitialView" ) );
}


void ElisaConfiguration::setColorScheme( const QString & v )
{
    if (v != self()->d->colorScheme && !self()->ElisaConfiguration::isColorSchemeImmutable()) {
      self()->d->colorScheme = v;
      Q_EMIT self()->ColorSchemeChanged();
    }
}

QString ElisaConfiguration::colorScheme()
{
  return self()->d->colorScheme;
}

bool  ElisaConfiguration::isColorSchemeImmutable()
{
    return self()->isImmutable( QStringLiteral( "ColorScheme" ) );
}


void ElisaConfiguration::setSortRolePreferences( const QStringList & v )
{
    if (v != self()->d->sortRolePreferences && !self()->ElisaConfiguration::isSortRolePreferencesImmutable()) {
      self()->d->sortRolePreferences = v;
      Q_EMIT self()->SortRolePreferencesChanged();
    }
}

QStringList ElisaConfiguration::sortRolePreferences()
{
  return self()->d->sortRolePreferences;
}

bool  ElisaConfiguration::isSortRolePreferencesImmutable()
{
    return self()->isImmutable( QStringLiteral( "SortRolePreferences" ) );
}


void ElisaConfiguration::setSortOrderPreferences( const QStringList & v )
{
    if (v != self()->d->sortOrderPreferences && !self()->ElisaConfiguration::isSortOrderPreferencesImmutable()) {
      self()->d->sortOrderPreferences = v;
      Q_EMIT self()->SortOrderPreferencesChanged();
    }
}

QStringList ElisaConfiguration::sortOrderPreferences()
{
  return self()->d->sortOrderPreferences;
}

bool  ElisaConfiguration::isSortOrderPreferencesImmutable()
{
    return self()->isImmutable( QStringLiteral( "SortOrderPreferences" ) );
}


ElisaConfiguration::~ElisaConfiguration()
{
  delete d;
  if (s_globalElisaConfiguration.exists() && !s_globalElisaConfiguration.isDestroyed()) {
    s_globalElisaConfiguration()->q = nullptr;
  }
}


void ElisaConfiguration::itemChanged(quint64 flags) {

  if ( flags & signalRootPathChanged ) {
    Q_EMIT RootPathChanged();
  }
  if ( flags & signalForceUsageOfFastFileSearchChanged ) {
    Q_EMIT ForceUsageOfFastFileSearchChanged();
  }
  if ( flags & signalShowNowPlayingBackgroundChanged ) {
    Q_EMIT ShowNowPlayingBackgroundChanged();
  }
  if ( flags & signalShowProgressOnTaskBarChanged ) {
    Q_EMIT ShowProgressOnTaskBarChanged();
  }
  if ( flags & signalShowSystemTrayIconChanged ) {
    Q_EMIT ShowSystemTrayIconChanged();
  }
  if ( flags & signalPlayAtStartupChanged ) {
    Q_EMIT PlayAtStartupChanged();
  }
  if ( flags & signalScanAtStartupChanged ) {
    Q_EMIT ScanAtStartupChanged();
  }
  if ( flags & signalUseFavoriteStyleRatingsChanged ) {
    Q_EMIT UseFavoriteStyleRatingsChanged();
  }
  if ( flags & signalEmbeddedViewChanged ) {
    Q_EMIT EmbeddedViewChanged();
  }
  if ( flags & signalInitialViewChanged ) {
    Q_EMIT InitialViewChanged();
  }
  if ( flags & signalColorSchemeChanged ) {
    Q_EMIT ColorSchemeChanged();
  }
  if ( flags & signalSortRolePreferencesChanged ) {
    Q_EMIT SortRolePreferencesChanged();
  }
  if ( flags & signalSortOrderPreferencesChanged ) {
    Q_EMIT SortOrderPreferencesChanged();
  }
}

#include "elisa_settings.moc"

