/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.6.2
 *
 * Copyright (c) 2022 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtGui.h"

#line 26 "/build/pyqt6/src/PyQt6-6.3.1/sip/QtGui/qpolygon.sip"
#include <qpolygon.h>
#line 29 "/build/pyqt6/src/PyQt6-6.3.1/build/QtGui/sipQtGuiQPolygon.cpp"

#line 26 "/build/pyqt6/src/PyQt6-6.3.1/sip/QtCore/qrect.sip"
#include <qrect.h>
#line 33 "/build/pyqt6/src/PyQt6-6.3.1/build/QtGui/sipQtGuiQPolygon.cpp"
#line 28 "/build/pyqt6/src/PyQt6-6.3.1/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 36 "/build/pyqt6/src/PyQt6-6.3.1/build/QtGui/sipQtGuiQPolygon.cpp"
#line 26 "/build/pyqt6/src/PyQt6-6.3.1/sip/QtCore/qpoint.sip"
#include <qpoint.h>
#line 39 "/build/pyqt6/src/PyQt6-6.3.1/build/QtGui/sipQtGuiQPolygon.cpp"
#line 26 "/build/pyqt6/src/PyQt6-6.3.1/sip/QtCore/qvariant.sip"
#include <qvariant.h>
#line 42 "/build/pyqt6/src/PyQt6-6.3.1/build/QtGui/sipQtGuiQPolygon.cpp"
#line 30 "/build/pyqt6/src/PyQt6-6.3.1/sip/QtGui/qtransform.sip"
#include <qtransform.h>
#line 45 "/build/pyqt6/src/PyQt6-6.3.1/build/QtGui/sipQtGuiQPolygon.cpp"
#line 26 "/build/pyqt6/src/PyQt6-6.3.1/sip/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 150 "/build/pyqt6/src/PyQt6-6.3.1/sip/QtCore/qtextstream.sip"
#include <qtextstream.h>
#line 50 "/build/pyqt6/src/PyQt6-6.3.1/build/QtGui/sipQtGuiQPolygon.cpp"


PyDoc_STRVAR(doc_QPolygon_swap, "swap(self, QPolygon)");

extern "C" {static PyObject *meth_QPolygon_swap(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_swap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QPolygon* a0;
         ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QPolygon, &sipCpp, sipType_QPolygon, &a0))
        {
            sipCpp->swap(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_swap, doc_QPolygon_swap);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygon_translate, "translate(self, int, int)\n"
"translate(self, QPoint)");

extern "C" {static PyObject *meth_QPolygon_translate(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_translate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        int a1;
         ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bii", &sipSelf, sipType_QPolygon, &sipCpp, &a0, &a1))
        {
            sipCpp->translate(a0,a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::QPoint* a0;
         ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QPolygon, &sipCpp, sipType_QPoint, &a0))
        {
            sipCpp->translate(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_translate, doc_QPolygon_translate);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygon_translated, "translated(self, int, int) -> QPolygon\n"
"translated(self, QPoint) -> QPolygon");

extern "C" {static PyObject *meth_QPolygon_translated(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_translated(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        int a1;
        const  ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bii", &sipSelf, sipType_QPolygon, &sipCpp, &a0, &a1))
        {
             ::QPolygon*sipRes;

            sipRes = new  ::QPolygon(sipCpp->translated(a0,a1));

            return sipConvertFromNewType(sipRes,sipType_QPolygon,SIP_NULLPTR);
        }
    }

    {
        const  ::QPoint* a0;
        const  ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QPolygon, &sipCpp, sipType_QPoint, &a0))
        {
             ::QPolygon*sipRes;

            sipRes = new  ::QPolygon(sipCpp->translated(*a0));

            return sipConvertFromNewType(sipRes,sipType_QPolygon,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_translated, doc_QPolygon_translated);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygon_boundingRect, "boundingRect(self) -> QRect");

extern "C" {static PyObject *meth_QPolygon_boundingRect(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_boundingRect(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPolygon, &sipCpp))
        {
             ::QRect*sipRes;

            sipRes = new  ::QRect(sipCpp->boundingRect());

            return sipConvertFromNewType(sipRes,sipType_QRect,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_boundingRect, doc_QPolygon_boundingRect);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygon_point, "point(self, int) -> QPoint");

extern "C" {static PyObject *meth_QPolygon_point(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_point(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const  ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QPolygon, &sipCpp, &a0))
        {
             ::QPoint*sipRes;

            sipRes = new  ::QPoint(sipCpp->point(a0));

            return sipConvertFromNewType(sipRes,sipType_QPoint,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_point, doc_QPolygon_point);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygon_setPoint, "setPoint(self, int, int, int)\n"
"setPoint(self, int, QPoint)");

extern "C" {static PyObject *meth_QPolygon_setPoint(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_setPoint(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        int a1;
        int a2;
         ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Biii", &sipSelf, sipType_QPolygon, &sipCpp, &a0, &a1, &a2))
        {
            sipCpp->setPoint(a0,a1,a2);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        int a0;
        const  ::QPoint* a1;
         ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BiJ9", &sipSelf, sipType_QPolygon, &sipCpp, &a0, sipType_QPoint, &a1))
        {
            sipCpp->setPoint(a0,*a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_setPoint, doc_QPolygon_setPoint);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygon_setPoints, "setPoints(self, int, int, *)");

extern "C" {static PyObject *meth_QPolygon_setPoints(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_setPoints(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        int a1;
        PyObject * a2;
         ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BiiW", &sipSelf, sipType_QPolygon, &sipCpp, &a0, &a1, &a2))
        {
#line 68 "/build/pyqt6/src/PyQt6-6.3.1/sip/QtGui/qpolygon.sip"
        // Accept at least one pair of integer coordinates.
        int nPoints = 1 + ((PyTuple_Size(a2) + 1) >> 1);
        
        int *points = new int[nPoints * 2];
        
        points[0] = a0;
        points[1] = a1;
        
        for (Py_ssize_t i = 0; i < PyTuple_Size(a2); ++i)
            points[2 + i] = PyLong_AsLong(PyTuple_GetItem(a2, i));
        
        sipCpp->setPoints(nPoints, points);
        
        delete[] points;
#line 299 "/build/pyqt6/src/PyQt6-6.3.1/build/QtGui/sipQtGuiQPolygon.cpp"

            Py_DECREF(a2);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_setPoints, doc_QPolygon_setPoints);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygon_putPoints, "putPoints(self, int, int, int, *)\n"
"putPoints(self, int, int, QPolygon, from_: int = 0)");

extern "C" {static PyObject *meth_QPolygon_putPoints(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QPolygon_putPoints(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        int a1;
        int a2;
        PyObject * a3;
         ::QPolygon *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "BiiiW", &sipSelf, sipType_QPolygon, &sipCpp, &a0, &a1, &a2, &a3))
        {
#line 86 "/build/pyqt6/src/PyQt6-6.3.1/sip/QtGui/qpolygon.sip"
        // Accept at least one pair of integer coordinates.
        int nPoints = 1 + ((PyTuple_Size(a3) + 1) >> 1);
        
        int *points = new int[nPoints * 2];
        
        points[0] = a1;
        points[1] = a2;
        
        for (Py_ssize_t i = 0; i < PyTuple_Size(a3); ++i)
            points[2 + i] = PyLong_AsLong(PyTuple_GetItem(a3, i));
        
        sipCpp->putPoints(a0, nPoints, points);
        
        delete[] points;
#line 348 "/build/pyqt6/src/PyQt6-6.3.1/build/QtGui/sipQtGuiQPolygon.cpp"

            Py_DECREF(a3);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        int a0;
        int a1;
        const  ::QPolygon* a2;
        int a3 = 0;
         ::QPolygon *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_from,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BiiJ9|i", &sipSelf, sipType_QPolygon, &sipCpp, &a0, &a1, sipType_QPolygon, &a2, &a3))
        {
            sipCpp->putPoints(a0,a1,*a2,a3);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_putPoints, doc_QPolygon_putPoints);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygon_containsPoint, "containsPoint(self, QPoint, Qt.FillRule) -> bool");

extern "C" {static PyObject *meth_QPolygon_containsPoint(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_containsPoint(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPoint* a0;
         ::Qt::FillRule a1;
        const  ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9E", &sipSelf, sipType_QPolygon, &sipCpp, sipType_QPoint, &a0, sipType_Qt_FillRule, &a1))
        {
            bool sipRes;

            sipRes = sipCpp->containsPoint(*a0,a1);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_containsPoint, doc_QPolygon_containsPoint);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygon_united, "united(self, QPolygon) -> QPolygon");

extern "C" {static PyObject *meth_QPolygon_united(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_united(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPolygon* a0;
        const  ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QPolygon, &sipCpp, sipType_QPolygon, &a0))
        {
             ::QPolygon*sipRes;

            sipRes = new  ::QPolygon(sipCpp->united(*a0));

            return sipConvertFromNewType(sipRes,sipType_QPolygon,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_united, doc_QPolygon_united);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygon_intersected, "intersected(self, QPolygon) -> QPolygon");

extern "C" {static PyObject *meth_QPolygon_intersected(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_intersected(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPolygon* a0;
        const  ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QPolygon, &sipCpp, sipType_QPolygon, &a0))
        {
             ::QPolygon*sipRes;

            sipRes = new  ::QPolygon(sipCpp->intersected(*a0));

            return sipConvertFromNewType(sipRes,sipType_QPolygon,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_intersected, doc_QPolygon_intersected);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygon_subtracted, "subtracted(self, QPolygon) -> QPolygon");

extern "C" {static PyObject *meth_QPolygon_subtracted(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_subtracted(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPolygon* a0;
        const  ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QPolygon, &sipCpp, sipType_QPolygon, &a0))
        {
             ::QPolygon*sipRes;

            sipRes = new  ::QPolygon(sipCpp->subtracted(*a0));

            return sipConvertFromNewType(sipRes,sipType_QPolygon,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_subtracted, doc_QPolygon_subtracted);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygon_intersects, "intersects(self, QPolygon) -> bool");

extern "C" {static PyObject *meth_QPolygon_intersects(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_intersects(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPolygon* a0;
        const  ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QPolygon, &sipCpp, sipType_QPolygon, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->intersects(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_intersects, doc_QPolygon_intersects);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygon_append, "append(self, QPoint)");

extern "C" {static PyObject *meth_QPolygon_append(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_append(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPoint* a0;
         ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QPolygon, &sipCpp, sipType_QPoint, &a0))
        {
            sipCpp->append(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_append, doc_QPolygon_append);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygon_at, "at(self, int) -> QPoint");

extern "C" {static PyObject *meth_QPolygon_at(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_at(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const  ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QPolygon, &sipCpp, &a0))
        {
             ::QPoint*sipRes;

            sipRes = new  ::QPoint(sipCpp->at(a0));

            return sipConvertFromNewType(sipRes,sipType_QPoint,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_at, doc_QPolygon_at);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygon_clear, "clear(self)");

extern "C" {static PyObject *meth_QPolygon_clear(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_clear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPolygon, &sipCpp))
        {
            sipCpp->clear();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_clear, doc_QPolygon_clear);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygon_contains, "contains(self, QPoint) -> bool");

extern "C" {static PyObject *meth_QPolygon_contains(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_contains(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPoint* a0;
        const  ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QPolygon, &sipCpp, sipType_QPoint, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->contains(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_contains, doc_QPolygon_contains);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygon_count, "count(self, QPoint) -> int\n"
"count(self) -> int");

extern "C" {static PyObject *meth_QPolygon_count(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_count(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPoint* a0;
        const  ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QPolygon, &sipCpp, sipType_QPoint, &a0))
        {
            int sipRes;

            sipRes = sipCpp->count(*a0);

            return PyLong_FromLong(sipRes);
        }
    }

    {
        const  ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPolygon, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->count();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_count, doc_QPolygon_count);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygon_data, "data(self) -> PyQt6.sip.voidptr");

extern "C" {static PyObject *meth_QPolygon_data(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_data(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPolygon, &sipCpp))
        {
            void*sipRes;

            sipRes = sipCpp->data();

            return sipConvertFromVoidPtr(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_data, doc_QPolygon_data);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygon_fill, "fill(self, QPoint, size: int = -1)");

extern "C" {static PyObject *meth_QPolygon_fill(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QPolygon_fill(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPoint* a0;
        int a1 = -1;
         ::QPolygon *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9|i", &sipSelf, sipType_QPolygon, &sipCpp, sipType_QPoint, &a0, &a1))
        {
            sipCpp->fill(*a0,a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_fill, doc_QPolygon_fill);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygon_first, "first(self) -> QPoint");

extern "C" {static PyObject *meth_QPolygon_first(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_first(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPolygon, &sipCpp))
        {
             ::QPoint*sipRes;

            sipRes = &sipCpp->first();

            return sipConvertFromType(sipRes,sipType_QPoint,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_first, doc_QPolygon_first);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygon_indexOf, "indexOf(self, QPoint, from_: int = 0) -> int");

extern "C" {static PyObject *meth_QPolygon_indexOf(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QPolygon_indexOf(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPoint* a0;
        int a1 = 0;
        const  ::QPolygon *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_from,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9|i", &sipSelf, sipType_QPolygon, &sipCpp, sipType_QPoint, &a0, &a1))
        {
            int sipRes;

            sipRes = sipCpp->indexOf(*a0,a1);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_indexOf, doc_QPolygon_indexOf);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygon_insert, "insert(self, int, QPoint)");

extern "C" {static PyObject *meth_QPolygon_insert(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_insert(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const  ::QPoint* a1;
         ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BiJ9", &sipSelf, sipType_QPolygon, &sipCpp, &a0, sipType_QPoint, &a1))
        {
            sipCpp->insert(a0,*a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_insert, doc_QPolygon_insert);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygon_isEmpty, "isEmpty(self) -> bool");

extern "C" {static PyObject *meth_QPolygon_isEmpty(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_isEmpty(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPolygon, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isEmpty();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_isEmpty, doc_QPolygon_isEmpty);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygon_last, "last(self) -> QPoint");

extern "C" {static PyObject *meth_QPolygon_last(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_last(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPolygon, &sipCpp))
        {
             ::QPoint*sipRes;

            sipRes = &sipCpp->last();

            return sipConvertFromType(sipRes,sipType_QPoint,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_last, doc_QPolygon_last);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygon_lastIndexOf, "lastIndexOf(self, QPoint, from_: int = -1) -> int");

extern "C" {static PyObject *meth_QPolygon_lastIndexOf(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QPolygon_lastIndexOf(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPoint* a0;
        int a1 = -1;
        const  ::QPolygon *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_from,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9|i", &sipSelf, sipType_QPolygon, &sipCpp, sipType_QPoint, &a0, &a1))
        {
            int sipRes;

            sipRes = sipCpp->lastIndexOf(*a0,a1);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_lastIndexOf, doc_QPolygon_lastIndexOf);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygon_mid, "mid(self, int, length: int = -1) -> QPolygon");

extern "C" {static PyObject *meth_QPolygon_mid(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QPolygon_mid(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        int a1 = -1;
        const  ::QPolygon *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_length,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi|i", &sipSelf, sipType_QPolygon, &sipCpp, &a0, &a1))
        {
             ::QPolygon*sipRes;

            sipRes = new  ::QPolygon(sipCpp->mid(a0,a1));

            return sipConvertFromNewType(sipRes,sipType_QPolygon,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_mid, doc_QPolygon_mid);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygon_prepend, "prepend(self, QPoint)");

extern "C" {static PyObject *meth_QPolygon_prepend(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_prepend(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPoint* a0;
         ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QPolygon, &sipCpp, sipType_QPoint, &a0))
        {
            sipCpp->prepend(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_prepend, doc_QPolygon_prepend);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygon_remove, "remove(self, int)\n"
"remove(self, int, int)");

extern "C" {static PyObject *meth_QPolygon_remove(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_remove(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
         ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QPolygon, &sipCpp, &a0))
        {
            sipCpp->remove(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        int a0;
        int a1;
         ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bii", &sipSelf, sipType_QPolygon, &sipCpp, &a0, &a1))
        {
            sipCpp->remove(a0,a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_remove, doc_QPolygon_remove);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygon_replace, "replace(self, int, QPoint)");

extern "C" {static PyObject *meth_QPolygon_replace(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_replace(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const  ::QPoint* a1;
         ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BiJ9", &sipSelf, sipType_QPolygon, &sipCpp, &a0, sipType_QPoint, &a1))
        {
            sipCpp->replace(a0,*a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_replace, doc_QPolygon_replace);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygon_resize, "resize(self, int)");

extern "C" {static PyObject *meth_QPolygon_resize(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_resize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qsizetype a0;
         ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QPolygon, &sipCpp, &a0))
        {
            sipCpp->resize(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_resize, doc_QPolygon_resize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygon_size, "size(self) -> int");

extern "C" {static PyObject *meth_QPolygon_size(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_size(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPolygon, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->size();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_size, doc_QPolygon_size);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygon_value, "value(self, int) -> QPoint\n"
"value(self, int, QPoint) -> QPoint");

extern "C" {static PyObject *meth_QPolygon_value(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_value(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const  ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QPolygon, &sipCpp, &a0))
        {
             ::QPoint*sipRes;

            sipRes = new  ::QPoint(sipCpp->value(a0));

            return sipConvertFromNewType(sipRes,sipType_QPoint,SIP_NULLPTR);
        }
    }

    {
        int a0;
        const  ::QPoint* a1;
        const  ::QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BiJ9", &sipSelf, sipType_QPolygon, &sipCpp, &a0, sipType_QPoint, &a1))
        {
             ::QPoint*sipRes;

            sipRes = new  ::QPoint(sipCpp->value(a0,*a1));

            return sipConvertFromNewType(sipRes,sipType_QPoint,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_value, doc_QPolygon_value);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QPolygon___mul__(PyObject *,PyObject *);}
static PyObject *slot_QPolygon___mul__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPolygon* a0;
        const  ::QTransform* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QPolygon, &a0, sipType_QTransform, &a1))
        {
             ::QPolygon*sipRes;

            sipRes = new  ::QPolygon((*a0 * *a1));

            return sipConvertFromNewType(sipRes,sipType_QPolygon,SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, mul_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static int slot_QPolygon___contains__(PyObject *,PyObject *);}
static int slot_QPolygon___contains__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QPolygon *sipCpp = reinterpret_cast< ::QPolygon *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QPolygon));

    if (!sipCpp)
        return -1;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPoint* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QPoint, &a0))
        {
            int sipRes = 0;

#line 261 "/build/pyqt6/src/PyQt6-6.3.1/sip/QtGui/qpolygon.sip"
sipRes = bool(sipCpp->contains(*a0));
#line 1194 "/build/pyqt6/src/PyQt6-6.3.1/build/QtGui/sipQtGuiQPolygon.cpp"

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName___contains__, SIP_NULLPTR);

    return -1;
}


extern "C" {static int slot_QPolygon___delitem__(PyObject *,PyObject *);}
static int slot_QPolygon___delitem__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QPolygon *sipCpp = reinterpret_cast< ::QPolygon *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QPolygon));

    if (!sipCpp)
        return -1;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1i", &a0))
        {
            int sipIsErr = 0;

#line 215 "/build/pyqt6/src/PyQt6-6.3.1/sip/QtGui/qpolygon.sip"
if ((a0 = (int)sipConvertFromSequenceIndex(a0, sipCpp->count())) < 0)
    sipIsErr = 1;
else
    sipCpp->remove(a0);
#line 1228 "/build/pyqt6/src/PyQt6-6.3.1/build/QtGui/sipQtGuiQPolygon.cpp"

            if (sipIsErr)
                return -1;

            return 0;
        }
    }

    {
        PyObject * a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1T", &PySlice_Type, &a0))
        {
            int sipIsErr = 0;

#line 223 "/build/pyqt6/src/PyQt6-6.3.1/sip/QtGui/qpolygon.sip"
Py_ssize_t start, stop, step, slicelength;

if (sipConvertFromSliceObject(a0, sipCpp->count(), &start, &stop, &step, &slicelength) < 0)
{
    sipIsErr = 1;
}
else
{
    for (Py_ssize_t i = 0; i < slicelength; ++i)
    {
        sipCpp->remove(start);
        start += step - 1;
    }
}
#line 1259 "/build/pyqt6/src/PyQt6-6.3.1/build/QtGui/sipQtGuiQPolygon.cpp"

            if (sipIsErr)
                return -1;

            return 0;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName___delitem__, SIP_NULLPTR);

    return -1;
}


extern "C" {static int slot_QPolygon___setitem__(PyObject *,PyObject *);}
static int slot_QPolygon___setitem__(PyObject *sipSelf,PyObject *sipArgs)
{
     ::QPolygon *sipCpp = reinterpret_cast< ::QPolygon *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QPolygon));

    if (!sipCpp)
        return -1;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const  ::QPoint* a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "iJ9", &a0, sipType_QPoint, &a1))
        {
            int sipIsErr = 0;

#line 172 "/build/pyqt6/src/PyQt6-6.3.1/sip/QtGui/qpolygon.sip"
int len;

len = sipCpp->count();

if ((a0 = (int)sipConvertFromSequenceIndex(a0, len)) < 0)
    sipIsErr = 1;
else
    (*sipCpp)[a0] = *a1;
#line 1301 "/build/pyqt6/src/PyQt6-6.3.1/build/QtGui/sipQtGuiQPolygon.cpp"

            if (sipIsErr)
                return -1;

            return 0;
        }
    }

    {
        PyObject * a0;
        const  ::QPolygon* a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "TJ9", &PySlice_Type, &a0, sipType_QPolygon, &a1))
        {
            int sipIsErr = 0;

#line 184 "/build/pyqt6/src/PyQt6-6.3.1/sip/QtGui/qpolygon.sip"
Py_ssize_t start, stop, step, slicelength;

if (sipConvertFromSliceObject(a0, sipCpp->count(), &start, &stop, &step, &slicelength) < 0)
{
    sipIsErr = 1;
}
else
{
    int vlen = a1->count();

    if (vlen != slicelength)
    {
        sipBadLengthForSlice(vlen, slicelength);
        sipIsErr = 1;
    }
    else
    {
        QList<QPoint>::const_iterator it = a1->begin();

        for (Py_ssize_t i = 0; i < slicelength; ++i)
        {
            (*sipCpp)[start] = *it;
            start += step;
            ++it;
        }
    }
}
#line 1346 "/build/pyqt6/src/PyQt6-6.3.1/build/QtGui/sipQtGuiQPolygon.cpp"

            if (sipIsErr)
                return -1;

            return 0;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName___setitem__, SIP_NULLPTR);

    return -1;
}


extern "C" {static PyObject *slot_QPolygon___getitem__(PyObject *,PyObject *);}
static PyObject *slot_QPolygon___getitem__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QPolygon *sipCpp = reinterpret_cast< ::QPolygon *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QPolygon));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1i", &a0))
        {
             ::QPoint*sipRes = 0;
            int sipIsErr = 0;

#line 160 "/build/pyqt6/src/PyQt6-6.3.1/sip/QtGui/qpolygon.sip"
Py_ssize_t idx = sipConvertFromSequenceIndex(a0, sipCpp->count());

if (idx < 0)
    sipIsErr = 1;
else
    sipRes = &sipCpp->operator[]((int)idx);
#line 1386 "/build/pyqt6/src/PyQt6-6.3.1/build/QtGui/sipQtGuiQPolygon.cpp"

            if (sipIsErr)
                return 0;

            return sipConvertFromType(sipRes,sipType_QPoint,SIP_NULLPTR);
        }
    }

    {
        PyObject * a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1T", &PySlice_Type, &a0))
        {
             ::QPolygon*sipRes = 0;
            int sipIsErr = 0;

#line 241 "/build/pyqt6/src/PyQt6-6.3.1/sip/QtGui/qpolygon.sip"
Py_ssize_t start, stop, step, slicelength;

if (sipConvertFromSliceObject(a0, sipCpp->count(), &start, &stop, &step, &slicelength) < 0)
{
    sipIsErr = 1;
}
else
{
    sipRes = new QPolygon();

    for (Py_ssize_t i = 0; i < slicelength; ++i)
    {
        (*sipRes) += (*sipCpp)[start];
        start += step;
    }
}
#line 1420 "/build/pyqt6/src/PyQt6-6.3.1/build/QtGui/sipQtGuiQPolygon.cpp"

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes,sipType_QPolygon,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygon, sipName___getitem__, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QPolygon___lshift__(PyObject *,PyObject *);}
static PyObject *slot_QPolygon___lshift__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QPolygon* a0;
        const  ::QPoint* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QPolygon, &a0, sipType_QPoint, &a1))
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 152 "/build/pyqt6/src/PyQt6-6.3.1/sip/QtGui/qpolygon.sip"
    *a0 << *a1;

    sipRes = sipArg0;
    Py_INCREF(sipRes);
#line 1453 "/build/pyqt6/src/PyQt6-6.3.1/build/QtGui/sipQtGuiQPolygon.cpp"

            return sipRes;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, lshift_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QPolygon___eq__(PyObject *,PyObject *);}
static PyObject *slot_QPolygon___eq__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QPolygon *sipCpp = reinterpret_cast< ::QPolygon *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QPolygon));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPolygon* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QPolygon, &a0))
        {
            bool sipRes;

            sipRes = sipCpp-> ::QPolygon::operator==(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, eq_slot, sipType_QPolygon, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QPolygon___iadd__(PyObject *,PyObject *);}
static PyObject *slot_QPolygon___iadd__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QPolygon *sipCpp = reinterpret_cast< ::QPolygon *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QPolygon));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPolygon* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QPolygon, &a0))
        {
            sipCpp-> ::QPolygon::operator+=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    {
        const  ::QPoint* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QPoint, &a0))
        {
            sipCpp-> ::QPolygon::operator+=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    /* Raise an exception if the argument couldn't be parsed. */
    sipBadOperatorArg(sipSelf,sipArg,iconcat_slot);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QPolygon___add__(PyObject *,PyObject *);}
static PyObject *slot_QPolygon___add__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QPolygon *sipCpp = reinterpret_cast< ::QPolygon *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QPolygon));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPolygon* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QPolygon, &a0))
        {
             ::QPolygon*sipRes;

            sipRes = new  ::QPolygon(sipCpp-> ::QPolygon::operator+(*a0));

            return sipConvertFromNewType(sipRes,sipType_QPolygon,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the argument couldn't be parsed. */
    sipBadOperatorArg(sipSelf,sipArg,concat_slot);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QPolygon___ne__(PyObject *,PyObject *);}
static PyObject *slot_QPolygon___ne__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QPolygon *sipCpp = reinterpret_cast< ::QPolygon *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QPolygon));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPolygon* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QPolygon, &a0))
        {
            bool sipRes;

            sipRes = sipCpp-> ::QPolygon::operator!=(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, ne_slot, sipType_QPolygon, sipSelf, sipArg);
}


extern "C" {static Py_ssize_t slot_QPolygon___len__(PyObject *);}
static Py_ssize_t slot_QPolygon___len__(PyObject *sipSelf)
{
     ::QPolygon *sipCpp = reinterpret_cast< ::QPolygon *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QPolygon));

    if (!sipCpp)
        return 0;


    {
        {
            Py_ssize_t sipRes = 0;

#line 1 "Auto-generated"
            sipRes = (Py_ssize_t)sipCpp->count();
#line 1618 "/build/pyqt6/src/PyQt6-6.3.1/build/QtGui/sipQtGuiQPolygon.cpp"

            return sipRes;
        }
    }

    return 0;
}


/* Call the instance's destructor. */
extern "C" {static void release_QPolygon(void *, int);}
static void release_QPolygon(void *sipCppV, int)
{
    delete reinterpret_cast< ::QPolygon *>(sipCppV);
}


extern "C" {static PyObject *pickle_QPolygon(void *);}
static PyObject *pickle_QPolygon(void *sipCppV)
{
     ::QPolygon *sipCpp = reinterpret_cast< ::QPolygon *>(sipCppV);
    PyObject *sipRes;

#line 30 "/build/pyqt6/src/PyQt6-6.3.1/sip/QtGui/qpolygon.sip"
    PyObject *pl = PyList_New(sipCpp->count() * 2);
    
    for (int p = 0, i = 0; i < sipCpp->count(); ++i, p += 2)
    {
        int x, y;
    
        sipCpp->point(i, &x, &y);
    
        PyList_SetItem(pl, p, PyLong_FromLong(x));
        PyList_SetItem(pl, p + 1, PyLong_FromLong(y));
    }
    
    sipRes = Py_BuildValue("(N)", pl);
#line 1656 "/build/pyqt6/src/PyQt6-6.3.1/build/QtGui/sipQtGuiQPolygon.cpp"

    return sipRes;
}


extern "C" {static void *array_QPolygon(Py_ssize_t);}
static void *array_QPolygon(Py_ssize_t sipNrElem)
{
    return new  ::QPolygon[sipNrElem];
}


extern "C" {static void array_delete_QPolygon(void *);}
static void array_delete_QPolygon(void *sipCpp)
{
    delete[] reinterpret_cast< ::QPolygon *>(sipCpp);
}


extern "C" {static void assign_QPolygon(void *, Py_ssize_t, void *);}
static void assign_QPolygon(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QPolygon *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QPolygon *>(sipSrc);
}


extern "C" {static void *copy_QPolygon(const void *, Py_ssize_t);}
static void *copy_QPolygon(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new  ::QPolygon(reinterpret_cast<const  ::QPolygon *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QPolygon(sipSimpleWrapper *);}
static void dealloc_QPolygon(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QPolygon(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QPolygon(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QPolygon(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::QPolygon *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new  ::QPolygon();

            return sipCpp;
        }
    }

    {
        const  ::QRect* a0;
        bool a1 = 0;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_closed,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9|b", sipType_QRect, &a0, &a1))
        {
            sipCpp = new  ::QPolygon(*a0,a1);

            return sipCpp;
        }
    }

    {
        const QList< ::QPoint>* a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J1", sipType_QList_0100QPoint, &a0, &a0State))
        {
            sipCpp = new  ::QPolygon(*a0);
            sipReleaseType(const_cast<QList< ::QPoint> *>(a0), sipType_QList_0100QPoint, a0State);

            return sipCpp;
        }
    }

    {
        const  ::QVariant* a0;
        PyObject *a0Wrapper;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "@J1", &a0Wrapper, sipType_QVariant, &a0, &a0State))
        {
            sipErrorState sipError = sipErrorNone;

#line 51 "/build/pyqt6/src/PyQt6-6.3.1/sip/QtGui/qpolygon.sip"
        if (a0->canConvert<QPolygon>())
            sipCpp = new QPolygon(a0->value<QPolygon>());
        else
            sipError = sipBadCallableArg(0, a0Wrapper);
#line 1758 "/build/pyqt6/src/PyQt6-6.3.1/build/QtGui/sipQtGuiQPolygon.cpp"
            sipReleaseType(const_cast< ::QVariant *>(a0), sipType_QVariant, a0State);

            if (sipError == sipErrorNone)
                return sipCpp;

            if (sipUnused)
            {
                Py_XDECREF(*sipUnused);
            }

            sipAddException(sipError, sipParseErr);

            if (sipError == sipErrorFail)
                return SIP_NULLPTR;
        }
    }

    {
        const  ::QPolygon* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QPolygon, &a0))
        {
            sipCpp = new  ::QPolygon(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QPolygon[] = {
    {(void *)slot_QPolygon___mul__, mul_slot},
    {(void *)slot_QPolygon___contains__, contains_slot},
    {(void *)slot_QPolygon___delitem__, delitem_slot},
    {(void *)slot_QPolygon___setitem__, setitem_slot},
    {(void *)slot_QPolygon___getitem__, getitem_slot},
    {(void *)slot_QPolygon___lshift__, lshift_slot},
    {(void *)slot_QPolygon___eq__, eq_slot},
    {(void *)slot_QPolygon___iadd__, iconcat_slot},
    {(void *)slot_QPolygon___add__, concat_slot},
    {(void *)slot_QPolygon___ne__, ne_slot},
    {(void *)slot_QPolygon___len__, len_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QPolygon[] = {
    {sipName_append, meth_QPolygon_append, METH_VARARGS, doc_QPolygon_append},
    {sipName_at, meth_QPolygon_at, METH_VARARGS, doc_QPolygon_at},
    {sipName_boundingRect, meth_QPolygon_boundingRect, METH_VARARGS, doc_QPolygon_boundingRect},
    {sipName_clear, meth_QPolygon_clear, METH_VARARGS, doc_QPolygon_clear},
    {sipName_contains, meth_QPolygon_contains, METH_VARARGS, doc_QPolygon_contains},
    {sipName_containsPoint, meth_QPolygon_containsPoint, METH_VARARGS, doc_QPolygon_containsPoint},
    {sipName_count, meth_QPolygon_count, METH_VARARGS, doc_QPolygon_count},
    {sipName_data, meth_QPolygon_data, METH_VARARGS, doc_QPolygon_data},
    {sipName_fill, SIP_MLMETH_CAST(meth_QPolygon_fill), METH_VARARGS|METH_KEYWORDS, doc_QPolygon_fill},
    {sipName_first, meth_QPolygon_first, METH_VARARGS, doc_QPolygon_first},
    {sipName_indexOf, SIP_MLMETH_CAST(meth_QPolygon_indexOf), METH_VARARGS|METH_KEYWORDS, doc_QPolygon_indexOf},
    {sipName_insert, meth_QPolygon_insert, METH_VARARGS, doc_QPolygon_insert},
    {sipName_intersected, meth_QPolygon_intersected, METH_VARARGS, doc_QPolygon_intersected},
    {sipName_intersects, meth_QPolygon_intersects, METH_VARARGS, doc_QPolygon_intersects},
    {sipName_isEmpty, meth_QPolygon_isEmpty, METH_VARARGS, doc_QPolygon_isEmpty},
    {sipName_last, meth_QPolygon_last, METH_VARARGS, doc_QPolygon_last},
    {sipName_lastIndexOf, SIP_MLMETH_CAST(meth_QPolygon_lastIndexOf), METH_VARARGS|METH_KEYWORDS, doc_QPolygon_lastIndexOf},
    {sipName_mid, SIP_MLMETH_CAST(meth_QPolygon_mid), METH_VARARGS|METH_KEYWORDS, doc_QPolygon_mid},
    {sipName_point, meth_QPolygon_point, METH_VARARGS, doc_QPolygon_point},
    {sipName_prepend, meth_QPolygon_prepend, METH_VARARGS, doc_QPolygon_prepend},
    {sipName_putPoints, SIP_MLMETH_CAST(meth_QPolygon_putPoints), METH_VARARGS|METH_KEYWORDS, doc_QPolygon_putPoints},
    {sipName_remove, meth_QPolygon_remove, METH_VARARGS, doc_QPolygon_remove},
    {sipName_replace, meth_QPolygon_replace, METH_VARARGS, doc_QPolygon_replace},
    {sipName_resize, meth_QPolygon_resize, METH_VARARGS, doc_QPolygon_resize},
    {sipName_setPoint, meth_QPolygon_setPoint, METH_VARARGS, doc_QPolygon_setPoint},
    {sipName_setPoints, meth_QPolygon_setPoints, METH_VARARGS, doc_QPolygon_setPoints},
    {sipName_size, meth_QPolygon_size, METH_VARARGS, doc_QPolygon_size},
    {sipName_subtracted, meth_QPolygon_subtracted, METH_VARARGS, doc_QPolygon_subtracted},
    {sipName_swap, meth_QPolygon_swap, METH_VARARGS, doc_QPolygon_swap},
    {sipName_translate, meth_QPolygon_translate, METH_VARARGS, doc_QPolygon_translate},
    {sipName_translated, meth_QPolygon_translated, METH_VARARGS, doc_QPolygon_translated},
    {sipName_united, meth_QPolygon_united, METH_VARARGS, doc_QPolygon_united},
    {sipName_value, meth_QPolygon_value, METH_VARARGS, doc_QPolygon_value}
};

PyDoc_STRVAR(doc_QPolygon, "\1QPolygon()\n"
"QPolygon(QRect, closed: bool = False)\n"
"QPolygon(Iterable[QPoint])\n"
"QPolygon(Any)\n"
"QPolygon(QPolygon)");


sipClassTypeDef sipTypeDef_QtGui_QPolygon = {
    {
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QPolygon,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_QPolygon,
        {0, 0, 1},
        33, methods_QPolygon,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QPolygon,
    -1,
    sipNameNr_PyQt6_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QPolygon,
    init_type_QPolygon,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QPolygon,
    assign_QPolygon,
    array_QPolygon,
    copy_QPolygon,
    release_QPolygon,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    pickle_QPolygon,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QPolygon,
    sizeof ( ::QPolygon),
};
