// components/performance_manager/public/mojom/coordination_unit.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/performance_manager/public/mojom/coordination_unit.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/performance_manager/public/mojom/coordination_unit.mojom-params-data.h"
#include "components/performance_manager/public/mojom/coordination_unit.mojom-shared-message-ids.h"

#include "components/performance_manager/public/mojom/coordination_unit.mojom-import-headers.h"


#ifndef COMPONENTS_PERFORMANCE_MANAGER_PUBLIC_MOJOM_COORDINATION_UNIT_MOJOM_JUMBO_H_
#define COMPONENTS_PERFORMANCE_MANAGER_PUBLIC_MOJOM_COORDINATION_UNIT_MOJOM_JUMBO_H_
#endif
namespace performance_manager {
namespace mojom {
const char DocumentCoordinationUnit::Name_[] = "performance_manager.mojom.DocumentCoordinationUnit";

class DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ForwardToCallback(
      DocumentCoordinationUnit::OnWebMemoryMeasurementRequestedCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  DocumentCoordinationUnit::OnWebMemoryMeasurementRequestedCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ForwardToCallback);
};

DocumentCoordinationUnitProxy::DocumentCoordinationUnitProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DocumentCoordinationUnitProxy::SetNetworkAlmostIdle(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "performance_manager::mojom::DocumentCoordinationUnit::SetNetworkAlmostIdle");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDocumentCoordinationUnit_SetNetworkAlmostIdle_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::DocumentCoordinationUnit_SetNetworkAlmostIdle_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentCoordinationUnit::Name_);
  message.set_method_name("SetNetworkAlmostIdle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DocumentCoordinationUnitProxy::SetLifecycleState(
    ::performance_manager::mojom::LifecycleState in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "performance_manager::mojom::DocumentCoordinationUnit::SetLifecycleState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type ::performance_manager::mojom::LifecycleState>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDocumentCoordinationUnit_SetLifecycleState_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::DocumentCoordinationUnit_SetLifecycleState_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::performance_manager::mojom::LifecycleState>(
      in_state, &params->state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentCoordinationUnit::Name_);
  message.set_method_name("SetLifecycleState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DocumentCoordinationUnitProxy::SetHasNonEmptyBeforeUnload(
    bool in_has_nonempty_beforeunload) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "performance_manager::mojom::DocumentCoordinationUnit::SetHasNonEmptyBeforeUnload", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_nonempty_beforeunload"), in_has_nonempty_beforeunload,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::DocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_Params_Data> params(
          message);
  params.Allocate();
  params->has_nonempty_beforeunload = in_has_nonempty_beforeunload;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentCoordinationUnit::Name_);
  message.set_method_name("SetHasNonEmptyBeforeUnload");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DocumentCoordinationUnitProxy::SetHadFormInteraction(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "performance_manager::mojom::DocumentCoordinationUnit::SetHadFormInteraction");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDocumentCoordinationUnit_SetHadFormInteraction_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::DocumentCoordinationUnit_SetHadFormInteraction_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentCoordinationUnit::Name_);
  message.set_method_name("SetHadFormInteraction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DocumentCoordinationUnitProxy::SetIsAdFrame(
    bool in_is_ad_frame) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "performance_manager::mojom::DocumentCoordinationUnit::SetIsAdFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_ad_frame"), in_is_ad_frame,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDocumentCoordinationUnit_SetIsAdFrame_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::DocumentCoordinationUnit_SetIsAdFrame_Params_Data> params(
          message);
  params.Allocate();
  params->is_ad_frame = in_is_ad_frame;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentCoordinationUnit::Name_);
  message.set_method_name("SetIsAdFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DocumentCoordinationUnitProxy::OnNonPersistentNotificationCreated(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "performance_manager::mojom::DocumentCoordinationUnit::OnNonPersistentNotificationCreated");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDocumentCoordinationUnit_OnNonPersistentNotificationCreated_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::DocumentCoordinationUnit_OnNonPersistentNotificationCreated_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentCoordinationUnit::Name_);
  message.set_method_name("OnNonPersistentNotificationCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DocumentCoordinationUnitProxy::OnFirstContentfulPaint(
    ::base::TimeDelta in_time_since_navigation_start) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "performance_manager::mojom::DocumentCoordinationUnit::OnFirstContentfulPaint", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("time_since_navigation_start"), in_time_since_navigation_start,
                        "<value of type ::base::TimeDelta>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDocumentCoordinationUnit_OnFirstContentfulPaint_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::DocumentCoordinationUnit_OnFirstContentfulPaint_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->time_since_navigation_start)::BaseType> time_since_navigation_start_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_time_since_navigation_start, time_since_navigation_start_fragment);
  params->time_since_navigation_start.Set(
      time_since_navigation_start_fragment.is_null() ? nullptr : time_since_navigation_start_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->time_since_navigation_start.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null time_since_navigation_start in DocumentCoordinationUnit.OnFirstContentfulPaint request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentCoordinationUnit::Name_);
  message.set_method_name("OnFirstContentfulPaint");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DocumentCoordinationUnitProxy::OnWebMemoryMeasurementRequested(
    ::performance_manager::mojom::WebMemoryMeasurement::Mode in_mode, OnWebMemoryMeasurementRequestedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "performance_manager::mojom::DocumentCoordinationUnit::OnWebMemoryMeasurementRequested", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), in_mode,
                        "<value of type ::performance_manager::mojom::WebMemoryMeasurement::Mode>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDocumentCoordinationUnit_OnWebMemoryMeasurementRequested_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::performance_manager::mojom::WebMemoryMeasurement_Mode>(
      in_mode, &params->mode);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentCoordinationUnit::Name_);
  message.set_method_name("OnWebMemoryMeasurementRequested");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ProxyToResponder {
 public:
  static DocumentCoordinationUnit::OnWebMemoryMeasurementRequestedCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ProxyToResponder> proxy(
        new DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DocumentCoordinationUnit::OnWebMemoryMeasurementRequestedCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::performance_manager::mojom::WebMemoryMeasurementPtr in_measurement);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ProxyToResponder);
};

bool DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "performance_manager::mojom::DocumentCoordinationUnit::OnWebMemoryMeasurementRequestedCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::performance_manager::mojom::WebMemoryMeasurementPtr p_measurement{};
  DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadMeasurement(&p_measurement))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DocumentCoordinationUnit::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_measurement));
  return true;
}

void DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ProxyToResponder::Run(
    ::performance_manager::mojom::WebMemoryMeasurementPtr in_measurement) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)performance_manager::mojom::DocumentCoordinationUnit::OnWebMemoryMeasurementRequestedCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("measurement"), in_measurement,
                        "<value of type ::performance_manager::mojom::WebMemoryMeasurementPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDocumentCoordinationUnit_OnWebMemoryMeasurementRequested_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->measurement)::BaseType> measurement_fragment(
          params.message());
  mojo::internal::Serialize<::performance_manager::mojom::WebMemoryMeasurementDataView>(
      in_measurement, measurement_fragment);
  params->measurement.Set(
      measurement_fragment.is_null() ? nullptr : measurement_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->measurement.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null measurement in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)performance_manager::mojom::DocumentCoordinationUnit::OnWebMemoryMeasurementRequestedCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentCoordinationUnit::Name_);
  message.set_method_name("OnWebMemoryMeasurementRequested");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DocumentCoordinationUnitStubDispatch::Accept(
    DocumentCoordinationUnit* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDocumentCoordinationUnit_SetNetworkAlmostIdle_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)performance_manager::mojom::DocumentCoordinationUnit::SetNetworkAlmostIdle",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)performance_manager::mojom::DocumentCoordinationUnit::SetNetworkAlmostIdle");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DocumentCoordinationUnit_SetNetworkAlmostIdle_Params_Data* params =
          reinterpret_cast<internal::DocumentCoordinationUnit_SetNetworkAlmostIdle_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      DocumentCoordinationUnit_SetNetworkAlmostIdle_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DocumentCoordinationUnit::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNetworkAlmostIdle();
      return true;
    }
    case internal::kDocumentCoordinationUnit_SetLifecycleState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)performance_manager::mojom::DocumentCoordinationUnit::SetLifecycleState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)performance_manager::mojom::DocumentCoordinationUnit::SetLifecycleState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DocumentCoordinationUnit_SetLifecycleState_Params_Data* params =
          reinterpret_cast<internal::DocumentCoordinationUnit_SetLifecycleState_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::performance_manager::mojom::LifecycleState p_state{};
      DocumentCoordinationUnit_SetLifecycleState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DocumentCoordinationUnit::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetLifecycleState(
std::move(p_state));
      return true;
    }
    case internal::kDocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)performance_manager::mojom::DocumentCoordinationUnit::SetHasNonEmptyBeforeUnload",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)performance_manager::mojom::DocumentCoordinationUnit::SetHasNonEmptyBeforeUnload");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_Params_Data* params =
          reinterpret_cast<internal::DocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_has_nonempty_beforeunload{};
      DocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_has_nonempty_beforeunload = input_data_view.has_nonempty_beforeunload();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DocumentCoordinationUnit::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHasNonEmptyBeforeUnload(
std::move(p_has_nonempty_beforeunload));
      return true;
    }
    case internal::kDocumentCoordinationUnit_SetHadFormInteraction_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)performance_manager::mojom::DocumentCoordinationUnit::SetHadFormInteraction",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)performance_manager::mojom::DocumentCoordinationUnit::SetHadFormInteraction");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DocumentCoordinationUnit_SetHadFormInteraction_Params_Data* params =
          reinterpret_cast<internal::DocumentCoordinationUnit_SetHadFormInteraction_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      DocumentCoordinationUnit_SetHadFormInteraction_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DocumentCoordinationUnit::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHadFormInteraction();
      return true;
    }
    case internal::kDocumentCoordinationUnit_SetIsAdFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)performance_manager::mojom::DocumentCoordinationUnit::SetIsAdFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)performance_manager::mojom::DocumentCoordinationUnit::SetIsAdFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DocumentCoordinationUnit_SetIsAdFrame_Params_Data* params =
          reinterpret_cast<internal::DocumentCoordinationUnit_SetIsAdFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_is_ad_frame{};
      DocumentCoordinationUnit_SetIsAdFrame_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_ad_frame = input_data_view.is_ad_frame();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DocumentCoordinationUnit::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIsAdFrame(
std::move(p_is_ad_frame));
      return true;
    }
    case internal::kDocumentCoordinationUnit_OnNonPersistentNotificationCreated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)performance_manager::mojom::DocumentCoordinationUnit::OnNonPersistentNotificationCreated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)performance_manager::mojom::DocumentCoordinationUnit::OnNonPersistentNotificationCreated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DocumentCoordinationUnit_OnNonPersistentNotificationCreated_Params_Data* params =
          reinterpret_cast<internal::DocumentCoordinationUnit_OnNonPersistentNotificationCreated_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      DocumentCoordinationUnit_OnNonPersistentNotificationCreated_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DocumentCoordinationUnit::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNonPersistentNotificationCreated();
      return true;
    }
    case internal::kDocumentCoordinationUnit_OnFirstContentfulPaint_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)performance_manager::mojom::DocumentCoordinationUnit::OnFirstContentfulPaint",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)performance_manager::mojom::DocumentCoordinationUnit::OnFirstContentfulPaint");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DocumentCoordinationUnit_OnFirstContentfulPaint_Params_Data* params =
          reinterpret_cast<internal::DocumentCoordinationUnit_OnFirstContentfulPaint_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::TimeDelta p_time_since_navigation_start{};
      DocumentCoordinationUnit_OnFirstContentfulPaint_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTimeSinceNavigationStart(&p_time_since_navigation_start))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DocumentCoordinationUnit::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFirstContentfulPaint(
std::move(p_time_since_navigation_start));
      return true;
    }
    case internal::kDocumentCoordinationUnit_OnWebMemoryMeasurementRequested_Name: {
      break;
    }
  }
  return false;
}

// static
bool DocumentCoordinationUnitStubDispatch::AcceptWithResponder(
    DocumentCoordinationUnit* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDocumentCoordinationUnit_SetNetworkAlmostIdle_Name: {
      break;
    }
    case internal::kDocumentCoordinationUnit_SetLifecycleState_Name: {
      break;
    }
    case internal::kDocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_Name: {
      break;
    }
    case internal::kDocumentCoordinationUnit_SetHadFormInteraction_Name: {
      break;
    }
    case internal::kDocumentCoordinationUnit_SetIsAdFrame_Name: {
      break;
    }
    case internal::kDocumentCoordinationUnit_OnNonPersistentNotificationCreated_Name: {
      break;
    }
    case internal::kDocumentCoordinationUnit_OnFirstContentfulPaint_Name: {
      break;
    }
    case internal::kDocumentCoordinationUnit_OnWebMemoryMeasurementRequested_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)performance_manager::mojom::DocumentCoordinationUnit::OnWebMemoryMeasurementRequested",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)performance_manager::mojom::DocumentCoordinationUnit::OnWebMemoryMeasurementRequested");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_Params_Data* params =
          reinterpret_cast<
              internal::DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::performance_manager::mojom::WebMemoryMeasurement::Mode p_mode{};
      DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMode(&p_mode))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DocumentCoordinationUnit::Name_, 7, false);
        return false;
      }
      DocumentCoordinationUnit::OnWebMemoryMeasurementRequestedCallback callback =
          DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnWebMemoryMeasurementRequested(
std::move(p_mode), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDocumentCoordinationUnitValidationInfo[] = {
    {internal::kDocumentCoordinationUnit_SetNetworkAlmostIdle_Name,
     {&internal::DocumentCoordinationUnit_SetNetworkAlmostIdle_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDocumentCoordinationUnit_SetLifecycleState_Name,
     {&internal::DocumentCoordinationUnit_SetLifecycleState_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_Name,
     {&internal::DocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDocumentCoordinationUnit_SetHadFormInteraction_Name,
     {&internal::DocumentCoordinationUnit_SetHadFormInteraction_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDocumentCoordinationUnit_SetIsAdFrame_Name,
     {&internal::DocumentCoordinationUnit_SetIsAdFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDocumentCoordinationUnit_OnNonPersistentNotificationCreated_Name,
     {&internal::DocumentCoordinationUnit_OnNonPersistentNotificationCreated_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDocumentCoordinationUnit_OnFirstContentfulPaint_Name,
     {&internal::DocumentCoordinationUnit_OnFirstContentfulPaint_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDocumentCoordinationUnit_OnWebMemoryMeasurementRequested_Name,
     {&internal::DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_Params_Data::Validate,
      &internal::DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ResponseParams_Data::Validate}},
};

bool DocumentCoordinationUnitRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::performance_manager::mojom::DocumentCoordinationUnit::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDocumentCoordinationUnitValidationInfo);
}

bool DocumentCoordinationUnitResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::performance_manager::mojom::DocumentCoordinationUnit::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kDocumentCoordinationUnitValidationInfo);

}
const char ProcessCoordinationUnit::Name_[] = "performance_manager.mojom.ProcessCoordinationUnit";

ProcessCoordinationUnitProxy::ProcessCoordinationUnitProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProcessCoordinationUnitProxy::SetMainThreadTaskLoadIsLow(
    bool in_main_thread_task_load_is_low) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "performance_manager::mojom::ProcessCoordinationUnit::SetMainThreadTaskLoadIsLow", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("main_thread_task_load_is_low"), in_main_thread_task_load_is_low,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::ProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_Params_Data> params(
          message);
  params.Allocate();
  params->main_thread_task_load_is_low = in_main_thread_task_load_is_low;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessCoordinationUnit::Name_);
  message.set_method_name("SetMainThreadTaskLoadIsLow");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ProcessCoordinationUnitProxy::OnV8ContextCreated(
    ::performance_manager::mojom::V8ContextDescriptionPtr in_description, ::performance_manager::mojom::IframeAttributionDataPtr in_iframe_attribution_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "performance_manager::mojom::ProcessCoordinationUnit::OnV8ContextCreated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("description"), in_description,
                        "<value of type ::performance_manager::mojom::V8ContextDescriptionPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("iframe_attribution_data"), in_iframe_attribution_data,
                        "<value of type ::performance_manager::mojom::IframeAttributionDataPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProcessCoordinationUnit_OnV8ContextCreated_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::ProcessCoordinationUnit_OnV8ContextCreated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->description)::BaseType> description_fragment(
          params.message());
  mojo::internal::Serialize<::performance_manager::mojom::V8ContextDescriptionDataView>(
      in_description, description_fragment);
  params->description.Set(
      description_fragment.is_null() ? nullptr : description_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->description.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null description in ProcessCoordinationUnit.OnV8ContextCreated request");
  mojo::internal::MessageFragment<
      typename decltype(params->iframe_attribution_data)::BaseType> iframe_attribution_data_fragment(
          params.message());
  mojo::internal::Serialize<::performance_manager::mojom::IframeAttributionDataDataView>(
      in_iframe_attribution_data, iframe_attribution_data_fragment);
  params->iframe_attribution_data.Set(
      iframe_attribution_data_fragment.is_null() ? nullptr : iframe_attribution_data_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessCoordinationUnit::Name_);
  message.set_method_name("OnV8ContextCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ProcessCoordinationUnitProxy::OnV8ContextDetached(
    const ::blink::V8ContextToken& in_v8_context_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "performance_manager::mojom::ProcessCoordinationUnit::OnV8ContextDetached", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("v8_context_token"), in_v8_context_token,
                        "<value of type const ::blink::V8ContextToken&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProcessCoordinationUnit_OnV8ContextDetached_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::ProcessCoordinationUnit_OnV8ContextDetached_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->v8_context_token)::BaseType> v8_context_token_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::V8ContextTokenDataView>(
      in_v8_context_token, v8_context_token_fragment);
  params->v8_context_token.Set(
      v8_context_token_fragment.is_null() ? nullptr : v8_context_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->v8_context_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null v8_context_token in ProcessCoordinationUnit.OnV8ContextDetached request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessCoordinationUnit::Name_);
  message.set_method_name("OnV8ContextDetached");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ProcessCoordinationUnitProxy::OnV8ContextDestroyed(
    const ::blink::V8ContextToken& in_v8_context_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "performance_manager::mojom::ProcessCoordinationUnit::OnV8ContextDestroyed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("v8_context_token"), in_v8_context_token,
                        "<value of type const ::blink::V8ContextToken&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProcessCoordinationUnit_OnV8ContextDestroyed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::ProcessCoordinationUnit_OnV8ContextDestroyed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->v8_context_token)::BaseType> v8_context_token_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::V8ContextTokenDataView>(
      in_v8_context_token, v8_context_token_fragment);
  params->v8_context_token.Set(
      v8_context_token_fragment.is_null() ? nullptr : v8_context_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->v8_context_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null v8_context_token in ProcessCoordinationUnit.OnV8ContextDestroyed request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessCoordinationUnit::Name_);
  message.set_method_name("OnV8ContextDestroyed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ProcessCoordinationUnitProxy::OnRemoteIframeAttached(
    const ::blink::LocalFrameToken& in_parent_frame_token, const ::blink::RemoteFrameToken& in_remote_frame_token, ::performance_manager::mojom::IframeAttributionDataPtr in_iframe_attribution_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "performance_manager::mojom::ProcessCoordinationUnit::OnRemoteIframeAttached", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("parent_frame_token"), in_parent_frame_token,
                        "<value of type const ::blink::LocalFrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote_frame_token"), in_remote_frame_token,
                        "<value of type const ::blink::RemoteFrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("iframe_attribution_data"), in_iframe_attribution_data,
                        "<value of type ::performance_manager::mojom::IframeAttributionDataPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProcessCoordinationUnit_OnRemoteIframeAttached_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::ProcessCoordinationUnit_OnRemoteIframeAttached_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->parent_frame_token)::BaseType> parent_frame_token_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
      in_parent_frame_token, parent_frame_token_fragment);
  params->parent_frame_token.Set(
      parent_frame_token_fragment.is_null() ? nullptr : parent_frame_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->parent_frame_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null parent_frame_token in ProcessCoordinationUnit.OnRemoteIframeAttached request");
  mojo::internal::MessageFragment<
      typename decltype(params->remote_frame_token)::BaseType> remote_frame_token_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::RemoteFrameTokenDataView>(
      in_remote_frame_token, remote_frame_token_fragment);
  params->remote_frame_token.Set(
      remote_frame_token_fragment.is_null() ? nullptr : remote_frame_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->remote_frame_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null remote_frame_token in ProcessCoordinationUnit.OnRemoteIframeAttached request");
  mojo::internal::MessageFragment<
      typename decltype(params->iframe_attribution_data)::BaseType> iframe_attribution_data_fragment(
          params.message());
  mojo::internal::Serialize<::performance_manager::mojom::IframeAttributionDataDataView>(
      in_iframe_attribution_data, iframe_attribution_data_fragment);
  params->iframe_attribution_data.Set(
      iframe_attribution_data_fragment.is_null() ? nullptr : iframe_attribution_data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->iframe_attribution_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null iframe_attribution_data in ProcessCoordinationUnit.OnRemoteIframeAttached request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessCoordinationUnit::Name_);
  message.set_method_name("OnRemoteIframeAttached");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ProcessCoordinationUnitProxy::OnRemoteIframeDetached(
    const ::blink::LocalFrameToken& in_parent_frame_token, const ::blink::RemoteFrameToken& in_remote_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "performance_manager::mojom::ProcessCoordinationUnit::OnRemoteIframeDetached", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("parent_frame_token"), in_parent_frame_token,
                        "<value of type const ::blink::LocalFrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote_frame_token"), in_remote_frame_token,
                        "<value of type const ::blink::RemoteFrameToken&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProcessCoordinationUnit_OnRemoteIframeDetached_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::ProcessCoordinationUnit_OnRemoteIframeDetached_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->parent_frame_token)::BaseType> parent_frame_token_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
      in_parent_frame_token, parent_frame_token_fragment);
  params->parent_frame_token.Set(
      parent_frame_token_fragment.is_null() ? nullptr : parent_frame_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->parent_frame_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null parent_frame_token in ProcessCoordinationUnit.OnRemoteIframeDetached request");
  mojo::internal::MessageFragment<
      typename decltype(params->remote_frame_token)::BaseType> remote_frame_token_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::RemoteFrameTokenDataView>(
      in_remote_frame_token, remote_frame_token_fragment);
  params->remote_frame_token.Set(
      remote_frame_token_fragment.is_null() ? nullptr : remote_frame_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->remote_frame_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null remote_frame_token in ProcessCoordinationUnit.OnRemoteIframeDetached request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessCoordinationUnit::Name_);
  message.set_method_name("OnRemoteIframeDetached");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ProcessCoordinationUnitProxy::FireBackgroundTracingTrigger(
    const std::string& in_trigger_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "performance_manager::mojom::ProcessCoordinationUnit::FireBackgroundTracingTrigger", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trigger_name"), in_trigger_name,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProcessCoordinationUnit_FireBackgroundTracingTrigger_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::ProcessCoordinationUnit_FireBackgroundTracingTrigger_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->trigger_name)::BaseType> trigger_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_trigger_name, trigger_name_fragment);
  params->trigger_name.Set(
      trigger_name_fragment.is_null() ? nullptr : trigger_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->trigger_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null trigger_name in ProcessCoordinationUnit.FireBackgroundTracingTrigger request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessCoordinationUnit::Name_);
  message.set_method_name("FireBackgroundTracingTrigger");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ProcessCoordinationUnitStubDispatch::Accept(
    ProcessCoordinationUnit* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)performance_manager::mojom::ProcessCoordinationUnit::SetMainThreadTaskLoadIsLow",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)performance_manager::mojom::ProcessCoordinationUnit::SetMainThreadTaskLoadIsLow");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_Params_Data* params =
          reinterpret_cast<internal::ProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_main_thread_task_load_is_low{};
      ProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_main_thread_task_load_is_low = input_data_view.main_thread_task_load_is_low();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProcessCoordinationUnit::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMainThreadTaskLoadIsLow(
std::move(p_main_thread_task_load_is_low));
      return true;
    }
    case internal::kProcessCoordinationUnit_OnV8ContextCreated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)performance_manager::mojom::ProcessCoordinationUnit::OnV8ContextCreated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)performance_manager::mojom::ProcessCoordinationUnit::OnV8ContextCreated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ProcessCoordinationUnit_OnV8ContextCreated_Params_Data* params =
          reinterpret_cast<internal::ProcessCoordinationUnit_OnV8ContextCreated_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::performance_manager::mojom::V8ContextDescriptionPtr p_description{};
      ::performance_manager::mojom::IframeAttributionDataPtr p_iframe_attribution_data{};
      ProcessCoordinationUnit_OnV8ContextCreated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDescription(&p_description))
        success = false;
      if (success && !input_data_view.ReadIframeAttributionData(&p_iframe_attribution_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProcessCoordinationUnit::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnV8ContextCreated(
std::move(p_description), 
std::move(p_iframe_attribution_data));
      return true;
    }
    case internal::kProcessCoordinationUnit_OnV8ContextDetached_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)performance_manager::mojom::ProcessCoordinationUnit::OnV8ContextDetached",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)performance_manager::mojom::ProcessCoordinationUnit::OnV8ContextDetached");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ProcessCoordinationUnit_OnV8ContextDetached_Params_Data* params =
          reinterpret_cast<internal::ProcessCoordinationUnit_OnV8ContextDetached_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::V8ContextToken p_v8_context_token{};
      ProcessCoordinationUnit_OnV8ContextDetached_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadV8ContextToken(&p_v8_context_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProcessCoordinationUnit::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnV8ContextDetached(
std::move(p_v8_context_token));
      return true;
    }
    case internal::kProcessCoordinationUnit_OnV8ContextDestroyed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)performance_manager::mojom::ProcessCoordinationUnit::OnV8ContextDestroyed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)performance_manager::mojom::ProcessCoordinationUnit::OnV8ContextDestroyed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ProcessCoordinationUnit_OnV8ContextDestroyed_Params_Data* params =
          reinterpret_cast<internal::ProcessCoordinationUnit_OnV8ContextDestroyed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::V8ContextToken p_v8_context_token{};
      ProcessCoordinationUnit_OnV8ContextDestroyed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadV8ContextToken(&p_v8_context_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProcessCoordinationUnit::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnV8ContextDestroyed(
std::move(p_v8_context_token));
      return true;
    }
    case internal::kProcessCoordinationUnit_OnRemoteIframeAttached_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)performance_manager::mojom::ProcessCoordinationUnit::OnRemoteIframeAttached",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)performance_manager::mojom::ProcessCoordinationUnit::OnRemoteIframeAttached");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ProcessCoordinationUnit_OnRemoteIframeAttached_Params_Data* params =
          reinterpret_cast<internal::ProcessCoordinationUnit_OnRemoteIframeAttached_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::LocalFrameToken p_parent_frame_token{};
      ::blink::RemoteFrameToken p_remote_frame_token{};
      ::performance_manager::mojom::IframeAttributionDataPtr p_iframe_attribution_data{};
      ProcessCoordinationUnit_OnRemoteIframeAttached_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParentFrameToken(&p_parent_frame_token))
        success = false;
      if (success && !input_data_view.ReadRemoteFrameToken(&p_remote_frame_token))
        success = false;
      if (success && !input_data_view.ReadIframeAttributionData(&p_iframe_attribution_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProcessCoordinationUnit::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnRemoteIframeAttached(
std::move(p_parent_frame_token), 
std::move(p_remote_frame_token), 
std::move(p_iframe_attribution_data));
      return true;
    }
    case internal::kProcessCoordinationUnit_OnRemoteIframeDetached_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)performance_manager::mojom::ProcessCoordinationUnit::OnRemoteIframeDetached",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)performance_manager::mojom::ProcessCoordinationUnit::OnRemoteIframeDetached");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ProcessCoordinationUnit_OnRemoteIframeDetached_Params_Data* params =
          reinterpret_cast<internal::ProcessCoordinationUnit_OnRemoteIframeDetached_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::LocalFrameToken p_parent_frame_token{};
      ::blink::RemoteFrameToken p_remote_frame_token{};
      ProcessCoordinationUnit_OnRemoteIframeDetached_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParentFrameToken(&p_parent_frame_token))
        success = false;
      if (success && !input_data_view.ReadRemoteFrameToken(&p_remote_frame_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProcessCoordinationUnit::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnRemoteIframeDetached(
std::move(p_parent_frame_token), 
std::move(p_remote_frame_token));
      return true;
    }
    case internal::kProcessCoordinationUnit_FireBackgroundTracingTrigger_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)performance_manager::mojom::ProcessCoordinationUnit::FireBackgroundTracingTrigger",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)performance_manager::mojom::ProcessCoordinationUnit::FireBackgroundTracingTrigger");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ProcessCoordinationUnit_FireBackgroundTracingTrigger_Params_Data* params =
          reinterpret_cast<internal::ProcessCoordinationUnit_FireBackgroundTracingTrigger_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_trigger_name{};
      ProcessCoordinationUnit_FireBackgroundTracingTrigger_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTriggerName(&p_trigger_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProcessCoordinationUnit::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FireBackgroundTracingTrigger(
std::move(p_trigger_name));
      return true;
    }
  }
  return false;
}

// static
bool ProcessCoordinationUnitStubDispatch::AcceptWithResponder(
    ProcessCoordinationUnit* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_Name: {
      break;
    }
    case internal::kProcessCoordinationUnit_OnV8ContextCreated_Name: {
      break;
    }
    case internal::kProcessCoordinationUnit_OnV8ContextDetached_Name: {
      break;
    }
    case internal::kProcessCoordinationUnit_OnV8ContextDestroyed_Name: {
      break;
    }
    case internal::kProcessCoordinationUnit_OnRemoteIframeAttached_Name: {
      break;
    }
    case internal::kProcessCoordinationUnit_OnRemoteIframeDetached_Name: {
      break;
    }
    case internal::kProcessCoordinationUnit_FireBackgroundTracingTrigger_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kProcessCoordinationUnitValidationInfo[] = {
    {internal::kProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_Name,
     {&internal::ProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kProcessCoordinationUnit_OnV8ContextCreated_Name,
     {&internal::ProcessCoordinationUnit_OnV8ContextCreated_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kProcessCoordinationUnit_OnV8ContextDetached_Name,
     {&internal::ProcessCoordinationUnit_OnV8ContextDetached_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kProcessCoordinationUnit_OnV8ContextDestroyed_Name,
     {&internal::ProcessCoordinationUnit_OnV8ContextDestroyed_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kProcessCoordinationUnit_OnRemoteIframeAttached_Name,
     {&internal::ProcessCoordinationUnit_OnRemoteIframeAttached_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kProcessCoordinationUnit_OnRemoteIframeDetached_Name,
     {&internal::ProcessCoordinationUnit_OnRemoteIframeDetached_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kProcessCoordinationUnit_FireBackgroundTracingTrigger_Name,
     {&internal::ProcessCoordinationUnit_FireBackgroundTracingTrigger_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ProcessCoordinationUnitRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::performance_manager::mojom::ProcessCoordinationUnit::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kProcessCoordinationUnitValidationInfo);
}

}  // namespace mojom
}  // namespace performance_manager

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif