// components/printing/common/print.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "components/printing/common/print.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "printing/mojom/print.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom.h"


#ifndef COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_JUMBO_H_
#define COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_JUMBO_H_
#endif


namespace printing {
namespace mojom {


void PrintRendererInterceptorForTesting::CreatePreviewDocument(::base::Value job_settings, CreatePreviewDocumentCallback callback) {
  GetForwardingInterface()->CreatePreviewDocument(std::move(job_settings), std::move(callback));
}
PrintRendererAsyncWaiter::PrintRendererAsyncWaiter(
    PrintRenderer* proxy) : proxy_(proxy) {}

PrintRendererAsyncWaiter::~PrintRendererAsyncWaiter() = default;

void PrintRendererAsyncWaiter::CreatePreviewDocument(
    ::base::Value job_settings, ::base::ReadOnlySharedMemoryRegion* out_preview_document_region) {
  base::RunLoop loop;
  proxy_->CreatePreviewDocument(std::move(job_settings),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::ReadOnlySharedMemoryRegion* out_preview_document_region
,
             ::base::ReadOnlySharedMemoryRegion preview_document_region) {*out_preview_document_region = std::move(preview_document_region);
            loop->Quit();
          },
          &loop,
          out_preview_document_region));
  loop.Run();
}



void PrintPreviewUIInterceptorForTesting::SetOptionsFromDocument(OptionsFromDocumentParamsPtr params, int32_t request_id) {
  GetForwardingInterface()->SetOptionsFromDocument(std::move(params), std::move(request_id));
}
void PrintPreviewUIInterceptorForTesting::DidPrepareDocumentForPreview(int32_t document_cookie, int32_t request_id) {
  GetForwardingInterface()->DidPrepareDocumentForPreview(std::move(document_cookie), std::move(request_id));
}
void PrintPreviewUIInterceptorForTesting::DidPreviewPage(DidPreviewPageParamsPtr params, int32_t request_id) {
  GetForwardingInterface()->DidPreviewPage(std::move(params), std::move(request_id));
}
void PrintPreviewUIInterceptorForTesting::MetafileReadyForPrinting(DidPreviewDocumentParamsPtr params, int32_t request_id) {
  GetForwardingInterface()->MetafileReadyForPrinting(std::move(params), std::move(request_id));
}
void PrintPreviewUIInterceptorForTesting::PrintPreviewFailed(int32_t document_cookie, int32_t request_id) {
  GetForwardingInterface()->PrintPreviewFailed(std::move(document_cookie), std::move(request_id));
}
void PrintPreviewUIInterceptorForTesting::PrintPreviewCancelled(int32_t document_cookie, int32_t request_id) {
  GetForwardingInterface()->PrintPreviewCancelled(std::move(document_cookie), std::move(request_id));
}
void PrintPreviewUIInterceptorForTesting::PrinterSettingsInvalid(int32_t document_cookie, int32_t request_id) {
  GetForwardingInterface()->PrinterSettingsInvalid(std::move(document_cookie), std::move(request_id));
}
void PrintPreviewUIInterceptorForTesting::DidGetDefaultPageLayout(::printing::mojom::PageSizeMarginsPtr page_layout_in_points, const ::gfx::Rect& printable_area_in_points, bool has_custom_page_size_style, int32_t request_id) {
  GetForwardingInterface()->DidGetDefaultPageLayout(std::move(page_layout_in_points), std::move(printable_area_in_points), std::move(has_custom_page_size_style), std::move(request_id));
}
void PrintPreviewUIInterceptorForTesting::DidStartPreview(DidStartPreviewParamsPtr params, int32_t request_id) {
  GetForwardingInterface()->DidStartPreview(std::move(params), std::move(request_id));
}
PrintPreviewUIAsyncWaiter::PrintPreviewUIAsyncWaiter(
    PrintPreviewUI* proxy) : proxy_(proxy) {}

PrintPreviewUIAsyncWaiter::~PrintPreviewUIAsyncWaiter() = default;




void PrintRenderFrameInterceptorForTesting::PrintRequestedPages() {
  GetForwardingInterface()->PrintRequestedPages();
}
void PrintRenderFrameInterceptorForTesting::PrintForSystemDialog() {
  GetForwardingInterface()->PrintForSystemDialog();
}
void PrintRenderFrameInterceptorForTesting::InitiatePrintPreview(::mojo::PendingAssociatedRemote<PrintRenderer> print_renderer, bool has_selection) {
  GetForwardingInterface()->InitiatePrintPreview(std::move(print_renderer), std::move(has_selection));
}
void PrintRenderFrameInterceptorForTesting::SetPrintPreviewUI(::mojo::PendingAssociatedRemote<PrintPreviewUI> preview) {
  GetForwardingInterface()->SetPrintPreviewUI(std::move(preview));
}
void PrintRenderFrameInterceptorForTesting::PrintPreview(::base::Value settings) {
  GetForwardingInterface()->PrintPreview(std::move(settings));
}
void PrintRenderFrameInterceptorForTesting::OnPrintPreviewDialogClosed() {
  GetForwardingInterface()->OnPrintPreviewDialogClosed();
}
void PrintRenderFrameInterceptorForTesting::PrintFrameContent(PrintFrameContentParamsPtr params, PrintFrameContentCallback callback) {
  GetForwardingInterface()->PrintFrameContent(std::move(params), std::move(callback));
}
void PrintRenderFrameInterceptorForTesting::SetPrintingEnabled(bool enabled) {
  GetForwardingInterface()->SetPrintingEnabled(std::move(enabled));
}
void PrintRenderFrameInterceptorForTesting::PrintingDone(bool success) {
  GetForwardingInterface()->PrintingDone(std::move(success));
}
void PrintRenderFrameInterceptorForTesting::PrintNodeUnderContextMenu() {
  GetForwardingInterface()->PrintNodeUnderContextMenu();
}
PrintRenderFrameAsyncWaiter::PrintRenderFrameAsyncWaiter(
    PrintRenderFrame* proxy) : proxy_(proxy) {}

PrintRenderFrameAsyncWaiter::~PrintRenderFrameAsyncWaiter() = default;

void PrintRenderFrameAsyncWaiter::PrintFrameContent(
    PrintFrameContentParamsPtr params, int32_t* out_document_cookie, DidPrintContentParamsPtr* out_params) {
  base::RunLoop loop;
  proxy_->PrintFrameContent(std::move(params),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_document_cookie
,
             DidPrintContentParamsPtr* out_params
,
             int32_t document_cookie,
             DidPrintContentParamsPtr params) {*out_document_cookie = std::move(document_cookie);*out_params = std::move(params);
            loop->Quit();
          },
          &loop,
          out_document_cookie,
          out_params));
  loop.Run();
}



void PrintManagerHostInterceptorForTesting::DidGetPrintedPagesCount(int32_t cookie, uint32_t number_pages) {
  GetForwardingInterface()->DidGetPrintedPagesCount(std::move(cookie), std::move(number_pages));
}
void PrintManagerHostInterceptorForTesting::GetDefaultPrintSettings(GetDefaultPrintSettingsCallback callback) {
  GetForwardingInterface()->GetDefaultPrintSettings(std::move(callback));
}
void PrintManagerHostInterceptorForTesting::DidShowPrintDialog() {
  GetForwardingInterface()->DidShowPrintDialog();
}
void PrintManagerHostInterceptorForTesting::DidPrintDocument(DidPrintDocumentParamsPtr params, DidPrintDocumentCallback callback) {
  GetForwardingInterface()->DidPrintDocument(std::move(params), std::move(callback));
}
void PrintManagerHostInterceptorForTesting::ScriptedPrint(ScriptedPrintParamsPtr params, ScriptedPrintCallback callback) {
  GetForwardingInterface()->ScriptedPrint(std::move(params), std::move(callback));
}
void PrintManagerHostInterceptorForTesting::ShowInvalidPrinterSettingsError() {
  GetForwardingInterface()->ShowInvalidPrinterSettingsError();
}
void PrintManagerHostInterceptorForTesting::PrintingFailed(int32_t cookie) {
  GetForwardingInterface()->PrintingFailed(std::move(cookie));
}
void PrintManagerHostInterceptorForTesting::UpdatePrintSettings(int32_t cookie, ::base::Value job_settings, UpdatePrintSettingsCallback callback) {
  GetForwardingInterface()->UpdatePrintSettings(std::move(cookie), std::move(job_settings), std::move(callback));
}
void PrintManagerHostInterceptorForTesting::SetupScriptedPrintPreview(SetupScriptedPrintPreviewCallback callback) {
  GetForwardingInterface()->SetupScriptedPrintPreview(std::move(callback));
}
void PrintManagerHostInterceptorForTesting::ShowScriptedPrintPreview(bool is_modifiable) {
  GetForwardingInterface()->ShowScriptedPrintPreview(std::move(is_modifiable));
}
void PrintManagerHostInterceptorForTesting::RequestPrintPreview(RequestPrintPreviewParamsPtr params) {
  GetForwardingInterface()->RequestPrintPreview(std::move(params));
}
void PrintManagerHostInterceptorForTesting::CheckForCancel(int32_t preview_ui_id, int32_t request_id, CheckForCancelCallback callback) {
  GetForwardingInterface()->CheckForCancel(std::move(preview_ui_id), std::move(request_id), std::move(callback));
}
void PrintManagerHostInterceptorForTesting::MetafileReadyForPrinting(DidPreviewDocumentParamsPtr params, int32_t request_id) {
  GetForwardingInterface()->MetafileReadyForPrinting(std::move(params), std::move(request_id));
}
void PrintManagerHostInterceptorForTesting::SetAccessibilityTree(int32_t cookie, const ::ui::AXTreeUpdate& accessibility_tree) {
  GetForwardingInterface()->SetAccessibilityTree(std::move(cookie), std::move(accessibility_tree));
}
PrintManagerHostAsyncWaiter::PrintManagerHostAsyncWaiter(
    PrintManagerHost* proxy) : proxy_(proxy) {}

PrintManagerHostAsyncWaiter::~PrintManagerHostAsyncWaiter() = default;

void PrintManagerHostAsyncWaiter::GetDefaultPrintSettings(
    PrintParamsPtr* out_default_settings) {
  base::RunLoop loop;
  proxy_->GetDefaultPrintSettings(
      base::BindOnce(
          [](base::RunLoop* loop,
             PrintParamsPtr* out_default_settings
,
             PrintParamsPtr default_settings) {*out_default_settings = std::move(default_settings);
            loop->Quit();
          },
          &loop,
          out_default_settings));
  loop.Run();
}
void PrintManagerHostAsyncWaiter::DidPrintDocument(
    DidPrintDocumentParamsPtr params, bool* out_completed) {
  base::RunLoop loop;
  proxy_->DidPrintDocument(std::move(params),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_completed
,
             bool completed) {*out_completed = std::move(completed);
            loop->Quit();
          },
          &loop,
          out_completed));
  loop.Run();
}
void PrintManagerHostAsyncWaiter::ScriptedPrint(
    ScriptedPrintParamsPtr params, PrintPagesParamsPtr* out_settings) {
  base::RunLoop loop;
  proxy_->ScriptedPrint(std::move(params),
      base::BindOnce(
          [](base::RunLoop* loop,
             PrintPagesParamsPtr* out_settings
,
             PrintPagesParamsPtr settings) {*out_settings = std::move(settings);
            loop->Quit();
          },
          &loop,
          out_settings));
  loop.Run();
}
void PrintManagerHostAsyncWaiter::UpdatePrintSettings(
    int32_t cookie, ::base::Value job_settings, PrintPagesParamsPtr* out_current_settings, bool* out_canceled) {
  base::RunLoop loop;
  proxy_->UpdatePrintSettings(std::move(cookie),std::move(job_settings),
      base::BindOnce(
          [](base::RunLoop* loop,
             PrintPagesParamsPtr* out_current_settings
,
             bool* out_canceled
,
             PrintPagesParamsPtr current_settings,
             bool canceled) {*out_current_settings = std::move(current_settings);*out_canceled = std::move(canceled);
            loop->Quit();
          },
          &loop,
          out_current_settings,
          out_canceled));
  loop.Run();
}
void PrintManagerHostAsyncWaiter::SetupScriptedPrintPreview(
    ) {
  base::RunLoop loop;
  proxy_->SetupScriptedPrintPreview(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void PrintManagerHostAsyncWaiter::CheckForCancel(
    int32_t preview_ui_id, int32_t request_id, bool* out_cancel) {
  base::RunLoop loop;
  proxy_->CheckForCancel(std::move(preview_ui_id),std::move(request_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_cancel
,
             bool cancel) {*out_cancel = std::move(cancel);
            loop->Quit();
          },
          &loop,
          out_cancel));
  loop.Run();
}





}  // namespace mojom
}  // namespace printing

#if defined(__clang__)
#pragma clang diagnostic pop
#endif