// components/printing/common/print.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/printing/common/print.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/printing/common/print.mojom-params-data.h"
#include "components/printing/common/print.mojom-shared-message-ids.h"

#include "components/printing/common/print.mojom-import-headers.h"


#ifndef COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_JUMBO_H_
#define COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_JUMBO_H_
#endif
namespace printing {
namespace mojom {
PreviewIds::PreviewIds()
    : request_id(-1),
      ui_id(-1) {}

PreviewIds::PreviewIds(
    int32_t request_id_in,
    int32_t ui_id_in)
    : request_id(std::move(request_id_in)),
      ui_id(std::move(ui_id_in)) {}

PreviewIds::~PreviewIds() = default;
size_t PreviewIds::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->request_id);
  seed = mojo::internal::Hash(seed, this->ui_id);
  return seed;
}

void PreviewIds::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_id"), this->request_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ui_id"), this->ui_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PreviewIds::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RequestPrintPreviewParams::RequestPrintPreviewParams()
    : is_from_arc(false),
      is_modifiable(false),
      webnode_only(false),
      has_selection(false),
      selection_only(false) {}

RequestPrintPreviewParams::RequestPrintPreviewParams(
    bool is_from_arc_in,
    bool is_modifiable_in,
    bool webnode_only_in,
    bool has_selection_in,
    bool selection_only_in)
    : is_from_arc(std::move(is_from_arc_in)),
      is_modifiable(std::move(is_modifiable_in)),
      webnode_only(std::move(webnode_only_in)),
      has_selection(std::move(has_selection_in)),
      selection_only(std::move(selection_only_in)) {}

RequestPrintPreviewParams::~RequestPrintPreviewParams() = default;
size_t RequestPrintPreviewParams::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->is_from_arc);
  seed = mojo::internal::Hash(seed, this->is_modifiable);
  seed = mojo::internal::Hash(seed, this->webnode_only);
  seed = mojo::internal::Hash(seed, this->has_selection);
  seed = mojo::internal::Hash(seed, this->selection_only);
  return seed;
}

void RequestPrintPreviewParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_from_arc"), this->is_from_arc,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_modifiable"), this->is_modifiable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "webnode_only"), this->webnode_only,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_selection"), this->has_selection,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selection_only"), this->selection_only,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RequestPrintPreviewParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PrintFrameContentParams::PrintFrameContentParams()
    : printable_area(),
      document_cookie() {}

PrintFrameContentParams::PrintFrameContentParams(
    const ::gfx::Rect& printable_area_in,
    int32_t document_cookie_in)
    : printable_area(std::move(printable_area_in)),
      document_cookie(std::move(document_cookie_in)) {}

PrintFrameContentParams::~PrintFrameContentParams() = default;

void PrintFrameContentParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "printable_area"), this->printable_area,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "document_cookie"), this->document_cookie,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PrintFrameContentParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
OptionsFromDocumentParams::OptionsFromDocumentParams()
    : is_scaling_disabled(),
      copies(),
      duplex() {}

OptionsFromDocumentParams::OptionsFromDocumentParams(
    bool is_scaling_disabled_in,
    int32_t copies_in,
    ::printing::mojom::DuplexMode duplex_in)
    : is_scaling_disabled(std::move(is_scaling_disabled_in)),
      copies(std::move(copies_in)),
      duplex(std::move(duplex_in)) {}

OptionsFromDocumentParams::~OptionsFromDocumentParams() = default;
size_t OptionsFromDocumentParams::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->is_scaling_disabled);
  seed = mojo::internal::Hash(seed, this->copies);
  seed = mojo::internal::Hash(seed, this->duplex);
  return seed;
}

void OptionsFromDocumentParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_scaling_disabled"), this->is_scaling_disabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "copies"), this->copies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "duplex"), this->duplex,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::printing::mojom::DuplexMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool OptionsFromDocumentParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DidPrintContentParams::DidPrintContentParams()
    : metafile_data_region(),
      subframe_content_info() {}

DidPrintContentParams::DidPrintContentParams(
    ::base::ReadOnlySharedMemoryRegion metafile_data_region_in,
    const base::flat_map<uint32_t, ::base::UnguessableToken>& subframe_content_info_in)
    : metafile_data_region(std::move(metafile_data_region_in)),
      subframe_content_info(std::move(subframe_content_info_in)) {}

DidPrintContentParams::~DidPrintContentParams() = default;

void DidPrintContentParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "metafile_data_region"), this->metafile_data_region,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::ReadOnlySharedMemoryRegion>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subframe_content_info"), this->subframe_content_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<uint32_t, ::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DidPrintContentParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DidStartPreviewParams::DidStartPreviewParams()
    : page_count(),
      pages_to_render(),
      pages_per_sheet(),
      page_size(),
      fit_to_page_scaling() {}

DidStartPreviewParams::DidStartPreviewParams(
    uint32_t page_count_in,
    std::vector<uint32_t> pages_to_render_in,
    int32_t pages_per_sheet_in,
    const ::gfx::Size& page_size_in,
    int32_t fit_to_page_scaling_in)
    : page_count(std::move(page_count_in)),
      pages_to_render(std::move(pages_to_render_in)),
      pages_per_sheet(std::move(pages_per_sheet_in)),
      page_size(std::move(page_size_in)),
      fit_to_page_scaling(std::move(fit_to_page_scaling_in)) {}

DidStartPreviewParams::~DidStartPreviewParams() = default;

void DidStartPreviewParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_count"), this->page_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pages_to_render"), this->pages_to_render,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pages_per_sheet"), this->pages_per_sheet,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_size"), this->page_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fit_to_page_scaling"), this->fit_to_page_scaling,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DidStartPreviewParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DidPreviewPageParams::DidPreviewPageParams()
    : content(),
      page_number(),
      document_cookie() {}

DidPreviewPageParams::DidPreviewPageParams(
    DidPrintContentParamsPtr content_in,
    uint32_t page_number_in,
    int32_t document_cookie_in)
    : content(std::move(content_in)),
      page_number(std::move(page_number_in)),
      document_cookie(std::move(document_cookie_in)) {}

DidPreviewPageParams::~DidPreviewPageParams() = default;

void DidPreviewPageParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content"), this->content,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DidPrintContentParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_number"), this->page_number,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "document_cookie"), this->document_cookie,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DidPreviewPageParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DidPreviewDocumentParams::DidPreviewDocumentParams()
    : content(),
      document_cookie(),
      expected_pages_count() {}

DidPreviewDocumentParams::DidPreviewDocumentParams(
    DidPrintContentParamsPtr content_in,
    int32_t document_cookie_in,
    uint32_t expected_pages_count_in)
    : content(std::move(content_in)),
      document_cookie(std::move(document_cookie_in)),
      expected_pages_count(std::move(expected_pages_count_in)) {}

DidPreviewDocumentParams::~DidPreviewDocumentParams() = default;

void DidPreviewDocumentParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content"), this->content,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DidPrintContentParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "document_cookie"), this->document_cookie,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expected_pages_count"), this->expected_pages_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DidPreviewDocumentParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PrintParams::PrintParams()
    : page_size(),
      content_size(),
      printable_area(),
      margin_top(0),
      margin_left(0),
      page_orientation(::printing::mojom::PageOrientation::kUpright),
      dpi(),
      scale_factor(1.0),
      document_cookie(0),
      selection_only(false),
      supports_alpha_blend(false),
      preview_ui_id(-1),
      preview_request_id(0),
      is_first_request(false),
      print_scaling_option(::printing::mojom::PrintScalingOption::kSourceSize),
      print_to_pdf(false),
      display_header_footer(false),
      title(),
      url(),
      header_template(),
      footer_template(),
      rasterize_pdf(false),
      rasterize_pdf_dpi(0),
      should_print_backgrounds(false),
      printed_doc_type(::printing::mojom::SkiaDocumentType::kPDF),
      prefer_css_page_size(false),
      pages_per_sheet(1U) {}

PrintParams::PrintParams(
    const ::gfx::Size& page_size_in,
    const ::gfx::Size& content_size_in,
    const ::gfx::Rect& printable_area_in,
    int32_t margin_top_in,
    int32_t margin_left_in,
    ::printing::mojom::PageOrientation page_orientation_in,
    const ::gfx::Size& dpi_in,
    double scale_factor_in,
    int32_t document_cookie_in,
    bool selection_only_in,
    bool supports_alpha_blend_in,
    int32_t preview_ui_id_in,
    int32_t preview_request_id_in,
    bool is_first_request_in,
    ::printing::mojom::PrintScalingOption print_scaling_option_in,
    bool print_to_pdf_in,
    bool display_header_footer_in,
    const ::std::u16string& title_in,
    const ::std::u16string& url_in,
    const ::std::u16string& header_template_in,
    const ::std::u16string& footer_template_in,
    bool rasterize_pdf_in,
    int32_t rasterize_pdf_dpi_in,
    bool should_print_backgrounds_in,
    ::printing::mojom::SkiaDocumentType printed_doc_type_in,
    bool prefer_css_page_size_in,
    uint32_t pages_per_sheet_in)
    : page_size(std::move(page_size_in)),
      content_size(std::move(content_size_in)),
      printable_area(std::move(printable_area_in)),
      margin_top(std::move(margin_top_in)),
      margin_left(std::move(margin_left_in)),
      page_orientation(std::move(page_orientation_in)),
      dpi(std::move(dpi_in)),
      scale_factor(std::move(scale_factor_in)),
      document_cookie(std::move(document_cookie_in)),
      selection_only(std::move(selection_only_in)),
      supports_alpha_blend(std::move(supports_alpha_blend_in)),
      preview_ui_id(std::move(preview_ui_id_in)),
      preview_request_id(std::move(preview_request_id_in)),
      is_first_request(std::move(is_first_request_in)),
      print_scaling_option(std::move(print_scaling_option_in)),
      print_to_pdf(std::move(print_to_pdf_in)),
      display_header_footer(std::move(display_header_footer_in)),
      title(std::move(title_in)),
      url(std::move(url_in)),
      header_template(std::move(header_template_in)),
      footer_template(std::move(footer_template_in)),
      rasterize_pdf(std::move(rasterize_pdf_in)),
      rasterize_pdf_dpi(std::move(rasterize_pdf_dpi_in)),
      should_print_backgrounds(std::move(should_print_backgrounds_in)),
      printed_doc_type(std::move(printed_doc_type_in)),
      prefer_css_page_size(std::move(prefer_css_page_size_in)),
      pages_per_sheet(std::move(pages_per_sheet_in)) {}

PrintParams::~PrintParams() = default;

void PrintParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_size"), this->page_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_size"), this->content_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "printable_area"), this->printable_area,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "margin_top"), this->margin_top,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "margin_left"), this->margin_left,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_orientation"), this->page_orientation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::printing::mojom::PageOrientation>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dpi"), this->dpi,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scale_factor"), this->scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "document_cookie"), this->document_cookie,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selection_only"), this->selection_only,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supports_alpha_blend"), this->supports_alpha_blend,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "preview_ui_id"), this->preview_ui_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "preview_request_id"), this->preview_request_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_first_request"), this->is_first_request,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "print_scaling_option"), this->print_scaling_option,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::printing::mojom::PrintScalingOption>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "print_to_pdf"), this->print_to_pdf,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_header_footer"), this->display_header_footer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "header_template"), this->header_template,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "footer_template"), this->footer_template,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rasterize_pdf"), this->rasterize_pdf,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rasterize_pdf_dpi"), this->rasterize_pdf_dpi,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_print_backgrounds"), this->should_print_backgrounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "printed_doc_type"), this->printed_doc_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::printing::mojom::SkiaDocumentType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prefer_css_page_size"), this->prefer_css_page_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pages_per_sheet"), this->pages_per_sheet,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PrintParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PrintPagesParams::PrintPagesParams()
    : params(),
      pages() {}

PrintPagesParams::PrintPagesParams(
    PrintParamsPtr params_in,
    std::vector<uint32_t> pages_in)
    : params(std::move(params_in)),
      pages(std::move(pages_in)) {}

PrintPagesParams::~PrintPagesParams() = default;

void PrintPagesParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "params"), this->params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PrintParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pages"), this->pages,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PrintPagesParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DidPrintDocumentParams::DidPrintDocumentParams()
    : content(),
      document_cookie(),
      page_size(),
      content_area(),
      physical_offsets() {}

DidPrintDocumentParams::DidPrintDocumentParams(
    DidPrintContentParamsPtr content_in,
    int32_t document_cookie_in,
    const ::gfx::Size& page_size_in,
    const ::gfx::Rect& content_area_in,
    const ::gfx::Point& physical_offsets_in)
    : content(std::move(content_in)),
      document_cookie(std::move(document_cookie_in)),
      page_size(std::move(page_size_in)),
      content_area(std::move(content_area_in)),
      physical_offsets(std::move(physical_offsets_in)) {}

DidPrintDocumentParams::~DidPrintDocumentParams() = default;

void DidPrintDocumentParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content"), this->content,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DidPrintContentParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "document_cookie"), this->document_cookie,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_size"), this->page_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_area"), this->content_area,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "physical_offsets"), this->physical_offsets,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Point&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DidPrintDocumentParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ScriptedPrintParams::ScriptedPrintParams()
    : cookie(),
      expected_pages_count(),
      has_selection(),
      is_scripted(),
      is_modifiable(),
      margin_type() {}

ScriptedPrintParams::ScriptedPrintParams(
    int32_t cookie_in,
    uint32_t expected_pages_count_in,
    bool has_selection_in,
    bool is_scripted_in,
    bool is_modifiable_in,
    ::printing::mojom::MarginType margin_type_in)
    : cookie(std::move(cookie_in)),
      expected_pages_count(std::move(expected_pages_count_in)),
      has_selection(std::move(has_selection_in)),
      is_scripted(std::move(is_scripted_in)),
      is_modifiable(std::move(is_modifiable_in)),
      margin_type(std::move(margin_type_in)) {}

ScriptedPrintParams::~ScriptedPrintParams() = default;
size_t ScriptedPrintParams::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->cookie);
  seed = mojo::internal::Hash(seed, this->expected_pages_count);
  seed = mojo::internal::Hash(seed, this->has_selection);
  seed = mojo::internal::Hash(seed, this->is_scripted);
  seed = mojo::internal::Hash(seed, this->is_modifiable);
  seed = mojo::internal::Hash(seed, this->margin_type);
  return seed;
}

void ScriptedPrintParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie"), this->cookie,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expected_pages_count"), this->expected_pages_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_selection"), this->has_selection,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_scripted"), this->is_scripted,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_modifiable"), this->is_modifiable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "margin_type"), this->margin_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::printing::mojom::MarginType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ScriptedPrintParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char PrintRenderer::Name_[] = "printing.mojom.PrintRenderer";

class PrintRenderer_CreatePreviewDocument_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintRenderer_CreatePreviewDocument_ForwardToCallback(
      PrintRenderer::CreatePreviewDocumentCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PrintRenderer::CreatePreviewDocumentCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PrintRenderer_CreatePreviewDocument_ForwardToCallback);
};

PrintRendererProxy::PrintRendererProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PrintRendererProxy::CreatePreviewDocument(
    ::base::Value in_job_settings, CreatePreviewDocumentCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintRenderer::CreatePreviewDocument", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("job_settings"), in_job_settings,
                        "<value of type ::base::Value>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintRenderer_CreatePreviewDocument_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintRenderer_CreatePreviewDocument_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->job_settings)::BaseType> job_settings_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
      in_job_settings, job_settings_fragment);
  params->job_settings.Set(
      job_settings_fragment.is_null() ? nullptr : job_settings_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->job_settings.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null job_settings in PrintRenderer.CreatePreviewDocument request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintRenderer::Name_);
  message.set_method_name("CreatePreviewDocument");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintRenderer_CreatePreviewDocument_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class PrintRenderer_CreatePreviewDocument_ProxyToResponder {
 public:
  static PrintRenderer::CreatePreviewDocumentCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PrintRenderer_CreatePreviewDocument_ProxyToResponder> proxy(
        new PrintRenderer_CreatePreviewDocument_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PrintRenderer_CreatePreviewDocument_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PrintRenderer_CreatePreviewDocument_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PrintRenderer_CreatePreviewDocument_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PrintRenderer::CreatePreviewDocumentCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::ReadOnlySharedMemoryRegion in_preview_document_region);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PrintRenderer_CreatePreviewDocument_ProxyToResponder);
};

bool PrintRenderer_CreatePreviewDocument_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "printing::mojom::PrintRenderer::CreatePreviewDocumentCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PrintRenderer_CreatePreviewDocument_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintRenderer_CreatePreviewDocument_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::ReadOnlySharedMemoryRegion p_preview_document_region{};
  PrintRenderer_CreatePreviewDocument_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPreviewDocumentRegion(&p_preview_document_region))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintRenderer::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_preview_document_region));
  return true;
}

void PrintRenderer_CreatePreviewDocument_ProxyToResponder::Run(
    ::base::ReadOnlySharedMemoryRegion in_preview_document_region) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)printing::mojom::PrintRenderer::CreatePreviewDocumentCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("preview_document_region"), in_preview_document_region,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintRenderer_CreatePreviewDocument_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintRenderer_CreatePreviewDocument_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->preview_document_region)::BaseType> preview_document_region_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
      in_preview_document_region, preview_document_region_fragment);
  params->preview_document_region.Set(
      preview_document_region_fragment.is_null() ? nullptr : preview_document_region_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)printing::mojom::PrintRenderer::CreatePreviewDocumentCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintRenderer::Name_);
  message.set_method_name("CreatePreviewDocument");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PrintRendererStubDispatch::Accept(
    PrintRenderer* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPrintRenderer_CreatePreviewDocument_Name: {
      break;
    }
  }
  return false;
}

// static
bool PrintRendererStubDispatch::AcceptWithResponder(
    PrintRenderer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPrintRenderer_CreatePreviewDocument_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintRenderer::CreatePreviewDocument",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintRenderer::CreatePreviewDocument");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PrintRenderer_CreatePreviewDocument_Params_Data* params =
          reinterpret_cast<
              internal::PrintRenderer_CreatePreviewDocument_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::Value p_job_settings{};
      PrintRenderer_CreatePreviewDocument_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadJobSettings(&p_job_settings))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintRenderer::Name_, 0, false);
        return false;
      }
      PrintRenderer::CreatePreviewDocumentCallback callback =
          PrintRenderer_CreatePreviewDocument_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePreviewDocument(
std::move(p_job_settings), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPrintRendererValidationInfo[] = {
    {internal::kPrintRenderer_CreatePreviewDocument_Name,
     {&internal::PrintRenderer_CreatePreviewDocument_Params_Data::Validate,
      &internal::PrintRenderer_CreatePreviewDocument_ResponseParams_Data::Validate}},
};

bool PrintRendererRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::printing::mojom::PrintRenderer::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPrintRendererValidationInfo);
}

bool PrintRendererResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::printing::mojom::PrintRenderer::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kPrintRendererValidationInfo);

}
const char PrintPreviewUI::Name_[] = "printing.mojom.PrintPreviewUI";

PrintPreviewUIProxy::PrintPreviewUIProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PrintPreviewUIProxy::SetOptionsFromDocument(
    OptionsFromDocumentParamsPtr in_params, int32_t in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintPreviewUI::SetOptionsFromDocument", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type OptionsFromDocumentParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintPreviewUI_SetOptionsFromDocument_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintPreviewUI_SetOptionsFromDocument_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::OptionsFromDocumentParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in PrintPreviewUI.SetOptionsFromDocument request");
  params->request_id = in_request_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintPreviewUI::Name_);
  message.set_method_name("SetOptionsFromDocument");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PrintPreviewUIProxy::DidPrepareDocumentForPreview(
    int32_t in_document_cookie, int32_t in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintPreviewUI::DidPrepareDocumentForPreview", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_cookie"), in_document_cookie,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintPreviewUI_DidPrepareDocumentForPreview_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintPreviewUI_DidPrepareDocumentForPreview_Params_Data> params(
          message);
  params.Allocate();
  params->document_cookie = in_document_cookie;
  params->request_id = in_request_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintPreviewUI::Name_);
  message.set_method_name("DidPrepareDocumentForPreview");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PrintPreviewUIProxy::DidPreviewPage(
    DidPreviewPageParamsPtr in_params, int32_t in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintPreviewUI::DidPreviewPage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type DidPreviewPageParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintPreviewUI_DidPreviewPage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintPreviewUI_DidPreviewPage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::DidPreviewPageParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in PrintPreviewUI.DidPreviewPage request");
  params->request_id = in_request_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintPreviewUI::Name_);
  message.set_method_name("DidPreviewPage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PrintPreviewUIProxy::MetafileReadyForPrinting(
    DidPreviewDocumentParamsPtr in_params, int32_t in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintPreviewUI::MetafileReadyForPrinting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type DidPreviewDocumentParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintPreviewUI_MetafileReadyForPrinting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintPreviewUI_MetafileReadyForPrinting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::DidPreviewDocumentParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in PrintPreviewUI.MetafileReadyForPrinting request");
  params->request_id = in_request_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintPreviewUI::Name_);
  message.set_method_name("MetafileReadyForPrinting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PrintPreviewUIProxy::PrintPreviewFailed(
    int32_t in_document_cookie, int32_t in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintPreviewUI::PrintPreviewFailed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_cookie"), in_document_cookie,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintPreviewUI_PrintPreviewFailed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintPreviewUI_PrintPreviewFailed_Params_Data> params(
          message);
  params.Allocate();
  params->document_cookie = in_document_cookie;
  params->request_id = in_request_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintPreviewUI::Name_);
  message.set_method_name("PrintPreviewFailed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PrintPreviewUIProxy::PrintPreviewCancelled(
    int32_t in_document_cookie, int32_t in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintPreviewUI::PrintPreviewCancelled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_cookie"), in_document_cookie,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintPreviewUI_PrintPreviewCancelled_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintPreviewUI_PrintPreviewCancelled_Params_Data> params(
          message);
  params.Allocate();
  params->document_cookie = in_document_cookie;
  params->request_id = in_request_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintPreviewUI::Name_);
  message.set_method_name("PrintPreviewCancelled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PrintPreviewUIProxy::PrinterSettingsInvalid(
    int32_t in_document_cookie, int32_t in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintPreviewUI::PrinterSettingsInvalid", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_cookie"), in_document_cookie,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintPreviewUI_PrinterSettingsInvalid_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintPreviewUI_PrinterSettingsInvalid_Params_Data> params(
          message);
  params.Allocate();
  params->document_cookie = in_document_cookie;
  params->request_id = in_request_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintPreviewUI::Name_);
  message.set_method_name("PrinterSettingsInvalid");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PrintPreviewUIProxy::DidGetDefaultPageLayout(
    ::printing::mojom::PageSizeMarginsPtr in_page_layout_in_points, const ::gfx::Rect& in_printable_area_in_points, bool in_has_custom_page_size_style, int32_t in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintPreviewUI::DidGetDefaultPageLayout", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_layout_in_points"), in_page_layout_in_points,
                        "<value of type ::printing::mojom::PageSizeMarginsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("printable_area_in_points"), in_printable_area_in_points,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_custom_page_size_style"), in_has_custom_page_size_style,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintPreviewUI_DidGetDefaultPageLayout_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintPreviewUI_DidGetDefaultPageLayout_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->page_layout_in_points)::BaseType> page_layout_in_points_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::PageSizeMarginsDataView>(
      in_page_layout_in_points, page_layout_in_points_fragment);
  params->page_layout_in_points.Set(
      page_layout_in_points_fragment.is_null() ? nullptr : page_layout_in_points_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->page_layout_in_points.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null page_layout_in_points in PrintPreviewUI.DidGetDefaultPageLayout request");
  mojo::internal::MessageFragment<
      typename decltype(params->printable_area_in_points)::BaseType> printable_area_in_points_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_printable_area_in_points, printable_area_in_points_fragment);
  params->printable_area_in_points.Set(
      printable_area_in_points_fragment.is_null() ? nullptr : printable_area_in_points_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->printable_area_in_points.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null printable_area_in_points in PrintPreviewUI.DidGetDefaultPageLayout request");
  params->has_custom_page_size_style = in_has_custom_page_size_style;
  params->request_id = in_request_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintPreviewUI::Name_);
  message.set_method_name("DidGetDefaultPageLayout");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PrintPreviewUIProxy::DidStartPreview(
    DidStartPreviewParamsPtr in_params, int32_t in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintPreviewUI::DidStartPreview", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type DidStartPreviewParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintPreviewUI_DidStartPreview_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintPreviewUI_DidStartPreview_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::DidStartPreviewParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in PrintPreviewUI.DidStartPreview request");
  params->request_id = in_request_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintPreviewUI::Name_);
  message.set_method_name("DidStartPreview");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool PrintPreviewUIStubDispatch::Accept(
    PrintPreviewUI* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPrintPreviewUI_SetOptionsFromDocument_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintPreviewUI::SetOptionsFromDocument",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintPreviewUI::SetOptionsFromDocument");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrintPreviewUI_SetOptionsFromDocument_Params_Data* params =
          reinterpret_cast<internal::PrintPreviewUI_SetOptionsFromDocument_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      OptionsFromDocumentParamsPtr p_params{};
      int32_t p_request_id{};
      PrintPreviewUI_SetOptionsFromDocument_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success)
        p_request_id = input_data_view.request_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintPreviewUI::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetOptionsFromDocument(
std::move(p_params), 
std::move(p_request_id));
      return true;
    }
    case internal::kPrintPreviewUI_DidPrepareDocumentForPreview_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintPreviewUI::DidPrepareDocumentForPreview",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintPreviewUI::DidPrepareDocumentForPreview");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrintPreviewUI_DidPrepareDocumentForPreview_Params_Data* params =
          reinterpret_cast<internal::PrintPreviewUI_DidPrepareDocumentForPreview_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_document_cookie{};
      int32_t p_request_id{};
      PrintPreviewUI_DidPrepareDocumentForPreview_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_document_cookie = input_data_view.document_cookie();
      if (success)
        p_request_id = input_data_view.request_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintPreviewUI::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidPrepareDocumentForPreview(
std::move(p_document_cookie), 
std::move(p_request_id));
      return true;
    }
    case internal::kPrintPreviewUI_DidPreviewPage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintPreviewUI::DidPreviewPage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintPreviewUI::DidPreviewPage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrintPreviewUI_DidPreviewPage_Params_Data* params =
          reinterpret_cast<internal::PrintPreviewUI_DidPreviewPage_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      DidPreviewPageParamsPtr p_params{};
      int32_t p_request_id{};
      PrintPreviewUI_DidPreviewPage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success)
        p_request_id = input_data_view.request_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintPreviewUI::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidPreviewPage(
std::move(p_params), 
std::move(p_request_id));
      return true;
    }
    case internal::kPrintPreviewUI_MetafileReadyForPrinting_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintPreviewUI::MetafileReadyForPrinting",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintPreviewUI::MetafileReadyForPrinting");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrintPreviewUI_MetafileReadyForPrinting_Params_Data* params =
          reinterpret_cast<internal::PrintPreviewUI_MetafileReadyForPrinting_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      DidPreviewDocumentParamsPtr p_params{};
      int32_t p_request_id{};
      PrintPreviewUI_MetafileReadyForPrinting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success)
        p_request_id = input_data_view.request_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintPreviewUI::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MetafileReadyForPrinting(
std::move(p_params), 
std::move(p_request_id));
      return true;
    }
    case internal::kPrintPreviewUI_PrintPreviewFailed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintPreviewUI::PrintPreviewFailed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintPreviewUI::PrintPreviewFailed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrintPreviewUI_PrintPreviewFailed_Params_Data* params =
          reinterpret_cast<internal::PrintPreviewUI_PrintPreviewFailed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_document_cookie{};
      int32_t p_request_id{};
      PrintPreviewUI_PrintPreviewFailed_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_document_cookie = input_data_view.document_cookie();
      if (success)
        p_request_id = input_data_view.request_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintPreviewUI::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrintPreviewFailed(
std::move(p_document_cookie), 
std::move(p_request_id));
      return true;
    }
    case internal::kPrintPreviewUI_PrintPreviewCancelled_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintPreviewUI::PrintPreviewCancelled",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintPreviewUI::PrintPreviewCancelled");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrintPreviewUI_PrintPreviewCancelled_Params_Data* params =
          reinterpret_cast<internal::PrintPreviewUI_PrintPreviewCancelled_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_document_cookie{};
      int32_t p_request_id{};
      PrintPreviewUI_PrintPreviewCancelled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_document_cookie = input_data_view.document_cookie();
      if (success)
        p_request_id = input_data_view.request_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintPreviewUI::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrintPreviewCancelled(
std::move(p_document_cookie), 
std::move(p_request_id));
      return true;
    }
    case internal::kPrintPreviewUI_PrinterSettingsInvalid_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintPreviewUI::PrinterSettingsInvalid",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintPreviewUI::PrinterSettingsInvalid");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrintPreviewUI_PrinterSettingsInvalid_Params_Data* params =
          reinterpret_cast<internal::PrintPreviewUI_PrinterSettingsInvalid_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_document_cookie{};
      int32_t p_request_id{};
      PrintPreviewUI_PrinterSettingsInvalid_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_document_cookie = input_data_view.document_cookie();
      if (success)
        p_request_id = input_data_view.request_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintPreviewUI::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrinterSettingsInvalid(
std::move(p_document_cookie), 
std::move(p_request_id));
      return true;
    }
    case internal::kPrintPreviewUI_DidGetDefaultPageLayout_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintPreviewUI::DidGetDefaultPageLayout",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintPreviewUI::DidGetDefaultPageLayout");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrintPreviewUI_DidGetDefaultPageLayout_Params_Data* params =
          reinterpret_cast<internal::PrintPreviewUI_DidGetDefaultPageLayout_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::printing::mojom::PageSizeMarginsPtr p_page_layout_in_points{};
      ::gfx::Rect p_printable_area_in_points{};
      bool p_has_custom_page_size_style{};
      int32_t p_request_id{};
      PrintPreviewUI_DidGetDefaultPageLayout_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPageLayoutInPoints(&p_page_layout_in_points))
        success = false;
      if (success && !input_data_view.ReadPrintableAreaInPoints(&p_printable_area_in_points))
        success = false;
      if (success)
        p_has_custom_page_size_style = input_data_view.has_custom_page_size_style();
      if (success)
        p_request_id = input_data_view.request_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintPreviewUI::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidGetDefaultPageLayout(
std::move(p_page_layout_in_points), 
std::move(p_printable_area_in_points), 
std::move(p_has_custom_page_size_style), 
std::move(p_request_id));
      return true;
    }
    case internal::kPrintPreviewUI_DidStartPreview_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintPreviewUI::DidStartPreview",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintPreviewUI::DidStartPreview");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrintPreviewUI_DidStartPreview_Params_Data* params =
          reinterpret_cast<internal::PrintPreviewUI_DidStartPreview_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      DidStartPreviewParamsPtr p_params{};
      int32_t p_request_id{};
      PrintPreviewUI_DidStartPreview_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success)
        p_request_id = input_data_view.request_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintPreviewUI::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidStartPreview(
std::move(p_params), 
std::move(p_request_id));
      return true;
    }
  }
  return false;
}

// static
bool PrintPreviewUIStubDispatch::AcceptWithResponder(
    PrintPreviewUI* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPrintPreviewUI_SetOptionsFromDocument_Name: {
      break;
    }
    case internal::kPrintPreviewUI_DidPrepareDocumentForPreview_Name: {
      break;
    }
    case internal::kPrintPreviewUI_DidPreviewPage_Name: {
      break;
    }
    case internal::kPrintPreviewUI_MetafileReadyForPrinting_Name: {
      break;
    }
    case internal::kPrintPreviewUI_PrintPreviewFailed_Name: {
      break;
    }
    case internal::kPrintPreviewUI_PrintPreviewCancelled_Name: {
      break;
    }
    case internal::kPrintPreviewUI_PrinterSettingsInvalid_Name: {
      break;
    }
    case internal::kPrintPreviewUI_DidGetDefaultPageLayout_Name: {
      break;
    }
    case internal::kPrintPreviewUI_DidStartPreview_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPrintPreviewUIValidationInfo[] = {
    {internal::kPrintPreviewUI_SetOptionsFromDocument_Name,
     {&internal::PrintPreviewUI_SetOptionsFromDocument_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPrintPreviewUI_DidPrepareDocumentForPreview_Name,
     {&internal::PrintPreviewUI_DidPrepareDocumentForPreview_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPrintPreviewUI_DidPreviewPage_Name,
     {&internal::PrintPreviewUI_DidPreviewPage_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPrintPreviewUI_MetafileReadyForPrinting_Name,
     {&internal::PrintPreviewUI_MetafileReadyForPrinting_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPrintPreviewUI_PrintPreviewFailed_Name,
     {&internal::PrintPreviewUI_PrintPreviewFailed_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPrintPreviewUI_PrintPreviewCancelled_Name,
     {&internal::PrintPreviewUI_PrintPreviewCancelled_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPrintPreviewUI_PrinterSettingsInvalid_Name,
     {&internal::PrintPreviewUI_PrinterSettingsInvalid_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPrintPreviewUI_DidGetDefaultPageLayout_Name,
     {&internal::PrintPreviewUI_DidGetDefaultPageLayout_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPrintPreviewUI_DidStartPreview_Name,
     {&internal::PrintPreviewUI_DidStartPreview_Params_Data::Validate,
      nullptr /* no response */}},
};

bool PrintPreviewUIRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::printing::mojom::PrintPreviewUI::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPrintPreviewUIValidationInfo);
}

const char PrintRenderFrame::Name_[] = "printing.mojom.PrintRenderFrame";

class PrintRenderFrame_PrintFrameContent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintRenderFrame_PrintFrameContent_ForwardToCallback(
      PrintRenderFrame::PrintFrameContentCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PrintRenderFrame::PrintFrameContentCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PrintRenderFrame_PrintFrameContent_ForwardToCallback);
};

PrintRenderFrameProxy::PrintRenderFrameProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PrintRenderFrameProxy::PrintRequestedPages(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "printing::mojom::PrintRenderFrame::PrintRequestedPages");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintRenderFrame_PrintRequestedPages_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintRenderFrame_PrintRequestedPages_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintRenderFrame::Name_);
  message.set_method_name("PrintRequestedPages");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PrintRenderFrameProxy::PrintForSystemDialog(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "printing::mojom::PrintRenderFrame::PrintForSystemDialog");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintRenderFrame_PrintForSystemDialog_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintRenderFrame_PrintForSystemDialog_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintRenderFrame::Name_);
  message.set_method_name("PrintForSystemDialog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PrintRenderFrameProxy::InitiatePrintPreview(
    ::mojo::PendingAssociatedRemote<PrintRenderer> in_print_renderer, bool in_has_selection) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintRenderFrame::InitiatePrintPreview", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("print_renderer"), in_print_renderer,
                        "<value of type ::mojo::PendingAssociatedRemote<PrintRenderer>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_selection"), in_has_selection,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintRenderFrame_InitiatePrintPreview_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintRenderFrame_InitiatePrintPreview_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::printing::mojom::PrintRendererAssociatedPtrInfoDataView>(
      in_print_renderer, &params->print_renderer, &params.message());
  params->has_selection = in_has_selection;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintRenderFrame::Name_);
  message.set_method_name("InitiatePrintPreview");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PrintRenderFrameProxy::SetPrintPreviewUI(
    ::mojo::PendingAssociatedRemote<PrintPreviewUI> in_preview) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintRenderFrame::SetPrintPreviewUI", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("preview"), in_preview,
                        "<value of type ::mojo::PendingAssociatedRemote<PrintPreviewUI>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintRenderFrame_SetPrintPreviewUI_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintRenderFrame_SetPrintPreviewUI_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::printing::mojom::PrintPreviewUIAssociatedPtrInfoDataView>(
      in_preview, &params->preview, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->preview),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid preview in PrintRenderFrame.SetPrintPreviewUI request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintRenderFrame::Name_);
  message.set_method_name("SetPrintPreviewUI");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PrintRenderFrameProxy::PrintPreview(
    ::base::Value in_settings) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintRenderFrame::PrintPreview", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("settings"), in_settings,
                        "<value of type ::base::Value>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintRenderFrame_PrintPreview_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintRenderFrame_PrintPreview_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->settings)::BaseType> settings_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
      in_settings, settings_fragment);
  params->settings.Set(
      settings_fragment.is_null() ? nullptr : settings_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->settings.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null settings in PrintRenderFrame.PrintPreview request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintRenderFrame::Name_);
  message.set_method_name("PrintPreview");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PrintRenderFrameProxy::OnPrintPreviewDialogClosed(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "printing::mojom::PrintRenderFrame::OnPrintPreviewDialogClosed");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintRenderFrame_OnPrintPreviewDialogClosed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintRenderFrame_OnPrintPreviewDialogClosed_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintRenderFrame::Name_);
  message.set_method_name("OnPrintPreviewDialogClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PrintRenderFrameProxy::PrintFrameContent(
    PrintFrameContentParamsPtr in_params, PrintFrameContentCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintRenderFrame::PrintFrameContent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type PrintFrameContentParamsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintRenderFrame_PrintFrameContent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintRenderFrame_PrintFrameContent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::PrintFrameContentParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in PrintRenderFrame.PrintFrameContent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintRenderFrame::Name_);
  message.set_method_name("PrintFrameContent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintRenderFrame_PrintFrameContent_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PrintRenderFrameProxy::SetPrintingEnabled(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintRenderFrame::SetPrintingEnabled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintRenderFrame_SetPrintingEnabled_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintRenderFrame_SetPrintingEnabled_Params_Data> params(
          message);
  params.Allocate();
  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintRenderFrame::Name_);
  message.set_method_name("SetPrintingEnabled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PrintRenderFrameProxy::PrintingDone(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintRenderFrame::PrintingDone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintRenderFrame_PrintingDone_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintRenderFrame_PrintingDone_Params_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintRenderFrame::Name_);
  message.set_method_name("PrintingDone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PrintRenderFrameProxy::PrintNodeUnderContextMenu(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "printing::mojom::PrintRenderFrame::PrintNodeUnderContextMenu");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintRenderFrame_PrintNodeUnderContextMenu_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintRenderFrame_PrintNodeUnderContextMenu_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintRenderFrame::Name_);
  message.set_method_name("PrintNodeUnderContextMenu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class PrintRenderFrame_PrintFrameContent_ProxyToResponder {
 public:
  static PrintRenderFrame::PrintFrameContentCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PrintRenderFrame_PrintFrameContent_ProxyToResponder> proxy(
        new PrintRenderFrame_PrintFrameContent_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PrintRenderFrame_PrintFrameContent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PrintRenderFrame_PrintFrameContent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PrintRenderFrame_PrintFrameContent_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PrintRenderFrame::PrintFrameContentCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_document_cookie, DidPrintContentParamsPtr in_params);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PrintRenderFrame_PrintFrameContent_ProxyToResponder);
};

bool PrintRenderFrame_PrintFrameContent_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "printing::mojom::PrintRenderFrame::PrintFrameContentCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PrintRenderFrame_PrintFrameContent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintRenderFrame_PrintFrameContent_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int32_t p_document_cookie{};
  DidPrintContentParamsPtr p_params{};
  PrintRenderFrame_PrintFrameContent_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_document_cookie = input_data_view.document_cookie();
  if (success && !input_data_view.ReadParams(&p_params))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintRenderFrame::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_document_cookie), 
std::move(p_params));
  return true;
}

void PrintRenderFrame_PrintFrameContent_ProxyToResponder::Run(
    int32_t in_document_cookie, DidPrintContentParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)printing::mojom::PrintRenderFrame::PrintFrameContentCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_cookie"), in_document_cookie,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type DidPrintContentParamsPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintRenderFrame_PrintFrameContent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintRenderFrame_PrintFrameContent_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->document_cookie = in_document_cookie;
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::DidPrintContentParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)printing::mojom::PrintRenderFrame::PrintFrameContentCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintRenderFrame::Name_);
  message.set_method_name("PrintFrameContent");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PrintRenderFrameStubDispatch::Accept(
    PrintRenderFrame* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPrintRenderFrame_PrintRequestedPages_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintRenderFrame::PrintRequestedPages",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintRenderFrame::PrintRequestedPages");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrintRenderFrame_PrintRequestedPages_Params_Data* params =
          reinterpret_cast<internal::PrintRenderFrame_PrintRequestedPages_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PrintRenderFrame_PrintRequestedPages_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintRenderFrame::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrintRequestedPages();
      return true;
    }
    case internal::kPrintRenderFrame_PrintForSystemDialog_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintRenderFrame::PrintForSystemDialog",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintRenderFrame::PrintForSystemDialog");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrintRenderFrame_PrintForSystemDialog_Params_Data* params =
          reinterpret_cast<internal::PrintRenderFrame_PrintForSystemDialog_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PrintRenderFrame_PrintForSystemDialog_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintRenderFrame::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrintForSystemDialog();
      return true;
    }
    case internal::kPrintRenderFrame_InitiatePrintPreview_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintRenderFrame::InitiatePrintPreview",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintRenderFrame::InitiatePrintPreview");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrintRenderFrame_InitiatePrintPreview_Params_Data* params =
          reinterpret_cast<internal::PrintRenderFrame_InitiatePrintPreview_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedRemote<PrintRenderer> p_print_renderer{};
      bool p_has_selection{};
      PrintRenderFrame_InitiatePrintPreview_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_print_renderer =
            input_data_view.TakePrintRenderer<decltype(p_print_renderer)>();
      }
      if (success)
        p_has_selection = input_data_view.has_selection();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintRenderFrame::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InitiatePrintPreview(
std::move(p_print_renderer), 
std::move(p_has_selection));
      return true;
    }
    case internal::kPrintRenderFrame_SetPrintPreviewUI_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintRenderFrame::SetPrintPreviewUI",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintRenderFrame::SetPrintPreviewUI");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrintRenderFrame_SetPrintPreviewUI_Params_Data* params =
          reinterpret_cast<internal::PrintRenderFrame_SetPrintPreviewUI_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedRemote<PrintPreviewUI> p_preview{};
      PrintRenderFrame_SetPrintPreviewUI_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_preview =
            input_data_view.TakePreview<decltype(p_preview)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintRenderFrame::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPrintPreviewUI(
std::move(p_preview));
      return true;
    }
    case internal::kPrintRenderFrame_PrintPreview_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintRenderFrame::PrintPreview",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintRenderFrame::PrintPreview");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrintRenderFrame_PrintPreview_Params_Data* params =
          reinterpret_cast<internal::PrintRenderFrame_PrintPreview_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::Value p_settings{};
      PrintRenderFrame_PrintPreview_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSettings(&p_settings))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintRenderFrame::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrintPreview(
std::move(p_settings));
      return true;
    }
    case internal::kPrintRenderFrame_OnPrintPreviewDialogClosed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintRenderFrame::OnPrintPreviewDialogClosed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintRenderFrame::OnPrintPreviewDialogClosed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrintRenderFrame_OnPrintPreviewDialogClosed_Params_Data* params =
          reinterpret_cast<internal::PrintRenderFrame_OnPrintPreviewDialogClosed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PrintRenderFrame_OnPrintPreviewDialogClosed_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintRenderFrame::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPrintPreviewDialogClosed();
      return true;
    }
    case internal::kPrintRenderFrame_PrintFrameContent_Name: {
      break;
    }
    case internal::kPrintRenderFrame_SetPrintingEnabled_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintRenderFrame::SetPrintingEnabled",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintRenderFrame::SetPrintingEnabled");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrintRenderFrame_SetPrintingEnabled_Params_Data* params =
          reinterpret_cast<internal::PrintRenderFrame_SetPrintingEnabled_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_enabled{};
      PrintRenderFrame_SetPrintingEnabled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintRenderFrame::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPrintingEnabled(
std::move(p_enabled));
      return true;
    }
    case internal::kPrintRenderFrame_PrintingDone_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintRenderFrame::PrintingDone",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintRenderFrame::PrintingDone");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrintRenderFrame_PrintingDone_Params_Data* params =
          reinterpret_cast<internal::PrintRenderFrame_PrintingDone_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_success{};
      PrintRenderFrame_PrintingDone_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_success = input_data_view.success();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintRenderFrame::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrintingDone(
std::move(p_success));
      return true;
    }
    case internal::kPrintRenderFrame_PrintNodeUnderContextMenu_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintRenderFrame::PrintNodeUnderContextMenu",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintRenderFrame::PrintNodeUnderContextMenu");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrintRenderFrame_PrintNodeUnderContextMenu_Params_Data* params =
          reinterpret_cast<internal::PrintRenderFrame_PrintNodeUnderContextMenu_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PrintRenderFrame_PrintNodeUnderContextMenu_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintRenderFrame::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrintNodeUnderContextMenu();
      return true;
    }
  }
  return false;
}

// static
bool PrintRenderFrameStubDispatch::AcceptWithResponder(
    PrintRenderFrame* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPrintRenderFrame_PrintRequestedPages_Name: {
      break;
    }
    case internal::kPrintRenderFrame_PrintForSystemDialog_Name: {
      break;
    }
    case internal::kPrintRenderFrame_InitiatePrintPreview_Name: {
      break;
    }
    case internal::kPrintRenderFrame_SetPrintPreviewUI_Name: {
      break;
    }
    case internal::kPrintRenderFrame_PrintPreview_Name: {
      break;
    }
    case internal::kPrintRenderFrame_OnPrintPreviewDialogClosed_Name: {
      break;
    }
    case internal::kPrintRenderFrame_PrintFrameContent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintRenderFrame::PrintFrameContent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintRenderFrame::PrintFrameContent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PrintRenderFrame_PrintFrameContent_Params_Data* params =
          reinterpret_cast<
              internal::PrintRenderFrame_PrintFrameContent_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      PrintFrameContentParamsPtr p_params{};
      PrintRenderFrame_PrintFrameContent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintRenderFrame::Name_, 6, false);
        return false;
      }
      PrintRenderFrame::PrintFrameContentCallback callback =
          PrintRenderFrame_PrintFrameContent_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrintFrameContent(
std::move(p_params), std::move(callback));
      return true;
    }
    case internal::kPrintRenderFrame_SetPrintingEnabled_Name: {
      break;
    }
    case internal::kPrintRenderFrame_PrintingDone_Name: {
      break;
    }
    case internal::kPrintRenderFrame_PrintNodeUnderContextMenu_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPrintRenderFrameValidationInfo[] = {
    {internal::kPrintRenderFrame_PrintRequestedPages_Name,
     {&internal::PrintRenderFrame_PrintRequestedPages_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPrintRenderFrame_PrintForSystemDialog_Name,
     {&internal::PrintRenderFrame_PrintForSystemDialog_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPrintRenderFrame_InitiatePrintPreview_Name,
     {&internal::PrintRenderFrame_InitiatePrintPreview_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPrintRenderFrame_SetPrintPreviewUI_Name,
     {&internal::PrintRenderFrame_SetPrintPreviewUI_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPrintRenderFrame_PrintPreview_Name,
     {&internal::PrintRenderFrame_PrintPreview_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPrintRenderFrame_OnPrintPreviewDialogClosed_Name,
     {&internal::PrintRenderFrame_OnPrintPreviewDialogClosed_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPrintRenderFrame_PrintFrameContent_Name,
     {&internal::PrintRenderFrame_PrintFrameContent_Params_Data::Validate,
      &internal::PrintRenderFrame_PrintFrameContent_ResponseParams_Data::Validate}},
    {internal::kPrintRenderFrame_SetPrintingEnabled_Name,
     {&internal::PrintRenderFrame_SetPrintingEnabled_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPrintRenderFrame_PrintingDone_Name,
     {&internal::PrintRenderFrame_PrintingDone_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPrintRenderFrame_PrintNodeUnderContextMenu_Name,
     {&internal::PrintRenderFrame_PrintNodeUnderContextMenu_Params_Data::Validate,
      nullptr /* no response */}},
};

bool PrintRenderFrameRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::printing::mojom::PrintRenderFrame::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPrintRenderFrameValidationInfo);
}

bool PrintRenderFrameResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::printing::mojom::PrintRenderFrame::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kPrintRenderFrameValidationInfo);

}
const char PrintManagerHost::Name_[] = "printing.mojom.PrintManagerHost";
bool PrintManagerHost::GetDefaultPrintSettings(PrintParamsPtr* out_default_settings) {
  NOTREACHED();
  return false;
}
bool PrintManagerHost::DidPrintDocument(DidPrintDocumentParamsPtr params, bool* out_completed) {
  NOTREACHED();
  return false;
}
bool PrintManagerHost::ScriptedPrint(ScriptedPrintParamsPtr params, PrintPagesParamsPtr* out_settings) {
  NOTREACHED();
  return false;
}
bool PrintManagerHost::UpdatePrintSettings(int32_t cookie, ::base::Value job_settings, PrintPagesParamsPtr* out_current_settings, bool* out_canceled) {
  NOTREACHED();
  return false;
}
bool PrintManagerHost::SetupScriptedPrintPreview() {
  NOTREACHED();
  return false;
}
bool PrintManagerHost::CheckForCancel(int32_t preview_ui_id, int32_t request_id, bool* out_cancel) {
  NOTREACHED();
  return false;
}
class PrintManagerHost_GetDefaultPrintSettings_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  PrintManagerHost_GetDefaultPrintSettings_HandleSyncResponse(
      bool* result, PrintParamsPtr* out_default_settings)
      : result_(result), out_default_settings_(out_default_settings) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  PrintParamsPtr* out_default_settings_;DISALLOW_COPY_AND_ASSIGN(PrintManagerHost_GetDefaultPrintSettings_HandleSyncResponse);
};

class PrintManagerHost_GetDefaultPrintSettings_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintManagerHost_GetDefaultPrintSettings_ForwardToCallback(
      PrintManagerHost::GetDefaultPrintSettingsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PrintManagerHost::GetDefaultPrintSettingsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PrintManagerHost_GetDefaultPrintSettings_ForwardToCallback);
};
class PrintManagerHost_DidPrintDocument_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  PrintManagerHost_DidPrintDocument_HandleSyncResponse(
      bool* result, bool* out_completed)
      : result_(result), out_completed_(out_completed) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_completed_;DISALLOW_COPY_AND_ASSIGN(PrintManagerHost_DidPrintDocument_HandleSyncResponse);
};

class PrintManagerHost_DidPrintDocument_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintManagerHost_DidPrintDocument_ForwardToCallback(
      PrintManagerHost::DidPrintDocumentCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PrintManagerHost::DidPrintDocumentCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PrintManagerHost_DidPrintDocument_ForwardToCallback);
};
class PrintManagerHost_ScriptedPrint_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  PrintManagerHost_ScriptedPrint_HandleSyncResponse(
      bool* result, PrintPagesParamsPtr* out_settings)
      : result_(result), out_settings_(out_settings) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  PrintPagesParamsPtr* out_settings_;DISALLOW_COPY_AND_ASSIGN(PrintManagerHost_ScriptedPrint_HandleSyncResponse);
};

class PrintManagerHost_ScriptedPrint_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintManagerHost_ScriptedPrint_ForwardToCallback(
      PrintManagerHost::ScriptedPrintCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PrintManagerHost::ScriptedPrintCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PrintManagerHost_ScriptedPrint_ForwardToCallback);
};
class PrintManagerHost_UpdatePrintSettings_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  PrintManagerHost_UpdatePrintSettings_HandleSyncResponse(
      bool* result, PrintPagesParamsPtr* out_current_settings, bool* out_canceled)
      : result_(result), out_current_settings_(out_current_settings), out_canceled_(out_canceled) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  PrintPagesParamsPtr* out_current_settings_;
  bool* out_canceled_;DISALLOW_COPY_AND_ASSIGN(PrintManagerHost_UpdatePrintSettings_HandleSyncResponse);
};

class PrintManagerHost_UpdatePrintSettings_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintManagerHost_UpdatePrintSettings_ForwardToCallback(
      PrintManagerHost::UpdatePrintSettingsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PrintManagerHost::UpdatePrintSettingsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PrintManagerHost_UpdatePrintSettings_ForwardToCallback);
};
class PrintManagerHost_SetupScriptedPrintPreview_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  PrintManagerHost_SetupScriptedPrintPreview_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;DISALLOW_COPY_AND_ASSIGN(PrintManagerHost_SetupScriptedPrintPreview_HandleSyncResponse);
};

class PrintManagerHost_SetupScriptedPrintPreview_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintManagerHost_SetupScriptedPrintPreview_ForwardToCallback(
      PrintManagerHost::SetupScriptedPrintPreviewCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PrintManagerHost::SetupScriptedPrintPreviewCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PrintManagerHost_SetupScriptedPrintPreview_ForwardToCallback);
};
class PrintManagerHost_CheckForCancel_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  PrintManagerHost_CheckForCancel_HandleSyncResponse(
      bool* result, bool* out_cancel)
      : result_(result), out_cancel_(out_cancel) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_cancel_;DISALLOW_COPY_AND_ASSIGN(PrintManagerHost_CheckForCancel_HandleSyncResponse);
};

class PrintManagerHost_CheckForCancel_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintManagerHost_CheckForCancel_ForwardToCallback(
      PrintManagerHost::CheckForCancelCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PrintManagerHost::CheckForCancelCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PrintManagerHost_CheckForCancel_ForwardToCallback);
};

PrintManagerHostProxy::PrintManagerHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PrintManagerHostProxy::DidGetPrintedPagesCount(
    int32_t in_cookie, uint32_t in_number_pages) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintManagerHost::DidGetPrintedPagesCount", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookie"), in_cookie,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("number_pages"), in_number_pages,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintManagerHost_DidGetPrintedPagesCount_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_DidGetPrintedPagesCount_Params_Data> params(
          message);
  params.Allocate();
  params->cookie = in_cookie;
  params->number_pages = in_number_pages;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("DidGetPrintedPagesCount");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
bool PrintManagerHostProxy::GetDefaultPrintSettings(
    PrintParamsPtr* out_param_default_settings) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "printing::mojom::PrintManagerHost::GetDefaultPrintSettings");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintManagerHost_GetDefaultPrintSettings_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_GetDefaultPrintSettings_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("GetDefaultPrintSettings");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintManagerHost_GetDefaultPrintSettings_HandleSyncResponse(
          &result, out_param_default_settings));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "printing::mojom::PrintManagerHost::GetDefaultPrintSettings", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("default_settings"), out_param_default_settings,
                        "<value of type PrintParamsPtr>");
   });
#endif
  return result;
}

void PrintManagerHostProxy::GetDefaultPrintSettings(
    GetDefaultPrintSettingsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "printing::mojom::PrintManagerHost::GetDefaultPrintSettings");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintManagerHost_GetDefaultPrintSettings_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_GetDefaultPrintSettings_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("GetDefaultPrintSettings");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintManagerHost_GetDefaultPrintSettings_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PrintManagerHostProxy::DidShowPrintDialog(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "printing::mojom::PrintManagerHost::DidShowPrintDialog");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintManagerHost_DidShowPrintDialog_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_DidShowPrintDialog_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("DidShowPrintDialog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
bool PrintManagerHostProxy::DidPrintDocument(
    DidPrintDocumentParamsPtr param_params, bool* out_param_completed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "printing::mojom::PrintManagerHost::DidPrintDocument", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), param_params,
                        "<value of type DidPrintDocumentParamsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintManagerHost_DidPrintDocument_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_DidPrintDocument_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::DidPrintDocumentParamsDataView>(
      param_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in PrintManagerHost.DidPrintDocument request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("DidPrintDocument");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintManagerHost_DidPrintDocument_HandleSyncResponse(
          &result, out_param_completed));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "printing::mojom::PrintManagerHost::DidPrintDocument", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("completed"), out_param_completed,
                        "<value of type bool>");
   });
#endif
  return result;
}

void PrintManagerHostProxy::DidPrintDocument(
    DidPrintDocumentParamsPtr in_params, DidPrintDocumentCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintManagerHost::DidPrintDocument", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type DidPrintDocumentParamsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintManagerHost_DidPrintDocument_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_DidPrintDocument_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::DidPrintDocumentParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in PrintManagerHost.DidPrintDocument request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("DidPrintDocument");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintManagerHost_DidPrintDocument_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool PrintManagerHostProxy::ScriptedPrint(
    ScriptedPrintParamsPtr param_params, PrintPagesParamsPtr* out_param_settings) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "printing::mojom::PrintManagerHost::ScriptedPrint", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), param_params,
                        "<value of type ScriptedPrintParamsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintManagerHost_ScriptedPrint_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_ScriptedPrint_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::ScriptedPrintParamsDataView>(
      param_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in PrintManagerHost.ScriptedPrint request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("ScriptedPrint");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintManagerHost_ScriptedPrint_HandleSyncResponse(
          &result, out_param_settings));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "printing::mojom::PrintManagerHost::ScriptedPrint", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("settings"), out_param_settings,
                        "<value of type PrintPagesParamsPtr>");
   });
#endif
  return result;
}

void PrintManagerHostProxy::ScriptedPrint(
    ScriptedPrintParamsPtr in_params, ScriptedPrintCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintManagerHost::ScriptedPrint", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ScriptedPrintParamsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintManagerHost_ScriptedPrint_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_ScriptedPrint_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::ScriptedPrintParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in PrintManagerHost.ScriptedPrint request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("ScriptedPrint");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintManagerHost_ScriptedPrint_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PrintManagerHostProxy::ShowInvalidPrinterSettingsError(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "printing::mojom::PrintManagerHost::ShowInvalidPrinterSettingsError");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintManagerHost_ShowInvalidPrinterSettingsError_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_ShowInvalidPrinterSettingsError_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("ShowInvalidPrinterSettingsError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PrintManagerHostProxy::PrintingFailed(
    int32_t in_cookie) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintManagerHost::PrintingFailed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookie"), in_cookie,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintManagerHost_PrintingFailed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_PrintingFailed_Params_Data> params(
          message);
  params.Allocate();
  params->cookie = in_cookie;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("PrintingFailed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
bool PrintManagerHostProxy::UpdatePrintSettings(
    int32_t param_cookie, ::base::Value param_job_settings, PrintPagesParamsPtr* out_param_current_settings, bool* out_param_canceled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "printing::mojom::PrintManagerHost::UpdatePrintSettings", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookie"), param_cookie,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("job_settings"), param_job_settings,
                        "<value of type ::base::Value>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintManagerHost_UpdatePrintSettings_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_UpdatePrintSettings_Params_Data> params(
          message);
  params.Allocate();
  params->cookie = param_cookie;
  mojo::internal::MessageFragment<
      typename decltype(params->job_settings)::BaseType> job_settings_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
      param_job_settings, job_settings_fragment);
  params->job_settings.Set(
      job_settings_fragment.is_null() ? nullptr : job_settings_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->job_settings.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null job_settings in PrintManagerHost.UpdatePrintSettings request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("UpdatePrintSettings");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintManagerHost_UpdatePrintSettings_HandleSyncResponse(
          &result, out_param_current_settings, out_param_canceled));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "printing::mojom::PrintManagerHost::UpdatePrintSettings", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("current_settings"), out_param_current_settings,
                        "<value of type PrintPagesParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("canceled"), out_param_canceled,
                        "<value of type bool>");
   });
#endif
  return result;
}

void PrintManagerHostProxy::UpdatePrintSettings(
    int32_t in_cookie, ::base::Value in_job_settings, UpdatePrintSettingsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintManagerHost::UpdatePrintSettings", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookie"), in_cookie,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("job_settings"), in_job_settings,
                        "<value of type ::base::Value>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintManagerHost_UpdatePrintSettings_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_UpdatePrintSettings_Params_Data> params(
          message);
  params.Allocate();
  params->cookie = in_cookie;
  mojo::internal::MessageFragment<
      typename decltype(params->job_settings)::BaseType> job_settings_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
      in_job_settings, job_settings_fragment);
  params->job_settings.Set(
      job_settings_fragment.is_null() ? nullptr : job_settings_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->job_settings.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null job_settings in PrintManagerHost.UpdatePrintSettings request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("UpdatePrintSettings");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintManagerHost_UpdatePrintSettings_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool PrintManagerHostProxy::SetupScriptedPrintPreview(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "printing::mojom::PrintManagerHost::SetupScriptedPrintPreview");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintManagerHost_SetupScriptedPrintPreview_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_SetupScriptedPrintPreview_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("SetupScriptedPrintPreview");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintManagerHost_SetupScriptedPrintPreview_HandleSyncResponse(
          &result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "printing::mojom::PrintManagerHost::SetupScriptedPrintPreview");
#endif
  return result;
}

void PrintManagerHostProxy::SetupScriptedPrintPreview(
    SetupScriptedPrintPreviewCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "printing::mojom::PrintManagerHost::SetupScriptedPrintPreview");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintManagerHost_SetupScriptedPrintPreview_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_SetupScriptedPrintPreview_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("SetupScriptedPrintPreview");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintManagerHost_SetupScriptedPrintPreview_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PrintManagerHostProxy::ShowScriptedPrintPreview(
    bool in_is_modifiable) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintManagerHost::ShowScriptedPrintPreview", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_modifiable"), in_is_modifiable,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintManagerHost_ShowScriptedPrintPreview_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_ShowScriptedPrintPreview_Params_Data> params(
          message);
  params.Allocate();
  params->is_modifiable = in_is_modifiable;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("ShowScriptedPrintPreview");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PrintManagerHostProxy::RequestPrintPreview(
    RequestPrintPreviewParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintManagerHost::RequestPrintPreview", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type RequestPrintPreviewParamsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintManagerHost_RequestPrintPreview_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_RequestPrintPreview_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::RequestPrintPreviewParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in PrintManagerHost.RequestPrintPreview request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("RequestPrintPreview");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
bool PrintManagerHostProxy::CheckForCancel(
    int32_t param_preview_ui_id, int32_t param_request_id, bool* out_param_cancel) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "printing::mojom::PrintManagerHost::CheckForCancel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("preview_ui_id"), param_preview_ui_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), param_request_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintManagerHost_CheckForCancel_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_CheckForCancel_Params_Data> params(
          message);
  params.Allocate();
  params->preview_ui_id = param_preview_ui_id;
  params->request_id = param_request_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("CheckForCancel");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintManagerHost_CheckForCancel_HandleSyncResponse(
          &result, out_param_cancel));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "printing::mojom::PrintManagerHost::CheckForCancel", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cancel"), out_param_cancel,
                        "<value of type bool>");
   });
#endif
  return result;
}

void PrintManagerHostProxy::CheckForCancel(
    int32_t in_preview_ui_id, int32_t in_request_id, CheckForCancelCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintManagerHost::CheckForCancel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("preview_ui_id"), in_preview_ui_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintManagerHost_CheckForCancel_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_CheckForCancel_Params_Data> params(
          message);
  params.Allocate();
  params->preview_ui_id = in_preview_ui_id;
  params->request_id = in_request_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("CheckForCancel");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintManagerHost_CheckForCancel_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PrintManagerHostProxy::MetafileReadyForPrinting(
    DidPreviewDocumentParamsPtr in_params, int32_t in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintManagerHost::MetafileReadyForPrinting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type DidPreviewDocumentParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintManagerHost_MetafileReadyForPrinting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_MetafileReadyForPrinting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::DidPreviewDocumentParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in PrintManagerHost.MetafileReadyForPrinting request");
  params->request_id = in_request_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("MetafileReadyForPrinting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PrintManagerHostProxy::SetAccessibilityTree(
    int32_t in_cookie, const ::ui::AXTreeUpdate& in_accessibility_tree) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintManagerHost::SetAccessibilityTree", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookie"), in_cookie,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("accessibility_tree"), in_accessibility_tree,
                        "<value of type const ::ui::AXTreeUpdate&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintManagerHost_SetAccessibilityTree_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_SetAccessibilityTree_Params_Data> params(
          message);
  params.Allocate();
  params->cookie = in_cookie;
  mojo::internal::MessageFragment<
      typename decltype(params->accessibility_tree)::BaseType> accessibility_tree_fragment(
          params.message());
  mojo::internal::Serialize<::ax::mojom::AXTreeUpdateDataView>(
      in_accessibility_tree, accessibility_tree_fragment);
  params->accessibility_tree.Set(
      accessibility_tree_fragment.is_null() ? nullptr : accessibility_tree_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->accessibility_tree.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null accessibility_tree in PrintManagerHost.SetAccessibilityTree request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("SetAccessibilityTree");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class PrintManagerHost_GetDefaultPrintSettings_ProxyToResponder {
 public:
  static PrintManagerHost::GetDefaultPrintSettingsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PrintManagerHost_GetDefaultPrintSettings_ProxyToResponder> proxy(
        new PrintManagerHost_GetDefaultPrintSettings_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PrintManagerHost_GetDefaultPrintSettings_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PrintManagerHost_GetDefaultPrintSettings_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PrintManagerHost_GetDefaultPrintSettings_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PrintManagerHost::GetDefaultPrintSettingsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PrintParamsPtr in_default_settings);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PrintManagerHost_GetDefaultPrintSettings_ProxyToResponder);
};

bool PrintManagerHost_GetDefaultPrintSettings_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "printing::mojom::PrintManagerHost::GetDefaultPrintSettingsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PrintManagerHost_GetDefaultPrintSettings_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintManagerHost_GetDefaultPrintSettings_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  PrintParamsPtr p_default_settings{};
  PrintManagerHost_GetDefaultPrintSettings_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDefaultSettings(&p_default_settings))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintManagerHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_default_settings));
  return true;
}

void PrintManagerHost_GetDefaultPrintSettings_ProxyToResponder::Run(
    PrintParamsPtr in_default_settings) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)printing::mojom::PrintManagerHost::GetDefaultPrintSettingsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("default_settings"), in_default_settings,
                        "<value of type PrintParamsPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintManagerHost_GetDefaultPrintSettings_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_GetDefaultPrintSettings_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->default_settings)::BaseType> default_settings_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::PrintParamsDataView>(
      in_default_settings, default_settings_fragment);
  params->default_settings.Set(
      default_settings_fragment.is_null() ? nullptr : default_settings_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->default_settings.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null default_settings in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)printing::mojom::PrintManagerHost::GetDefaultPrintSettingsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("GetDefaultPrintSettings");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool PrintManagerHost_GetDefaultPrintSettings_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::PrintManagerHost_GetDefaultPrintSettings_ResponseParams_Data* params =
      reinterpret_cast<internal::PrintManagerHost_GetDefaultPrintSettings_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  PrintParamsPtr p_default_settings{};
  PrintManagerHost_GetDefaultPrintSettings_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDefaultSettings(&p_default_settings))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintManagerHost::Name_, 1, true);
    return false;
  }
  *out_default_settings_ = std::move(p_default_settings);
  *result_ = true;
  return true;
}
class PrintManagerHost_DidPrintDocument_ProxyToResponder {
 public:
  static PrintManagerHost::DidPrintDocumentCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PrintManagerHost_DidPrintDocument_ProxyToResponder> proxy(
        new PrintManagerHost_DidPrintDocument_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PrintManagerHost_DidPrintDocument_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PrintManagerHost_DidPrintDocument_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PrintManagerHost_DidPrintDocument_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PrintManagerHost::DidPrintDocumentCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_completed);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PrintManagerHost_DidPrintDocument_ProxyToResponder);
};

bool PrintManagerHost_DidPrintDocument_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "printing::mojom::PrintManagerHost::DidPrintDocumentCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PrintManagerHost_DidPrintDocument_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintManagerHost_DidPrintDocument_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_completed{};
  PrintManagerHost_DidPrintDocument_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_completed = input_data_view.completed();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintManagerHost::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_completed));
  return true;
}

void PrintManagerHost_DidPrintDocument_ProxyToResponder::Run(
    bool in_completed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)printing::mojom::PrintManagerHost::DidPrintDocumentCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("completed"), in_completed,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintManagerHost_DidPrintDocument_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_DidPrintDocument_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->completed = in_completed;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)printing::mojom::PrintManagerHost::DidPrintDocumentCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("DidPrintDocument");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool PrintManagerHost_DidPrintDocument_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::PrintManagerHost_DidPrintDocument_ResponseParams_Data* params =
      reinterpret_cast<internal::PrintManagerHost_DidPrintDocument_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  bool p_completed{};
  PrintManagerHost_DidPrintDocument_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_completed = input_data_view.completed();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintManagerHost::Name_, 3, true);
    return false;
  }
  *out_completed_ = std::move(p_completed);
  *result_ = true;
  return true;
}
class PrintManagerHost_ScriptedPrint_ProxyToResponder {
 public:
  static PrintManagerHost::ScriptedPrintCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PrintManagerHost_ScriptedPrint_ProxyToResponder> proxy(
        new PrintManagerHost_ScriptedPrint_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PrintManagerHost_ScriptedPrint_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PrintManagerHost_ScriptedPrint_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PrintManagerHost_ScriptedPrint_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PrintManagerHost::ScriptedPrintCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PrintPagesParamsPtr in_settings);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PrintManagerHost_ScriptedPrint_ProxyToResponder);
};

bool PrintManagerHost_ScriptedPrint_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "printing::mojom::PrintManagerHost::ScriptedPrintCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PrintManagerHost_ScriptedPrint_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintManagerHost_ScriptedPrint_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  PrintPagesParamsPtr p_settings{};
  PrintManagerHost_ScriptedPrint_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSettings(&p_settings))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintManagerHost::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_settings));
  return true;
}

void PrintManagerHost_ScriptedPrint_ProxyToResponder::Run(
    PrintPagesParamsPtr in_settings) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)printing::mojom::PrintManagerHost::ScriptedPrintCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("settings"), in_settings,
                        "<value of type PrintPagesParamsPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintManagerHost_ScriptedPrint_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_ScriptedPrint_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->settings)::BaseType> settings_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::PrintPagesParamsDataView>(
      in_settings, settings_fragment);
  params->settings.Set(
      settings_fragment.is_null() ? nullptr : settings_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->settings.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null settings in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)printing::mojom::PrintManagerHost::ScriptedPrintCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("ScriptedPrint");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool PrintManagerHost_ScriptedPrint_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::PrintManagerHost_ScriptedPrint_ResponseParams_Data* params =
      reinterpret_cast<internal::PrintManagerHost_ScriptedPrint_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  PrintPagesParamsPtr p_settings{};
  PrintManagerHost_ScriptedPrint_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSettings(&p_settings))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintManagerHost::Name_, 4, true);
    return false;
  }
  *out_settings_ = std::move(p_settings);
  *result_ = true;
  return true;
}
class PrintManagerHost_UpdatePrintSettings_ProxyToResponder {
 public:
  static PrintManagerHost::UpdatePrintSettingsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PrintManagerHost_UpdatePrintSettings_ProxyToResponder> proxy(
        new PrintManagerHost_UpdatePrintSettings_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PrintManagerHost_UpdatePrintSettings_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PrintManagerHost_UpdatePrintSettings_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PrintManagerHost_UpdatePrintSettings_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PrintManagerHost::UpdatePrintSettingsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PrintPagesParamsPtr in_current_settings, bool in_canceled);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PrintManagerHost_UpdatePrintSettings_ProxyToResponder);
};

bool PrintManagerHost_UpdatePrintSettings_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "printing::mojom::PrintManagerHost::UpdatePrintSettingsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PrintManagerHost_UpdatePrintSettings_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintManagerHost_UpdatePrintSettings_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  PrintPagesParamsPtr p_current_settings{};
  bool p_canceled{};
  PrintManagerHost_UpdatePrintSettings_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCurrentSettings(&p_current_settings))
    success = false;
  if (success)
    p_canceled = input_data_view.canceled();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintManagerHost::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_current_settings), 
std::move(p_canceled));
  return true;
}

void PrintManagerHost_UpdatePrintSettings_ProxyToResponder::Run(
    PrintPagesParamsPtr in_current_settings, bool in_canceled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)printing::mojom::PrintManagerHost::UpdatePrintSettingsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("current_settings"), in_current_settings,
                        "<value of type PrintPagesParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("canceled"), in_canceled,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintManagerHost_UpdatePrintSettings_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_UpdatePrintSettings_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->current_settings)::BaseType> current_settings_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::PrintPagesParamsDataView>(
      in_current_settings, current_settings_fragment);
  params->current_settings.Set(
      current_settings_fragment.is_null() ? nullptr : current_settings_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->current_settings.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null current_settings in ");
  params->canceled = in_canceled;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)printing::mojom::PrintManagerHost::UpdatePrintSettingsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("UpdatePrintSettings");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool PrintManagerHost_UpdatePrintSettings_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::PrintManagerHost_UpdatePrintSettings_ResponseParams_Data* params =
      reinterpret_cast<internal::PrintManagerHost_UpdatePrintSettings_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  PrintPagesParamsPtr p_current_settings{};
  bool p_canceled{};
  PrintManagerHost_UpdatePrintSettings_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCurrentSettings(&p_current_settings))
    success = false;
  if (success)
    p_canceled = input_data_view.canceled();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintManagerHost::Name_, 7, true);
    return false;
  }
  *out_current_settings_ = std::move(p_current_settings);
  *out_canceled_ = std::move(p_canceled);
  *result_ = true;
  return true;
}
class PrintManagerHost_SetupScriptedPrintPreview_ProxyToResponder {
 public:
  static PrintManagerHost::SetupScriptedPrintPreviewCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PrintManagerHost_SetupScriptedPrintPreview_ProxyToResponder> proxy(
        new PrintManagerHost_SetupScriptedPrintPreview_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PrintManagerHost_SetupScriptedPrintPreview_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PrintManagerHost_SetupScriptedPrintPreview_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PrintManagerHost_SetupScriptedPrintPreview_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PrintManagerHost::SetupScriptedPrintPreviewCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PrintManagerHost_SetupScriptedPrintPreview_ProxyToResponder);
};

bool PrintManagerHost_SetupScriptedPrintPreview_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "printing::mojom::PrintManagerHost::SetupScriptedPrintPreviewCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PrintManagerHost_SetupScriptedPrintPreview_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintManagerHost_SetupScriptedPrintPreview_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  PrintManagerHost_SetupScriptedPrintPreview_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintManagerHost::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void PrintManagerHost_SetupScriptedPrintPreview_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)printing::mojom::PrintManagerHost::SetupScriptedPrintPreviewCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintManagerHost_SetupScriptedPrintPreview_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_SetupScriptedPrintPreview_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)printing::mojom::PrintManagerHost::SetupScriptedPrintPreviewCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("SetupScriptedPrintPreview");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool PrintManagerHost_SetupScriptedPrintPreview_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::PrintManagerHost_SetupScriptedPrintPreview_ResponseParams_Data* params =
      reinterpret_cast<internal::PrintManagerHost_SetupScriptedPrintPreview_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  PrintManagerHost_SetupScriptedPrintPreview_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintManagerHost::Name_, 8, true);
    return false;
  }
  *result_ = true;
  return true;
}
class PrintManagerHost_CheckForCancel_ProxyToResponder {
 public:
  static PrintManagerHost::CheckForCancelCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PrintManagerHost_CheckForCancel_ProxyToResponder> proxy(
        new PrintManagerHost_CheckForCancel_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PrintManagerHost_CheckForCancel_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PrintManagerHost_CheckForCancel_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PrintManagerHost_CheckForCancel_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PrintManagerHost::CheckForCancelCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_cancel);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PrintManagerHost_CheckForCancel_ProxyToResponder);
};

bool PrintManagerHost_CheckForCancel_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "printing::mojom::PrintManagerHost::CheckForCancelCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PrintManagerHost_CheckForCancel_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintManagerHost_CheckForCancel_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_cancel{};
  PrintManagerHost_CheckForCancel_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_cancel = input_data_view.cancel();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintManagerHost::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_cancel));
  return true;
}

void PrintManagerHost_CheckForCancel_ProxyToResponder::Run(
    bool in_cancel) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)printing::mojom::PrintManagerHost::CheckForCancelCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cancel"), in_cancel,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPrintManagerHost_CheckForCancel_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_CheckForCancel_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->cancel = in_cancel;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)printing::mojom::PrintManagerHost::CheckForCancelCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("CheckForCancel");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool PrintManagerHost_CheckForCancel_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::PrintManagerHost_CheckForCancel_ResponseParams_Data* params =
      reinterpret_cast<internal::PrintManagerHost_CheckForCancel_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  bool p_cancel{};
  PrintManagerHost_CheckForCancel_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_cancel = input_data_view.cancel();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintManagerHost::Name_, 11, true);
    return false;
  }
  *out_cancel_ = std::move(p_cancel);
  *result_ = true;
  return true;
}

// static
bool PrintManagerHostStubDispatch::Accept(
    PrintManagerHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPrintManagerHost_DidGetPrintedPagesCount_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintManagerHost::DidGetPrintedPagesCount",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintManagerHost::DidGetPrintedPagesCount");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrintManagerHost_DidGetPrintedPagesCount_Params_Data* params =
          reinterpret_cast<internal::PrintManagerHost_DidGetPrintedPagesCount_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_cookie{};
      uint32_t p_number_pages{};
      PrintManagerHost_DidGetPrintedPagesCount_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_cookie = input_data_view.cookie();
      if (success)
        p_number_pages = input_data_view.number_pages();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintManagerHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidGetPrintedPagesCount(
std::move(p_cookie), 
std::move(p_number_pages));
      return true;
    }
    case internal::kPrintManagerHost_GetDefaultPrintSettings_Name: {
      break;
    }
    case internal::kPrintManagerHost_DidShowPrintDialog_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintManagerHost::DidShowPrintDialog",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintManagerHost::DidShowPrintDialog");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrintManagerHost_DidShowPrintDialog_Params_Data* params =
          reinterpret_cast<internal::PrintManagerHost_DidShowPrintDialog_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PrintManagerHost_DidShowPrintDialog_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintManagerHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidShowPrintDialog();
      return true;
    }
    case internal::kPrintManagerHost_DidPrintDocument_Name: {
      break;
    }
    case internal::kPrintManagerHost_ScriptedPrint_Name: {
      break;
    }
    case internal::kPrintManagerHost_ShowInvalidPrinterSettingsError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintManagerHost::ShowInvalidPrinterSettingsError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintManagerHost::ShowInvalidPrinterSettingsError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrintManagerHost_ShowInvalidPrinterSettingsError_Params_Data* params =
          reinterpret_cast<internal::PrintManagerHost_ShowInvalidPrinterSettingsError_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PrintManagerHost_ShowInvalidPrinterSettingsError_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintManagerHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowInvalidPrinterSettingsError();
      return true;
    }
    case internal::kPrintManagerHost_PrintingFailed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintManagerHost::PrintingFailed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintManagerHost::PrintingFailed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrintManagerHost_PrintingFailed_Params_Data* params =
          reinterpret_cast<internal::PrintManagerHost_PrintingFailed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_cookie{};
      PrintManagerHost_PrintingFailed_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_cookie = input_data_view.cookie();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintManagerHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrintingFailed(
std::move(p_cookie));
      return true;
    }
    case internal::kPrintManagerHost_UpdatePrintSettings_Name: {
      break;
    }
    case internal::kPrintManagerHost_SetupScriptedPrintPreview_Name: {
      break;
    }
    case internal::kPrintManagerHost_ShowScriptedPrintPreview_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintManagerHost::ShowScriptedPrintPreview",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintManagerHost::ShowScriptedPrintPreview");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrintManagerHost_ShowScriptedPrintPreview_Params_Data* params =
          reinterpret_cast<internal::PrintManagerHost_ShowScriptedPrintPreview_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_is_modifiable{};
      PrintManagerHost_ShowScriptedPrintPreview_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_modifiable = input_data_view.is_modifiable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintManagerHost::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowScriptedPrintPreview(
std::move(p_is_modifiable));
      return true;
    }
    case internal::kPrintManagerHost_RequestPrintPreview_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintManagerHost::RequestPrintPreview",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintManagerHost::RequestPrintPreview");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrintManagerHost_RequestPrintPreview_Params_Data* params =
          reinterpret_cast<internal::PrintManagerHost_RequestPrintPreview_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RequestPrintPreviewParamsPtr p_params{};
      PrintManagerHost_RequestPrintPreview_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintManagerHost::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestPrintPreview(
std::move(p_params));
      return true;
    }
    case internal::kPrintManagerHost_CheckForCancel_Name: {
      break;
    }
    case internal::kPrintManagerHost_MetafileReadyForPrinting_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintManagerHost::MetafileReadyForPrinting",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintManagerHost::MetafileReadyForPrinting");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrintManagerHost_MetafileReadyForPrinting_Params_Data* params =
          reinterpret_cast<internal::PrintManagerHost_MetafileReadyForPrinting_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      DidPreviewDocumentParamsPtr p_params{};
      int32_t p_request_id{};
      PrintManagerHost_MetafileReadyForPrinting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success)
        p_request_id = input_data_view.request_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintManagerHost::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MetafileReadyForPrinting(
std::move(p_params), 
std::move(p_request_id));
      return true;
    }
    case internal::kPrintManagerHost_SetAccessibilityTree_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintManagerHost::SetAccessibilityTree",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintManagerHost::SetAccessibilityTree");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrintManagerHost_SetAccessibilityTree_Params_Data* params =
          reinterpret_cast<internal::PrintManagerHost_SetAccessibilityTree_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_cookie{};
      ::ui::AXTreeUpdate p_accessibility_tree{};
      PrintManagerHost_SetAccessibilityTree_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_cookie = input_data_view.cookie();
      if (success && !input_data_view.ReadAccessibilityTree(&p_accessibility_tree))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintManagerHost::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAccessibilityTree(
std::move(p_cookie), 
std::move(p_accessibility_tree));
      return true;
    }
  }
  return false;
}

// static
bool PrintManagerHostStubDispatch::AcceptWithResponder(
    PrintManagerHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPrintManagerHost_DidGetPrintedPagesCount_Name: {
      break;
    }
    case internal::kPrintManagerHost_GetDefaultPrintSettings_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintManagerHost::GetDefaultPrintSettings",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintManagerHost::GetDefaultPrintSettings");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PrintManagerHost_GetDefaultPrintSettings_Params_Data* params =
          reinterpret_cast<
              internal::PrintManagerHost_GetDefaultPrintSettings_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      PrintManagerHost_GetDefaultPrintSettings_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintManagerHost::Name_, 1, false);
        return false;
      }
      PrintManagerHost::GetDefaultPrintSettingsCallback callback =
          PrintManagerHost_GetDefaultPrintSettings_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDefaultPrintSettings(std::move(callback));
      return true;
    }
    case internal::kPrintManagerHost_DidShowPrintDialog_Name: {
      break;
    }
    case internal::kPrintManagerHost_DidPrintDocument_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintManagerHost::DidPrintDocument",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintManagerHost::DidPrintDocument");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PrintManagerHost_DidPrintDocument_Params_Data* params =
          reinterpret_cast<
              internal::PrintManagerHost_DidPrintDocument_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      DidPrintDocumentParamsPtr p_params{};
      PrintManagerHost_DidPrintDocument_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintManagerHost::Name_, 3, false);
        return false;
      }
      PrintManagerHost::DidPrintDocumentCallback callback =
          PrintManagerHost_DidPrintDocument_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidPrintDocument(
std::move(p_params), std::move(callback));
      return true;
    }
    case internal::kPrintManagerHost_ScriptedPrint_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintManagerHost::ScriptedPrint",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintManagerHost::ScriptedPrint");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PrintManagerHost_ScriptedPrint_Params_Data* params =
          reinterpret_cast<
              internal::PrintManagerHost_ScriptedPrint_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ScriptedPrintParamsPtr p_params{};
      PrintManagerHost_ScriptedPrint_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintManagerHost::Name_, 4, false);
        return false;
      }
      PrintManagerHost::ScriptedPrintCallback callback =
          PrintManagerHost_ScriptedPrint_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ScriptedPrint(
std::move(p_params), std::move(callback));
      return true;
    }
    case internal::kPrintManagerHost_ShowInvalidPrinterSettingsError_Name: {
      break;
    }
    case internal::kPrintManagerHost_PrintingFailed_Name: {
      break;
    }
    case internal::kPrintManagerHost_UpdatePrintSettings_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintManagerHost::UpdatePrintSettings",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintManagerHost::UpdatePrintSettings");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PrintManagerHost_UpdatePrintSettings_Params_Data* params =
          reinterpret_cast<
              internal::PrintManagerHost_UpdatePrintSettings_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int32_t p_cookie{};
      ::base::Value p_job_settings{};
      PrintManagerHost_UpdatePrintSettings_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_cookie = input_data_view.cookie();
      if (success && !input_data_view.ReadJobSettings(&p_job_settings))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintManagerHost::Name_, 7, false);
        return false;
      }
      PrintManagerHost::UpdatePrintSettingsCallback callback =
          PrintManagerHost_UpdatePrintSettings_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdatePrintSettings(
std::move(p_cookie), 
std::move(p_job_settings), std::move(callback));
      return true;
    }
    case internal::kPrintManagerHost_SetupScriptedPrintPreview_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintManagerHost::SetupScriptedPrintPreview",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintManagerHost::SetupScriptedPrintPreview");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PrintManagerHost_SetupScriptedPrintPreview_Params_Data* params =
          reinterpret_cast<
              internal::PrintManagerHost_SetupScriptedPrintPreview_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      PrintManagerHost_SetupScriptedPrintPreview_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintManagerHost::Name_, 8, false);
        return false;
      }
      PrintManagerHost::SetupScriptedPrintPreviewCallback callback =
          PrintManagerHost_SetupScriptedPrintPreview_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetupScriptedPrintPreview(std::move(callback));
      return true;
    }
    case internal::kPrintManagerHost_ShowScriptedPrintPreview_Name: {
      break;
    }
    case internal::kPrintManagerHost_RequestPrintPreview_Name: {
      break;
    }
    case internal::kPrintManagerHost_CheckForCancel_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintManagerHost::CheckForCancel",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintManagerHost::CheckForCancel");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PrintManagerHost_CheckForCancel_Params_Data* params =
          reinterpret_cast<
              internal::PrintManagerHost_CheckForCancel_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int32_t p_preview_ui_id{};
      int32_t p_request_id{};
      PrintManagerHost_CheckForCancel_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_preview_ui_id = input_data_view.preview_ui_id();
      if (success)
        p_request_id = input_data_view.request_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintManagerHost::Name_, 11, false);
        return false;
      }
      PrintManagerHost::CheckForCancelCallback callback =
          PrintManagerHost_CheckForCancel_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CheckForCancel(
std::move(p_preview_ui_id), 
std::move(p_request_id), std::move(callback));
      return true;
    }
    case internal::kPrintManagerHost_MetafileReadyForPrinting_Name: {
      break;
    }
    case internal::kPrintManagerHost_SetAccessibilityTree_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPrintManagerHostValidationInfo[] = {
    {internal::kPrintManagerHost_DidGetPrintedPagesCount_Name,
     {&internal::PrintManagerHost_DidGetPrintedPagesCount_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPrintManagerHost_GetDefaultPrintSettings_Name,
     {&internal::PrintManagerHost_GetDefaultPrintSettings_Params_Data::Validate,
      &internal::PrintManagerHost_GetDefaultPrintSettings_ResponseParams_Data::Validate}},
    {internal::kPrintManagerHost_DidShowPrintDialog_Name,
     {&internal::PrintManagerHost_DidShowPrintDialog_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPrintManagerHost_DidPrintDocument_Name,
     {&internal::PrintManagerHost_DidPrintDocument_Params_Data::Validate,
      &internal::PrintManagerHost_DidPrintDocument_ResponseParams_Data::Validate}},
    {internal::kPrintManagerHost_ScriptedPrint_Name,
     {&internal::PrintManagerHost_ScriptedPrint_Params_Data::Validate,
      &internal::PrintManagerHost_ScriptedPrint_ResponseParams_Data::Validate}},
    {internal::kPrintManagerHost_ShowInvalidPrinterSettingsError_Name,
     {&internal::PrintManagerHost_ShowInvalidPrinterSettingsError_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPrintManagerHost_PrintingFailed_Name,
     {&internal::PrintManagerHost_PrintingFailed_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPrintManagerHost_UpdatePrintSettings_Name,
     {&internal::PrintManagerHost_UpdatePrintSettings_Params_Data::Validate,
      &internal::PrintManagerHost_UpdatePrintSettings_ResponseParams_Data::Validate}},
    {internal::kPrintManagerHost_SetupScriptedPrintPreview_Name,
     {&internal::PrintManagerHost_SetupScriptedPrintPreview_Params_Data::Validate,
      &internal::PrintManagerHost_SetupScriptedPrintPreview_ResponseParams_Data::Validate}},
    {internal::kPrintManagerHost_ShowScriptedPrintPreview_Name,
     {&internal::PrintManagerHost_ShowScriptedPrintPreview_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPrintManagerHost_RequestPrintPreview_Name,
     {&internal::PrintManagerHost_RequestPrintPreview_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPrintManagerHost_CheckForCancel_Name,
     {&internal::PrintManagerHost_CheckForCancel_Params_Data::Validate,
      &internal::PrintManagerHost_CheckForCancel_ResponseParams_Data::Validate}},
    {internal::kPrintManagerHost_MetafileReadyForPrinting_Name,
     {&internal::PrintManagerHost_MetafileReadyForPrinting_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPrintManagerHost_SetAccessibilityTree_Name,
     {&internal::PrintManagerHost_SetAccessibilityTree_Params_Data::Validate,
      nullptr /* no response */}},
};

bool PrintManagerHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::printing::mojom::PrintManagerHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPrintManagerHostValidationInfo);
}

bool PrintManagerHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::printing::mojom::PrintManagerHost::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kPrintManagerHostValidationInfo);

}
}  // namespace mojom
}  // namespace printing

namespace mojo {


// static
bool StructTraits<::printing::mojom::PreviewIds::DataView, ::printing::mojom::PreviewIdsPtr>::Read(
    ::printing::mojom::PreviewIds::DataView input,
    ::printing::mojom::PreviewIdsPtr* output) {
  bool success = true;
  ::printing::mojom::PreviewIdsPtr result(::printing::mojom::PreviewIds::New());
  
      if (success)
        result->request_id = input.request_id();
      if (success)
        result->ui_id = input.ui_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::printing::mojom::RequestPrintPreviewParams::DataView, ::printing::mojom::RequestPrintPreviewParamsPtr>::Read(
    ::printing::mojom::RequestPrintPreviewParams::DataView input,
    ::printing::mojom::RequestPrintPreviewParamsPtr* output) {
  bool success = true;
  ::printing::mojom::RequestPrintPreviewParamsPtr result(::printing::mojom::RequestPrintPreviewParams::New());
  
      if (success)
        result->is_from_arc = input.is_from_arc();
      if (success)
        result->is_modifiable = input.is_modifiable();
      if (success)
        result->webnode_only = input.webnode_only();
      if (success)
        result->has_selection = input.has_selection();
      if (success)
        result->selection_only = input.selection_only();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::printing::mojom::PrintFrameContentParams::DataView, ::printing::mojom::PrintFrameContentParamsPtr>::Read(
    ::printing::mojom::PrintFrameContentParams::DataView input,
    ::printing::mojom::PrintFrameContentParamsPtr* output) {
  bool success = true;
  ::printing::mojom::PrintFrameContentParamsPtr result(::printing::mojom::PrintFrameContentParams::New());
  
      if (success && !input.ReadPrintableArea(&result->printable_area))
        success = false;
      if (success)
        result->document_cookie = input.document_cookie();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::printing::mojom::OptionsFromDocumentParams::DataView, ::printing::mojom::OptionsFromDocumentParamsPtr>::Read(
    ::printing::mojom::OptionsFromDocumentParams::DataView input,
    ::printing::mojom::OptionsFromDocumentParamsPtr* output) {
  bool success = true;
  ::printing::mojom::OptionsFromDocumentParamsPtr result(::printing::mojom::OptionsFromDocumentParams::New());
  
      if (success)
        result->is_scaling_disabled = input.is_scaling_disabled();
      if (success)
        result->copies = input.copies();
      if (success && !input.ReadDuplex(&result->duplex))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::printing::mojom::DidPrintContentParams::DataView, ::printing::mojom::DidPrintContentParamsPtr>::Read(
    ::printing::mojom::DidPrintContentParams::DataView input,
    ::printing::mojom::DidPrintContentParamsPtr* output) {
  bool success = true;
  ::printing::mojom::DidPrintContentParamsPtr result(::printing::mojom::DidPrintContentParams::New());
  
      if (success && !input.ReadMetafileDataRegion(&result->metafile_data_region))
        success = false;
      if (success && !input.ReadSubframeContentInfo(&result->subframe_content_info))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::printing::mojom::DidStartPreviewParams::DataView, ::printing::mojom::DidStartPreviewParamsPtr>::Read(
    ::printing::mojom::DidStartPreviewParams::DataView input,
    ::printing::mojom::DidStartPreviewParamsPtr* output) {
  bool success = true;
  ::printing::mojom::DidStartPreviewParamsPtr result(::printing::mojom::DidStartPreviewParams::New());
  
      if (success)
        result->page_count = input.page_count();
      if (success && !input.ReadPagesToRender(&result->pages_to_render))
        success = false;
      if (success)
        result->pages_per_sheet = input.pages_per_sheet();
      if (success && !input.ReadPageSize(&result->page_size))
        success = false;
      if (success)
        result->fit_to_page_scaling = input.fit_to_page_scaling();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::printing::mojom::DidPreviewPageParams::DataView, ::printing::mojom::DidPreviewPageParamsPtr>::Read(
    ::printing::mojom::DidPreviewPageParams::DataView input,
    ::printing::mojom::DidPreviewPageParamsPtr* output) {
  bool success = true;
  ::printing::mojom::DidPreviewPageParamsPtr result(::printing::mojom::DidPreviewPageParams::New());
  
      if (success && !input.ReadContent(&result->content))
        success = false;
      if (success)
        result->page_number = input.page_number();
      if (success)
        result->document_cookie = input.document_cookie();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::printing::mojom::DidPreviewDocumentParams::DataView, ::printing::mojom::DidPreviewDocumentParamsPtr>::Read(
    ::printing::mojom::DidPreviewDocumentParams::DataView input,
    ::printing::mojom::DidPreviewDocumentParamsPtr* output) {
  bool success = true;
  ::printing::mojom::DidPreviewDocumentParamsPtr result(::printing::mojom::DidPreviewDocumentParams::New());
  
      if (success && !input.ReadContent(&result->content))
        success = false;
      if (success)
        result->document_cookie = input.document_cookie();
      if (success)
        result->expected_pages_count = input.expected_pages_count();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::printing::mojom::PrintParams::DataView, ::printing::mojom::PrintParamsPtr>::Read(
    ::printing::mojom::PrintParams::DataView input,
    ::printing::mojom::PrintParamsPtr* output) {
  bool success = true;
  ::printing::mojom::PrintParamsPtr result(::printing::mojom::PrintParams::New());
  
      if (success && !input.ReadPageSize(&result->page_size))
        success = false;
      if (success && !input.ReadContentSize(&result->content_size))
        success = false;
      if (success && !input.ReadPrintableArea(&result->printable_area))
        success = false;
      if (success)
        result->margin_top = input.margin_top();
      if (success)
        result->margin_left = input.margin_left();
      if (success && !input.ReadPageOrientation(&result->page_orientation))
        success = false;
      if (success && !input.ReadDpi(&result->dpi))
        success = false;
      if (success)
        result->scale_factor = input.scale_factor();
      if (success)
        result->document_cookie = input.document_cookie();
      if (success)
        result->selection_only = input.selection_only();
      if (success)
        result->supports_alpha_blend = input.supports_alpha_blend();
      if (success)
        result->preview_ui_id = input.preview_ui_id();
      if (success)
        result->preview_request_id = input.preview_request_id();
      if (success)
        result->is_first_request = input.is_first_request();
      if (success && !input.ReadPrintScalingOption(&result->print_scaling_option))
        success = false;
      if (success)
        result->print_to_pdf = input.print_to_pdf();
      if (success)
        result->display_header_footer = input.display_header_footer();
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadHeaderTemplate(&result->header_template))
        success = false;
      if (success && !input.ReadFooterTemplate(&result->footer_template))
        success = false;
      if (success)
        result->rasterize_pdf = input.rasterize_pdf();
      if (success)
        result->rasterize_pdf_dpi = input.rasterize_pdf_dpi();
      if (success)
        result->should_print_backgrounds = input.should_print_backgrounds();
      if (success && !input.ReadPrintedDocType(&result->printed_doc_type))
        success = false;
      if (success)
        result->prefer_css_page_size = input.prefer_css_page_size();
      if (success)
        result->pages_per_sheet = input.pages_per_sheet();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::printing::mojom::PrintPagesParams::DataView, ::printing::mojom::PrintPagesParamsPtr>::Read(
    ::printing::mojom::PrintPagesParams::DataView input,
    ::printing::mojom::PrintPagesParamsPtr* output) {
  bool success = true;
  ::printing::mojom::PrintPagesParamsPtr result(::printing::mojom::PrintPagesParams::New());
  
      if (success && !input.ReadParams(&result->params))
        success = false;
      if (success && !input.ReadPages(&result->pages))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::printing::mojom::DidPrintDocumentParams::DataView, ::printing::mojom::DidPrintDocumentParamsPtr>::Read(
    ::printing::mojom::DidPrintDocumentParams::DataView input,
    ::printing::mojom::DidPrintDocumentParamsPtr* output) {
  bool success = true;
  ::printing::mojom::DidPrintDocumentParamsPtr result(::printing::mojom::DidPrintDocumentParams::New());
  
      if (success && !input.ReadContent(&result->content))
        success = false;
      if (success)
        result->document_cookie = input.document_cookie();
      if (success && !input.ReadPageSize(&result->page_size))
        success = false;
      if (success && !input.ReadContentArea(&result->content_area))
        success = false;
      if (success && !input.ReadPhysicalOffsets(&result->physical_offsets))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::printing::mojom::ScriptedPrintParams::DataView, ::printing::mojom::ScriptedPrintParamsPtr>::Read(
    ::printing::mojom::ScriptedPrintParams::DataView input,
    ::printing::mojom::ScriptedPrintParamsPtr* output) {
  bool success = true;
  ::printing::mojom::ScriptedPrintParamsPtr result(::printing::mojom::ScriptedPrintParams::New());
  
      if (success)
        result->cookie = input.cookie();
      if (success)
        result->expected_pages_count = input.expected_pages_count();
      if (success)
        result->has_selection = input.has_selection();
      if (success)
        result->is_scripted = input.is_scripted();
      if (success)
        result->is_modifiable = input.is_modifiable();
      if (success && !input.ReadMarginType(&result->margin_type))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif