// components/services/app_service/public/mojom/types.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/app_service/public/mojom/types.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/app_service/public/mojom/types.mojom-params-data.h"
#include "components/services/app_service/public/mojom/types.mojom-shared-message-ids.h"

#include "components/services/app_service/public/mojom/types.mojom-import-headers.h"


#ifndef COMPONENTS_SERVICES_APP_SERVICE_PUBLIC_MOJOM_TYPES_MOJOM_JUMBO_H_
#define COMPONENTS_SERVICES_APP_SERVICE_PUBLIC_MOJOM_TYPES_MOJOM_JUMBO_H_
#endif
namespace apps {
namespace mojom {
constexpr uint64_t IconKey::kDoesNotChangeOverTime;
constexpr int32_t IconKey::kInvalidResourceId;
App::App()
    : app_type(),
      app_id(),
      readiness(),
      name(),
      short_name(),
      publisher_id(),
      description(),
      version(),
      additional_search_terms(),
      icon_key(),
      last_launch_time(),
      install_time(),
      permissions(),
      install_source(),
      is_platform_app(),
      recommendable(),
      searchable(),
      show_in_launcher(),
      show_in_shelf(),
      show_in_search(),
      show_in_management(),
      has_badge(),
      paused(),
      intent_filters(),
      resize_locked(),
      window_mode() {}

App::App(
    AppType app_type_in,
    const std::string& app_id_in,
    Readiness readiness_in,
    const absl::optional<std::string>& name_in,
    const absl::optional<std::string>& short_name_in,
    const absl::optional<std::string>& publisher_id_in,
    const absl::optional<std::string>& description_in,
    const absl::optional<std::string>& version_in,
    std::vector<std::string> additional_search_terms_in,
    IconKeyPtr icon_key_in,
    absl::optional<::base::Time> last_launch_time_in,
    absl::optional<::base::Time> install_time_in,
    std::vector<PermissionPtr> permissions_in,
    InstallSource install_source_in,
    OptionalBool is_platform_app_in,
    OptionalBool recommendable_in,
    OptionalBool searchable_in,
    OptionalBool show_in_launcher_in,
    OptionalBool show_in_shelf_in,
    OptionalBool show_in_search_in,
    OptionalBool show_in_management_in,
    OptionalBool has_badge_in,
    OptionalBool paused_in,
    std::vector<IntentFilterPtr> intent_filters_in,
    OptionalBool resize_locked_in,
    WindowMode window_mode_in)
    : app_type(std::move(app_type_in)),
      app_id(std::move(app_id_in)),
      readiness(std::move(readiness_in)),
      name(std::move(name_in)),
      short_name(std::move(short_name_in)),
      publisher_id(std::move(publisher_id_in)),
      description(std::move(description_in)),
      version(std::move(version_in)),
      additional_search_terms(std::move(additional_search_terms_in)),
      icon_key(std::move(icon_key_in)),
      last_launch_time(std::move(last_launch_time_in)),
      install_time(std::move(install_time_in)),
      permissions(std::move(permissions_in)),
      install_source(std::move(install_source_in)),
      is_platform_app(std::move(is_platform_app_in)),
      recommendable(std::move(recommendable_in)),
      searchable(std::move(searchable_in)),
      show_in_launcher(std::move(show_in_launcher_in)),
      show_in_shelf(std::move(show_in_shelf_in)),
      show_in_search(std::move(show_in_search_in)),
      show_in_management(std::move(show_in_management_in)),
      has_badge(std::move(has_badge_in)),
      paused(std::move(paused_in)),
      intent_filters(std::move(intent_filters_in)),
      resize_locked(std::move(resize_locked_in)),
      window_mode(std::move(window_mode_in)) {}

App::~App() = default;

void App::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "app_type"), this->app_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AppType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "app_id"), this->app_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "readiness"), this->readiness,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type Readiness>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "short_name"), this->short_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "publisher_id"), this->publisher_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description"), this->description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version"), this->version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "additional_search_terms"), this->additional_search_terms,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icon_key"), this->icon_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type IconKeyPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_launch_time"), this->last_launch_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<::base::Time>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "install_time"), this->install_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<::base::Time>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "permissions"), this->permissions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<PermissionPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "install_source"), this->install_source,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type InstallSource>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_platform_app"), this->is_platform_app,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type OptionalBool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "recommendable"), this->recommendable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type OptionalBool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "searchable"), this->searchable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type OptionalBool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_in_launcher"), this->show_in_launcher,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type OptionalBool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_in_shelf"), this->show_in_shelf,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type OptionalBool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_in_search"), this->show_in_search,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type OptionalBool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_in_management"), this->show_in_management,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type OptionalBool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_badge"), this->has_badge,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type OptionalBool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "paused"), this->paused,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type OptionalBool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "intent_filters"), this->intent_filters,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<IntentFilterPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resize_locked"), this->resize_locked,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type OptionalBool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "window_mode"), this->window_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WindowMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool App::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Permission::Permission()
    : permission_id(),
      value_type(),
      value(),
      is_managed() {}

Permission::Permission(
    uint32_t permission_id_in,
    PermissionValueType value_type_in,
    uint32_t value_in,
    bool is_managed_in)
    : permission_id(std::move(permission_id_in)),
      value_type(std::move(value_type_in)),
      value(std::move(value_in)),
      is_managed(std::move(is_managed_in)) {}

Permission::~Permission() = default;
size_t Permission::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->permission_id);
  seed = mojo::internal::Hash(seed, this->value_type);
  seed = mojo::internal::Hash(seed, this->value);
  seed = mojo::internal::Hash(seed, this->is_managed);
  return seed;
}

void Permission::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "permission_id"), this->permission_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value_type"), this->value_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PermissionValueType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_managed"), this->is_managed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Permission::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IconKey::IconKey()
    : timeline(),
      resource_id(),
      icon_effects() {}

IconKey::IconKey(
    uint64_t timeline_in,
    int32_t resource_id_in,
    uint32_t icon_effects_in)
    : timeline(std::move(timeline_in)),
      resource_id(std::move(resource_id_in)),
      icon_effects(std::move(icon_effects_in)) {}

IconKey::~IconKey() = default;
size_t IconKey::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->timeline);
  seed = mojo::internal::Hash(seed, this->resource_id);
  seed = mojo::internal::Hash(seed, this->icon_effects);
  return seed;
}

void IconKey::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timeline"), this->timeline,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resource_id"), this->resource_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icon_effects"), this->icon_effects,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IconKey::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IconValue::IconValue()
    : icon_type(),
      uncompressed(),
      compressed(),
      is_placeholder_icon() {}

IconValue::IconValue(
    IconType icon_type_in,
    const ::gfx::ImageSkia& uncompressed_in,
    absl::optional<std::vector<uint8_t>> compressed_in,
    bool is_placeholder_icon_in)
    : icon_type(std::move(icon_type_in)),
      uncompressed(std::move(uncompressed_in)),
      compressed(std::move(compressed_in)),
      is_placeholder_icon(std::move(is_placeholder_icon_in)) {}

IconValue::~IconValue() = default;

void IconValue::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icon_type"), this->icon_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type IconType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uncompressed"), this->uncompressed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::ImageSkia&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "compressed"), this->compressed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_placeholder_icon"), this->is_placeholder_icon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IconValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MenuItems::MenuItems()
    : items() {}

MenuItems::MenuItems(
    std::vector<MenuItemPtr> items_in)
    : items(std::move(items_in)) {}

MenuItems::~MenuItems() = default;

void MenuItems::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "items"), this->items,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<MenuItemPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MenuItems::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MenuItem::MenuItem()
    : type(),
      command_id(),
      string_id(),
      submenu(),
      radio_group_id(),
      shortcut_id(),
      label(),
      image() {}

MenuItem::MenuItem(
    MenuItemType type_in,
    int32_t command_id_in,
    int32_t string_id_in,
    std::vector<MenuItemPtr> submenu_in,
    int32_t radio_group_id_in,
    const std::string& shortcut_id_in,
    const std::string& label_in,
    const ::gfx::ImageSkia& image_in)
    : type(std::move(type_in)),
      command_id(std::move(command_id_in)),
      string_id(std::move(string_id_in)),
      submenu(std::move(submenu_in)),
      radio_group_id(std::move(radio_group_id_in)),
      shortcut_id(std::move(shortcut_id_in)),
      label(std::move(label_in)),
      image(std::move(image_in)) {}

MenuItem::~MenuItem() = default;

void MenuItem::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type MenuItemType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "command_id"), this->command_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "string_id"), this->string_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "submenu"), this->submenu,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<MenuItemPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "radio_group_id"), this->radio_group_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shortcut_id"), this->shortcut_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image"), this->image,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::ImageSkia&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MenuItem::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ConditionValue::ConditionValue()
    : value(),
      match_type() {}

ConditionValue::ConditionValue(
    const std::string& value_in,
    PatternMatchType match_type_in)
    : value(std::move(value_in)),
      match_type(std::move(match_type_in)) {}

ConditionValue::~ConditionValue() = default;
size_t ConditionValue::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->value);
  seed = mojo::internal::Hash(seed, this->match_type);
  return seed;
}

void ConditionValue::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "match_type"), this->match_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PatternMatchType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ConditionValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Condition::Condition()
    : condition_type(),
      condition_values() {}

Condition::Condition(
    ConditionType condition_type_in,
    std::vector<ConditionValuePtr> condition_values_in)
    : condition_type(std::move(condition_type_in)),
      condition_values(std::move(condition_values_in)) {}

Condition::~Condition() = default;

void Condition::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "condition_type"), this->condition_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ConditionType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "condition_values"), this->condition_values,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ConditionValuePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Condition::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IntentFilter::IntentFilter()
    : conditions(),
      activity_name(),
      activity_label() {}

IntentFilter::IntentFilter(
    std::vector<ConditionPtr> conditions_in,
    const absl::optional<std::string>& activity_name_in,
    const absl::optional<std::string>& activity_label_in)
    : conditions(std::move(conditions_in)),
      activity_name(std::move(activity_name_in)),
      activity_label(std::move(activity_label_in)) {}

IntentFilter::~IntentFilter() = default;

void IntentFilter::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "conditions"), this->conditions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ConditionPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "activity_name"), this->activity_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "activity_label"), this->activity_label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IntentFilter::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IntentFile::IntentFile()
    : url(),
      mime_type(),
      file_name(),
      file_size() {}

IntentFile::IntentFile(
    const ::GURL& url_in,
    const absl::optional<std::string>& mime_type_in,
    const absl::optional<std::string>& file_name_in,
    uint64_t file_size_in)
    : url(std::move(url_in)),
      mime_type(std::move(mime_type_in)),
      file_name(std::move(file_name_in)),
      file_size(std::move(file_size_in)) {}

IntentFile::~IntentFile() = default;

void IntentFile::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mime_type"), this->mime_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_name"), this->file_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_size"), this->file_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IntentFile::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Intent::Intent()
    : action(),
      url(),
      mime_type(),
      files(),
      activity_name(),
      drive_share_url(),
      share_text(),
      share_title(),
      start_type(),
      categories(),
      data(),
      ui_bypassed(),
      extras() {}

Intent::Intent(
    const absl::optional<std::string>& action_in,
    const absl::optional<::GURL>& url_in,
    const absl::optional<std::string>& mime_type_in,
    absl::optional<std::vector<IntentFilePtr>> files_in,
    const absl::optional<std::string>& activity_name_in,
    const absl::optional<::GURL>& drive_share_url_in,
    const absl::optional<std::string>& share_text_in,
    const absl::optional<std::string>& share_title_in,
    const absl::optional<std::string>& start_type_in,
    absl::optional<std::vector<std::string>> categories_in,
    const absl::optional<std::string>& data_in,
    OptionalBool ui_bypassed_in,
    const absl::optional<base::flat_map<std::string, std::string>>& extras_in)
    : action(std::move(action_in)),
      url(std::move(url_in)),
      mime_type(std::move(mime_type_in)),
      files(std::move(files_in)),
      activity_name(std::move(activity_name_in)),
      drive_share_url(std::move(drive_share_url_in)),
      share_text(std::move(share_text_in)),
      share_title(std::move(share_title_in)),
      start_type(std::move(start_type_in)),
      categories(std::move(categories_in)),
      data(std::move(data_in)),
      ui_bypassed(std::move(ui_bypassed_in)),
      extras(std::move(extras_in)) {}

Intent::~Intent() = default;

void Intent::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "action"), this->action,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mime_type"), this->mime_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "files"), this->files,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<std::vector<IntentFilePtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "activity_name"), this->activity_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "drive_share_url"), this->drive_share_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "share_text"), this->share_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "share_title"), this->share_title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start_type"), this->start_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "categories"), this->categories,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::vector<std::string>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ui_bypassed"), this->ui_bypassed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type OptionalBool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extras"), this->extras,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<base::flat_map<std::string, std::string>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Intent::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ReplacedAppPreferences::ReplacedAppPreferences()
    : replaced_preference() {}

ReplacedAppPreferences::ReplacedAppPreferences(
    base::flat_map<std::string, std::vector<IntentFilterPtr>> replaced_preference_in)
    : replaced_preference(std::move(replaced_preference_in)) {}

ReplacedAppPreferences::~ReplacedAppPreferences() = default;

void ReplacedAppPreferences::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "replaced_preference"), this->replaced_preference,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type base::flat_map<std::string, std::vector<IntentFilterPtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ReplacedAppPreferences::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PreferredApp::PreferredApp()
    : intent_filter(),
      app_id() {}

PreferredApp::PreferredApp(
    IntentFilterPtr intent_filter_in,
    const std::string& app_id_in)
    : intent_filter(std::move(intent_filter_in)),
      app_id(std::move(app_id_in)) {}

PreferredApp::~PreferredApp() = default;

void PreferredApp::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "intent_filter"), this->intent_filter,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type IntentFilterPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "app_id"), this->app_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PreferredApp::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FilePaths::FilePaths()
    : file_paths() {}

FilePaths::FilePaths(
    std::vector<::base::FilePath> file_paths_in)
    : file_paths(std::move(file_paths_in)) {}

FilePaths::~FilePaths() = default;

void FilePaths::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_paths"), this->file_paths,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::base::FilePath>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FilePaths::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CapabilityAccess::CapabilityAccess()
    : app_id(),
      camera(),
      microphone() {}

CapabilityAccess::CapabilityAccess(
    const std::string& app_id_in,
    OptionalBool camera_in,
    OptionalBool microphone_in)
    : app_id(std::move(app_id_in)),
      camera(std::move(camera_in)),
      microphone(std::move(microphone_in)) {}

CapabilityAccess::~CapabilityAccess() = default;
size_t CapabilityAccess::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->app_id);
  seed = mojo::internal::Hash(seed, this->camera);
  seed = mojo::internal::Hash(seed, this->microphone);
  return seed;
}

void CapabilityAccess::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "app_id"), this->app_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "camera"), this->camera,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type OptionalBool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "microphone"), this->microphone,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type OptionalBool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CapabilityAccess::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Rect::Rect()
    : x(),
      y(),
      width(),
      height() {}

Rect::Rect(
    int32_t x_in,
    int32_t y_in,
    int32_t width_in,
    int32_t height_in)
    : x(std::move(x_in)),
      y(std::move(y_in)),
      width(std::move(width_in)),
      height(std::move(height_in)) {}

Rect::~Rect() = default;
size_t Rect::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->x);
  seed = mojo::internal::Hash(seed, this->y);
  seed = mojo::internal::Hash(seed, this->width);
  seed = mojo::internal::Hash(seed, this->height);
  return seed;
}

void Rect::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "x"), this->x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "y"), this->y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "width"), this->width,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "height"), this->height,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Rect::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WindowInfo::WindowInfo()
    : window_id(-1),
      state(0),
      display_id(-1),
      bounds() {}

WindowInfo::WindowInfo(
    int32_t window_id_in,
    int32_t state_in,
    int64_t display_id_in,
    RectPtr bounds_in)
    : window_id(std::move(window_id_in)),
      state(std::move(state_in)),
      display_id(std::move(display_id_in)),
      bounds(std::move(bounds_in)) {}

WindowInfo::~WindowInfo() = default;

void WindowInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "window_id"), this->window_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "state"), this->state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_id"), this->display_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bounds"), this->bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type RectPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WindowInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace apps

namespace mojo {


// static
bool StructTraits<::apps::mojom::App::DataView, ::apps::mojom::AppPtr>::Read(
    ::apps::mojom::App::DataView input,
    ::apps::mojom::AppPtr* output) {
  bool success = true;
  ::apps::mojom::AppPtr result(::apps::mojom::App::New());
  
      if (success && !input.ReadAppType(&result->app_type))
        success = false;
      if (success && !input.ReadAppId(&result->app_id))
        success = false;
      if (success && !input.ReadReadiness(&result->readiness))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadShortName(&result->short_name))
        success = false;
      if (success && !input.ReadPublisherId(&result->publisher_id))
        success = false;
      if (success && !input.ReadDescription(&result->description))
        success = false;
      if (success && !input.ReadVersion(&result->version))
        success = false;
      if (success && !input.ReadAdditionalSearchTerms(&result->additional_search_terms))
        success = false;
      if (success && !input.ReadIconKey(&result->icon_key))
        success = false;
      if (success && !input.ReadLastLaunchTime(&result->last_launch_time))
        success = false;
      if (success && !input.ReadInstallTime(&result->install_time))
        success = false;
      if (success && !input.ReadPermissions(&result->permissions))
        success = false;
      if (success && !input.ReadInstallSource(&result->install_source))
        success = false;
      if (success && !input.ReadIsPlatformApp(&result->is_platform_app))
        success = false;
      if (success && !input.ReadRecommendable(&result->recommendable))
        success = false;
      if (success && !input.ReadSearchable(&result->searchable))
        success = false;
      if (success && !input.ReadShowInLauncher(&result->show_in_launcher))
        success = false;
      if (success && !input.ReadShowInShelf(&result->show_in_shelf))
        success = false;
      if (success && !input.ReadShowInSearch(&result->show_in_search))
        success = false;
      if (success && !input.ReadShowInManagement(&result->show_in_management))
        success = false;
      if (success && !input.ReadHasBadge(&result->has_badge))
        success = false;
      if (success && !input.ReadPaused(&result->paused))
        success = false;
      if (success && !input.ReadIntentFilters(&result->intent_filters))
        success = false;
      if (success && !input.ReadResizeLocked(&result->resize_locked))
        success = false;
      if (success && !input.ReadWindowMode(&result->window_mode))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::apps::mojom::Permission::DataView, ::apps::mojom::PermissionPtr>::Read(
    ::apps::mojom::Permission::DataView input,
    ::apps::mojom::PermissionPtr* output) {
  bool success = true;
  ::apps::mojom::PermissionPtr result(::apps::mojom::Permission::New());
  
      if (success)
        result->permission_id = input.permission_id();
      if (success && !input.ReadValueType(&result->value_type))
        success = false;
      if (success)
        result->value = input.value();
      if (success)
        result->is_managed = input.is_managed();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::apps::mojom::IconKey::DataView, ::apps::mojom::IconKeyPtr>::Read(
    ::apps::mojom::IconKey::DataView input,
    ::apps::mojom::IconKeyPtr* output) {
  bool success = true;
  ::apps::mojom::IconKeyPtr result(::apps::mojom::IconKey::New());
  
      if (success)
        result->timeline = input.timeline();
      if (success)
        result->resource_id = input.resource_id();
      if (success)
        result->icon_effects = input.icon_effects();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::apps::mojom::IconValue::DataView, ::apps::mojom::IconValuePtr>::Read(
    ::apps::mojom::IconValue::DataView input,
    ::apps::mojom::IconValuePtr* output) {
  bool success = true;
  ::apps::mojom::IconValuePtr result(::apps::mojom::IconValue::New());
  
      if (success && !input.ReadIconType(&result->icon_type))
        success = false;
      if (success && !input.ReadUncompressed(&result->uncompressed))
        success = false;
      if (success && !input.ReadCompressed(&result->compressed))
        success = false;
      if (success)
        result->is_placeholder_icon = input.is_placeholder_icon();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::apps::mojom::MenuItems::DataView, ::apps::mojom::MenuItemsPtr>::Read(
    ::apps::mojom::MenuItems::DataView input,
    ::apps::mojom::MenuItemsPtr* output) {
  bool success = true;
  ::apps::mojom::MenuItemsPtr result(::apps::mojom::MenuItems::New());
  
      if (success && !input.ReadItems(&result->items))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::apps::mojom::MenuItem::DataView, ::apps::mojom::MenuItemPtr>::Read(
    ::apps::mojom::MenuItem::DataView input,
    ::apps::mojom::MenuItemPtr* output) {
  bool success = true;
  ::apps::mojom::MenuItemPtr result(::apps::mojom::MenuItem::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success)
        result->command_id = input.command_id();
      if (success)
        result->string_id = input.string_id();
      if (success && !input.ReadSubmenu(&result->submenu))
        success = false;
      if (success)
        result->radio_group_id = input.radio_group_id();
      if (success && !input.ReadShortcutId(&result->shortcut_id))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
      if (success && !input.ReadImage(&result->image))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::apps::mojom::ConditionValue::DataView, ::apps::mojom::ConditionValuePtr>::Read(
    ::apps::mojom::ConditionValue::DataView input,
    ::apps::mojom::ConditionValuePtr* output) {
  bool success = true;
  ::apps::mojom::ConditionValuePtr result(::apps::mojom::ConditionValue::New());
  
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success && !input.ReadMatchType(&result->match_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::apps::mojom::Condition::DataView, ::apps::mojom::ConditionPtr>::Read(
    ::apps::mojom::Condition::DataView input,
    ::apps::mojom::ConditionPtr* output) {
  bool success = true;
  ::apps::mojom::ConditionPtr result(::apps::mojom::Condition::New());
  
      if (success && !input.ReadConditionType(&result->condition_type))
        success = false;
      if (success && !input.ReadConditionValues(&result->condition_values))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::apps::mojom::IntentFilter::DataView, ::apps::mojom::IntentFilterPtr>::Read(
    ::apps::mojom::IntentFilter::DataView input,
    ::apps::mojom::IntentFilterPtr* output) {
  bool success = true;
  ::apps::mojom::IntentFilterPtr result(::apps::mojom::IntentFilter::New());
  
      if (success && !input.ReadConditions(&result->conditions))
        success = false;
      if (success && !input.ReadActivityName(&result->activity_name))
        success = false;
      if (success && !input.ReadActivityLabel(&result->activity_label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::apps::mojom::IntentFile::DataView, ::apps::mojom::IntentFilePtr>::Read(
    ::apps::mojom::IntentFile::DataView input,
    ::apps::mojom::IntentFilePtr* output) {
  bool success = true;
  ::apps::mojom::IntentFilePtr result(::apps::mojom::IntentFile::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadMimeType(&result->mime_type))
        success = false;
      if (success && !input.ReadFileName(&result->file_name))
        success = false;
      if (success)
        result->file_size = input.file_size();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::apps::mojom::Intent::DataView, ::apps::mojom::IntentPtr>::Read(
    ::apps::mojom::Intent::DataView input,
    ::apps::mojom::IntentPtr* output) {
  bool success = true;
  ::apps::mojom::IntentPtr result(::apps::mojom::Intent::New());
  
      if (success && !input.ReadAction(&result->action))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadMimeType(&result->mime_type))
        success = false;
      if (success && !input.ReadFiles(&result->files))
        success = false;
      if (success && !input.ReadActivityName(&result->activity_name))
        success = false;
      if (success && !input.ReadDriveShareUrl(&result->drive_share_url))
        success = false;
      if (success && !input.ReadShareText(&result->share_text))
        success = false;
      if (success && !input.ReadShareTitle(&result->share_title))
        success = false;
      if (success && !input.ReadStartType(&result->start_type))
        success = false;
      if (success && !input.ReadCategories(&result->categories))
        success = false;
      if (success && !input.ReadData(&result->data))
        success = false;
      if (success && !input.ReadUiBypassed(&result->ui_bypassed))
        success = false;
      if (success && !input.ReadExtras(&result->extras))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::apps::mojom::ReplacedAppPreferences::DataView, ::apps::mojom::ReplacedAppPreferencesPtr>::Read(
    ::apps::mojom::ReplacedAppPreferences::DataView input,
    ::apps::mojom::ReplacedAppPreferencesPtr* output) {
  bool success = true;
  ::apps::mojom::ReplacedAppPreferencesPtr result(::apps::mojom::ReplacedAppPreferences::New());
  
      if (success && !input.ReadReplacedPreference(&result->replaced_preference))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::apps::mojom::PreferredApp::DataView, ::apps::mojom::PreferredAppPtr>::Read(
    ::apps::mojom::PreferredApp::DataView input,
    ::apps::mojom::PreferredAppPtr* output) {
  bool success = true;
  ::apps::mojom::PreferredAppPtr result(::apps::mojom::PreferredApp::New());
  
      if (success && !input.ReadIntentFilter(&result->intent_filter))
        success = false;
      if (success && !input.ReadAppId(&result->app_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::apps::mojom::FilePaths::DataView, ::apps::mojom::FilePathsPtr>::Read(
    ::apps::mojom::FilePaths::DataView input,
    ::apps::mojom::FilePathsPtr* output) {
  bool success = true;
  ::apps::mojom::FilePathsPtr result(::apps::mojom::FilePaths::New());
  
      if (success && !input.ReadFilePaths(&result->file_paths))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::apps::mojom::CapabilityAccess::DataView, ::apps::mojom::CapabilityAccessPtr>::Read(
    ::apps::mojom::CapabilityAccess::DataView input,
    ::apps::mojom::CapabilityAccessPtr* output) {
  bool success = true;
  ::apps::mojom::CapabilityAccessPtr result(::apps::mojom::CapabilityAccess::New());
  
      if (success && !input.ReadAppId(&result->app_id))
        success = false;
      if (success && !input.ReadCamera(&result->camera))
        success = false;
      if (success && !input.ReadMicrophone(&result->microphone))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::apps::mojom::Rect::DataView, ::apps::mojom::RectPtr>::Read(
    ::apps::mojom::Rect::DataView input,
    ::apps::mojom::RectPtr* output) {
  bool success = true;
  ::apps::mojom::RectPtr result(::apps::mojom::Rect::New());
  
      if (success)
        result->x = input.x();
      if (success)
        result->y = input.y();
      if (success)
        result->width = input.width();
      if (success)
        result->height = input.height();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::apps::mojom::WindowInfo::DataView, ::apps::mojom::WindowInfoPtr>::Read(
    ::apps::mojom::WindowInfo::DataView input,
    ::apps::mojom::WindowInfoPtr* output) {
  bool success = true;
  ::apps::mojom::WindowInfoPtr result(::apps::mojom::WindowInfo::New());
  
      if (success)
        result->window_id = input.window_id();
      if (success)
        result->state = input.state();
      if (success)
        result->display_id = input.display_id();
      if (success && !input.ReadBounds(&result->bounds))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif