// components/services/storage/public/mojom/cache_storage_control.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/storage/public/mojom/cache_storage_control.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/storage/public/mojom/cache_storage_control.mojom-params-data.h"
#include "components/services/storage/public/mojom/cache_storage_control.mojom-shared-message-ids.h"

#include "components/services/storage/public/mojom/cache_storage_control.mojom-import-headers.h"


#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_CACHE_STORAGE_CONTROL_MOJOM_JUMBO_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_CACHE_STORAGE_CONTROL_MOJOM_JUMBO_H_
#endif
namespace storage {
namespace mojom {
const char CacheStorageObserver::Name_[] = "storage.mojom.CacheStorageObserver";

CacheStorageObserverProxy::CacheStorageObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CacheStorageObserverProxy::OnCacheListChanged(
    const ::blink::StorageKey& in_storage_key) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::CacheStorageObserver::OnCacheListChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_key"), in_storage_key,
                        "<value of type const ::blink::StorageKey&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCacheStorageObserver_OnCacheListChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::CacheStorageObserver_OnCacheListChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->storage_key)::BaseType> storage_key_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
      in_storage_key, storage_key_fragment);
  params->storage_key.Set(
      storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->storage_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null storage_key in CacheStorageObserver.OnCacheListChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageObserver::Name_);
  message.set_method_name("OnCacheListChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CacheStorageObserverProxy::OnCacheContentChanged(
    const ::blink::StorageKey& in_storage_key, const std::string& in_cache_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::CacheStorageObserver::OnCacheContentChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_key"), in_storage_key,
                        "<value of type const ::blink::StorageKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cache_name"), in_cache_name,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCacheStorageObserver_OnCacheContentChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::CacheStorageObserver_OnCacheContentChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->storage_key)::BaseType> storage_key_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
      in_storage_key, storage_key_fragment);
  params->storage_key.Set(
      storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->storage_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null storage_key in CacheStorageObserver.OnCacheContentChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->cache_name)::BaseType> cache_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_cache_name, cache_name_fragment);
  params->cache_name.Set(
      cache_name_fragment.is_null() ? nullptr : cache_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cache_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cache_name in CacheStorageObserver.OnCacheContentChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageObserver::Name_);
  message.set_method_name("OnCacheContentChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool CacheStorageObserverStubDispatch::Accept(
    CacheStorageObserver* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kCacheStorageObserver_OnCacheListChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::CacheStorageObserver::OnCacheListChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::CacheStorageObserver::OnCacheListChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CacheStorageObserver_OnCacheListChanged_Params_Data* params =
          reinterpret_cast<internal::CacheStorageObserver_OnCacheListChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::StorageKey p_storage_key{};
      CacheStorageObserver_OnCacheListChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStorageKey(&p_storage_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CacheStorageObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCacheListChanged(
std::move(p_storage_key));
      return true;
    }
    case internal::kCacheStorageObserver_OnCacheContentChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::CacheStorageObserver::OnCacheContentChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::CacheStorageObserver::OnCacheContentChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CacheStorageObserver_OnCacheContentChanged_Params_Data* params =
          reinterpret_cast<internal::CacheStorageObserver_OnCacheContentChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::StorageKey p_storage_key{};
      std::string p_cache_name{};
      CacheStorageObserver_OnCacheContentChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStorageKey(&p_storage_key))
        success = false;
      if (success && !input_data_view.ReadCacheName(&p_cache_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CacheStorageObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCacheContentChanged(
std::move(p_storage_key), 
std::move(p_cache_name));
      return true;
    }
  }
  return false;
}

// static
bool CacheStorageObserverStubDispatch::AcceptWithResponder(
    CacheStorageObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCacheStorageObserver_OnCacheListChanged_Name: {
      break;
    }
    case internal::kCacheStorageObserver_OnCacheContentChanged_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCacheStorageObserverValidationInfo[] = {
    {internal::kCacheStorageObserver_OnCacheListChanged_Name,
     {&internal::CacheStorageObserver_OnCacheListChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCacheStorageObserver_OnCacheContentChanged_Name,
     {&internal::CacheStorageObserver_OnCacheContentChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CacheStorageObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::CacheStorageObserver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCacheStorageObserverValidationInfo);
}

const char CacheStorageControl::Name_[] = "storage.mojom.CacheStorageControl";

class CacheStorageControl_GetAllStorageKeysInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CacheStorageControl_GetAllStorageKeysInfo_ForwardToCallback(
      CacheStorageControl::GetAllStorageKeysInfoCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CacheStorageControl::GetAllStorageKeysInfoCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CacheStorageControl_GetAllStorageKeysInfo_ForwardToCallback);
};

CacheStorageControlProxy::CacheStorageControlProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CacheStorageControlProxy::AddReceiver(
    const ::network::CrossOriginEmbedderPolicy& in_policy, ::mojo::PendingRemote<::network::mojom::CrossOriginEmbedderPolicyReporter> in_coep_reporter, const ::blink::StorageKey& in_storage_key, CacheStorageOwner in_owner, ::mojo::PendingReceiver<::blink::mojom::CacheStorage> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::CacheStorageControl::AddReceiver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy"), in_policy,
                        "<value of type const ::network::CrossOriginEmbedderPolicy&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("coep_reporter"), in_coep_reporter,
                        "<value of type ::mojo::PendingRemote<::network::mojom::CrossOriginEmbedderPolicyReporter>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_key"), in_storage_key,
                        "<value of type const ::blink::StorageKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("owner"), in_owner,
                        "<value of type CacheStorageOwner>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::CacheStorage>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCacheStorageControl_AddReceiver_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::CacheStorageControl_AddReceiver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->policy)::BaseType> policy_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::CrossOriginEmbedderPolicyDataView>(
      in_policy, policy_fragment);
  params->policy.Set(
      policy_fragment.is_null() ? nullptr : policy_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->policy.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null policy in CacheStorageControl.AddReceiver request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::CrossOriginEmbedderPolicyReporterInterfaceBase>>(
      in_coep_reporter, &params->coep_reporter, &params.message());
  mojo::internal::MessageFragment<
      typename decltype(params->storage_key)::BaseType> storage_key_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
      in_storage_key, storage_key_fragment);
  params->storage_key.Set(
      storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->storage_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null storage_key in CacheStorageControl.AddReceiver request");
  mojo::internal::Serialize<::storage::mojom::CacheStorageOwner>(
      in_owner, &params->owner);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::CacheStorageInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in CacheStorageControl.AddReceiver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageControl::Name_);
  message.set_method_name("AddReceiver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CacheStorageControlProxy::DeleteForStorageKey(
    const ::blink::StorageKey& in_storage_key) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::CacheStorageControl::DeleteForStorageKey", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_key"), in_storage_key,
                        "<value of type const ::blink::StorageKey&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCacheStorageControl_DeleteForStorageKey_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::CacheStorageControl_DeleteForStorageKey_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->storage_key)::BaseType> storage_key_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
      in_storage_key, storage_key_fragment);
  params->storage_key.Set(
      storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->storage_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null storage_key in CacheStorageControl.DeleteForStorageKey request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageControl::Name_);
  message.set_method_name("DeleteForStorageKey");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CacheStorageControlProxy::GetAllStorageKeysInfo(
    GetAllStorageKeysInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::CacheStorageControl::GetAllStorageKeysInfo");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCacheStorageControl_GetAllStorageKeysInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::CacheStorageControl_GetAllStorageKeysInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageControl::Name_);
  message.set_method_name("GetAllStorageKeysInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CacheStorageControl_GetAllStorageKeysInfo_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CacheStorageControlProxy::AddObserver(
    ::mojo::PendingRemote<CacheStorageObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::CacheStorageControl::AddObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<CacheStorageObserver>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCacheStorageControl_AddObserver_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::CacheStorageControl_AddObserver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::storage::mojom::CacheStorageObserverInterfaceBase>>(
      in_observer, &params->observer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->observer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid observer in CacheStorageControl.AddObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageControl::Name_);
  message.set_method_name("AddObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CacheStorageControlProxy::ApplyPolicyUpdates(
    std::vector<::storage::mojom::StoragePolicyUpdatePtr> in_policy_updates) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::CacheStorageControl::ApplyPolicyUpdates", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy_updates"), in_policy_updates,
                        "<value of type std::vector<::storage::mojom::StoragePolicyUpdatePtr>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCacheStorageControl_ApplyPolicyUpdates_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::CacheStorageControl_ApplyPolicyUpdates_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->policy_updates)::BaseType>
      policy_updates_fragment(params.message());
  const mojo::internal::ContainerValidateParams policy_updates_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::StoragePolicyUpdateDataView>>(
      in_policy_updates, policy_updates_fragment, &policy_updates_validate_params);
  params->policy_updates.Set(
      policy_updates_fragment.is_null() ? nullptr : policy_updates_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->policy_updates.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null policy_updates in CacheStorageControl.ApplyPolicyUpdates request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageControl::Name_);
  message.set_method_name("ApplyPolicyUpdates");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class CacheStorageControl_GetAllStorageKeysInfo_ProxyToResponder {
 public:
  static CacheStorageControl::GetAllStorageKeysInfoCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CacheStorageControl_GetAllStorageKeysInfo_ProxyToResponder> proxy(
        new CacheStorageControl_GetAllStorageKeysInfo_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CacheStorageControl_GetAllStorageKeysInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CacheStorageControl_GetAllStorageKeysInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CacheStorageControl_GetAllStorageKeysInfo_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CacheStorageControl::GetAllStorageKeysInfoCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<::storage::mojom::StorageUsageInfoPtr> in_usage_info);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CacheStorageControl_GetAllStorageKeysInfo_ProxyToResponder);
};

bool CacheStorageControl_GetAllStorageKeysInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::CacheStorageControl::GetAllStorageKeysInfoCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::CacheStorageControl_GetAllStorageKeysInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CacheStorageControl_GetAllStorageKeysInfo_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<::storage::mojom::StorageUsageInfoPtr> p_usage_info{};
  CacheStorageControl_GetAllStorageKeysInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadUsageInfo(&p_usage_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CacheStorageControl::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_usage_info));
  return true;
}

void CacheStorageControl_GetAllStorageKeysInfo_ProxyToResponder::Run(
    std::vector<::storage::mojom::StorageUsageInfoPtr> in_usage_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::CacheStorageControl::GetAllStorageKeysInfoCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("usage_info"), in_usage_info,
                        "<value of type std::vector<::storage::mojom::StorageUsageInfoPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCacheStorageControl_GetAllStorageKeysInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::CacheStorageControl_GetAllStorageKeysInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->usage_info)::BaseType>
      usage_info_fragment(params.message());
  const mojo::internal::ContainerValidateParams usage_info_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::StorageUsageInfoDataView>>(
      in_usage_info, usage_info_fragment, &usage_info_validate_params);
  params->usage_info.Set(
      usage_info_fragment.is_null() ? nullptr : usage_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->usage_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null usage_info in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::CacheStorageControl::GetAllStorageKeysInfoCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageControl::Name_);
  message.set_method_name("GetAllStorageKeysInfo");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CacheStorageControlStubDispatch::Accept(
    CacheStorageControl* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kCacheStorageControl_AddReceiver_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::CacheStorageControl::AddReceiver",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::CacheStorageControl::AddReceiver");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CacheStorageControl_AddReceiver_Params_Data* params =
          reinterpret_cast<internal::CacheStorageControl_AddReceiver_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::network::CrossOriginEmbedderPolicy p_policy{};
      ::mojo::PendingRemote<::network::mojom::CrossOriginEmbedderPolicyReporter> p_coep_reporter{};
      ::blink::StorageKey p_storage_key{};
      CacheStorageOwner p_owner{};
      ::mojo::PendingReceiver<::blink::mojom::CacheStorage> p_receiver{};
      CacheStorageControl_AddReceiver_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPolicy(&p_policy))
        success = false;
      if (success) {
        p_coep_reporter =
            input_data_view.TakeCoepReporter<decltype(p_coep_reporter)>();
      }
      if (success && !input_data_view.ReadStorageKey(&p_storage_key))
        success = false;
      if (success && !input_data_view.ReadOwner(&p_owner))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CacheStorageControl::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddReceiver(
std::move(p_policy), 
std::move(p_coep_reporter), 
std::move(p_storage_key), 
std::move(p_owner), 
std::move(p_receiver));
      return true;
    }
    case internal::kCacheStorageControl_DeleteForStorageKey_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::CacheStorageControl::DeleteForStorageKey",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::CacheStorageControl::DeleteForStorageKey");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CacheStorageControl_DeleteForStorageKey_Params_Data* params =
          reinterpret_cast<internal::CacheStorageControl_DeleteForStorageKey_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::StorageKey p_storage_key{};
      CacheStorageControl_DeleteForStorageKey_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStorageKey(&p_storage_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CacheStorageControl::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteForStorageKey(
std::move(p_storage_key));
      return true;
    }
    case internal::kCacheStorageControl_GetAllStorageKeysInfo_Name: {
      break;
    }
    case internal::kCacheStorageControl_AddObserver_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::CacheStorageControl::AddObserver",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::CacheStorageControl::AddObserver");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CacheStorageControl_AddObserver_Params_Data* params =
          reinterpret_cast<internal::CacheStorageControl_AddObserver_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<CacheStorageObserver> p_observer{};
      CacheStorageControl_AddObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CacheStorageControl::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddObserver(
std::move(p_observer));
      return true;
    }
    case internal::kCacheStorageControl_ApplyPolicyUpdates_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::CacheStorageControl::ApplyPolicyUpdates",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::CacheStorageControl::ApplyPolicyUpdates");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CacheStorageControl_ApplyPolicyUpdates_Params_Data* params =
          reinterpret_cast<internal::CacheStorageControl_ApplyPolicyUpdates_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<::storage::mojom::StoragePolicyUpdatePtr> p_policy_updates{};
      CacheStorageControl_ApplyPolicyUpdates_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPolicyUpdates(&p_policy_updates))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CacheStorageControl::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ApplyPolicyUpdates(
std::move(p_policy_updates));
      return true;
    }
  }
  return false;
}

// static
bool CacheStorageControlStubDispatch::AcceptWithResponder(
    CacheStorageControl* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCacheStorageControl_AddReceiver_Name: {
      break;
    }
    case internal::kCacheStorageControl_DeleteForStorageKey_Name: {
      break;
    }
    case internal::kCacheStorageControl_GetAllStorageKeysInfo_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::CacheStorageControl::GetAllStorageKeysInfo",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::CacheStorageControl::GetAllStorageKeysInfo");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CacheStorageControl_GetAllStorageKeysInfo_Params_Data* params =
          reinterpret_cast<
              internal::CacheStorageControl_GetAllStorageKeysInfo_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      CacheStorageControl_GetAllStorageKeysInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CacheStorageControl::Name_, 2, false);
        return false;
      }
      CacheStorageControl::GetAllStorageKeysInfoCallback callback =
          CacheStorageControl_GetAllStorageKeysInfo_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllStorageKeysInfo(std::move(callback));
      return true;
    }
    case internal::kCacheStorageControl_AddObserver_Name: {
      break;
    }
    case internal::kCacheStorageControl_ApplyPolicyUpdates_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCacheStorageControlValidationInfo[] = {
    {internal::kCacheStorageControl_AddReceiver_Name,
     {&internal::CacheStorageControl_AddReceiver_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCacheStorageControl_DeleteForStorageKey_Name,
     {&internal::CacheStorageControl_DeleteForStorageKey_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCacheStorageControl_GetAllStorageKeysInfo_Name,
     {&internal::CacheStorageControl_GetAllStorageKeysInfo_Params_Data::Validate,
      &internal::CacheStorageControl_GetAllStorageKeysInfo_ResponseParams_Data::Validate}},
    {internal::kCacheStorageControl_AddObserver_Name,
     {&internal::CacheStorageControl_AddObserver_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCacheStorageControl_ApplyPolicyUpdates_Name,
     {&internal::CacheStorageControl_ApplyPolicyUpdates_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CacheStorageControlRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::CacheStorageControl::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCacheStorageControlValidationInfo);
}

bool CacheStorageControlResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::CacheStorageControl::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kCacheStorageControlValidationInfo);

}
}  // namespace mojom
}  // namespace storage

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif