// components/services/storage/public/mojom/indexed_db_control_test.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "components/services/storage/public/mojom/indexed_db_control_test.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom.h"


#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_INDEXED_DB_CONTROL_TEST_MOJOM_JUMBO_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_INDEXED_DB_CONTROL_TEST_MOJOM_JUMBO_H_
#endif


namespace storage {
namespace mojom {


void MockFailureInjectorInterceptorForTesting::FailOperation(FailClass failure_class, FailMethod failure_method, int32_t instance_num, int32_t call_num, FailOperationCallback callback) {
  GetForwardingInterface()->FailOperation(std::move(failure_class), std::move(failure_method), std::move(instance_num), std::move(call_num), std::move(callback));
}
MockFailureInjectorAsyncWaiter::MockFailureInjectorAsyncWaiter(
    MockFailureInjector* proxy) : proxy_(proxy) {}

MockFailureInjectorAsyncWaiter::~MockFailureInjectorAsyncWaiter() = default;

void MockFailureInjectorAsyncWaiter::FailOperation(
    FailClass failure_class, FailMethod failure_method, int32_t instance_num, int32_t call_num) {
  base::RunLoop loop;
  proxy_->FailOperation(std::move(failure_class),std::move(failure_method),std::move(instance_num),std::move(call_num),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void IndexedDBControlTestInterceptorForTesting::GetBaseDataPathForTesting(GetBaseDataPathForTestingCallback callback) {
  GetForwardingInterface()->GetBaseDataPathForTesting(std::move(callback));
}
void IndexedDBControlTestInterceptorForTesting::GetFilePathForTesting(const ::blink::StorageKey& storage_key, GetFilePathForTestingCallback callback) {
  GetForwardingInterface()->GetFilePathForTesting(std::move(storage_key), std::move(callback));
}
void IndexedDBControlTestInterceptorForTesting::ResetCachesForTesting(ResetCachesForTestingCallback callback) {
  GetForwardingInterface()->ResetCachesForTesting(std::move(callback));
}
void IndexedDBControlTestInterceptorForTesting::ForceSchemaDowngradeForTesting(const ::blink::StorageKey& storage_key, ForceSchemaDowngradeForTestingCallback callback) {
  GetForwardingInterface()->ForceSchemaDowngradeForTesting(std::move(storage_key), std::move(callback));
}
void IndexedDBControlTestInterceptorForTesting::HasV2SchemaCorruptionForTesting(const ::blink::StorageKey& storage_key, HasV2SchemaCorruptionForTestingCallback callback) {
  GetForwardingInterface()->HasV2SchemaCorruptionForTesting(std::move(storage_key), std::move(callback));
}
void IndexedDBControlTestInterceptorForTesting::WriteToIndexedDBForTesting(const ::blink::StorageKey& storage_key, const std::string& key, const std::string& value, WriteToIndexedDBForTestingCallback callback) {
  GetForwardingInterface()->WriteToIndexedDBForTesting(std::move(storage_key), std::move(key), std::move(value), std::move(callback));
}
void IndexedDBControlTestInterceptorForTesting::GetBlobCountForTesting(const ::blink::StorageKey& storage_key, GetBlobCountForTestingCallback callback) {
  GetForwardingInterface()->GetBlobCountForTesting(std::move(storage_key), std::move(callback));
}
void IndexedDBControlTestInterceptorForTesting::GetNextBlobNumberForTesting(const ::blink::StorageKey& storage_key, int64_t database_id, GetNextBlobNumberForTestingCallback callback) {
  GetForwardingInterface()->GetNextBlobNumberForTesting(std::move(storage_key), std::move(database_id), std::move(callback));
}
void IndexedDBControlTestInterceptorForTesting::GetPathForBlobForTesting(const ::blink::StorageKey& storage_key, int64_t database_id, int64_t blob_number, GetPathForBlobForTestingCallback callback) {
  GetForwardingInterface()->GetPathForBlobForTesting(std::move(storage_key), std::move(database_id), std::move(blob_number), std::move(callback));
}
void IndexedDBControlTestInterceptorForTesting::CompactBackingStoreForTesting(const ::blink::StorageKey& storage_key, CompactBackingStoreForTestingCallback callback) {
  GetForwardingInterface()->CompactBackingStoreForTesting(std::move(storage_key), std::move(callback));
}
void IndexedDBControlTestInterceptorForTesting::BindMockFailureSingletonForTesting(::mojo::PendingReceiver<MockFailureInjector> receiver) {
  GetForwardingInterface()->BindMockFailureSingletonForTesting(std::move(receiver));
}
void IndexedDBControlTestInterceptorForTesting::GetDatabaseKeysForTesting(GetDatabaseKeysForTestingCallback callback) {
  GetForwardingInterface()->GetDatabaseKeysForTesting(std::move(callback));
}
IndexedDBControlTestAsyncWaiter::IndexedDBControlTestAsyncWaiter(
    IndexedDBControlTest* proxy) : proxy_(proxy) {}

IndexedDBControlTestAsyncWaiter::~IndexedDBControlTestAsyncWaiter() = default;

void IndexedDBControlTestAsyncWaiter::GetBaseDataPathForTesting(
    ::base::FilePath* out_path) {
  base::RunLoop loop;
  proxy_->GetBaseDataPathForTesting(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::FilePath* out_path
,
             const ::base::FilePath& path) {*out_path = std::move(path);
            loop->Quit();
          },
          &loop,
          out_path));
  loop.Run();
}
void IndexedDBControlTestAsyncWaiter::GetFilePathForTesting(
    const ::blink::StorageKey& storage_key, ::base::FilePath* out_path) {
  base::RunLoop loop;
  proxy_->GetFilePathForTesting(std::move(storage_key),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::FilePath* out_path
,
             const ::base::FilePath& path) {*out_path = std::move(path);
            loop->Quit();
          },
          &loop,
          out_path));
  loop.Run();
}
void IndexedDBControlTestAsyncWaiter::ResetCachesForTesting(
    ) {
  base::RunLoop loop;
  proxy_->ResetCachesForTesting(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void IndexedDBControlTestAsyncWaiter::ForceSchemaDowngradeForTesting(
    const ::blink::StorageKey& storage_key, bool* out_downgraded) {
  base::RunLoop loop;
  proxy_->ForceSchemaDowngradeForTesting(std::move(storage_key),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_downgraded
,
             bool downgraded) {*out_downgraded = std::move(downgraded);
            loop->Quit();
          },
          &loop,
          out_downgraded));
  loop.Run();
}
void IndexedDBControlTestAsyncWaiter::HasV2SchemaCorruptionForTesting(
    const ::blink::StorageKey& storage_key, V2SchemaCorruptionStatus* out_status) {
  base::RunLoop loop;
  proxy_->HasV2SchemaCorruptionForTesting(std::move(storage_key),
      base::BindOnce(
          [](base::RunLoop* loop,
             V2SchemaCorruptionStatus* out_status
,
             V2SchemaCorruptionStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}
void IndexedDBControlTestAsyncWaiter::WriteToIndexedDBForTesting(
    const ::blink::StorageKey& storage_key, const std::string& key, const std::string& value) {
  base::RunLoop loop;
  proxy_->WriteToIndexedDBForTesting(std::move(storage_key),std::move(key),std::move(value),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void IndexedDBControlTestAsyncWaiter::GetBlobCountForTesting(
    const ::blink::StorageKey& storage_key, int64_t* out_num_blobs) {
  base::RunLoop loop;
  proxy_->GetBlobCountForTesting(std::move(storage_key),
      base::BindOnce(
          [](base::RunLoop* loop,
             int64_t* out_num_blobs
,
             int64_t num_blobs) {*out_num_blobs = std::move(num_blobs);
            loop->Quit();
          },
          &loop,
          out_num_blobs));
  loop.Run();
}
void IndexedDBControlTestAsyncWaiter::GetNextBlobNumberForTesting(
    const ::blink::StorageKey& storage_key, int64_t database_id, int64_t* out_next_blob_number) {
  base::RunLoop loop;
  proxy_->GetNextBlobNumberForTesting(std::move(storage_key),std::move(database_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             int64_t* out_next_blob_number
,
             int64_t next_blob_number) {*out_next_blob_number = std::move(next_blob_number);
            loop->Quit();
          },
          &loop,
          out_next_blob_number));
  loop.Run();
}
void IndexedDBControlTestAsyncWaiter::GetPathForBlobForTesting(
    const ::blink::StorageKey& storage_key, int64_t database_id, int64_t blob_number, ::base::FilePath* out_path) {
  base::RunLoop loop;
  proxy_->GetPathForBlobForTesting(std::move(storage_key),std::move(database_id),std::move(blob_number),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::FilePath* out_path
,
             const ::base::FilePath& path) {*out_path = std::move(path);
            loop->Quit();
          },
          &loop,
          out_path));
  loop.Run();
}
void IndexedDBControlTestAsyncWaiter::CompactBackingStoreForTesting(
    const ::blink::StorageKey& storage_key) {
  base::RunLoop loop;
  proxy_->CompactBackingStoreForTesting(std::move(storage_key),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void IndexedDBControlTestAsyncWaiter::GetDatabaseKeysForTesting(
    std::string* out_schema_version_key, std::string* out_data_version_key) {
  base::RunLoop loop;
  proxy_->GetDatabaseKeysForTesting(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_schema_version_key
,
             std::string* out_data_version_key
,
             const std::string& schema_version_key,
             const std::string& data_version_key) {*out_schema_version_key = std::move(schema_version_key);*out_data_version_key = std::move(data_version_key);
            loop->Quit();
          },
          &loop,
          out_schema_version_key,
          out_data_version_key));
  loop.Run();
}





}  // namespace mojom
}  // namespace storage

#if defined(__clang__)
#pragma clang diagnostic pop
#endif