// components/services/storage/public/mojom/service_worker_storage_control.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/services/storage/public/mojom/service_worker_storage_control.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/storage/public/mojom/service_worker_storage_control.mojom-params-data.h"
namespace storage {
namespace mojom {

static NOINLINE const char* ServiceWorkerStorageStorageKeyStateToStringHelper(ServiceWorkerStorageStorageKeyState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ServiceWorkerStorageStorageKeyState::kKeep:
      return "kKeep";
    case ServiceWorkerStorageStorageKeyState::kDelete:
      return "kDelete";
    default:
      return nullptr;
  }
}

std::string ServiceWorkerStorageStorageKeyStateToString(ServiceWorkerStorageStorageKeyState value) {
  const char *str = ServiceWorkerStorageStorageKeyStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ServiceWorkerStorageStorageKeyState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ServiceWorkerStorageStorageKeyState value) {
  return os << ServiceWorkerStorageStorageKeyStateToString(value);
}

namespace internal {


// static
bool ServiceWorkerLiveVersionInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerLiveVersionInfo_Data* object = static_cast<const ServiceWorkerLiveVersionInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->purgeable_resources, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams purgeable_resources_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->purgeable_resources, validation_context,
                                         &purgeable_resources_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->reference, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->reference,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ServiceWorkerLiveVersionInfo_Data::ServiceWorkerLiveVersionInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerFindRegistrationResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerFindRegistrationResult_Data* object = static_cast<const ServiceWorkerFindRegistrationResult_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->version_reference, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->version_reference,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->registration, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->registration, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->resources, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams resources_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->resources, validation_context,
                                         &resources_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerFindRegistrationResult_Data::ServiceWorkerFindRegistrationResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerUserData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerUserData_Data* object = static_cast<const ServiceWorkerUserData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams key_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->key, validation_context,
                                         &key_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams value_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->value, validation_context,
                                         &value_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerUserData_Data::ServiceWorkerUserData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerDataPipeStateNotifier_OnComplete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerDataPipeStateNotifier_OnComplete_Params_Data* object = static_cast<const ServiceWorkerDataPipeStateNotifier_OnComplete_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ServiceWorkerDataPipeStateNotifier_OnComplete_Params_Data::ServiceWorkerDataPipeStateNotifier_OnComplete_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerResourceReader_ReadResponseHead_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerResourceReader_ReadResponseHead_Params_Data* object = static_cast<const ServiceWorkerResourceReader_ReadResponseHead_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ServiceWorkerResourceReader_ReadResponseHead_Params_Data::ServiceWorkerResourceReader_ReadResponseHead_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerResourceReader_ReadResponseHead_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerResourceReader_ReadResponseHead_ResponseParams_Data* object = static_cast<const ServiceWorkerResourceReader_ReadResponseHead_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->response_head, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->metadata, validation_context))
    return false;

  return true;
}

ServiceWorkerResourceReader_ReadResponseHead_ResponseParams_Data::ServiceWorkerResourceReader_ReadResponseHead_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerResourceReader_ReadData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerResourceReader_ReadData_Params_Data* object = static_cast<const ServiceWorkerResourceReader_ReadData_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->notifier, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->notifier,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ServiceWorkerResourceReader_ReadData_Params_Data::ServiceWorkerResourceReader_ReadData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerResourceReader_ReadData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerResourceReader_ReadData_ResponseParams_Data* object = static_cast<const ServiceWorkerResourceReader_ReadData_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterface(object->pipe,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ServiceWorkerResourceReader_ReadData_ResponseParams_Data::ServiceWorkerResourceReader_ReadData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerResourceWriter_WriteResponseHead_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerResourceWriter_WriteResponseHead_Params_Data* object = static_cast<const ServiceWorkerResourceWriter_WriteResponseHead_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response_head, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response_head, validation_context))
    return false;

  return true;
}

ServiceWorkerResourceWriter_WriteResponseHead_Params_Data::ServiceWorkerResourceWriter_WriteResponseHead_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerResourceWriter_WriteResponseHead_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerResourceWriter_WriteResponseHead_ResponseParams_Data* object = static_cast<const ServiceWorkerResourceWriter_WriteResponseHead_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ServiceWorkerResourceWriter_WriteResponseHead_ResponseParams_Data::ServiceWorkerResourceWriter_WriteResponseHead_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerResourceWriter_WriteData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerResourceWriter_WriteData_Params_Data* object = static_cast<const ServiceWorkerResourceWriter_WriteData_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->data, validation_context))
    return false;

  return true;
}

ServiceWorkerResourceWriter_WriteData_Params_Data::ServiceWorkerResourceWriter_WriteData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerResourceWriter_WriteData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerResourceWriter_WriteData_ResponseParams_Data* object = static_cast<const ServiceWorkerResourceWriter_WriteData_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ServiceWorkerResourceWriter_WriteData_ResponseParams_Data::ServiceWorkerResourceWriter_WriteData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerResourceMetadataWriter_WriteMetadata_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerResourceMetadataWriter_WriteMetadata_Params_Data* object = static_cast<const ServiceWorkerResourceMetadataWriter_WriteMetadata_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->data, validation_context))
    return false;

  return true;
}

ServiceWorkerResourceMetadataWriter_WriteMetadata_Params_Data::ServiceWorkerResourceMetadataWriter_WriteMetadata_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerResourceMetadataWriter_WriteMetadata_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerResourceMetadataWriter_WriteMetadata_ResponseParams_Data* object = static_cast<const ServiceWorkerResourceMetadataWriter_WriteMetadata_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ServiceWorkerResourceMetadataWriter_WriteMetadata_ResponseParams_Data::ServiceWorkerResourceMetadataWriter_WriteMetadata_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_Disable_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_Disable_Params_Data* object = static_cast<const ServiceWorkerStorageControl_Disable_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ServiceWorkerStorageControl_Disable_Params_Data::ServiceWorkerStorageControl_Disable_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_Disable_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_Disable_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_Disable_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ServiceWorkerStorageControl_Disable_ResponseParams_Data::ServiceWorkerStorageControl_Disable_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_Delete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_Delete_Params_Data* object = static_cast<const ServiceWorkerStorageControl_Delete_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ServiceWorkerStorageControl_Delete_Params_Data::ServiceWorkerStorageControl_Delete_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_Delete_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_Delete_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_Delete_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::storage::mojom::internal::ServiceWorkerDatabaseStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

ServiceWorkerStorageControl_Delete_ResponseParams_Data::ServiceWorkerStorageControl_Delete_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_Recover_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_Recover_Params_Data* object = static_cast<const ServiceWorkerStorageControl_Recover_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->versions, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams versions_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->versions, validation_context,
                                         &versions_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerStorageControl_Recover_Params_Data::ServiceWorkerStorageControl_Recover_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_Recover_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_Recover_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_Recover_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ServiceWorkerStorageControl_Recover_ResponseParams_Data::ServiceWorkerStorageControl_Recover_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_GetRegisteredStorageKeys_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_GetRegisteredStorageKeys_Params_Data* object = static_cast<const ServiceWorkerStorageControl_GetRegisteredStorageKeys_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ServiceWorkerStorageControl_GetRegisteredStorageKeys_Params_Data::ServiceWorkerStorageControl_GetRegisteredStorageKeys_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_GetRegisteredStorageKeys_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_GetRegisteredStorageKeys_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_GetRegisteredStorageKeys_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->keys, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams keys_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->keys, validation_context,
                                         &keys_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerStorageControl_GetRegisteredStorageKeys_ResponseParams_Data::ServiceWorkerStorageControl_GetRegisteredStorageKeys_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_FindRegistrationForClientUrl_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_FindRegistrationForClientUrl_Params_Data* object = static_cast<const ServiceWorkerStorageControl_FindRegistrationForClientUrl_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->client_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->client_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key, validation_context))
    return false;

  return true;
}

ServiceWorkerStorageControl_FindRegistrationForClientUrl_Params_Data::ServiceWorkerStorageControl_FindRegistrationForClientUrl_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_FindRegistrationForClientUrl_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_FindRegistrationForClientUrl_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_FindRegistrationForClientUrl_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::storage::mojom::internal::ServiceWorkerDatabaseStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

ServiceWorkerStorageControl_FindRegistrationForClientUrl_ResponseParams_Data::ServiceWorkerStorageControl_FindRegistrationForClientUrl_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_FindRegistrationForScope_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_FindRegistrationForScope_Params_Data* object = static_cast<const ServiceWorkerStorageControl_FindRegistrationForScope_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scope, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scope, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key, validation_context))
    return false;

  return true;
}

ServiceWorkerStorageControl_FindRegistrationForScope_Params_Data::ServiceWorkerStorageControl_FindRegistrationForScope_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_FindRegistrationForScope_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_FindRegistrationForScope_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_FindRegistrationForScope_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::storage::mojom::internal::ServiceWorkerDatabaseStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

ServiceWorkerStorageControl_FindRegistrationForScope_ResponseParams_Data::ServiceWorkerStorageControl_FindRegistrationForScope_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_FindRegistrationForId_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_FindRegistrationForId_Params_Data* object = static_cast<const ServiceWorkerStorageControl_FindRegistrationForId_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->key, validation_context))
    return false;

  return true;
}

ServiceWorkerStorageControl_FindRegistrationForId_Params_Data::ServiceWorkerStorageControl_FindRegistrationForId_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_FindRegistrationForId_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_FindRegistrationForId_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_FindRegistrationForId_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::storage::mojom::internal::ServiceWorkerDatabaseStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

ServiceWorkerStorageControl_FindRegistrationForId_ResponseParams_Data::ServiceWorkerStorageControl_FindRegistrationForId_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_GetRegistrationsForStorageKey_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_GetRegistrationsForStorageKey_Params_Data* object = static_cast<const ServiceWorkerStorageControl_GetRegistrationsForStorageKey_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key, validation_context))
    return false;

  return true;
}

ServiceWorkerStorageControl_GetRegistrationsForStorageKey_Params_Data::ServiceWorkerStorageControl_GetRegistrationsForStorageKey_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_GetRegistrationsForStorageKey_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_GetRegistrationsForStorageKey_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_GetRegistrationsForStorageKey_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::storage::mojom::internal::ServiceWorkerDatabaseStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->registrations, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams registrations_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->registrations, validation_context,
                                         &registrations_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerStorageControl_GetRegistrationsForStorageKey_ResponseParams_Data::ServiceWorkerStorageControl_GetRegistrationsForStorageKey_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_GetUsageForStorageKey_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_GetUsageForStorageKey_Params_Data* object = static_cast<const ServiceWorkerStorageControl_GetUsageForStorageKey_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key, validation_context))
    return false;

  return true;
}

ServiceWorkerStorageControl_GetUsageForStorageKey_Params_Data::ServiceWorkerStorageControl_GetUsageForStorageKey_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_GetUsageForStorageKey_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_GetUsageForStorageKey_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_GetUsageForStorageKey_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::storage::mojom::internal::ServiceWorkerDatabaseStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

ServiceWorkerStorageControl_GetUsageForStorageKey_ResponseParams_Data::ServiceWorkerStorageControl_GetUsageForStorageKey_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_Params_Data* object = static_cast<const ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_Params_Data::ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::storage::mojom::internal::ServiceWorkerDatabaseStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->registrations, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams registrations_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->registrations, validation_context,
                                         &registrations_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ResponseParams_Data::ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_StoreRegistration_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_StoreRegistration_Params_Data* object = static_cast<const ServiceWorkerStorageControl_StoreRegistration_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->registration, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->registration, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->resources, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams resources_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->resources, validation_context,
                                         &resources_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerStorageControl_StoreRegistration_Params_Data::ServiceWorkerStorageControl_StoreRegistration_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_StoreRegistration_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_StoreRegistration_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_StoreRegistration_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::storage::mojom::internal::ServiceWorkerDatabaseStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

ServiceWorkerStorageControl_StoreRegistration_ResponseParams_Data::ServiceWorkerStorageControl_StoreRegistration_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_DeleteRegistration_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_DeleteRegistration_Params_Data* object = static_cast<const ServiceWorkerStorageControl_DeleteRegistration_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key, validation_context))
    return false;

  return true;
}

ServiceWorkerStorageControl_DeleteRegistration_Params_Data::ServiceWorkerStorageControl_DeleteRegistration_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_DeleteRegistration_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_DeleteRegistration_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_DeleteRegistration_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::storage::mojom::internal::ServiceWorkerDatabaseStatus_Data
        ::Validate(object->status, validation_context))
    return false;


  if (!::storage::mojom::internal::ServiceWorkerStorageStorageKeyState_Data
        ::Validate(object->storage_key_state, validation_context))
    return false;

  return true;
}

ServiceWorkerStorageControl_DeleteRegistration_ResponseParams_Data::ServiceWorkerStorageControl_DeleteRegistration_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_UpdateToActiveState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_UpdateToActiveState_Params_Data* object = static_cast<const ServiceWorkerStorageControl_UpdateToActiveState_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key, validation_context))
    return false;

  return true;
}

ServiceWorkerStorageControl_UpdateToActiveState_Params_Data::ServiceWorkerStorageControl_UpdateToActiveState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_UpdateToActiveState_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_UpdateToActiveState_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_UpdateToActiveState_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::storage::mojom::internal::ServiceWorkerDatabaseStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

ServiceWorkerStorageControl_UpdateToActiveState_ResponseParams_Data::ServiceWorkerStorageControl_UpdateToActiveState_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_Params_Data* object = static_cast<const ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_update_check_time, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->last_update_check_time, validation_context))
    return false;

  return true;
}

ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_Params_Data::ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::storage::mojom::internal::ServiceWorkerDatabaseStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ResponseParams_Data::ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_Params_Data* object = static_cast<const ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key, validation_context))
    return false;

  return true;
}

ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_Params_Data::ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::storage::mojom::internal::ServiceWorkerDatabaseStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ResponseParams_Data::ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_Params_Data* object = static_cast<const ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams value_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->value, validation_context,
                                         &value_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_Params_Data::ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::storage::mojom::internal::ServiceWorkerDatabaseStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ResponseParams_Data::ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_GetNewRegistrationId_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_GetNewRegistrationId_Params_Data* object = static_cast<const ServiceWorkerStorageControl_GetNewRegistrationId_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ServiceWorkerStorageControl_GetNewRegistrationId_Params_Data::ServiceWorkerStorageControl_GetNewRegistrationId_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_GetNewRegistrationId_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_GetNewRegistrationId_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_GetNewRegistrationId_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ServiceWorkerStorageControl_GetNewRegistrationId_ResponseParams_Data::ServiceWorkerStorageControl_GetNewRegistrationId_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_GetNewVersionId_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_GetNewVersionId_Params_Data* object = static_cast<const ServiceWorkerStorageControl_GetNewVersionId_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ServiceWorkerStorageControl_GetNewVersionId_Params_Data::ServiceWorkerStorageControl_GetNewVersionId_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_GetNewVersionId_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_GetNewVersionId_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_GetNewVersionId_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterface(object->version_reference,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ServiceWorkerStorageControl_GetNewVersionId_ResponseParams_Data::ServiceWorkerStorageControl_GetNewVersionId_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_GetNewResourceId_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_GetNewResourceId_Params_Data* object = static_cast<const ServiceWorkerStorageControl_GetNewResourceId_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ServiceWorkerStorageControl_GetNewResourceId_Params_Data::ServiceWorkerStorageControl_GetNewResourceId_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_GetNewResourceId_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_GetNewResourceId_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_GetNewResourceId_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ServiceWorkerStorageControl_GetNewResourceId_ResponseParams_Data::ServiceWorkerStorageControl_GetNewResourceId_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_CreateResourceReader_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_CreateResourceReader_Params_Data* object = static_cast<const ServiceWorkerStorageControl_CreateResourceReader_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->reader, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->reader,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ServiceWorkerStorageControl_CreateResourceReader_Params_Data::ServiceWorkerStorageControl_CreateResourceReader_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_CreateResourceWriter_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_CreateResourceWriter_Params_Data* object = static_cast<const ServiceWorkerStorageControl_CreateResourceWriter_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->writer, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->writer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ServiceWorkerStorageControl_CreateResourceWriter_Params_Data::ServiceWorkerStorageControl_CreateResourceWriter_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_CreateResourceMetadataWriter_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_CreateResourceMetadataWriter_Params_Data* object = static_cast<const ServiceWorkerStorageControl_CreateResourceMetadataWriter_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->writer, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->writer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ServiceWorkerStorageControl_CreateResourceMetadataWriter_Params_Data::ServiceWorkerStorageControl_CreateResourceMetadataWriter_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_StoreUncommittedResourceId_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_StoreUncommittedResourceId_Params_Data* object = static_cast<const ServiceWorkerStorageControl_StoreUncommittedResourceId_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ServiceWorkerStorageControl_StoreUncommittedResourceId_Params_Data::ServiceWorkerStorageControl_StoreUncommittedResourceId_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_StoreUncommittedResourceId_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_StoreUncommittedResourceId_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_StoreUncommittedResourceId_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::storage::mojom::internal::ServiceWorkerDatabaseStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

ServiceWorkerStorageControl_StoreUncommittedResourceId_ResponseParams_Data::ServiceWorkerStorageControl_StoreUncommittedResourceId_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_DoomUncommittedResources_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_DoomUncommittedResources_Params_Data* object = static_cast<const ServiceWorkerStorageControl_DoomUncommittedResources_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->resource_ids, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams resource_ids_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->resource_ids, validation_context,
                                         &resource_ids_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerStorageControl_DoomUncommittedResources_Params_Data::ServiceWorkerStorageControl_DoomUncommittedResources_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_DoomUncommittedResources_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_DoomUncommittedResources_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_DoomUncommittedResources_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::storage::mojom::internal::ServiceWorkerDatabaseStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

ServiceWorkerStorageControl_DoomUncommittedResources_ResponseParams_Data::ServiceWorkerStorageControl_DoomUncommittedResources_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_GetUserData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_GetUserData_Params_Data* object = static_cast<const ServiceWorkerStorageControl_GetUserData_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->keys, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams keys_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->keys, validation_context,
                                         &keys_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerStorageControl_GetUserData_Params_Data::ServiceWorkerStorageControl_GetUserData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_GetUserData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_GetUserData_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_GetUserData_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::storage::mojom::internal::ServiceWorkerDatabaseStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->values, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams values_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->values, validation_context,
                                         &values_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerStorageControl_GetUserData_ResponseParams_Data::ServiceWorkerStorageControl_GetUserData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_StoreUserData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_StoreUserData_Params_Data* object = static_cast<const ServiceWorkerStorageControl_StoreUserData_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_data, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams user_data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->user_data, validation_context,
                                         &user_data_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerStorageControl_StoreUserData_Params_Data::ServiceWorkerStorageControl_StoreUserData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_StoreUserData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_StoreUserData_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_StoreUserData_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::storage::mojom::internal::ServiceWorkerDatabaseStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

ServiceWorkerStorageControl_StoreUserData_ResponseParams_Data::ServiceWorkerStorageControl_StoreUserData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_ClearUserData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_ClearUserData_Params_Data* object = static_cast<const ServiceWorkerStorageControl_ClearUserData_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->keys, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams keys_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->keys, validation_context,
                                         &keys_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerStorageControl_ClearUserData_Params_Data::ServiceWorkerStorageControl_ClearUserData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_ClearUserData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_ClearUserData_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_ClearUserData_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::storage::mojom::internal::ServiceWorkerDatabaseStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

ServiceWorkerStorageControl_ClearUserData_ResponseParams_Data::ServiceWorkerStorageControl_ClearUserData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_GetUserDataByKeyPrefix_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_GetUserDataByKeyPrefix_Params_Data* object = static_cast<const ServiceWorkerStorageControl_GetUserDataByKeyPrefix_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_prefix, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams key_prefix_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->key_prefix, validation_context,
                                         &key_prefix_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerStorageControl_GetUserDataByKeyPrefix_Params_Data::ServiceWorkerStorageControl_GetUserDataByKeyPrefix_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::storage::mojom::internal::ServiceWorkerDatabaseStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->values, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams values_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->values, validation_context,
                                         &values_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ResponseParams_Data::ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_Params_Data* object = static_cast<const ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_prefix, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams key_prefix_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->key_prefix, validation_context,
                                         &key_prefix_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_Params_Data::ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::storage::mojom::internal::ServiceWorkerDatabaseStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_data, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams user_data_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
  if (!mojo::internal::ValidateContainer(object->user_data, validation_context,
                                         &user_data_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ResponseParams_Data::ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_Params_Data* object = static_cast<const ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_prefixes, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams key_prefixes_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->key_prefixes, validation_context,
                                         &key_prefixes_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_Params_Data::ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::storage::mojom::internal::ServiceWorkerDatabaseStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ResponseParams_Data::ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_GetUserDataForAllRegistrations_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_GetUserDataForAllRegistrations_Params_Data* object = static_cast<const ServiceWorkerStorageControl_GetUserDataForAllRegistrations_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams key_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->key, validation_context,
                                         &key_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerStorageControl_GetUserDataForAllRegistrations_Params_Data::ServiceWorkerStorageControl_GetUserDataForAllRegistrations_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::storage::mojom::internal::ServiceWorkerDatabaseStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->values, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams values_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->values, validation_context,
                                         &values_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ResponseParams_Data::ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_Params_Data* object = static_cast<const ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_prefix, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams key_prefix_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->key_prefix, validation_context,
                                         &key_prefix_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_Params_Data::ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::storage::mojom::internal::ServiceWorkerDatabaseStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->values, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams values_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->values, validation_context,
                                         &values_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ResponseParams_Data::ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_Params_Data* object = static_cast<const ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_prefix, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams key_prefix_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->key_prefix, validation_context,
                                         &key_prefix_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_Params_Data::ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::storage::mojom::internal::ServiceWorkerDatabaseStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ResponseParams_Data::ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_PerformStorageCleanup_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_PerformStorageCleanup_Params_Data* object = static_cast<const ServiceWorkerStorageControl_PerformStorageCleanup_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ServiceWorkerStorageControl_PerformStorageCleanup_Params_Data::ServiceWorkerStorageControl_PerformStorageCleanup_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_PerformStorageCleanup_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_PerformStorageCleanup_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_PerformStorageCleanup_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ServiceWorkerStorageControl_PerformStorageCleanup_ResponseParams_Data::ServiceWorkerStorageControl_PerformStorageCleanup_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_ApplyPolicyUpdates_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_ApplyPolicyUpdates_Params_Data* object = static_cast<const ServiceWorkerStorageControl_ApplyPolicyUpdates_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->policy_updates, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams policy_updates_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->policy_updates, validation_context,
                                         &policy_updates_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerStorageControl_ApplyPolicyUpdates_Params_Data::ServiceWorkerStorageControl_ApplyPolicyUpdates_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_ApplyPolicyUpdates_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_ApplyPolicyUpdates_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_ApplyPolicyUpdates_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::storage::mojom::internal::ServiceWorkerDatabaseStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

ServiceWorkerStorageControl_ApplyPolicyUpdates_ResponseParams_Data::ServiceWorkerStorageControl_ApplyPolicyUpdates_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_Params_Data* object = static_cast<const ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_Params_Data::ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::storage::mojom::internal::ServiceWorkerDatabaseStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->resource_ids, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams resource_ids_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->resource_ids, validation_context,
                                         &resource_ids_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ResponseParams_Data::ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_Params_Data* object = static_cast<const ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_Params_Data::ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::storage::mojom::internal::ServiceWorkerDatabaseStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->resource_ids, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams resource_ids_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->resource_ids, validation_context,
                                         &resource_ids_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ResponseParams_Data::ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_Params_Data* object = static_cast<const ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_Params_Data::ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::storage::mojom::internal::ServiceWorkerDatabaseStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->resource_ids, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams resource_ids_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->resource_ids, validation_context,
                                         &resource_ids_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ResponseParams_Data::ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_Params_Data* object = static_cast<const ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_Params_Data::ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ResponseParams_Data* object = static_cast<const ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ResponseParams_Data::ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace storage

namespace perfetto {

// static
void TraceFormatTraits<::storage::mojom::ServiceWorkerStorageStorageKeyState>::WriteIntoTrace(
   perfetto::TracedValue context, ::storage::mojom::ServiceWorkerStorageStorageKeyState value) {
  return std::move(context).WriteString(::storage::mojom::ServiceWorkerStorageStorageKeyStateToString(value));
}

} // namespace perfetto
