// components/spellcheck/common/spellcheck.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "components/spellcheck/common/spellcheck.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/mojom/base/read_only_file.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"


#ifndef COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_MOJOM_JUMBO_H_
#define COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_MOJOM_JUMBO_H_
#endif


namespace spellcheck {
namespace mojom {


void SpellCheckerInterceptorForTesting::Initialize(std::vector<SpellCheckBDictLanguagePtr> dictionaries, const std::vector<std::string>& custom_words, bool enable) {
  GetForwardingInterface()->Initialize(std::move(dictionaries), std::move(custom_words), std::move(enable));
}
void SpellCheckerInterceptorForTesting::CustomDictionaryChanged(const std::vector<std::string>& words_added, const std::vector<std::string>& words_removed) {
  GetForwardingInterface()->CustomDictionaryChanged(std::move(words_added), std::move(words_removed));
}
SpellCheckerAsyncWaiter::SpellCheckerAsyncWaiter(
    SpellChecker* proxy) : proxy_(proxy) {}

SpellCheckerAsyncWaiter::~SpellCheckerAsyncWaiter() = default;




void SpellCheckHostInterceptorForTesting::RequestDictionary() {
  GetForwardingInterface()->RequestDictionary();
}
void SpellCheckHostInterceptorForTesting::NotifyChecked(const ::std::u16string& word, bool misspelled) {
  GetForwardingInterface()->NotifyChecked(std::move(word), std::move(misspelled));
}
void SpellCheckHostInterceptorForTesting::CallSpellingService(const ::std::u16string& text, CallSpellingServiceCallback callback) {
  GetForwardingInterface()->CallSpellingService(std::move(text), std::move(callback));
}
SpellCheckHostAsyncWaiter::SpellCheckHostAsyncWaiter(
    SpellCheckHost* proxy) : proxy_(proxy) {}

SpellCheckHostAsyncWaiter::~SpellCheckHostAsyncWaiter() = default;

void SpellCheckHostAsyncWaiter::CallSpellingService(
    const ::std::u16string& text, bool* out_success, std::vector<::SpellCheckResult>* out_results) {
  base::RunLoop loop;
  proxy_->CallSpellingService(std::move(text),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             std::vector<::SpellCheckResult>* out_results
,
             bool success,
             const std::vector<::SpellCheckResult>& results) {*out_success = std::move(success);*out_results = std::move(results);
            loop->Quit();
          },
          &loop,
          out_success,
          out_results));
  loop.Run();
}





}  // namespace mojom
}  // namespace spellcheck

#if defined(__clang__)
#pragma clang diagnostic pop
#endif