// content/browser/conversions/conversion_internals.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "content/browser/conversions/conversion_internals.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"


#ifndef CONTENT_BROWSER_CONVERSIONS_CONVERSION_INTERNALS_MOJOM_JUMBO_H_
#define CONTENT_BROWSER_CONVERSIONS_CONVERSION_INTERNALS_MOJOM_JUMBO_H_
#endif


namespace mojom {


void ConversionInternalsHandlerInterceptorForTesting::IsMeasurementEnabled(IsMeasurementEnabledCallback callback) {
  GetForwardingInterface()->IsMeasurementEnabled(std::move(callback));
}
void ConversionInternalsHandlerInterceptorForTesting::GetActiveImpressions(GetActiveImpressionsCallback callback) {
  GetForwardingInterface()->GetActiveImpressions(std::move(callback));
}
void ConversionInternalsHandlerInterceptorForTesting::GetPendingReports(GetPendingReportsCallback callback) {
  GetForwardingInterface()->GetPendingReports(std::move(callback));
}
void ConversionInternalsHandlerInterceptorForTesting::GetSentReports(GetSentReportsCallback callback) {
  GetForwardingInterface()->GetSentReports(std::move(callback));
}
void ConversionInternalsHandlerInterceptorForTesting::SendPendingReports(SendPendingReportsCallback callback) {
  GetForwardingInterface()->SendPendingReports(std::move(callback));
}
void ConversionInternalsHandlerInterceptorForTesting::ClearStorage(ClearStorageCallback callback) {
  GetForwardingInterface()->ClearStorage(std::move(callback));
}
ConversionInternalsHandlerAsyncWaiter::ConversionInternalsHandlerAsyncWaiter(
    ConversionInternalsHandler* proxy) : proxy_(proxy) {}

ConversionInternalsHandlerAsyncWaiter::~ConversionInternalsHandlerAsyncWaiter() = default;

void ConversionInternalsHandlerAsyncWaiter::IsMeasurementEnabled(
    bool* out_enabled, bool* out_debug_mode) {
  base::RunLoop loop;
  proxy_->IsMeasurementEnabled(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_enabled
,
             bool* out_debug_mode
,
             bool enabled,
             bool debug_mode) {*out_enabled = std::move(enabled);*out_debug_mode = std::move(debug_mode);
            loop->Quit();
          },
          &loop,
          out_enabled,
          out_debug_mode));
  loop.Run();
}
void ConversionInternalsHandlerAsyncWaiter::GetActiveImpressions(
    std::vector<WebUIImpressionPtr>* out_impressions) {
  base::RunLoop loop;
  proxy_->GetActiveImpressions(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<WebUIImpressionPtr>* out_impressions
,
             std::vector<WebUIImpressionPtr> impressions) {*out_impressions = std::move(impressions);
            loop->Quit();
          },
          &loop,
          out_impressions));
  loop.Run();
}
void ConversionInternalsHandlerAsyncWaiter::GetPendingReports(
    std::vector<WebUIConversionReportPtr>* out_reports) {
  base::RunLoop loop;
  proxy_->GetPendingReports(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<WebUIConversionReportPtr>* out_reports
,
             std::vector<WebUIConversionReportPtr> reports) {*out_reports = std::move(reports);
            loop->Quit();
          },
          &loop,
          out_reports));
  loop.Run();
}
void ConversionInternalsHandlerAsyncWaiter::GetSentReports(
    std::vector<SentReportInfoPtr>* out_reports) {
  base::RunLoop loop;
  proxy_->GetSentReports(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<SentReportInfoPtr>* out_reports
,
             std::vector<SentReportInfoPtr> reports) {*out_reports = std::move(reports);
            loop->Quit();
          },
          &loop,
          out_reports));
  loop.Run();
}
void ConversionInternalsHandlerAsyncWaiter::SendPendingReports(
    ) {
  base::RunLoop loop;
  proxy_->SendPendingReports(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void ConversionInternalsHandlerAsyncWaiter::ClearStorage(
    ) {
  base::RunLoop loop;
  proxy_->ClearStorage(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}





}  // namespace mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif