// content/common/frame.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/common/frame.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/frame.mojom-params-data.h"
namespace content {
namespace mojom {

static NOINLINE const char* ViewWidgetTypeToStringHelper(ViewWidgetType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ViewWidgetType::kTopLevel:
      return "kTopLevel";
    case ViewWidgetType::kGuestView:
      return "kGuestView";
    case ViewWidgetType::kPortal:
      return "kPortal";
    default:
      return nullptr;
  }
}

std::string ViewWidgetTypeToString(ViewWidgetType value) {
  const char *str = ViewWidgetTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ViewWidgetType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ViewWidgetType value) {
  return os << ViewWidgetTypeToString(value);
}

static NOINLINE const char* FrameDeleteIntentionToStringHelper(FrameDeleteIntention value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FrameDeleteIntention::kNotMainFrame:
      return "kNotMainFrame";
    case FrameDeleteIntention::kSpeculativeMainFrameForShutdown:
      return "kSpeculativeMainFrameForShutdown";
    case FrameDeleteIntention::kSpeculativeMainFrameForNavigationCancelled:
      return "kSpeculativeMainFrameForNavigationCancelled";
    default:
      return nullptr;
  }
}

std::string FrameDeleteIntentionToString(FrameDeleteIntention value) {
  const char *str = FrameDeleteIntentionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FrameDeleteIntention value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FrameDeleteIntention value) {
  return os << FrameDeleteIntentionToString(value);
}

static NOINLINE const char* CreateNewWindowStatusToStringHelper(CreateNewWindowStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CreateNewWindowStatus::kBlocked:
      return "kBlocked";
    case CreateNewWindowStatus::kIgnore:
      return "kIgnore";
    case CreateNewWindowStatus::kReuse:
      return "kReuse";
    case CreateNewWindowStatus::kSuccess:
      return "kSuccess";
    default:
      return nullptr;
  }
}

std::string CreateNewWindowStatusToString(CreateNewWindowStatus value) {
  const char *str = CreateNewWindowStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CreateNewWindowStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CreateNewWindowStatus value) {
  return os << CreateNewWindowStatusToString(value);
}

namespace internal {
// static
bool CreateMainFrameUnion_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const CreateMainFrameUnion_Data* object = static_cast<const CreateMainFrameUnion_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case CreateMainFrameUnion_Tag::LOCAL_PARAMS: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_local_params, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_local_params, validation_context))
        return false;
      return true;
    }
    case CreateMainFrameUnion_Tag::REMOTE_PARAMS: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_remote_params, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_remote_params, validation_context))
        return false;
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in CreateMainFrameUnion");
      return false;
    }
  }
}


// static
bool CreateViewParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 104, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CreateViewParams_Data* object = static_cast<const CreateViewParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->renderer_preferences, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->renderer_preferences, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->web_preferences, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->web_preferences, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_storage_namespace_id, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams session_storage_namespace_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->session_storage_namespace_id, validation_context,
                                         &session_storage_namespace_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnion(object->opener_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->replication_state, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->replication_state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtools_main_frame_token, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->devtools_main_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->main_frame, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->main_frame, validation_context))
    return false;


  if (!::content::mojom::internal::ViewWidgetType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->blink_page_broadcast, 15, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->blink_page_broadcast,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->base_background_color, validation_context))
    return false;

  return true;
}

CreateViewParams_Data::CreateViewParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CreateLocalMainFrameParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CreateLocalMainFrameParams_Data* object = static_cast<const CreateLocalMainFrameParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->token, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->frame, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->frame,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->interface_broker, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->interface_broker,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->policy_container, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->widget_params, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->widget_params, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->subresource_loader_factories, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->subresource_loader_factories, validation_context))
    return false;

  return true;
}

CreateLocalMainFrameParams_Data::CreateLocalMainFrameParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CreateRemoteMainFrameParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CreateRemoteMainFrameParams_Data* object = static_cast<const CreateRemoteMainFrameParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->main_frame_interfaces, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->main_frame_interfaces, validation_context))
    return false;

  return true;
}

CreateRemoteMainFrameParams_Data::CreateRemoteMainFrameParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CreateFrameWidgetParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CreateFrameWidgetParams_Data* object = static_cast<const CreateFrameWidgetParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->frame_widget_host, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->frame_widget_host,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->frame_widget, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->frame_widget,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->widget_host, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->widget_host,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->widget, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->widget,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->visual_properties, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->visual_properties, validation_context))
    return false;

  return true;
}

CreateFrameWidgetParams_Data::CreateFrameWidgetParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CreateFrameParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 112, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CreateFrameParams_Data* object = static_cast<const CreateFrameParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->token, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->opener_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->interface_broker, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->interface_broker,
                                                 validation_context)) {
    return false;
  }


  if (!::blink::mojom::internal::TreeScopeType_Data
        ::Validate(object->tree_scope_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->replication_state, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->replication_state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtools_frame_token, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->devtools_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_owner_properties, 11, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_owner_properties, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->widget_params, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->policy_container, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->frame, 15, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->frame,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CreateFrameParams_Data::CreateFrameParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SnapshotAccessibilityTreeParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SnapshotAccessibilityTreeParams_Data* object = static_cast<const SnapshotAccessibilityTreeParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->timeout, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->timeout, validation_context))
    return false;

  return true;
}

SnapshotAccessibilityTreeParams_Data::SnapshotAccessibilityTreeParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteMainFrameInterfaces_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteMainFrameInterfaces_Data* object = static_cast<const RemoteMainFrameInterfaces_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->main_frame_host, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->main_frame_host,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->main_frame, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->main_frame,
                                                 validation_context)) {
    return false;
  }

  return true;
}

RemoteMainFrameInterfaces_Data::RemoteMainFrameInterfaces_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CreateNewWindowParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 88, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CreateNewWindowParams_Data* object = static_cast<const CreateNewWindowParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::content::mojom::internal::WindowContainerType_Data
        ::Validate(object->window_container_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_storage_namespace_id, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams session_storage_namespace_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->session_storage_namespace_id, validation_context,
                                         &session_storage_namespace_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->clone_from_session_storage_namespace_id, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams clone_from_session_storage_namespace_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->clone_from_session_storage_namespace_id, validation_context,
                                         &clone_from_session_storage_namespace_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_name, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams frame_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->frame_name, validation_context,
                                         &frame_name_validate_params)) {
    return false;
  }


  if (!::ui::mojom::internal::WindowOpenDisposition_Data
        ::Validate(object->disposition, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->target_url, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->target_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->referrer, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->referrer, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->features, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->features, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->impression, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->download_policy, 12, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->download_policy, validation_context))
    return false;

  return true;
}

CreateNewWindowParams_Data::CreateNewWindowParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CreateNewWindowReply_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CreateNewWindowReply_Data* object = static_cast<const CreateNewWindowReply_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->main_frame_token, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->main_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->frame, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->frame,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->widget_params, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->widget_params, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page_broadcast, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page_broadcast,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->main_frame_interface_broker, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->main_frame_interface_broker,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cloned_session_storage_namespace_id, 8, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams cloned_session_storage_namespace_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->cloned_session_storage_namespace_id, validation_context,
                                         &cloned_session_storage_namespace_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtools_main_frame_token, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->devtools_main_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->policy_container, 11, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->policy_container, validation_context))
    return false;

  return true;
}

CreateNewWindowReply_Data::CreateNewWindowReply_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameHTMLSerializerHandler_DidReceiveData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameHTMLSerializerHandler_DidReceiveData_Params_Data* object = static_cast<const FrameHTMLSerializerHandler_DidReceiveData_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data_buffer, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams data_buffer_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->data_buffer, validation_context,
                                         &data_buffer_validate_params)) {
    return false;
  }

  return true;
}

FrameHTMLSerializerHandler_DidReceiveData_Params_Data::FrameHTMLSerializerHandler_DidReceiveData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameHTMLSerializerHandler_Done_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameHTMLSerializerHandler_Done_Params_Data* object = static_cast<const FrameHTMLSerializerHandler_Done_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

FrameHTMLSerializerHandler_Done_Params_Data::FrameHTMLSerializerHandler_Done_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Frame_CommitSameDocumentNavigation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Frame_CommitSameDocumentNavigation_Params_Data* object = static_cast<const Frame_CommitSameDocumentNavigation_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->common_params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->common_params, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request_params, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request_params, validation_context))
    return false;

  return true;
}

Frame_CommitSameDocumentNavigation_Params_Data::Frame_CommitSameDocumentNavigation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Frame_CommitSameDocumentNavigation_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Frame_CommitSameDocumentNavigation_ResponseParams_Data* object = static_cast<const Frame_CommitSameDocumentNavigation_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::CommitResult_Data
        ::Validate(object->commit_result, validation_context))
    return false;

  return true;
}

Frame_CommitSameDocumentNavigation_ResponseParams_Data::Frame_CommitSameDocumentNavigation_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Frame_UpdateSubresourceLoaderFactories_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Frame_UpdateSubresourceLoaderFactories_Params_Data* object = static_cast<const Frame_UpdateSubresourceLoaderFactories_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->subresource_loader_factories, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->subresource_loader_factories, validation_context))
    return false;

  return true;
}

Frame_UpdateSubresourceLoaderFactories_Params_Data::Frame_UpdateSubresourceLoaderFactories_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Frame_SetWantErrorMessageStackTrace_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Frame_SetWantErrorMessageStackTrace_Params_Data* object = static_cast<const Frame_SetWantErrorMessageStackTrace_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Frame_SetWantErrorMessageStackTrace_Params_Data::Frame_SetWantErrorMessageStackTrace_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Frame_Unload_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Frame_Unload_Params_Data* object = static_cast<const Frame_Unload_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_remote_frame_replication_state, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->new_remote_frame_replication_state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_remote_frame_token, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->new_remote_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_remote_main_frame_interfaces, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->new_remote_main_frame_interfaces, validation_context))
    return false;

  return true;
}

Frame_Unload_Params_Data::Frame_Unload_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Frame_Delete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Frame_Delete_Params_Data* object = static_cast<const Frame_Delete_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::content::mojom::internal::FrameDeleteIntention_Data
        ::Validate(object->intention, validation_context))
    return false;

  return true;
}

Frame_Delete_Params_Data::Frame_Delete_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Frame_UndoCommitNavigation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Frame_UndoCommitNavigation_Params_Data* object = static_cast<const Frame_UndoCommitNavigation_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_remote_frame_replication_state, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->new_remote_frame_replication_state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_remote_frame_token, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->new_remote_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_remote_main_frame_interfaces, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->new_remote_main_frame_interfaces, validation_context))
    return false;

  return true;
}

Frame_UndoCommitNavigation_Params_Data::Frame_UndoCommitNavigation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Frame_BlockRequests_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Frame_BlockRequests_Params_Data* object = static_cast<const Frame_BlockRequests_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Frame_BlockRequests_Params_Data::Frame_BlockRequests_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Frame_ResumeBlockedRequests_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Frame_ResumeBlockedRequests_Params_Data* object = static_cast<const Frame_ResumeBlockedRequests_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Frame_ResumeBlockedRequests_Params_Data::Frame_ResumeBlockedRequests_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Frame_GetInterfaceProvider_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Frame_GetInterfaceProvider_Params_Data* object = static_cast<const Frame_GetInterfaceProvider_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->interfaces, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->interfaces,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Frame_GetInterfaceProvider_Params_Data::Frame_GetInterfaceProvider_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Frame_SnapshotAccessibilityTree_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Frame_SnapshotAccessibilityTree_Params_Data* object = static_cast<const Frame_SnapshotAccessibilityTree_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

Frame_SnapshotAccessibilityTree_Params_Data::Frame_SnapshotAccessibilityTree_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Frame_SnapshotAccessibilityTree_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Frame_SnapshotAccessibilityTree_ResponseParams_Data* object = static_cast<const Frame_SnapshotAccessibilityTree_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->snapshot, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->snapshot, validation_context))
    return false;

  return true;
}

Frame_SnapshotAccessibilityTree_ResponseParams_Data::Frame_SnapshotAccessibilityTree_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Frame_GetSerializedHtmlWithLocalLinks_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Frame_GetSerializedHtmlWithLocalLinks_Params_Data* object = static_cast<const Frame_GetSerializedHtmlWithLocalLinks_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url_map, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams url_map_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, nullptr), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->url_map, validation_context,
                                         &url_map_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_token_map, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams frame_token_map_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, nullptr), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->frame_token_map, validation_context,
                                         &frame_token_map_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler_remote, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler_remote,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Frame_GetSerializedHtmlWithLocalLinks_Params_Data::Frame_GetSerializedHtmlWithLocalLinks_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameBindingsControl_AllowBindings_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameBindingsControl_AllowBindings_Params_Data* object = static_cast<const FrameBindingsControl_AllowBindings_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

FrameBindingsControl_AllowBindings_Params_Data::FrameBindingsControl_AllowBindings_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameBindingsControl_EnableMojoJsBindings_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameBindingsControl_EnableMojoJsBindings_Params_Data* object = static_cast<const FrameBindingsControl_EnableMojoJsBindings_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

FrameBindingsControl_EnableMojoJsBindings_Params_Data::FrameBindingsControl_EnableMojoJsBindings_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameBindingsControl_BindWebUI_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameBindingsControl_BindWebUI_Params_Data* object = static_cast<const FrameBindingsControl_BindWebUI_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->remote, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->remote,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FrameBindingsControl_BindWebUI_Params_Data::FrameBindingsControl_BindWebUI_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameHost_CreateNewWindow_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameHost_CreateNewWindow_Params_Data* object = static_cast<const FrameHost_CreateNewWindow_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

FrameHost_CreateNewWindow_Params_Data::FrameHost_CreateNewWindow_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameHost_CreateNewWindow_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameHost_CreateNewWindow_ResponseParams_Data* object = static_cast<const FrameHost_CreateNewWindow_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::content::mojom::internal::CreateNewWindowStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->reply, validation_context))
    return false;

  return true;
}

FrameHost_CreateNewWindow_ResponseParams_Data::FrameHost_CreateNewWindow_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameHost_CreatePortal_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameHost_CreatePortal_Params_Data* object = static_cast<const FrameHost_CreatePortal_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->portal, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->portal,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FrameHost_CreatePortal_Params_Data::FrameHost_CreatePortal_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameHost_CreatePortal_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameHost_CreatePortal_ResponseParams_Data* object = static_cast<const FrameHost_CreatePortal_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->initial_replicated_state, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->initial_replicated_state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->portal_token, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->portal_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_token, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtools_frame_token, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->devtools_frame_token, validation_context))
    return false;

  return true;
}

FrameHost_CreatePortal_ResponseParams_Data::FrameHost_CreatePortal_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameHost_AdoptPortal_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameHost_AdoptPortal_Params_Data* object = static_cast<const FrameHost_AdoptPortal_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->portal_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->portal_token, validation_context))
    return false;

  return true;
}

FrameHost_AdoptPortal_Params_Data::FrameHost_AdoptPortal_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameHost_AdoptPortal_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameHost_AdoptPortal_ResponseParams_Data* object = static_cast<const FrameHost_AdoptPortal_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->replicated_state, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->replicated_state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_token, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtools_frame_token, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->devtools_frame_token, validation_context))
    return false;

  return true;
}

FrameHost_AdoptPortal_ResponseParams_Data::FrameHost_AdoptPortal_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameHost_CreateChildFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameHost_CreateChildFrame_Params_Data* object = static_cast<const FrameHost_CreateChildFrame_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->frame, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->frame,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->browser_interface_broker, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->browser_interface_broker,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->policy_container_bind_params, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->policy_container_bind_params, validation_context))
    return false;


  if (!::blink::mojom::internal::TreeScopeType_Data
        ::Validate(object->scope, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_name, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams frame_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->frame_name, validation_context,
                                         &frame_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_unique_name, 7, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams frame_unique_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->frame_unique_name, validation_context,
                                         &frame_unique_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_policy, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_policy, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_owner_properties, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_owner_properties, validation_context))
    return false;


  if (!::blink::mojom::internal::FrameOwnerElementType_Data
        ::Validate(object->frame_owner_element_type, validation_context))
    return false;

  return true;
}

FrameHost_CreateChildFrame_Params_Data::FrameHost_CreateChildFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameHost_DidCommitProvisionalLoad_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameHost_DidCommitProvisionalLoad_Params_Data* object = static_cast<const FrameHost_DidCommitProvisionalLoad_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->interface_params, validation_context))
    return false;

  return true;
}

FrameHost_DidCommitProvisionalLoad_Params_Data::FrameHost_DidCommitProvisionalLoad_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameHost_DidCommitSameDocumentNavigation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameHost_DidCommitSameDocumentNavigation_Params_Data* object = static_cast<const FrameHost_DidCommitSameDocumentNavigation_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->same_document_params, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->same_document_params, validation_context))
    return false;

  return true;
}

FrameHost_DidCommitSameDocumentNavigation_Params_Data::FrameHost_DidCommitSameDocumentNavigation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameHost_DidOpenDocumentInputStream_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameHost_DidOpenDocumentInputStream_Params_Data* object = static_cast<const FrameHost_DidOpenDocumentInputStream_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

FrameHost_DidOpenDocumentInputStream_Params_Data::FrameHost_DidOpenDocumentInputStream_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameHost_BeginNavigation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameHost_BeginNavigation_Params_Data* object = static_cast<const FrameHost_BeginNavigation_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->common_params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->common_params, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->begin_params, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->begin_params, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->blob_url_token,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->navigation_client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->initiator_policy_container_keep_alive_handle,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FrameHost_BeginNavigation_Params_Data::FrameHost_BeginNavigation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameHost_SubresourceResponseStarted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameHost_SubresourceResponseStarted_Params_Data* object = static_cast<const FrameHost_SubresourceResponseStarted_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

FrameHost_SubresourceResponseStarted_Params_Data::FrameHost_SubresourceResponseStarted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameHost_ResourceLoadComplete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameHost_ResourceLoadComplete_Params_Data* object = static_cast<const FrameHost_ResourceLoadComplete_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url_load_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url_load_info, validation_context))
    return false;

  return true;
}

FrameHost_ResourceLoadComplete_Params_Data::FrameHost_ResourceLoadComplete_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameHost_DidChangeName_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameHost_DidChangeName_Params_Data* object = static_cast<const FrameHost_DidChangeName_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->unique_name, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams unique_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->unique_name, validation_context,
                                         &unique_name_validate_params)) {
    return false;
  }

  return true;
}

FrameHost_DidChangeName_Params_Data::FrameHost_DidChangeName_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameHost_CancelInitialHistoryLoad_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameHost_CancelInitialHistoryLoad_Params_Data* object = static_cast<const FrameHost_CancelInitialHistoryLoad_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

FrameHost_CancelInitialHistoryLoad_Params_Data::FrameHost_CancelInitialHistoryLoad_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameHost_UpdateEncoding_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameHost_UpdateEncoding_Params_Data* object = static_cast<const FrameHost_UpdateEncoding_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->encoding_name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams encoding_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->encoding_name, validation_context,
                                         &encoding_name_validate_params)) {
    return false;
  }

  return true;
}

FrameHost_UpdateEncoding_Params_Data::FrameHost_UpdateEncoding_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameHost_UpdateState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameHost_UpdateState_Params_Data* object = static_cast<const FrameHost_UpdateState_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->state, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->state, validation_context))
    return false;

  return true;
}

FrameHost_UpdateState_Params_Data::FrameHost_UpdateState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameHost_OpenURL_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameHost_OpenURL_Params_Data* object = static_cast<const FrameHost_OpenURL_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

FrameHost_OpenURL_Params_Data::FrameHost_OpenURL_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameHost_DidStopLoading_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameHost_DidStopLoading_Params_Data* object = static_cast<const FrameHost_DidStopLoading_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

FrameHost_DidStopLoading_Params_Data::FrameHost_DidStopLoading_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace content

namespace perfetto {

// static
void TraceFormatTraits<::content::mojom::ViewWidgetType>::WriteIntoTrace(
   perfetto::TracedValue context, ::content::mojom::ViewWidgetType value) {
  return std::move(context).WriteString(::content::mojom::ViewWidgetTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::content::mojom::FrameDeleteIntention>::WriteIntoTrace(
   perfetto::TracedValue context, ::content::mojom::FrameDeleteIntention value) {
  return std::move(context).WriteString(::content::mojom::FrameDeleteIntentionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::content::mojom::CreateNewWindowStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::content::mojom::CreateNewWindowStatus value) {
  return std::move(context).WriteString(::content::mojom::CreateNewWindowStatusToString(value));
}

} // namespace perfetto
