// content/common/input/input_injector.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/common/input/input_injector.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/input/input_injector.mojom-params-data.h"
namespace content {
namespace mojom {

static NOINLINE const char* GestureSourceTypeToStringHelper(GestureSourceType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case GestureSourceType::kDefaultInput:
      return "kDefaultInput";
    case GestureSourceType::kTouchInput:
      return "kTouchInput";
    case GestureSourceType::kMouseInput:
      return "{kMouseInput, kTouchpadInput}";
    case GestureSourceType::kPenInput:
      return "{kPenInput, kGestureSourceTypeMax}";
    default:
      return nullptr;
  }
}

std::string GestureSourceTypeToString(GestureSourceType value) {
  const char *str = GestureSourceTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown GestureSourceType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, GestureSourceType value) {
  return os << GestureSourceTypeToString(value);
}

static NOINLINE const char* PointerActionTypeToStringHelper(PointerActionType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PointerActionType::kNotInitialized:
      return "kNotInitialized";
    case PointerActionType::kPress:
      return "kPress";
    case PointerActionType::kMove:
      return "kMove";
    case PointerActionType::kRelease:
      return "kRelease";
    case PointerActionType::kCancel:
      return "kCancel";
    case PointerActionType::kLeave:
      return "kLeave";
    case PointerActionType::kIdle:
      return "kIdle";
    default:
      return nullptr;
  }
}

std::string PointerActionTypeToString(PointerActionType value) {
  const char *str = PointerActionTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PointerActionType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PointerActionType value) {
  return os << PointerActionTypeToString(value);
}

static NOINLINE const char* SyntheticButtonToStringHelper(SyntheticButton value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SyntheticButton::kNoButton:
      return "kNoButton";
    case SyntheticButton::kLeft:
      return "kLeft";
    case SyntheticButton::kMiddle:
      return "kMiddle";
    case SyntheticButton::kRight:
      return "kRight";
    case SyntheticButton::kBack:
      return "kBack";
    case SyntheticButton::kForward:
      return "kForward";
    default:
      return nullptr;
  }
}

std::string SyntheticButtonToString(SyntheticButton value) {
  const char *str = SyntheticButtonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SyntheticButton value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SyntheticButton value) {
  return os << SyntheticButtonToString(value);
}

namespace internal {


// static
bool SyntheticSmoothDrag_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SyntheticSmoothDrag_Data* object = static_cast<const SyntheticSmoothDrag_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::content::mojom::internal::GestureSourceType_Data
        ::Validate(object->gesture_source_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->start_point, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->start_point, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->distances, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams distances_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->distances, validation_context,
                                         &distances_validate_params)) {
    return false;
  }

  return true;
}

SyntheticSmoothDrag_Data::SyntheticSmoothDrag_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SyntheticSmoothScroll_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SyntheticSmoothScroll_Data* object = static_cast<const SyntheticSmoothScroll_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::content::mojom::internal::GestureSourceType_Data
        ::Validate(object->gesture_source_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->anchor, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->anchor, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->distances, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams distances_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->distances, validation_context,
                                         &distances_validate_params)) {
    return false;
  }


  if (!::ui::mojom::internal::ScrollGranularity_Data
        ::Validate(object->granularity, validation_context))
    return false;

  return true;
}

SyntheticSmoothScroll_Data::SyntheticSmoothScroll_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SyntheticPinch_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SyntheticPinch_Data* object = static_cast<const SyntheticPinch_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->anchor, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->anchor, validation_context))
    return false;

  return true;
}

SyntheticPinch_Data::SyntheticPinch_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SyntheticTap_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SyntheticTap_Data* object = static_cast<const SyntheticTap_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::content::mojom::internal::GestureSourceType_Data
        ::Validate(object->gesture_source_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->position, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->position, validation_context))
    return false;

  return true;
}

SyntheticTap_Data::SyntheticTap_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SyntheticPointerActionParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SyntheticPointerActionParams_Data* object = static_cast<const SyntheticPointerActionParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::content::mojom::internal::PointerActionType_Data
        ::Validate(object->pointer_action_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->position, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->position, validation_context))
    return false;


  if (!::content::mojom::internal::SyntheticButton_Data
        ::Validate(object->button, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->timestamp, 13, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->timestamp, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->duration, 14, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->duration, validation_context))
    return false;

  return true;
}

SyntheticPointerActionParams_Data::SyntheticPointerActionParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SyntheticPointerAction_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SyntheticPointerAction_Data* object = static_cast<const SyntheticPointerAction_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::content::mojom::internal::GestureSourceType_Data
        ::Validate(object->gesture_source_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams params_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->params, validation_context,
                                         &params_validate_params)) {
    return false;
  }

  return true;
}

SyntheticPointerAction_Data::SyntheticPointerAction_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InputInjector_QueueSyntheticSmoothDrag_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const InputInjector_QueueSyntheticSmoothDrag_Params_Data* object = static_cast<const InputInjector_QueueSyntheticSmoothDrag_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->drag, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->drag, validation_context))
    return false;

  return true;
}

InputInjector_QueueSyntheticSmoothDrag_Params_Data::InputInjector_QueueSyntheticSmoothDrag_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InputInjector_QueueSyntheticSmoothDrag_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const InputInjector_QueueSyntheticSmoothDrag_ResponseParams_Data* object = static_cast<const InputInjector_QueueSyntheticSmoothDrag_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

InputInjector_QueueSyntheticSmoothDrag_ResponseParams_Data::InputInjector_QueueSyntheticSmoothDrag_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InputInjector_QueueSyntheticSmoothScroll_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const InputInjector_QueueSyntheticSmoothScroll_Params_Data* object = static_cast<const InputInjector_QueueSyntheticSmoothScroll_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scroll, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scroll, validation_context))
    return false;

  return true;
}

InputInjector_QueueSyntheticSmoothScroll_Params_Data::InputInjector_QueueSyntheticSmoothScroll_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InputInjector_QueueSyntheticSmoothScroll_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const InputInjector_QueueSyntheticSmoothScroll_ResponseParams_Data* object = static_cast<const InputInjector_QueueSyntheticSmoothScroll_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

InputInjector_QueueSyntheticSmoothScroll_ResponseParams_Data::InputInjector_QueueSyntheticSmoothScroll_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InputInjector_QueueSyntheticPinch_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const InputInjector_QueueSyntheticPinch_Params_Data* object = static_cast<const InputInjector_QueueSyntheticPinch_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pinch, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->pinch, validation_context))
    return false;

  return true;
}

InputInjector_QueueSyntheticPinch_Params_Data::InputInjector_QueueSyntheticPinch_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InputInjector_QueueSyntheticPinch_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const InputInjector_QueueSyntheticPinch_ResponseParams_Data* object = static_cast<const InputInjector_QueueSyntheticPinch_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

InputInjector_QueueSyntheticPinch_ResponseParams_Data::InputInjector_QueueSyntheticPinch_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InputInjector_QueueSyntheticTap_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const InputInjector_QueueSyntheticTap_Params_Data* object = static_cast<const InputInjector_QueueSyntheticTap_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tap, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tap, validation_context))
    return false;

  return true;
}

InputInjector_QueueSyntheticTap_Params_Data::InputInjector_QueueSyntheticTap_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InputInjector_QueueSyntheticTap_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const InputInjector_QueueSyntheticTap_ResponseParams_Data* object = static_cast<const InputInjector_QueueSyntheticTap_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

InputInjector_QueueSyntheticTap_ResponseParams_Data::InputInjector_QueueSyntheticTap_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InputInjector_QueueSyntheticPointerAction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const InputInjector_QueueSyntheticPointerAction_Params_Data* object = static_cast<const InputInjector_QueueSyntheticPointerAction_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pointer_action, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->pointer_action, validation_context))
    return false;

  return true;
}

InputInjector_QueueSyntheticPointerAction_Params_Data::InputInjector_QueueSyntheticPointerAction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InputInjector_QueueSyntheticPointerAction_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const InputInjector_QueueSyntheticPointerAction_ResponseParams_Data* object = static_cast<const InputInjector_QueueSyntheticPointerAction_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

InputInjector_QueueSyntheticPointerAction_ResponseParams_Data::InputInjector_QueueSyntheticPointerAction_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace content

namespace perfetto {

// static
void TraceFormatTraits<::content::mojom::GestureSourceType>::WriteIntoTrace(
   perfetto::TracedValue context, ::content::mojom::GestureSourceType value) {
  return std::move(context).WriteString(::content::mojom::GestureSourceTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::content::mojom::PointerActionType>::WriteIntoTrace(
   perfetto::TracedValue context, ::content::mojom::PointerActionType value) {
  return std::move(context).WriteString(::content::mojom::PointerActionTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::content::mojom::SyntheticButton>::WriteIntoTrace(
   perfetto::TracedValue context, ::content::mojom::SyntheticButton value) {
  return std::move(context).WriteString(::content::mojom::SyntheticButtonToString(value));
}

} // namespace perfetto
