// content/public/common/window_container_type.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/public/common/window_container_type.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/public/common/window_container_type.mojom-params-data.h"
namespace content {
namespace mojom {

static NOINLINE const char* WindowContainerTypeToStringHelper(WindowContainerType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WindowContainerType::NORMAL:
      return "NORMAL";
    case WindowContainerType::BACKGROUND:
      return "BACKGROUND";
    case WindowContainerType::PERSISTENT:
      return "PERSISTENT";
    default:
      return nullptr;
  }
}

std::string WindowContainerTypeToString(WindowContainerType value) {
  const char *str = WindowContainerTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WindowContainerType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WindowContainerType value) {
  return os << WindowContainerTypeToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace content

namespace perfetto {

// static
void TraceFormatTraits<::content::mojom::WindowContainerType>::WriteIntoTrace(
   perfetto::TracedValue context, ::content::mojom::WindowContainerType value) {
  return std::move(context).WriteString(::content::mojom::WindowContainerTypeToString(value));
}

} // namespace perfetto
