// content/services/auction_worklet/public/mojom/bidder_worklet.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/services/auction_worklet/public/mojom/bidder_worklet.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/services/auction_worklet/public/mojom/bidder_worklet.mojom-params-data.h"
#include "content/services/auction_worklet/public/mojom/bidder_worklet.mojom-shared-message-ids.h"

#include "content/services/auction_worklet/public/mojom/bidder_worklet.mojom-import-headers.h"


#ifndef CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_BIDDER_WORKLET_MOJOM_JUMBO_H_
#define CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_BIDDER_WORKLET_MOJOM_JUMBO_H_
#endif
namespace auction_worklet {
namespace mojom {
PreviousWin::PreviousWin()
    : time(),
      ad_json() {}

PreviousWin::PreviousWin(
    ::base::Time time_in,
    const std::string& ad_json_in)
    : time(std::move(time_in)),
      ad_json(std::move(ad_json_in)) {}

PreviousWin::~PreviousWin() = default;

void PreviousWin::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "time"), this->time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ad_json"), this->ad_json,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PreviousWin::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BiddingBrowserSignals::BiddingBrowserSignals()
    : join_count(),
      bid_count(),
      prev_wins() {}

BiddingBrowserSignals::BiddingBrowserSignals(
    int32_t join_count_in,
    int32_t bid_count_in,
    std::vector<PreviousWinPtr> prev_wins_in)
    : join_count(std::move(join_count_in)),
      bid_count(std::move(bid_count_in)),
      prev_wins(std::move(prev_wins_in)) {}

BiddingBrowserSignals::~BiddingBrowserSignals() = default;

void BiddingBrowserSignals::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "join_count"), this->join_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bid_count"), this->bid_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prev_wins"), this->prev_wins,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<PreviousWinPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BiddingBrowserSignals::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BiddingInterestGroup::BiddingInterestGroup()
    : group(),
      signals() {}

BiddingInterestGroup::BiddingInterestGroup(
    const ::blink::InterestGroup& group_in,
    BiddingBrowserSignalsPtr signals_in)
    : group(std::move(group_in)),
      signals(std::move(signals_in)) {}

BiddingInterestGroup::~BiddingInterestGroup() = default;

void BiddingInterestGroup::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "group"), this->group,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::InterestGroup&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "signals"), this->signals,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BiddingBrowserSignalsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BiddingInterestGroup::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BidderWorkletBid::BidderWorkletBid()
    : ad(),
      bid(),
      render_url(),
      bid_duration() {}

BidderWorkletBid::BidderWorkletBid(
    const std::string& ad_in,
    double bid_in,
    const ::GURL& render_url_in,
    ::base::TimeDelta bid_duration_in)
    : ad(std::move(ad_in)),
      bid(std::move(bid_in)),
      render_url(std::move(render_url_in)),
      bid_duration(std::move(bid_duration_in)) {}

BidderWorkletBid::~BidderWorkletBid() = default;

void BidderWorkletBid::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ad"), this->ad,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bid"), this->bid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "render_url"), this->render_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bid_duration"), this->bid_duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BidderWorkletBid::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char BidderWorklet::Name_[] = "auction_worklet.mojom.BidderWorklet";

class BidderWorklet_ReportWin_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BidderWorklet_ReportWin_ForwardToCallback(
      BidderWorklet::ReportWinCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  BidderWorklet::ReportWinCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(BidderWorklet_ReportWin_ForwardToCallback);
};

BidderWorkletProxy::BidderWorkletProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BidderWorkletProxy::ReportWin(
    const std::string& in_seller_signals_json, const ::GURL& in_browser_signal_render_url, const std::string& in_browser_signal_ad_render_fingerprint, double in_browser_signal_bid, ReportWinCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "auction_worklet::mojom::BidderWorklet::ReportWin", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("seller_signals_json"), in_seller_signals_json,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_render_url"), in_browser_signal_render_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_ad_render_fingerprint"), in_browser_signal_ad_render_fingerprint,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_bid"), in_browser_signal_bid,
                        "<value of type double>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBidderWorklet_ReportWin_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::BidderWorklet_ReportWin_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->seller_signals_json)::BaseType> seller_signals_json_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_seller_signals_json, seller_signals_json_fragment);
  params->seller_signals_json.Set(
      seller_signals_json_fragment.is_null() ? nullptr : seller_signals_json_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->seller_signals_json.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null seller_signals_json in BidderWorklet.ReportWin request");
  mojo::internal::MessageFragment<
      typename decltype(params->browser_signal_render_url)::BaseType> browser_signal_render_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_browser_signal_render_url, browser_signal_render_url_fragment);
  params->browser_signal_render_url.Set(
      browser_signal_render_url_fragment.is_null() ? nullptr : browser_signal_render_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->browser_signal_render_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null browser_signal_render_url in BidderWorklet.ReportWin request");
  mojo::internal::MessageFragment<
      typename decltype(params->browser_signal_ad_render_fingerprint)::BaseType> browser_signal_ad_render_fingerprint_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_browser_signal_ad_render_fingerprint, browser_signal_ad_render_fingerprint_fragment);
  params->browser_signal_ad_render_fingerprint.Set(
      browser_signal_ad_render_fingerprint_fragment.is_null() ? nullptr : browser_signal_ad_render_fingerprint_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->browser_signal_ad_render_fingerprint.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null browser_signal_ad_render_fingerprint in BidderWorklet.ReportWin request");
  params->browser_signal_bid = in_browser_signal_bid;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BidderWorklet::Name_);
  message.set_method_name("ReportWin");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BidderWorklet_ReportWin_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class BidderWorklet_ReportWin_ProxyToResponder {
 public:
  static BidderWorklet::ReportWinCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<BidderWorklet_ReportWin_ProxyToResponder> proxy(
        new BidderWorklet_ReportWin_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&BidderWorklet_ReportWin_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BidderWorklet_ReportWin_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  BidderWorklet_ReportWin_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BidderWorklet::ReportWinCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const absl::optional<::GURL>& in_report_url, const std::vector<std::string>& in_errors);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(BidderWorklet_ReportWin_ProxyToResponder);
};

bool BidderWorklet_ReportWin_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "auction_worklet::mojom::BidderWorklet::ReportWinCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::BidderWorklet_ReportWin_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BidderWorklet_ReportWin_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  absl::optional<::GURL> p_report_url{};
  std::vector<std::string> p_errors{};
  BidderWorklet_ReportWin_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadReportUrl(&p_report_url))
    success = false;
  if (success && !input_data_view.ReadErrors(&p_errors))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BidderWorklet::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_report_url), 
std::move(p_errors));
  return true;
}

void BidderWorklet_ReportWin_ProxyToResponder::Run(
    const absl::optional<::GURL>& in_report_url, const std::vector<std::string>& in_errors) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)auction_worklet::mojom::BidderWorklet::ReportWinCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("report_url"), in_report_url,
                        "<value of type const absl::optional<::GURL>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("errors"), in_errors,
                        "<value of type const std::vector<std::string>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBidderWorklet_ReportWin_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::BidderWorklet_ReportWin_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->report_url)::BaseType> report_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_report_url, report_url_fragment);
  params->report_url.Set(
      report_url_fragment.is_null() ? nullptr : report_url_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->errors)::BaseType>
      errors_fragment(params.message());
  const mojo::internal::ContainerValidateParams errors_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_errors, errors_fragment, &errors_validate_params);
  params->errors.Set(
      errors_fragment.is_null() ? nullptr : errors_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->errors.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null errors in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)auction_worklet::mojom::BidderWorklet::ReportWinCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BidderWorklet::Name_);
  message.set_method_name("ReportWin");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BidderWorkletStubDispatch::Accept(
    BidderWorklet* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kBidderWorklet_ReportWin_Name: {
      break;
    }
  }
  return false;
}

// static
bool BidderWorkletStubDispatch::AcceptWithResponder(
    BidderWorklet* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kBidderWorklet_ReportWin_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)auction_worklet::mojom::BidderWorklet::ReportWin",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)auction_worklet::mojom::BidderWorklet::ReportWin");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::BidderWorklet_ReportWin_Params_Data* params =
          reinterpret_cast<
              internal::BidderWorklet_ReportWin_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_seller_signals_json{};
      ::GURL p_browser_signal_render_url{};
      std::string p_browser_signal_ad_render_fingerprint{};
      double p_browser_signal_bid{};
      BidderWorklet_ReportWin_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSellerSignalsJson(&p_seller_signals_json))
        success = false;
      if (success && !input_data_view.ReadBrowserSignalRenderUrl(&p_browser_signal_render_url))
        success = false;
      if (success && !input_data_view.ReadBrowserSignalAdRenderFingerprint(&p_browser_signal_ad_render_fingerprint))
        success = false;
      if (success)
        p_browser_signal_bid = input_data_view.browser_signal_bid();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BidderWorklet::Name_, 0, false);
        return false;
      }
      BidderWorklet::ReportWinCallback callback =
          BidderWorklet_ReportWin_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportWin(
std::move(p_seller_signals_json), 
std::move(p_browser_signal_render_url), 
std::move(p_browser_signal_ad_render_fingerprint), 
std::move(p_browser_signal_bid), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kBidderWorkletValidationInfo[] = {
    {internal::kBidderWorklet_ReportWin_Name,
     {&internal::BidderWorklet_ReportWin_Params_Data::Validate,
      &internal::BidderWorklet_ReportWin_ResponseParams_Data::Validate}},
};

bool BidderWorkletRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::auction_worklet::mojom::BidderWorklet::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kBidderWorkletValidationInfo);
}

bool BidderWorkletResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::auction_worklet::mojom::BidderWorklet::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kBidderWorkletValidationInfo);

}
}  // namespace mojom
}  // namespace auction_worklet

namespace mojo {


// static
bool StructTraits<::auction_worklet::mojom::PreviousWin::DataView, ::auction_worklet::mojom::PreviousWinPtr>::Read(
    ::auction_worklet::mojom::PreviousWin::DataView input,
    ::auction_worklet::mojom::PreviousWinPtr* output) {
  bool success = true;
  ::auction_worklet::mojom::PreviousWinPtr result(::auction_worklet::mojom::PreviousWin::New());
  
      if (success && !input.ReadTime(&result->time))
        success = false;
      if (success && !input.ReadAdJson(&result->ad_json))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::auction_worklet::mojom::BiddingBrowserSignals::DataView, ::auction_worklet::mojom::BiddingBrowserSignalsPtr>::Read(
    ::auction_worklet::mojom::BiddingBrowserSignals::DataView input,
    ::auction_worklet::mojom::BiddingBrowserSignalsPtr* output) {
  bool success = true;
  ::auction_worklet::mojom::BiddingBrowserSignalsPtr result(::auction_worklet::mojom::BiddingBrowserSignals::New());
  
      if (success)
        result->join_count = input.join_count();
      if (success)
        result->bid_count = input.bid_count();
      if (success && !input.ReadPrevWins(&result->prev_wins))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::auction_worklet::mojom::BiddingInterestGroup::DataView, ::auction_worklet::mojom::BiddingInterestGroupPtr>::Read(
    ::auction_worklet::mojom::BiddingInterestGroup::DataView input,
    ::auction_worklet::mojom::BiddingInterestGroupPtr* output) {
  bool success = true;
  ::auction_worklet::mojom::BiddingInterestGroupPtr result(::auction_worklet::mojom::BiddingInterestGroup::New());
  
      if (success && !input.ReadGroup(&result->group))
        success = false;
      if (success && !input.ReadSignals(&result->signals))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::auction_worklet::mojom::BidderWorkletBid::DataView, ::auction_worklet::mojom::BidderWorkletBidPtr>::Read(
    ::auction_worklet::mojom::BidderWorkletBid::DataView input,
    ::auction_worklet::mojom::BidderWorkletBidPtr* output) {
  bool success = true;
  ::auction_worklet::mojom::BidderWorkletBidPtr result(::auction_worklet::mojom::BidderWorkletBid::New());
  
      if (success && !input.ReadAd(&result->ad))
        success = false;
      if (success)
        result->bid = input.bid();
      if (success && !input.ReadRenderUrl(&result->render_url))
        success = false;
      if (success && !input.ReadBidDuration(&result->bid_duration))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif