// content/services/auction_worklet/public/mojom/seller_worklet.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/services/auction_worklet/public/mojom/seller_worklet.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/services/auction_worklet/public/mojom/seller_worklet.mojom-params-data.h"
#include "content/services/auction_worklet/public/mojom/seller_worklet.mojom-shared-message-ids.h"

#include "content/services/auction_worklet/public/mojom/seller_worklet.mojom-import-headers.h"


#ifndef CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_SELLER_WORKLET_MOJOM_JUMBO_H_
#define CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_SELLER_WORKLET_MOJOM_JUMBO_H_
#endif
namespace auction_worklet {
namespace mojom {
const char SellerWorklet::Name_[] = "auction_worklet.mojom.SellerWorklet";

class SellerWorklet_ScoreAd_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SellerWorklet_ScoreAd_ForwardToCallback(
      SellerWorklet::ScoreAdCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SellerWorklet::ScoreAdCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SellerWorklet_ScoreAd_ForwardToCallback);
};

class SellerWorklet_ReportResult_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SellerWorklet_ReportResult_ForwardToCallback(
      SellerWorklet::ReportResultCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SellerWorklet::ReportResultCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SellerWorklet_ReportResult_ForwardToCallback);
};

SellerWorkletProxy::SellerWorkletProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SellerWorkletProxy::ScoreAd(
    const std::string& in_ad_metadata_json, double in_bid, ::blink::mojom::AuctionAdConfigPtr in_auction_config, const ::url::Origin& in_browser_signal_top_window_origin, const ::url::Origin& in_browser_signal_interest_group_owner, const std::string& in_browser_signal_ad_render_fingerprint, uint32_t in_browser_signal_bidding_duration_msecs, ScoreAdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "auction_worklet::mojom::SellerWorklet::ScoreAd", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ad_metadata_json"), in_ad_metadata_json,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bid"), in_bid,
                        "<value of type double>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("auction_config"), in_auction_config,
                        "<value of type ::blink::mojom::AuctionAdConfigPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_top_window_origin"), in_browser_signal_top_window_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_interest_group_owner"), in_browser_signal_interest_group_owner,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_ad_render_fingerprint"), in_browser_signal_ad_render_fingerprint,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_bidding_duration_msecs"), in_browser_signal_bidding_duration_msecs,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSellerWorklet_ScoreAd_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::SellerWorklet_ScoreAd_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->ad_metadata_json)::BaseType> ad_metadata_json_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_ad_metadata_json, ad_metadata_json_fragment);
  params->ad_metadata_json.Set(
      ad_metadata_json_fragment.is_null() ? nullptr : ad_metadata_json_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->ad_metadata_json.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ad_metadata_json in SellerWorklet.ScoreAd request");
  params->bid = in_bid;
  mojo::internal::MessageFragment<
      typename decltype(params->auction_config)::BaseType> auction_config_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::AuctionAdConfigDataView>(
      in_auction_config, auction_config_fragment);
  params->auction_config.Set(
      auction_config_fragment.is_null() ? nullptr : auction_config_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->auction_config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null auction_config in SellerWorklet.ScoreAd request");
  mojo::internal::MessageFragment<
      typename decltype(params->browser_signal_top_window_origin)::BaseType> browser_signal_top_window_origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_browser_signal_top_window_origin, browser_signal_top_window_origin_fragment);
  params->browser_signal_top_window_origin.Set(
      browser_signal_top_window_origin_fragment.is_null() ? nullptr : browser_signal_top_window_origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->browser_signal_top_window_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null browser_signal_top_window_origin in SellerWorklet.ScoreAd request");
  mojo::internal::MessageFragment<
      typename decltype(params->browser_signal_interest_group_owner)::BaseType> browser_signal_interest_group_owner_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_browser_signal_interest_group_owner, browser_signal_interest_group_owner_fragment);
  params->browser_signal_interest_group_owner.Set(
      browser_signal_interest_group_owner_fragment.is_null() ? nullptr : browser_signal_interest_group_owner_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->browser_signal_interest_group_owner.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null browser_signal_interest_group_owner in SellerWorklet.ScoreAd request");
  mojo::internal::MessageFragment<
      typename decltype(params->browser_signal_ad_render_fingerprint)::BaseType> browser_signal_ad_render_fingerprint_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_browser_signal_ad_render_fingerprint, browser_signal_ad_render_fingerprint_fragment);
  params->browser_signal_ad_render_fingerprint.Set(
      browser_signal_ad_render_fingerprint_fragment.is_null() ? nullptr : browser_signal_ad_render_fingerprint_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->browser_signal_ad_render_fingerprint.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null browser_signal_ad_render_fingerprint in SellerWorklet.ScoreAd request");
  params->browser_signal_bidding_duration_msecs = in_browser_signal_bidding_duration_msecs;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SellerWorklet::Name_);
  message.set_method_name("ScoreAd");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SellerWorklet_ScoreAd_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void SellerWorkletProxy::ReportResult(
    ::blink::mojom::AuctionAdConfigPtr in_auction_config, const ::url::Origin& in_browser_signal_top_window_origin, const ::url::Origin& in_browser_signal_interest_group_owner, const ::GURL& in_browser_signal_render_url, const std::string& in_browser_signal_ad_render_fingerprint, double in_browser_signal_bid, double in_browser_signal_desirability, ReportResultCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "auction_worklet::mojom::SellerWorklet::ReportResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("auction_config"), in_auction_config,
                        "<value of type ::blink::mojom::AuctionAdConfigPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_top_window_origin"), in_browser_signal_top_window_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_interest_group_owner"), in_browser_signal_interest_group_owner,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_render_url"), in_browser_signal_render_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_ad_render_fingerprint"), in_browser_signal_ad_render_fingerprint,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_bid"), in_browser_signal_bid,
                        "<value of type double>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_desirability"), in_browser_signal_desirability,
                        "<value of type double>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSellerWorklet_ReportResult_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::SellerWorklet_ReportResult_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->auction_config)::BaseType> auction_config_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::AuctionAdConfigDataView>(
      in_auction_config, auction_config_fragment);
  params->auction_config.Set(
      auction_config_fragment.is_null() ? nullptr : auction_config_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->auction_config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null auction_config in SellerWorklet.ReportResult request");
  mojo::internal::MessageFragment<
      typename decltype(params->browser_signal_top_window_origin)::BaseType> browser_signal_top_window_origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_browser_signal_top_window_origin, browser_signal_top_window_origin_fragment);
  params->browser_signal_top_window_origin.Set(
      browser_signal_top_window_origin_fragment.is_null() ? nullptr : browser_signal_top_window_origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->browser_signal_top_window_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null browser_signal_top_window_origin in SellerWorklet.ReportResult request");
  mojo::internal::MessageFragment<
      typename decltype(params->browser_signal_interest_group_owner)::BaseType> browser_signal_interest_group_owner_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_browser_signal_interest_group_owner, browser_signal_interest_group_owner_fragment);
  params->browser_signal_interest_group_owner.Set(
      browser_signal_interest_group_owner_fragment.is_null() ? nullptr : browser_signal_interest_group_owner_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->browser_signal_interest_group_owner.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null browser_signal_interest_group_owner in SellerWorklet.ReportResult request");
  mojo::internal::MessageFragment<
      typename decltype(params->browser_signal_render_url)::BaseType> browser_signal_render_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_browser_signal_render_url, browser_signal_render_url_fragment);
  params->browser_signal_render_url.Set(
      browser_signal_render_url_fragment.is_null() ? nullptr : browser_signal_render_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->browser_signal_render_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null browser_signal_render_url in SellerWorklet.ReportResult request");
  mojo::internal::MessageFragment<
      typename decltype(params->browser_signal_ad_render_fingerprint)::BaseType> browser_signal_ad_render_fingerprint_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_browser_signal_ad_render_fingerprint, browser_signal_ad_render_fingerprint_fragment);
  params->browser_signal_ad_render_fingerprint.Set(
      browser_signal_ad_render_fingerprint_fragment.is_null() ? nullptr : browser_signal_ad_render_fingerprint_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->browser_signal_ad_render_fingerprint.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null browser_signal_ad_render_fingerprint in SellerWorklet.ReportResult request");
  params->browser_signal_bid = in_browser_signal_bid;
  params->browser_signal_desirability = in_browser_signal_desirability;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SellerWorklet::Name_);
  message.set_method_name("ReportResult");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SellerWorklet_ReportResult_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class SellerWorklet_ScoreAd_ProxyToResponder {
 public:
  static SellerWorklet::ScoreAdCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SellerWorklet_ScoreAd_ProxyToResponder> proxy(
        new SellerWorklet_ScoreAd_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SellerWorklet_ScoreAd_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SellerWorklet_ScoreAd_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SellerWorklet_ScoreAd_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SellerWorklet::ScoreAdCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      double in_score, const std::vector<std::string>& in_errors);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SellerWorklet_ScoreAd_ProxyToResponder);
};

bool SellerWorklet_ScoreAd_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "auction_worklet::mojom::SellerWorklet::ScoreAdCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::SellerWorklet_ScoreAd_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SellerWorklet_ScoreAd_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  double p_score{};
  std::vector<std::string> p_errors{};
  SellerWorklet_ScoreAd_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_score = input_data_view.score();
  if (success && !input_data_view.ReadErrors(&p_errors))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SellerWorklet::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_score), 
std::move(p_errors));
  return true;
}

void SellerWorklet_ScoreAd_ProxyToResponder::Run(
    double in_score, const std::vector<std::string>& in_errors) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)auction_worklet::mojom::SellerWorklet::ScoreAdCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("score"), in_score,
                        "<value of type double>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("errors"), in_errors,
                        "<value of type const std::vector<std::string>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSellerWorklet_ScoreAd_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::SellerWorklet_ScoreAd_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->score = in_score;
  mojo::internal::MessageFragment<
      typename decltype(params->errors)::BaseType>
      errors_fragment(params.message());
  const mojo::internal::ContainerValidateParams errors_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_errors, errors_fragment, &errors_validate_params);
  params->errors.Set(
      errors_fragment.is_null() ? nullptr : errors_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->errors.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null errors in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)auction_worklet::mojom::SellerWorklet::ScoreAdCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SellerWorklet::Name_);
  message.set_method_name("ScoreAd");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SellerWorklet_ReportResult_ProxyToResponder {
 public:
  static SellerWorklet::ReportResultCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SellerWorklet_ReportResult_ProxyToResponder> proxy(
        new SellerWorklet_ReportResult_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SellerWorklet_ReportResult_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SellerWorklet_ReportResult_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SellerWorklet_ReportResult_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SellerWorklet::ReportResultCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const absl::optional<std::string>& in_signals_for_winner, const absl::optional<::GURL>& in_report_url, const std::vector<std::string>& in_error_msgs);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SellerWorklet_ReportResult_ProxyToResponder);
};

bool SellerWorklet_ReportResult_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "auction_worklet::mojom::SellerWorklet::ReportResultCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::SellerWorklet_ReportResult_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SellerWorklet_ReportResult_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  absl::optional<std::string> p_signals_for_winner{};
  absl::optional<::GURL> p_report_url{};
  std::vector<std::string> p_error_msgs{};
  SellerWorklet_ReportResult_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSignalsForWinner(&p_signals_for_winner))
    success = false;
  if (success && !input_data_view.ReadReportUrl(&p_report_url))
    success = false;
  if (success && !input_data_view.ReadErrorMsgs(&p_error_msgs))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SellerWorklet::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_signals_for_winner), 
std::move(p_report_url), 
std::move(p_error_msgs));
  return true;
}

void SellerWorklet_ReportResult_ProxyToResponder::Run(
    const absl::optional<std::string>& in_signals_for_winner, const absl::optional<::GURL>& in_report_url, const std::vector<std::string>& in_error_msgs) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)auction_worklet::mojom::SellerWorklet::ReportResultCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("signals_for_winner"), in_signals_for_winner,
                        "<value of type const absl::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("report_url"), in_report_url,
                        "<value of type const absl::optional<::GURL>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_msgs"), in_error_msgs,
                        "<value of type const std::vector<std::string>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSellerWorklet_ReportResult_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::SellerWorklet_ReportResult_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->signals_for_winner)::BaseType> signals_for_winner_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_signals_for_winner, signals_for_winner_fragment);
  params->signals_for_winner.Set(
      signals_for_winner_fragment.is_null() ? nullptr : signals_for_winner_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->report_url)::BaseType> report_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_report_url, report_url_fragment);
  params->report_url.Set(
      report_url_fragment.is_null() ? nullptr : report_url_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->error_msgs)::BaseType>
      error_msgs_fragment(params.message());
  const mojo::internal::ContainerValidateParams error_msgs_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_error_msgs, error_msgs_fragment, &error_msgs_validate_params);
  params->error_msgs.Set(
      error_msgs_fragment.is_null() ? nullptr : error_msgs_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error_msgs.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error_msgs in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)auction_worklet::mojom::SellerWorklet::ReportResultCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SellerWorklet::Name_);
  message.set_method_name("ReportResult");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SellerWorkletStubDispatch::Accept(
    SellerWorklet* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSellerWorklet_ScoreAd_Name: {
      break;
    }
    case internal::kSellerWorklet_ReportResult_Name: {
      break;
    }
  }
  return false;
}

// static
bool SellerWorkletStubDispatch::AcceptWithResponder(
    SellerWorklet* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSellerWorklet_ScoreAd_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)auction_worklet::mojom::SellerWorklet::ScoreAd",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)auction_worklet::mojom::SellerWorklet::ScoreAd");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SellerWorklet_ScoreAd_Params_Data* params =
          reinterpret_cast<
              internal::SellerWorklet_ScoreAd_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_ad_metadata_json{};
      double p_bid{};
      ::blink::mojom::AuctionAdConfigPtr p_auction_config{};
      ::url::Origin p_browser_signal_top_window_origin{};
      ::url::Origin p_browser_signal_interest_group_owner{};
      std::string p_browser_signal_ad_render_fingerprint{};
      uint32_t p_browser_signal_bidding_duration_msecs{};
      SellerWorklet_ScoreAd_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAdMetadataJson(&p_ad_metadata_json))
        success = false;
      if (success)
        p_bid = input_data_view.bid();
      if (success && !input_data_view.ReadAuctionConfig(&p_auction_config))
        success = false;
      if (success && !input_data_view.ReadBrowserSignalTopWindowOrigin(&p_browser_signal_top_window_origin))
        success = false;
      if (success && !input_data_view.ReadBrowserSignalInterestGroupOwner(&p_browser_signal_interest_group_owner))
        success = false;
      if (success && !input_data_view.ReadBrowserSignalAdRenderFingerprint(&p_browser_signal_ad_render_fingerprint))
        success = false;
      if (success)
        p_browser_signal_bidding_duration_msecs = input_data_view.browser_signal_bidding_duration_msecs();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SellerWorklet::Name_, 0, false);
        return false;
      }
      SellerWorklet::ScoreAdCallback callback =
          SellerWorklet_ScoreAd_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ScoreAd(
std::move(p_ad_metadata_json), 
std::move(p_bid), 
std::move(p_auction_config), 
std::move(p_browser_signal_top_window_origin), 
std::move(p_browser_signal_interest_group_owner), 
std::move(p_browser_signal_ad_render_fingerprint), 
std::move(p_browser_signal_bidding_duration_msecs), std::move(callback));
      return true;
    }
    case internal::kSellerWorklet_ReportResult_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)auction_worklet::mojom::SellerWorklet::ReportResult",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)auction_worklet::mojom::SellerWorklet::ReportResult");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SellerWorklet_ReportResult_Params_Data* params =
          reinterpret_cast<
              internal::SellerWorklet_ReportResult_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::AuctionAdConfigPtr p_auction_config{};
      ::url::Origin p_browser_signal_top_window_origin{};
      ::url::Origin p_browser_signal_interest_group_owner{};
      ::GURL p_browser_signal_render_url{};
      std::string p_browser_signal_ad_render_fingerprint{};
      double p_browser_signal_bid{};
      double p_browser_signal_desirability{};
      SellerWorklet_ReportResult_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAuctionConfig(&p_auction_config))
        success = false;
      if (success && !input_data_view.ReadBrowserSignalTopWindowOrigin(&p_browser_signal_top_window_origin))
        success = false;
      if (success && !input_data_view.ReadBrowserSignalInterestGroupOwner(&p_browser_signal_interest_group_owner))
        success = false;
      if (success && !input_data_view.ReadBrowserSignalRenderUrl(&p_browser_signal_render_url))
        success = false;
      if (success && !input_data_view.ReadBrowserSignalAdRenderFingerprint(&p_browser_signal_ad_render_fingerprint))
        success = false;
      if (success)
        p_browser_signal_bid = input_data_view.browser_signal_bid();
      if (success)
        p_browser_signal_desirability = input_data_view.browser_signal_desirability();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SellerWorklet::Name_, 1, false);
        return false;
      }
      SellerWorklet::ReportResultCallback callback =
          SellerWorklet_ReportResult_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportResult(
std::move(p_auction_config), 
std::move(p_browser_signal_top_window_origin), 
std::move(p_browser_signal_interest_group_owner), 
std::move(p_browser_signal_render_url), 
std::move(p_browser_signal_ad_render_fingerprint), 
std::move(p_browser_signal_bid), 
std::move(p_browser_signal_desirability), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSellerWorkletValidationInfo[] = {
    {internal::kSellerWorklet_ScoreAd_Name,
     {&internal::SellerWorklet_ScoreAd_Params_Data::Validate,
      &internal::SellerWorklet_ScoreAd_ResponseParams_Data::Validate}},
    {internal::kSellerWorklet_ReportResult_Name,
     {&internal::SellerWorklet_ReportResult_Params_Data::Validate,
      &internal::SellerWorklet_ReportResult_ResponseParams_Data::Validate}},
};

bool SellerWorkletRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::auction_worklet::mojom::SellerWorklet::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSellerWorkletValidationInfo);
}

bool SellerWorkletResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::auction_worklet::mojom::SellerWorklet::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kSellerWorkletValidationInfo);

}
}  // namespace mojom
}  // namespace auction_worklet

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif