// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/app_view_guest_internal.json
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "extensions/common/api/app_view_guest_internal.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace app_view_guest_internal {
//
// Functions
//

namespace AttachFrame {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* url_value = nullptr;
  if (args.Get(0, &url_value) &&
      !url_value->is_none()) {
    {
      auto* temp = url_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->url = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* guest_instance_id_value = nullptr;
  if (args.Get(1, &guest_instance_id_value) &&
      !guest_instance_id_value->is_none()) {
    {
      auto temp = guest_instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->guest_instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(int instance_id) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(instance_id)));

  return create_results;
}
}  // namespace AttachFrame

namespace DenyRequest {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* guest_instance_id_value = nullptr;
  if (args.Get(0, &guest_instance_id_value) &&
      !guest_instance_id_value->is_none()) {
    {
      auto temp = guest_instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->guest_instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace DenyRequest

}  // namespace app_view_guest_internal
}  // namespace api
}  // namespace extensions

