// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/extension_options_internal.idl
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "extensions/common/api/extension_options_internal.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace extension_options_internal {
//
// Types
//

SizeChangedOptions::SizeChangedOptions()
: old_width(0),
old_height(0),
new_width(0),
new_height(0) {}

SizeChangedOptions::~SizeChangedOptions() = default;
SizeChangedOptions::SizeChangedOptions(SizeChangedOptions&& rhs) = default;
SizeChangedOptions& SizeChangedOptions::operator=(SizeChangedOptions&& rhs) = default;
// static
bool SizeChangedOptions::Populate(
    const base::Value& value, SizeChangedOptions* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* old_width_value = dict->FindKey("oldWidth");
  if (!old_width_value) {
    return false;
  }
  {
    auto temp = old_width_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->old_width = temp.value();
  }

  const base::Value* old_height_value = dict->FindKey("oldHeight");
  if (!old_height_value) {
    return false;
  }
  {
    auto temp = old_height_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->old_height = temp.value();
  }

  const base::Value* new_width_value = dict->FindKey("newWidth");
  if (!new_width_value) {
    return false;
  }
  {
    auto temp = new_width_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->new_width = temp.value();
  }

  const base::Value* new_height_value = dict->FindKey("newHeight");
  if (!new_height_value) {
    return false;
  }
  {
    auto temp = new_height_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->new_height = temp.value();
  }

  return true;
}

// static
std::unique_ptr<SizeChangedOptions> SizeChangedOptions::FromValue(const base::Value& value) {
  auto out = std::make_unique<SizeChangedOptions>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> SizeChangedOptions::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("oldWidth", std::make_unique<base::Value>(this->old_width));

  to_value_result->SetWithoutPathExpansion("oldHeight", std::make_unique<base::Value>(this->old_height));

  to_value_result->SetWithoutPathExpansion("newWidth", std::make_unique<base::Value>(this->new_width));

  to_value_result->SetWithoutPathExpansion("newHeight", std::make_unique<base::Value>(this->new_height));


  return to_value_result;
}


PreferredSizeChangedOptions::PreferredSizeChangedOptions()
: width(0.0),
height(0.0) {}

PreferredSizeChangedOptions::~PreferredSizeChangedOptions() = default;
PreferredSizeChangedOptions::PreferredSizeChangedOptions(PreferredSizeChangedOptions&& rhs) = default;
PreferredSizeChangedOptions& PreferredSizeChangedOptions::operator=(PreferredSizeChangedOptions&& rhs) = default;
// static
bool PreferredSizeChangedOptions::Populate(
    const base::Value& value, PreferredSizeChangedOptions* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* width_value = dict->FindKey("width");
  if (!width_value) {
    return false;
  }
  {
    auto temp = width_value->GetIfDouble();
    if (!temp.has_value()) {
      return false;
    }
    out->width = temp.value();
  }

  const base::Value* height_value = dict->FindKey("height");
  if (!height_value) {
    return false;
  }
  {
    auto temp = height_value->GetIfDouble();
    if (!temp.has_value()) {
      return false;
    }
    out->height = temp.value();
  }

  return true;
}

// static
std::unique_ptr<PreferredSizeChangedOptions> PreferredSizeChangedOptions::FromValue(const base::Value& value) {
  auto out = std::make_unique<PreferredSizeChangedOptions>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> PreferredSizeChangedOptions::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("width", std::make_unique<base::Value>(this->width));

  to_value_result->SetWithoutPathExpansion("height", std::make_unique<base::Value>(this->height));


  return to_value_result;
}



//
// Events
//

namespace OnClose {

const char kEventName[] = "extensionOptionsInternal.onClose";

std::vector<base::Value> Create() {
  std::vector<base::Value> create_results;

  return create_results;
}

}  // namespace OnClose

namespace OnLoad {

const char kEventName[] = "extensionOptionsInternal.onLoad";

std::vector<base::Value> Create() {
  std::vector<base::Value> create_results;

  return create_results;
}

}  // namespace OnLoad

namespace OnPreferredSizeChanged {

const char kEventName[] = "extensionOptionsInternal.onPreferredSizeChanged";

std::vector<base::Value> Create(const PreferredSizeChangedOptions& options) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((options).ToValue()));

  return create_results;
}

}  // namespace OnPreferredSizeChanged

}  // namespace extension_options_internal
}  // namespace api
}  // namespace extensions

