// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/extension_types.json
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "extensions/common/api/extension_types.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace extension_types {
//
// Types
//

const char* ToString(ImageFormat enum_param) {
  switch (enum_param) {
    case IMAGE_FORMAT_JPEG:
      return "jpeg";
    case IMAGE_FORMAT_PNG:
      return "png";
    case IMAGE_FORMAT_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

ImageFormat ParseImageFormat(const std::string& enum_string) {
  if (enum_string == "jpeg")
    return IMAGE_FORMAT_JPEG;
  if (enum_string == "png")
    return IMAGE_FORMAT_PNG;
  return IMAGE_FORMAT_NONE;
}


ImageDetails::ImageDetails()
: format(IMAGE_FORMAT_NONE) {}

ImageDetails::~ImageDetails() = default;
ImageDetails::ImageDetails(ImageDetails&& rhs) = default;
ImageDetails& ImageDetails::operator=(ImageDetails&& rhs) = default;
// static
bool ImageDetails::Populate(
    const base::Value& value, ImageDetails* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  out->format = IMAGE_FORMAT_NONE;
  const base::Value* format_value = dict->FindKey("format");
  if (format_value) {
    {
      std::string image_format_as_string;
      if (!format_value->GetAsString(&image_format_as_string)) {
        return false;
      }
      out->format = ParseImageFormat(image_format_as_string);
      if (out->format == IMAGE_FORMAT_NONE) {
        return false;
      }
    }
    } else {
    out->format = IMAGE_FORMAT_NONE;
  }

  const base::Value* quality_value = dict->FindKey("quality");
  if (quality_value) {
    {
      auto temp = quality_value->GetIfInt();
      if (!temp.has_value()) {
        out->quality.reset();
        return false;
      }
      out->quality = std::make_unique<int>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<ImageDetails> ImageDetails::FromValue(const base::Value& value) {
  auto out = std::make_unique<ImageDetails>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ImageDetails::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->format != IMAGE_FORMAT_NONE) {
    to_value_result->SetWithoutPathExpansion("format", std::make_unique<base::Value>(extension_types::ToString(this->format)));

  }
  if (this->quality.get()) {
    to_value_result->SetWithoutPathExpansion("quality", std::make_unique<base::Value>(*this->quality));

  }

  return to_value_result;
}


const char* ToString(RunAt enum_param) {
  switch (enum_param) {
    case RUN_AT_DOCUMENT_START:
      return "document_start";
    case RUN_AT_DOCUMENT_END:
      return "document_end";
    case RUN_AT_DOCUMENT_IDLE:
      return "document_idle";
    case RUN_AT_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

RunAt ParseRunAt(const std::string& enum_string) {
  if (enum_string == "document_start")
    return RUN_AT_DOCUMENT_START;
  if (enum_string == "document_end")
    return RUN_AT_DOCUMENT_END;
  if (enum_string == "document_idle")
    return RUN_AT_DOCUMENT_IDLE;
  return RUN_AT_NONE;
}


const char* ToString(CSSOrigin enum_param) {
  switch (enum_param) {
    case CSS_ORIGIN_AUTHOR:
      return "author";
    case CSS_ORIGIN_USER:
      return "user";
    case CSS_ORIGIN_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

CSSOrigin ParseCSSOrigin(const std::string& enum_string) {
  if (enum_string == "author")
    return CSS_ORIGIN_AUTHOR;
  if (enum_string == "user")
    return CSS_ORIGIN_USER;
  return CSS_ORIGIN_NONE;
}


InjectDetails::InjectDetails()
: run_at(RUN_AT_NONE),
css_origin(CSS_ORIGIN_NONE) {}

InjectDetails::~InjectDetails() = default;
InjectDetails::InjectDetails(InjectDetails&& rhs) = default;
InjectDetails& InjectDetails::operator=(InjectDetails&& rhs) = default;
// static
bool InjectDetails::Populate(
    const base::Value& value, InjectDetails* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  out->run_at = RUN_AT_NONE;
  out->css_origin = CSS_ORIGIN_NONE;
  const base::Value* code_value = dict->FindKey("code");
  if (code_value) {
    {
      auto* temp = code_value->GetIfString();
      if (!temp) {
        out->code.reset();
        return false;
      }
      out->code = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* file_value = dict->FindKey("file");
  if (file_value) {
    {
      auto* temp = file_value->GetIfString();
      if (!temp) {
        out->file.reset();
        return false;
      }
      out->file = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* all_frames_value = dict->FindKey("allFrames");
  if (all_frames_value) {
    {
      auto temp = all_frames_value->GetIfBool();
      if (!temp.has_value()) {
        out->all_frames.reset();
        return false;
      }
      out->all_frames = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* frame_id_value = dict->FindKey("frameId");
  if (frame_id_value) {
    {
      auto temp = frame_id_value->GetIfInt();
      if (!temp.has_value()) {
        out->frame_id.reset();
        return false;
      }
      out->frame_id = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* match_about_blank_value = dict->FindKey("matchAboutBlank");
  if (match_about_blank_value) {
    {
      auto temp = match_about_blank_value->GetIfBool();
      if (!temp.has_value()) {
        out->match_about_blank.reset();
        return false;
      }
      out->match_about_blank = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* run_at_value = dict->FindKey("runAt");
  if (run_at_value) {
    {
      std::string run_at_as_string;
      if (!run_at_value->GetAsString(&run_at_as_string)) {
        return false;
      }
      out->run_at = ParseRunAt(run_at_as_string);
      if (out->run_at == RUN_AT_NONE) {
        return false;
      }
    }
    } else {
    out->run_at = RUN_AT_NONE;
  }

  const base::Value* css_origin_value = dict->FindKey("cssOrigin");
  if (css_origin_value) {
    {
      std::string css_origin_as_string;
      if (!css_origin_value->GetAsString(&css_origin_as_string)) {
        return false;
      }
      out->css_origin = ParseCSSOrigin(css_origin_as_string);
      if (out->css_origin == CSS_ORIGIN_NONE) {
        return false;
      }
    }
    } else {
    out->css_origin = CSS_ORIGIN_NONE;
  }

  return true;
}

// static
std::unique_ptr<InjectDetails> InjectDetails::FromValue(const base::Value& value) {
  auto out = std::make_unique<InjectDetails>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> InjectDetails::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->code.get()) {
    to_value_result->SetWithoutPathExpansion("code", std::make_unique<base::Value>(*this->code));

  }
  if (this->file.get()) {
    to_value_result->SetWithoutPathExpansion("file", std::make_unique<base::Value>(*this->file));

  }
  if (this->all_frames.get()) {
    to_value_result->SetWithoutPathExpansion("allFrames", std::make_unique<base::Value>(*this->all_frames));

  }
  if (this->frame_id.get()) {
    to_value_result->SetWithoutPathExpansion("frameId", std::make_unique<base::Value>(*this->frame_id));

  }
  if (this->match_about_blank.get()) {
    to_value_result->SetWithoutPathExpansion("matchAboutBlank", std::make_unique<base::Value>(*this->match_about_blank));

  }
  if (this->run_at != RUN_AT_NONE) {
    to_value_result->SetWithoutPathExpansion("runAt", std::make_unique<base::Value>(extension_types::ToString(this->run_at)));

  }
  if (this->css_origin != CSS_ORIGIN_NONE) {
    to_value_result->SetWithoutPathExpansion("cssOrigin", std::make_unique<base::Value>(extension_types::ToString(this->css_origin)));

  }

  return to_value_result;
}


DeleteInjectionDetails::DeleteInjectionDetails()
: css_origin(CSS_ORIGIN_NONE) {}

DeleteInjectionDetails::~DeleteInjectionDetails() = default;
DeleteInjectionDetails::DeleteInjectionDetails(DeleteInjectionDetails&& rhs) = default;
DeleteInjectionDetails& DeleteInjectionDetails::operator=(DeleteInjectionDetails&& rhs) = default;
// static
bool DeleteInjectionDetails::Populate(
    const base::Value& value, DeleteInjectionDetails* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  out->css_origin = CSS_ORIGIN_NONE;
  const base::Value* code_value = dict->FindKey("code");
  if (code_value) {
    {
      auto* temp = code_value->GetIfString();
      if (!temp) {
        out->code.reset();
        return false;
      }
      out->code = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* file_value = dict->FindKey("file");
  if (file_value) {
    {
      auto* temp = file_value->GetIfString();
      if (!temp) {
        out->file.reset();
        return false;
      }
      out->file = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* all_frames_value = dict->FindKey("allFrames");
  if (all_frames_value) {
    {
      auto temp = all_frames_value->GetIfBool();
      if (!temp.has_value()) {
        out->all_frames.reset();
        return false;
      }
      out->all_frames = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* frame_id_value = dict->FindKey("frameId");
  if (frame_id_value) {
    {
      auto temp = frame_id_value->GetIfInt();
      if (!temp.has_value()) {
        out->frame_id.reset();
        return false;
      }
      out->frame_id = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* match_about_blank_value = dict->FindKey("matchAboutBlank");
  if (match_about_blank_value) {
    {
      auto temp = match_about_blank_value->GetIfBool();
      if (!temp.has_value()) {
        out->match_about_blank.reset();
        return false;
      }
      out->match_about_blank = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* css_origin_value = dict->FindKey("cssOrigin");
  if (css_origin_value) {
    {
      std::string css_origin_as_string;
      if (!css_origin_value->GetAsString(&css_origin_as_string)) {
        return false;
      }
      out->css_origin = ParseCSSOrigin(css_origin_as_string);
      if (out->css_origin == CSS_ORIGIN_NONE) {
        return false;
      }
    }
    } else {
    out->css_origin = CSS_ORIGIN_NONE;
  }

  return true;
}

// static
std::unique_ptr<DeleteInjectionDetails> DeleteInjectionDetails::FromValue(const base::Value& value) {
  auto out = std::make_unique<DeleteInjectionDetails>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> DeleteInjectionDetails::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->code.get()) {
    to_value_result->SetWithoutPathExpansion("code", std::make_unique<base::Value>(*this->code));

  }
  if (this->file.get()) {
    to_value_result->SetWithoutPathExpansion("file", std::make_unique<base::Value>(*this->file));

  }
  if (this->all_frames.get()) {
    to_value_result->SetWithoutPathExpansion("allFrames", std::make_unique<base::Value>(*this->all_frames));

  }
  if (this->frame_id.get()) {
    to_value_result->SetWithoutPathExpansion("frameId", std::make_unique<base::Value>(*this->frame_id));

  }
  if (this->match_about_blank.get()) {
    to_value_result->SetWithoutPathExpansion("matchAboutBlank", std::make_unique<base::Value>(*this->match_about_blank));

  }
  if (this->css_origin != CSS_ORIGIN_NONE) {
    to_value_result->SetWithoutPathExpansion("cssOrigin", std::make_unique<base::Value>(extension_types::ToString(this->css_origin)));

  }

  return to_value_result;
}



}  // namespace extension_types
}  // namespace api
}  // namespace extensions

