// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/hid.idl
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "extensions/common/api/hid.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace hid {
//
// Types
//

HidCollectionInfo::HidCollectionInfo()
: usage_page(0),
usage(0) {}

HidCollectionInfo::~HidCollectionInfo() = default;
HidCollectionInfo::HidCollectionInfo(HidCollectionInfo&& rhs) = default;
HidCollectionInfo& HidCollectionInfo::operator=(HidCollectionInfo&& rhs) = default;
// static
bool HidCollectionInfo::Populate(
    const base::Value& value, HidCollectionInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* usage_page_value = dict->FindKey("usagePage");
  if (!usage_page_value) {
    return false;
  }
  {
    auto temp = usage_page_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->usage_page = temp.value();
  }

  const base::Value* usage_value = dict->FindKey("usage");
  if (!usage_value) {
    return false;
  }
  {
    auto temp = usage_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->usage = temp.value();
  }

  const base::Value* report_ids_value = dict->FindKey("reportIds");
  if (!report_ids_value) {
    return false;
  }
  {
    const base::ListValue* list = nullptr;
    if (!report_ids_value->GetAsList(&list)) {
      return false;
    }
    else {
      if (!json_schema_compiler::util::PopulateArrayFromList(*list, &out->report_ids)) {
        return false;
      }
    }
  }

  return true;
}

// static
std::unique_ptr<HidCollectionInfo> HidCollectionInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<HidCollectionInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> HidCollectionInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("usagePage", std::make_unique<base::Value>(this->usage_page));

  to_value_result->SetWithoutPathExpansion("usage", std::make_unique<base::Value>(this->usage));

  to_value_result->SetWithoutPathExpansion("reportIds", json_schema_compiler::util::CreateValueFromArray(this->report_ids));


  return to_value_result;
}


HidDeviceInfo::HidDeviceInfo()
: device_id(0),
vendor_id(0),
product_id(0),
max_input_report_size(0),
max_output_report_size(0),
max_feature_report_size(0) {}

HidDeviceInfo::~HidDeviceInfo() = default;
HidDeviceInfo::HidDeviceInfo(HidDeviceInfo&& rhs) = default;
HidDeviceInfo& HidDeviceInfo::operator=(HidDeviceInfo&& rhs) = default;
// static
bool HidDeviceInfo::Populate(
    const base::Value& value, HidDeviceInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* device_id_value = dict->FindKey("deviceId");
  if (!device_id_value) {
    return false;
  }
  {
    auto temp = device_id_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->device_id = temp.value();
  }

  const base::Value* vendor_id_value = dict->FindKey("vendorId");
  if (!vendor_id_value) {
    return false;
  }
  {
    auto temp = vendor_id_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->vendor_id = temp.value();
  }

  const base::Value* product_id_value = dict->FindKey("productId");
  if (!product_id_value) {
    return false;
  }
  {
    auto temp = product_id_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->product_id = temp.value();
  }

  const base::Value* product_name_value = dict->FindKey("productName");
  if (!product_name_value) {
    return false;
  }
  {
    auto* temp = product_name_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->product_name = *temp;
  }

  const base::Value* serial_number_value = dict->FindKey("serialNumber");
  if (!serial_number_value) {
    return false;
  }
  {
    auto* temp = serial_number_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->serial_number = *temp;
  }

  const base::Value* collections_value = dict->FindKey("collections");
  if (!collections_value) {
    return false;
  }
  {
    const base::ListValue* list = nullptr;
    if (!collections_value->GetAsList(&list)) {
      return false;
    }
    else {
      if (!json_schema_compiler::util::PopulateArrayFromList(*list, &out->collections)) {
        return false;
      }
    }
  }

  const base::Value* max_input_report_size_value = dict->FindKey("maxInputReportSize");
  if (!max_input_report_size_value) {
    return false;
  }
  {
    auto temp = max_input_report_size_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->max_input_report_size = temp.value();
  }

  const base::Value* max_output_report_size_value = dict->FindKey("maxOutputReportSize");
  if (!max_output_report_size_value) {
    return false;
  }
  {
    auto temp = max_output_report_size_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->max_output_report_size = temp.value();
  }

  const base::Value* max_feature_report_size_value = dict->FindKey("maxFeatureReportSize");
  if (!max_feature_report_size_value) {
    return false;
  }
  {
    auto temp = max_feature_report_size_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->max_feature_report_size = temp.value();
  }

  const base::Value* report_descriptor_value = dict->FindKey("reportDescriptor");
  if (!report_descriptor_value) {
    return false;
  }
  {
    if (!report_descriptor_value->is_blob()) {
      return false;
    }
    else {
      out->report_descriptor = report_descriptor_value->GetBlob();
    }
  }

  return true;
}

// static
std::unique_ptr<HidDeviceInfo> HidDeviceInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<HidDeviceInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> HidDeviceInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("deviceId", std::make_unique<base::Value>(this->device_id));

  to_value_result->SetWithoutPathExpansion("vendorId", std::make_unique<base::Value>(this->vendor_id));

  to_value_result->SetWithoutPathExpansion("productId", std::make_unique<base::Value>(this->product_id));

  to_value_result->SetWithoutPathExpansion("productName", std::make_unique<base::Value>(this->product_name));

  to_value_result->SetWithoutPathExpansion("serialNumber", std::make_unique<base::Value>(this->serial_number));

  to_value_result->SetWithoutPathExpansion("collections", json_schema_compiler::util::CreateValueFromArray(this->collections));

  to_value_result->SetWithoutPathExpansion("maxInputReportSize", std::make_unique<base::Value>(this->max_input_report_size));

  to_value_result->SetWithoutPathExpansion("maxOutputReportSize", std::make_unique<base::Value>(this->max_output_report_size));

  to_value_result->SetWithoutPathExpansion("maxFeatureReportSize", std::make_unique<base::Value>(this->max_feature_report_size));

  to_value_result->SetWithoutPathExpansion("reportDescriptor", std::make_unique<base::Value>(this->report_descriptor));


  return to_value_result;
}


HidConnectInfo::HidConnectInfo()
: connection_id(0) {}

HidConnectInfo::~HidConnectInfo() = default;
HidConnectInfo::HidConnectInfo(HidConnectInfo&& rhs) = default;
HidConnectInfo& HidConnectInfo::operator=(HidConnectInfo&& rhs) = default;
// static
bool HidConnectInfo::Populate(
    const base::Value& value, HidConnectInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* connection_id_value = dict->FindKey("connectionId");
  if (!connection_id_value) {
    return false;
  }
  {
    auto temp = connection_id_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->connection_id = temp.value();
  }

  return true;
}

// static
std::unique_ptr<HidConnectInfo> HidConnectInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<HidConnectInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> HidConnectInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("connectionId", std::make_unique<base::Value>(this->connection_id));


  return to_value_result;
}


DeviceFilter::DeviceFilter()
 {}

DeviceFilter::~DeviceFilter() = default;
DeviceFilter::DeviceFilter(DeviceFilter&& rhs) = default;
DeviceFilter& DeviceFilter::operator=(DeviceFilter&& rhs) = default;
// static
bool DeviceFilter::Populate(
    const base::Value& value, DeviceFilter* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* vendor_id_value = dict->FindKey("vendorId");
  if (vendor_id_value) {
    {
      auto temp = vendor_id_value->GetIfInt();
      if (!temp.has_value()) {
        out->vendor_id.reset();
        return false;
      }
      out->vendor_id = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* product_id_value = dict->FindKey("productId");
  if (product_id_value) {
    {
      auto temp = product_id_value->GetIfInt();
      if (!temp.has_value()) {
        out->product_id.reset();
        return false;
      }
      out->product_id = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* usage_page_value = dict->FindKey("usagePage");
  if (usage_page_value) {
    {
      auto temp = usage_page_value->GetIfInt();
      if (!temp.has_value()) {
        out->usage_page.reset();
        return false;
      }
      out->usage_page = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* usage_value = dict->FindKey("usage");
  if (usage_value) {
    {
      auto temp = usage_value->GetIfInt();
      if (!temp.has_value()) {
        out->usage.reset();
        return false;
      }
      out->usage = std::make_unique<int>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<DeviceFilter> DeviceFilter::FromValue(const base::Value& value) {
  auto out = std::make_unique<DeviceFilter>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> DeviceFilter::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->vendor_id.get()) {
    to_value_result->SetWithoutPathExpansion("vendorId", std::make_unique<base::Value>(*this->vendor_id));

  }
  if (this->product_id.get()) {
    to_value_result->SetWithoutPathExpansion("productId", std::make_unique<base::Value>(*this->product_id));

  }
  if (this->usage_page.get()) {
    to_value_result->SetWithoutPathExpansion("usagePage", std::make_unique<base::Value>(*this->usage_page));

  }
  if (this->usage.get()) {
    to_value_result->SetWithoutPathExpansion("usage", std::make_unique<base::Value>(*this->usage));

  }

  return to_value_result;
}


GetDevicesOptions::GetDevicesOptions()
 {}

GetDevicesOptions::~GetDevicesOptions() = default;
GetDevicesOptions::GetDevicesOptions(GetDevicesOptions&& rhs) = default;
GetDevicesOptions& GetDevicesOptions::operator=(GetDevicesOptions&& rhs) = default;
// static
bool GetDevicesOptions::Populate(
    const base::Value& value, GetDevicesOptions* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* vendor_id_value = dict->FindKey("vendorId");
  if (vendor_id_value) {
    {
      auto temp = vendor_id_value->GetIfInt();
      if (!temp.has_value()) {
        out->vendor_id.reset();
        return false;
      }
      out->vendor_id = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* product_id_value = dict->FindKey("productId");
  if (product_id_value) {
    {
      auto temp = product_id_value->GetIfInt();
      if (!temp.has_value()) {
        out->product_id.reset();
        return false;
      }
      out->product_id = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* filters_value = dict->FindKey("filters");
  if (filters_value) {
    {
      const base::ListValue* list = nullptr;
      if (!filters_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->filters)) {
          return false;
        }
      }
    }
  }

  return true;
}

// static
std::unique_ptr<GetDevicesOptions> GetDevicesOptions::FromValue(const base::Value& value) {
  auto out = std::make_unique<GetDevicesOptions>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> GetDevicesOptions::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->vendor_id.get()) {
    to_value_result->SetWithoutPathExpansion("vendorId", std::make_unique<base::Value>(*this->vendor_id));

  }
  if (this->product_id.get()) {
    to_value_result->SetWithoutPathExpansion("productId", std::make_unique<base::Value>(*this->product_id));

  }
  if (this->filters.get()) {
    to_value_result->SetWithoutPathExpansion("filters", json_schema_compiler::util::CreateValueFromArray(*this->filters));

  }

  return to_value_result;
}


DevicePromptOptions::DevicePromptOptions()
 {}

DevicePromptOptions::~DevicePromptOptions() = default;
DevicePromptOptions::DevicePromptOptions(DevicePromptOptions&& rhs) = default;
DevicePromptOptions& DevicePromptOptions::operator=(DevicePromptOptions&& rhs) = default;
// static
bool DevicePromptOptions::Populate(
    const base::Value& value, DevicePromptOptions* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* multiple_value = dict->FindKey("multiple");
  if (multiple_value) {
    {
      auto temp = multiple_value->GetIfBool();
      if (!temp.has_value()) {
        out->multiple.reset();
        return false;
      }
      out->multiple = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* filters_value = dict->FindKey("filters");
  if (filters_value) {
    {
      const base::ListValue* list = nullptr;
      if (!filters_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->filters)) {
          return false;
        }
      }
    }
  }

  return true;
}

// static
std::unique_ptr<DevicePromptOptions> DevicePromptOptions::FromValue(const base::Value& value) {
  auto out = std::make_unique<DevicePromptOptions>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> DevicePromptOptions::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->multiple.get()) {
    to_value_result->SetWithoutPathExpansion("multiple", std::make_unique<base::Value>(*this->multiple));

  }
  if (this->filters.get()) {
    to_value_result->SetWithoutPathExpansion("filters", json_schema_compiler::util::CreateValueFromArray(*this->filters));

  }

  return to_value_result;
}



//
// Functions
//

namespace GetDevices {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* options_value = nullptr;
  if (args.Get(0, &options_value) &&
      !options_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!options_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!GetDevicesOptions::Populate(*dictionary, &params->options)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const std::vector<HidDeviceInfo>& devices) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(json_schema_compiler::util::CreateValueFromArray(devices)));

  return create_results;
}
}  // namespace GetDevices

namespace GetUserSelectedDevices {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() > 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* options_value = nullptr;
  if (args.Get(0, &options_value) &&
      !options_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!options_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      else {
        auto temp = std::make_unique<DevicePromptOptions>();
        if (!DevicePromptOptions::Populate(*dictionary, temp.get())) {
          return std::unique_ptr<Params>();
        }
        else
          params->options = std::move(temp);
      }
    }
  }

  return params;
}


std::vector<base::Value> Results::Create(const std::vector<HidDeviceInfo>& devices) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(json_schema_compiler::util::CreateValueFromArray(devices)));

  return create_results;
}
}  // namespace GetUserSelectedDevices

namespace Connect {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* device_id_value = nullptr;
  if (args.Get(0, &device_id_value) &&
      !device_id_value->is_none()) {
    {
      auto temp = device_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->device_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const HidConnectInfo& connection) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((connection).ToValue()));

  return create_results;
}
}  // namespace Connect

namespace Disconnect {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* connection_id_value = nullptr;
  if (args.Get(0, &connection_id_value) &&
      !connection_id_value->is_none()) {
    {
      auto temp = connection_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->connection_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace Disconnect

namespace Receive {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* connection_id_value = nullptr;
  if (args.Get(0, &connection_id_value) &&
      !connection_id_value->is_none()) {
    {
      auto temp = connection_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->connection_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(int report_id, const std::vector<uint8_t>& data) {
  std::vector<base::Value> create_results;
  create_results.reserve(2);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(report_id)));

  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(data)));

  return create_results;
}
}  // namespace Receive

namespace Send {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 3) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* connection_id_value = nullptr;
  if (args.Get(0, &connection_id_value) &&
      !connection_id_value->is_none()) {
    {
      auto temp = connection_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->connection_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* report_id_value = nullptr;
  if (args.Get(1, &report_id_value) &&
      !report_id_value->is_none()) {
    {
      auto temp = report_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->report_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* data_value = nullptr;
  if (args.Get(2, &data_value) &&
      !data_value->is_none()) {
    {
      if (!data_value->is_blob()) {
        return std::unique_ptr<Params>();
      }
      else {
        params->data = data_value->GetBlob();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace Send

namespace ReceiveFeatureReport {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* connection_id_value = nullptr;
  if (args.Get(0, &connection_id_value) &&
      !connection_id_value->is_none()) {
    {
      auto temp = connection_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->connection_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* report_id_value = nullptr;
  if (args.Get(1, &report_id_value) &&
      !report_id_value->is_none()) {
    {
      auto temp = report_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->report_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const std::vector<uint8_t>& data) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(data)));

  return create_results;
}
}  // namespace ReceiveFeatureReport

namespace SendFeatureReport {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 3) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* connection_id_value = nullptr;
  if (args.Get(0, &connection_id_value) &&
      !connection_id_value->is_none()) {
    {
      auto temp = connection_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->connection_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* report_id_value = nullptr;
  if (args.Get(1, &report_id_value) &&
      !report_id_value->is_none()) {
    {
      auto temp = report_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->report_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* data_value = nullptr;
  if (args.Get(2, &data_value) &&
      !data_value->is_none()) {
    {
      if (!data_value->is_blob()) {
        return std::unique_ptr<Params>();
      }
      else {
        params->data = data_value->GetBlob();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace SendFeatureReport

//
// Events
//

namespace OnDeviceAdded {

const char kEventName[] = "hid.onDeviceAdded";

std::vector<base::Value> Create(const HidDeviceInfo& device) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((device).ToValue()));

  return create_results;
}

}  // namespace OnDeviceAdded

namespace OnDeviceRemoved {

const char kEventName[] = "hid.onDeviceRemoved";

std::vector<base::Value> Create(int device_id) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(device_id)));

  return create_results;
}

}  // namespace OnDeviceRemoved

}  // namespace hid
}  // namespace api
}  // namespace extensions

