// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/idle.json
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "extensions/common/api/idle.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace idle {
//
// Types
//

const char* ToString(IdleState enum_param) {
  switch (enum_param) {
    case IDLE_STATE_ACTIVE:
      return "active";
    case IDLE_STATE_IDLE:
      return "idle";
    case IDLE_STATE_LOCKED:
      return "locked";
    case IDLE_STATE_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

IdleState ParseIdleState(const std::string& enum_string) {
  if (enum_string == "active")
    return IDLE_STATE_ACTIVE;
  if (enum_string == "idle")
    return IDLE_STATE_IDLE;
  if (enum_string == "locked")
    return IDLE_STATE_LOCKED;
  return IDLE_STATE_NONE;
}



//
// Functions
//

namespace QueryState {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* detection_interval_in_seconds_value = nullptr;
  if (args.Get(0, &detection_interval_in_seconds_value) &&
      !detection_interval_in_seconds_value->is_none()) {
    {
      auto temp = detection_interval_in_seconds_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->detection_interval_in_seconds = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const IdleState& new_state) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(idle::ToString(new_state))));

  return create_results;
}
}  // namespace QueryState

namespace SetDetectionInterval {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* interval_in_seconds_value = nullptr;
  if (args.Get(0, &interval_in_seconds_value) &&
      !interval_in_seconds_value->is_none()) {
    {
      auto temp = interval_in_seconds_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->interval_in_seconds = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace SetDetectionInterval

namespace GetAutoLockDelay {

std::vector<base::Value> Results::Create(int delay) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(delay)));

  return create_results;
}
}  // namespace GetAutoLockDelay

//
// Events
//

namespace OnStateChanged {

const char kEventName[] = "idle.onStateChanged";

std::vector<base::Value> Create(const IdleState& new_state) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(idle::ToString(new_state))));

  return create_results;
}

}  // namespace OnStateChanged

}  // namespace idle
}  // namespace api
}  // namespace extensions

