// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/metrics_private.json
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "extensions/common/api/metrics_private.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace metrics_private {
//
// Types
//

const char* ToString(MetricTypeType enum_param) {
  switch (enum_param) {
    case METRIC_TYPE_TYPE_HISTOGRAM_LOG:
      return "histogram-log";
    case METRIC_TYPE_TYPE_HISTOGRAM_LINEAR:
      return "histogram-linear";
    case METRIC_TYPE_TYPE_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

MetricTypeType ParseMetricTypeType(const std::string& enum_string) {
  if (enum_string == "histogram-log")
    return METRIC_TYPE_TYPE_HISTOGRAM_LOG;
  if (enum_string == "histogram-linear")
    return METRIC_TYPE_TYPE_HISTOGRAM_LINEAR;
  return METRIC_TYPE_TYPE_NONE;
}


MetricType::MetricType()
: type(METRIC_TYPE_TYPE_NONE),
min(0),
max(0),
buckets(0) {}

MetricType::~MetricType() = default;
MetricType::MetricType(MetricType&& rhs) = default;
MetricType& MetricType::operator=(MetricType&& rhs) = default;
// static
bool MetricType::Populate(
    const base::Value& value, MetricType* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* metric_name_value = dict->FindKey("metricName");
  if (!metric_name_value) {
    return false;
  }
  {
    auto* temp = metric_name_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->metric_name = *temp;
  }

  const base::Value* type_value = dict->FindKey("type");
  if (!type_value) {
    return false;
  }
  {
    std::string metric_type_type_as_string;
    if (!type_value->GetAsString(&metric_type_type_as_string)) {
      return false;
    }
    out->type = ParseMetricTypeType(metric_type_type_as_string);
    if (out->type == METRIC_TYPE_TYPE_NONE) {
      return false;
    }
  }

  const base::Value* min_value = dict->FindKey("min");
  if (!min_value) {
    return false;
  }
  {
    auto temp = min_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->min = temp.value();
  }

  const base::Value* max_value = dict->FindKey("max");
  if (!max_value) {
    return false;
  }
  {
    auto temp = max_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->max = temp.value();
  }

  const base::Value* buckets_value = dict->FindKey("buckets");
  if (!buckets_value) {
    return false;
  }
  {
    auto temp = buckets_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->buckets = temp.value();
  }

  return true;
}

// static
std::unique_ptr<MetricType> MetricType::FromValue(const base::Value& value) {
  auto out = std::make_unique<MetricType>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> MetricType::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("metricName", std::make_unique<base::Value>(this->metric_name));

  to_value_result->SetWithoutPathExpansion("type", std::make_unique<base::Value>(metrics_private::ToString(this->type)));

  to_value_result->SetWithoutPathExpansion("min", std::make_unique<base::Value>(this->min));

  to_value_result->SetWithoutPathExpansion("max", std::make_unique<base::Value>(this->max));

  to_value_result->SetWithoutPathExpansion("buckets", std::make_unique<base::Value>(this->buckets));


  return to_value_result;
}


HistogramBucket::HistogramBucket()
: min(0),
max(0),
count(0) {}

HistogramBucket::~HistogramBucket() = default;
HistogramBucket::HistogramBucket(HistogramBucket&& rhs) = default;
HistogramBucket& HistogramBucket::operator=(HistogramBucket&& rhs) = default;
// static
bool HistogramBucket::Populate(
    const base::Value& value, HistogramBucket* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* min_value = dict->FindKey("min");
  if (!min_value) {
    return false;
  }
  {
    auto temp = min_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->min = temp.value();
  }

  const base::Value* max_value = dict->FindKey("max");
  if (!max_value) {
    return false;
  }
  {
    auto temp = max_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->max = temp.value();
  }

  const base::Value* count_value = dict->FindKey("count");
  if (!count_value) {
    return false;
  }
  {
    auto temp = count_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->count = temp.value();
  }

  return true;
}

// static
std::unique_ptr<HistogramBucket> HistogramBucket::FromValue(const base::Value& value) {
  auto out = std::make_unique<HistogramBucket>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> HistogramBucket::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("min", std::make_unique<base::Value>(this->min));

  to_value_result->SetWithoutPathExpansion("max", std::make_unique<base::Value>(this->max));

  to_value_result->SetWithoutPathExpansion("count", std::make_unique<base::Value>(this->count));


  return to_value_result;
}


Histogram::Histogram()
: sum(0.0) {}

Histogram::~Histogram() = default;
Histogram::Histogram(Histogram&& rhs) = default;
Histogram& Histogram::operator=(Histogram&& rhs) = default;
// static
bool Histogram::Populate(
    const base::Value& value, Histogram* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* sum_value = dict->FindKey("sum");
  if (!sum_value) {
    return false;
  }
  {
    auto temp = sum_value->GetIfDouble();
    if (!temp.has_value()) {
      return false;
    }
    out->sum = temp.value();
  }

  const base::Value* buckets_value = dict->FindKey("buckets");
  if (!buckets_value) {
    return false;
  }
  {
    const base::ListValue* list = nullptr;
    if (!buckets_value->GetAsList(&list)) {
      return false;
    }
    else {
      if (!json_schema_compiler::util::PopulateArrayFromList(*list, &out->buckets)) {
        return false;
      }
    }
  }

  return true;
}

// static
std::unique_ptr<Histogram> Histogram::FromValue(const base::Value& value) {
  auto out = std::make_unique<Histogram>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> Histogram::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("sum", std::make_unique<base::Value>(this->sum));

  to_value_result->SetWithoutPathExpansion("buckets", json_schema_compiler::util::CreateValueFromArray(this->buckets));


  return to_value_result;
}



//
// Functions
//

namespace GetHistogram {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* name_value = nullptr;
  if (args.Get(0, &name_value) &&
      !name_value->is_none()) {
    {
      auto* temp = name_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->name = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const Histogram& histogram) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((histogram).ToValue()));

  return create_results;
}
}  // namespace GetHistogram

namespace GetIsCrashReportingEnabled {

std::vector<base::Value> Results::Create(bool is_enabled) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(is_enabled)));

  return create_results;
}
}  // namespace GetIsCrashReportingEnabled

namespace GetFieldTrial {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* name_value = nullptr;
  if (args.Get(0, &name_value) &&
      !name_value->is_none()) {
    {
      auto* temp = name_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->name = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const std::string& group) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(group)));

  return create_results;
}
}  // namespace GetFieldTrial

namespace GetVariationParams {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* name_value = nullptr;
  if (args.Get(0, &name_value) &&
      !name_value->is_none()) {
    {
      auto* temp = name_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->name = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


Results::Params::Params()
 {}

Results::Params::~Params() = default;
Results::Params::Params(Params&& rhs) = default;
Results::Params& Results::Params::operator=(Params&& rhs) = default;
std::unique_ptr<base::DictionaryValue> Results::Params::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  for (const auto& it : additional_properties) {
    to_value_result->SetWithoutPathExpansion(it.first, std::make_unique<base::Value>(it.second));

  }

  return to_value_result;
}


std::vector<base::Value> Results::Create(const Params& params) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((params).ToValue()));

  return create_results;
}
}  // namespace GetVariationParams

namespace RecordUserAction {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* name_value = nullptr;
  if (args.Get(0, &name_value) &&
      !name_value->is_none()) {
    {
      auto* temp = name_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->name = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace RecordUserAction

namespace RecordPercentage {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* metric_name_value = nullptr;
  if (args.Get(0, &metric_name_value) &&
      !metric_name_value->is_none()) {
    {
      auto* temp = metric_name_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->metric_name = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* value_value = nullptr;
  if (args.Get(1, &value_value) &&
      !value_value->is_none()) {
    {
      auto temp = value_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->value = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace RecordPercentage

namespace RecordCount {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* metric_name_value = nullptr;
  if (args.Get(0, &metric_name_value) &&
      !metric_name_value->is_none()) {
    {
      auto* temp = metric_name_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->metric_name = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* value_value = nullptr;
  if (args.Get(1, &value_value) &&
      !value_value->is_none()) {
    {
      auto temp = value_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->value = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace RecordCount

namespace RecordSmallCount {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* metric_name_value = nullptr;
  if (args.Get(0, &metric_name_value) &&
      !metric_name_value->is_none()) {
    {
      auto* temp = metric_name_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->metric_name = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* value_value = nullptr;
  if (args.Get(1, &value_value) &&
      !value_value->is_none()) {
    {
      auto temp = value_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->value = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace RecordSmallCount

namespace RecordMediumCount {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* metric_name_value = nullptr;
  if (args.Get(0, &metric_name_value) &&
      !metric_name_value->is_none()) {
    {
      auto* temp = metric_name_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->metric_name = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* value_value = nullptr;
  if (args.Get(1, &value_value) &&
      !value_value->is_none()) {
    {
      auto temp = value_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->value = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace RecordMediumCount

namespace RecordTime {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* metric_name_value = nullptr;
  if (args.Get(0, &metric_name_value) &&
      !metric_name_value->is_none()) {
    {
      auto* temp = metric_name_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->metric_name = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* value_value = nullptr;
  if (args.Get(1, &value_value) &&
      !value_value->is_none()) {
    {
      auto temp = value_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->value = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace RecordTime

namespace RecordMediumTime {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* metric_name_value = nullptr;
  if (args.Get(0, &metric_name_value) &&
      !metric_name_value->is_none()) {
    {
      auto* temp = metric_name_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->metric_name = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* value_value = nullptr;
  if (args.Get(1, &value_value) &&
      !value_value->is_none()) {
    {
      auto temp = value_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->value = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace RecordMediumTime

namespace RecordLongTime {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* metric_name_value = nullptr;
  if (args.Get(0, &metric_name_value) &&
      !metric_name_value->is_none()) {
    {
      auto* temp = metric_name_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->metric_name = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* value_value = nullptr;
  if (args.Get(1, &value_value) &&
      !value_value->is_none()) {
    {
      auto temp = value_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->value = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace RecordLongTime

namespace RecordSparseHashable {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* metric_name_value = nullptr;
  if (args.Get(0, &metric_name_value) &&
      !metric_name_value->is_none()) {
    {
      auto* temp = metric_name_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->metric_name = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* value_value = nullptr;
  if (args.Get(1, &value_value) &&
      !value_value->is_none()) {
    {
      auto* temp = value_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->value = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace RecordSparseHashable

namespace RecordSparseValue {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* metric_name_value = nullptr;
  if (args.Get(0, &metric_name_value) &&
      !metric_name_value->is_none()) {
    {
      auto* temp = metric_name_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->metric_name = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* value_value = nullptr;
  if (args.Get(1, &value_value) &&
      !value_value->is_none()) {
    {
      auto temp = value_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->value = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace RecordSparseValue

namespace RecordValue {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* metric_value = nullptr;
  if (args.Get(0, &metric_value) &&
      !metric_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!metric_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!MetricType::Populate(*dictionary, &params->metric)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* value_value = nullptr;
  if (args.Get(1, &value_value) &&
      !value_value->is_none()) {
    {
      auto temp = value_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->value = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace RecordValue

namespace RecordBoolean {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* metric_name_value = nullptr;
  if (args.Get(0, &metric_name_value) &&
      !metric_name_value->is_none()) {
    {
      auto* temp = metric_name_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->metric_name = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* value_value = nullptr;
  if (args.Get(1, &value_value) &&
      !value_value->is_none()) {
    {
      auto temp = value_value->GetIfBool();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->value = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace RecordBoolean

namespace RecordEnumerationValue {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 3) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* metric_name_value = nullptr;
  if (args.Get(0, &metric_name_value) &&
      !metric_name_value->is_none()) {
    {
      auto* temp = metric_name_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->metric_name = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* value_value = nullptr;
  if (args.Get(1, &value_value) &&
      !value_value->is_none()) {
    {
      auto temp = value_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->value = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* enum_size_value = nullptr;
  if (args.Get(2, &enum_size_value) &&
      !enum_size_value->is_none()) {
    {
      auto temp = enum_size_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->enum_size = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace RecordEnumerationValue

}  // namespace metrics_private
}  // namespace api
}  // namespace extensions

