// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/oauth2.idl
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "extensions/common/api/oauth2.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"
#include "tools/json_schema_compiler/manifest_parse_util.h"

#include "base/strings/string_piece.h"


using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace oauth2 {
//
// Types
//

OAuth2Info::OAuth2Info()
 {}

OAuth2Info::~OAuth2Info() = default;
OAuth2Info::OAuth2Info(OAuth2Info&& rhs) = default;
OAuth2Info& OAuth2Info::operator=(OAuth2Info&& rhs) = default;
// static
constexpr char OAuth2Info::kAutoApprove[];
// static
constexpr char OAuth2Info::kClientId[];
// static
constexpr char OAuth2Info::kScopes[];

// static
bool OAuth2Info::Populate(
    const base::Value& value, OAuth2Info* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* auto_approve_value = dict->FindKey("auto_approve");
  if (auto_approve_value) {
    {
      auto temp = auto_approve_value->GetIfBool();
      if (!temp.has_value()) {
        out->auto_approve.reset();
        return false;
      }
      out->auto_approve = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* client_id_value = dict->FindKey("client_id");
  if (client_id_value) {
    {
      auto* temp = client_id_value->GetIfString();
      if (!temp) {
        out->client_id.reset();
        return false;
      }
      out->client_id = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* scopes_value = dict->FindKey("scopes");
  if (!scopes_value) {
    return false;
  }
  {
    const base::ListValue* list = nullptr;
    if (!scopes_value->GetAsList(&list)) {
      return false;
    }
    else {
      if (!json_schema_compiler::util::PopulateArrayFromList(*list, &out->scopes)) {
        return false;
      }
    }
  }

  return true;
}

// static
std::unique_ptr<OAuth2Info> OAuth2Info::FromValue(const base::Value& value) {
  auto out = std::make_unique<OAuth2Info>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> OAuth2Info::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->auto_approve.get()) {
    to_value_result->SetWithoutPathExpansion("auto_approve", std::make_unique<base::Value>(*this->auto_approve));

  }
  if (this->client_id.get()) {
    to_value_result->SetWithoutPathExpansion("client_id", std::make_unique<base::Value>(*this->client_id));

  }
  to_value_result->SetWithoutPathExpansion("scopes", json_schema_compiler::util::CreateValueFromArray(this->scopes));


  return to_value_result;
}

//static
bool OAuth2Info::ParseFromDictionary(
const base::DictionaryValue& root_dict, base::StringPiece key, OAuth2Info* out, std::u16string* error, std::vector<base::StringPiece>* error_path_reversed) {
  DCHECK(out);
  DCHECK(error);
  DCHECK(error_path_reversed);

  const base::Value* value = ::json_schema_compiler::manifest_parse_util::FindKeyOfType(root_dict, key, base::Value::Type::DICTIONARY, error, error_path_reversed);
  if (!value)
    return false;
  const base::DictionaryValue& dict = base::Value::AsDictionaryValue(*value);
  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kAutoApprove, &out->auto_approve, error, error_path_reversed)) {
    error_path_reversed->push_back(key);
    return false;
  }

  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kClientId, &out->client_id, error, error_path_reversed)) {
    error_path_reversed->push_back(key);
    return false;
  }

  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kScopes, &out->scopes, error, error_path_reversed)) {
    error_path_reversed->push_back(key);
    return false;
  }

  return true;
}



//
// Manifest Keys
//

ManifestKeys::ManifestKeys()
 {}

ManifestKeys::~ManifestKeys() = default;
ManifestKeys::ManifestKeys(ManifestKeys&& rhs) = default;
ManifestKeys& ManifestKeys::operator=(ManifestKeys&& rhs) = default;
// static
constexpr char ManifestKeys::kOauth2[];

//static
bool ManifestKeys::ParseFromDictionary(
const base::DictionaryValue& root_dict, ManifestKeys* out, std::u16string* error) {
  DCHECK(out);
  DCHECK(error);

  std::vector<base::StringPiece> error_path_reversed_vec;
  auto* error_path_reversed = &error_path_reversed_vec;
  const base::DictionaryValue& dict = root_dict;
  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kOauth2, &out->oauth2, error, error_path_reversed)) {
    ::json_schema_compiler::manifest_parse_util::PopulateFinalError(error, error_path_reversed);
    return false;
  }

  return true;
}


}  // namespace oauth2
}  // namespace api
}  // namespace extensions

