// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/sockets_tcp.idl
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "extensions/common/api/sockets_tcp.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace sockets_tcp {
//
// Types
//

SocketProperties::SocketProperties()
 {}

SocketProperties::~SocketProperties() = default;
SocketProperties::SocketProperties(SocketProperties&& rhs) = default;
SocketProperties& SocketProperties::operator=(SocketProperties&& rhs) = default;
// static
bool SocketProperties::Populate(
    const base::Value& value, SocketProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* persistent_value = dict->FindKey("persistent");
  if (persistent_value) {
    {
      auto temp = persistent_value->GetIfBool();
      if (!temp.has_value()) {
        out->persistent.reset();
        return false;
      }
      out->persistent = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* name_value = dict->FindKey("name");
  if (name_value) {
    {
      auto* temp = name_value->GetIfString();
      if (!temp) {
        out->name.reset();
        return false;
      }
      out->name = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* buffer_size_value = dict->FindKey("bufferSize");
  if (buffer_size_value) {
    {
      auto temp = buffer_size_value->GetIfInt();
      if (!temp.has_value()) {
        out->buffer_size.reset();
        return false;
      }
      out->buffer_size = std::make_unique<int>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<SocketProperties> SocketProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<SocketProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> SocketProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->persistent.get()) {
    to_value_result->SetWithoutPathExpansion("persistent", std::make_unique<base::Value>(*this->persistent));

  }
  if (this->name.get()) {
    to_value_result->SetWithoutPathExpansion("name", std::make_unique<base::Value>(*this->name));

  }
  if (this->buffer_size.get()) {
    to_value_result->SetWithoutPathExpansion("bufferSize", std::make_unique<base::Value>(*this->buffer_size));

  }

  return to_value_result;
}


CreateInfo::CreateInfo()
: socket_id(0) {}

CreateInfo::~CreateInfo() = default;
CreateInfo::CreateInfo(CreateInfo&& rhs) = default;
CreateInfo& CreateInfo::operator=(CreateInfo&& rhs) = default;
// static
bool CreateInfo::Populate(
    const base::Value& value, CreateInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* socket_id_value = dict->FindKey("socketId");
  if (!socket_id_value) {
    return false;
  }
  {
    auto temp = socket_id_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->socket_id = temp.value();
  }

  return true;
}

// static
std::unique_ptr<CreateInfo> CreateInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<CreateInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> CreateInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("socketId", std::make_unique<base::Value>(this->socket_id));


  return to_value_result;
}


SendInfo::SendInfo()
: result_code(0) {}

SendInfo::~SendInfo() = default;
SendInfo::SendInfo(SendInfo&& rhs) = default;
SendInfo& SendInfo::operator=(SendInfo&& rhs) = default;
// static
bool SendInfo::Populate(
    const base::Value& value, SendInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* result_code_value = dict->FindKey("resultCode");
  if (!result_code_value) {
    return false;
  }
  {
    auto temp = result_code_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->result_code = temp.value();
  }

  const base::Value* bytes_sent_value = dict->FindKey("bytesSent");
  if (bytes_sent_value) {
    {
      auto temp = bytes_sent_value->GetIfInt();
      if (!temp.has_value()) {
        out->bytes_sent.reset();
        return false;
      }
      out->bytes_sent = std::make_unique<int>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<SendInfo> SendInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<SendInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> SendInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("resultCode", std::make_unique<base::Value>(this->result_code));

  if (this->bytes_sent.get()) {
    to_value_result->SetWithoutPathExpansion("bytesSent", std::make_unique<base::Value>(*this->bytes_sent));

  }

  return to_value_result;
}


TLSVersionConstraints::TLSVersionConstraints()
 {}

TLSVersionConstraints::~TLSVersionConstraints() = default;
TLSVersionConstraints::TLSVersionConstraints(TLSVersionConstraints&& rhs) = default;
TLSVersionConstraints& TLSVersionConstraints::operator=(TLSVersionConstraints&& rhs) = default;
// static
bool TLSVersionConstraints::Populate(
    const base::Value& value, TLSVersionConstraints* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* min_value = dict->FindKey("min");
  if (min_value) {
    {
      auto* temp = min_value->GetIfString();
      if (!temp) {
        out->min.reset();
        return false;
      }
      out->min = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* max_value = dict->FindKey("max");
  if (max_value) {
    {
      auto* temp = max_value->GetIfString();
      if (!temp) {
        out->max.reset();
        return false;
      }
      out->max = std::make_unique<std::string>(*temp);
    }
  }

  return true;
}

// static
std::unique_ptr<TLSVersionConstraints> TLSVersionConstraints::FromValue(const base::Value& value) {
  auto out = std::make_unique<TLSVersionConstraints>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> TLSVersionConstraints::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->min.get()) {
    to_value_result->SetWithoutPathExpansion("min", std::make_unique<base::Value>(*this->min));

  }
  if (this->max.get()) {
    to_value_result->SetWithoutPathExpansion("max", std::make_unique<base::Value>(*this->max));

  }

  return to_value_result;
}


SecureOptions::SecureOptions()
 {}

SecureOptions::~SecureOptions() = default;
SecureOptions::SecureOptions(SecureOptions&& rhs) = default;
SecureOptions& SecureOptions::operator=(SecureOptions&& rhs) = default;
// static
bool SecureOptions::Populate(
    const base::Value& value, SecureOptions* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* tls_version_value = dict->FindKey("tlsVersion");
  if (tls_version_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!tls_version_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<TLSVersionConstraints>();
        if (!TLSVersionConstraints::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->tls_version = std::move(temp);
      }
    }
  }

  return true;
}

// static
std::unique_ptr<SecureOptions> SecureOptions::FromValue(const base::Value& value) {
  auto out = std::make_unique<SecureOptions>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> SecureOptions::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->tls_version.get()) {
    to_value_result->SetWithoutPathExpansion("tlsVersion", (this->tls_version)->ToValue());

  }

  return to_value_result;
}


SocketInfo::SocketInfo()
: socket_id(0),
persistent(false),
paused(false),
connected(false) {}

SocketInfo::~SocketInfo() = default;
SocketInfo::SocketInfo(SocketInfo&& rhs) = default;
SocketInfo& SocketInfo::operator=(SocketInfo&& rhs) = default;
// static
bool SocketInfo::Populate(
    const base::Value& value, SocketInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* socket_id_value = dict->FindKey("socketId");
  if (!socket_id_value) {
    return false;
  }
  {
    auto temp = socket_id_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->socket_id = temp.value();
  }

  const base::Value* persistent_value = dict->FindKey("persistent");
  if (!persistent_value) {
    return false;
  }
  {
    auto temp = persistent_value->GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out->persistent = temp.value();
  }

  const base::Value* name_value = dict->FindKey("name");
  if (name_value) {
    {
      auto* temp = name_value->GetIfString();
      if (!temp) {
        out->name.reset();
        return false;
      }
      out->name = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* buffer_size_value = dict->FindKey("bufferSize");
  if (buffer_size_value) {
    {
      auto temp = buffer_size_value->GetIfInt();
      if (!temp.has_value()) {
        out->buffer_size.reset();
        return false;
      }
      out->buffer_size = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* paused_value = dict->FindKey("paused");
  if (!paused_value) {
    return false;
  }
  {
    auto temp = paused_value->GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out->paused = temp.value();
  }

  const base::Value* connected_value = dict->FindKey("connected");
  if (!connected_value) {
    return false;
  }
  {
    auto temp = connected_value->GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out->connected = temp.value();
  }

  const base::Value* local_address_value = dict->FindKey("localAddress");
  if (local_address_value) {
    {
      auto* temp = local_address_value->GetIfString();
      if (!temp) {
        out->local_address.reset();
        return false;
      }
      out->local_address = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* local_port_value = dict->FindKey("localPort");
  if (local_port_value) {
    {
      auto temp = local_port_value->GetIfInt();
      if (!temp.has_value()) {
        out->local_port.reset();
        return false;
      }
      out->local_port = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* peer_address_value = dict->FindKey("peerAddress");
  if (peer_address_value) {
    {
      auto* temp = peer_address_value->GetIfString();
      if (!temp) {
        out->peer_address.reset();
        return false;
      }
      out->peer_address = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* peer_port_value = dict->FindKey("peerPort");
  if (peer_port_value) {
    {
      auto temp = peer_port_value->GetIfInt();
      if (!temp.has_value()) {
        out->peer_port.reset();
        return false;
      }
      out->peer_port = std::make_unique<int>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<SocketInfo> SocketInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<SocketInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> SocketInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("socketId", std::make_unique<base::Value>(this->socket_id));

  to_value_result->SetWithoutPathExpansion("persistent", std::make_unique<base::Value>(this->persistent));

  if (this->name.get()) {
    to_value_result->SetWithoutPathExpansion("name", std::make_unique<base::Value>(*this->name));

  }
  if (this->buffer_size.get()) {
    to_value_result->SetWithoutPathExpansion("bufferSize", std::make_unique<base::Value>(*this->buffer_size));

  }
  to_value_result->SetWithoutPathExpansion("paused", std::make_unique<base::Value>(this->paused));

  to_value_result->SetWithoutPathExpansion("connected", std::make_unique<base::Value>(this->connected));

  if (this->local_address.get()) {
    to_value_result->SetWithoutPathExpansion("localAddress", std::make_unique<base::Value>(*this->local_address));

  }
  if (this->local_port.get()) {
    to_value_result->SetWithoutPathExpansion("localPort", std::make_unique<base::Value>(*this->local_port));

  }
  if (this->peer_address.get()) {
    to_value_result->SetWithoutPathExpansion("peerAddress", std::make_unique<base::Value>(*this->peer_address));

  }
  if (this->peer_port.get()) {
    to_value_result->SetWithoutPathExpansion("peerPort", std::make_unique<base::Value>(*this->peer_port));

  }

  return to_value_result;
}


ReceiveInfo::ReceiveInfo()
: socket_id(0) {}

ReceiveInfo::~ReceiveInfo() = default;
ReceiveInfo::ReceiveInfo(ReceiveInfo&& rhs) = default;
ReceiveInfo& ReceiveInfo::operator=(ReceiveInfo&& rhs) = default;
// static
bool ReceiveInfo::Populate(
    const base::Value& value, ReceiveInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* socket_id_value = dict->FindKey("socketId");
  if (!socket_id_value) {
    return false;
  }
  {
    auto temp = socket_id_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->socket_id = temp.value();
  }

  const base::Value* data_value = dict->FindKey("data");
  if (!data_value) {
    return false;
  }
  {
    if (!data_value->is_blob()) {
      return false;
    }
    else {
      out->data = data_value->GetBlob();
    }
  }

  return true;
}

// static
std::unique_ptr<ReceiveInfo> ReceiveInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<ReceiveInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ReceiveInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("socketId", std::make_unique<base::Value>(this->socket_id));

  to_value_result->SetWithoutPathExpansion("data", std::make_unique<base::Value>(this->data));


  return to_value_result;
}


ReceiveErrorInfo::ReceiveErrorInfo()
: socket_id(0),
result_code(0) {}

ReceiveErrorInfo::~ReceiveErrorInfo() = default;
ReceiveErrorInfo::ReceiveErrorInfo(ReceiveErrorInfo&& rhs) = default;
ReceiveErrorInfo& ReceiveErrorInfo::operator=(ReceiveErrorInfo&& rhs) = default;
// static
bool ReceiveErrorInfo::Populate(
    const base::Value& value, ReceiveErrorInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* socket_id_value = dict->FindKey("socketId");
  if (!socket_id_value) {
    return false;
  }
  {
    auto temp = socket_id_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->socket_id = temp.value();
  }

  const base::Value* result_code_value = dict->FindKey("resultCode");
  if (!result_code_value) {
    return false;
  }
  {
    auto temp = result_code_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->result_code = temp.value();
  }

  return true;
}

// static
std::unique_ptr<ReceiveErrorInfo> ReceiveErrorInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<ReceiveErrorInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ReceiveErrorInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("socketId", std::make_unique<base::Value>(this->socket_id));

  to_value_result->SetWithoutPathExpansion("resultCode", std::make_unique<base::Value>(this->result_code));


  return to_value_result;
}



//
// Functions
//

namespace Create {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() > 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* properties_value = nullptr;
  if (args.Get(0, &properties_value) &&
      !properties_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!properties_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      else {
        auto temp = std::make_unique<SocketProperties>();
        if (!SocketProperties::Populate(*dictionary, temp.get())) {
          return std::unique_ptr<Params>();
        }
        else
          params->properties = std::move(temp);
      }
    }
  }

  return params;
}


std::vector<base::Value> Results::Create(const CreateInfo& create_info) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((create_info).ToValue()));

  return create_results;
}
}  // namespace Create

namespace Update {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* socket_id_value = nullptr;
  if (args.Get(0, &socket_id_value) &&
      !socket_id_value->is_none()) {
    {
      auto temp = socket_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->socket_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* properties_value = nullptr;
  if (args.Get(1, &properties_value) &&
      !properties_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!properties_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!SocketProperties::Populate(*dictionary, &params->properties)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace Update

namespace SetPaused {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* socket_id_value = nullptr;
  if (args.Get(0, &socket_id_value) &&
      !socket_id_value->is_none()) {
    {
      auto temp = socket_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->socket_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* paused_value = nullptr;
  if (args.Get(1, &paused_value) &&
      !paused_value->is_none()) {
    {
      auto temp = paused_value->GetIfBool();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->paused = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace SetPaused

namespace SetKeepAlive {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() < 2 || args.GetSize() > 3) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* socket_id_value = nullptr;
  if (args.Get(0, &socket_id_value) &&
      !socket_id_value->is_none()) {
    {
      auto temp = socket_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->socket_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* enable_value = nullptr;
  if (args.Get(1, &enable_value) &&
      !enable_value->is_none()) {
    {
      auto temp = enable_value->GetIfBool();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->enable = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* delay_value = nullptr;
  if (args.Get(2, &delay_value) &&
      !delay_value->is_none()) {
    {
      auto temp = delay_value->GetIfInt();
      if (!temp.has_value()) {
        params->delay.reset();
        return std::unique_ptr<Params>();
      }
      params->delay = std::make_unique<int>(temp.value());
    }
  }

  return params;
}


std::vector<base::Value> Results::Create(int result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(result)));

  return create_results;
}
}  // namespace SetKeepAlive

namespace SetNoDelay {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* socket_id_value = nullptr;
  if (args.Get(0, &socket_id_value) &&
      !socket_id_value->is_none()) {
    {
      auto temp = socket_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->socket_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* no_delay_value = nullptr;
  if (args.Get(1, &no_delay_value) &&
      !no_delay_value->is_none()) {
    {
      auto temp = no_delay_value->GetIfBool();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->no_delay = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(int result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(result)));

  return create_results;
}
}  // namespace SetNoDelay

namespace Connect {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 3) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* socket_id_value = nullptr;
  if (args.Get(0, &socket_id_value) &&
      !socket_id_value->is_none()) {
    {
      auto temp = socket_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->socket_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* peer_address_value = nullptr;
  if (args.Get(1, &peer_address_value) &&
      !peer_address_value->is_none()) {
    {
      auto* temp = peer_address_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->peer_address = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* peer_port_value = nullptr;
  if (args.Get(2, &peer_port_value) &&
      !peer_port_value->is_none()) {
    {
      auto temp = peer_port_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->peer_port = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(int result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(result)));

  return create_results;
}
}  // namespace Connect

namespace Disconnect {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* socket_id_value = nullptr;
  if (args.Get(0, &socket_id_value) &&
      !socket_id_value->is_none()) {
    {
      auto temp = socket_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->socket_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace Disconnect

namespace Secure {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() < 1 || args.GetSize() > 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* socket_id_value = nullptr;
  if (args.Get(0, &socket_id_value) &&
      !socket_id_value->is_none()) {
    {
      auto temp = socket_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->socket_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* options_value = nullptr;
  if (args.Get(1, &options_value) &&
      !options_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!options_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      else {
        auto temp = std::make_unique<SecureOptions>();
        if (!SecureOptions::Populate(*dictionary, temp.get())) {
          return std::unique_ptr<Params>();
        }
        else
          params->options = std::move(temp);
      }
    }
  }

  return params;
}


std::vector<base::Value> Results::Create(int result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(result)));

  return create_results;
}
}  // namespace Secure

namespace Send {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* socket_id_value = nullptr;
  if (args.Get(0, &socket_id_value) &&
      !socket_id_value->is_none()) {
    {
      auto temp = socket_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->socket_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* data_value = nullptr;
  if (args.Get(1, &data_value) &&
      !data_value->is_none()) {
    {
      if (!data_value->is_blob()) {
        return std::unique_ptr<Params>();
      }
      else {
        params->data = data_value->GetBlob();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const SendInfo& send_info) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((send_info).ToValue()));

  return create_results;
}
}  // namespace Send

namespace Close {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* socket_id_value = nullptr;
  if (args.Get(0, &socket_id_value) &&
      !socket_id_value->is_none()) {
    {
      auto temp = socket_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->socket_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace Close

namespace GetInfo {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* socket_id_value = nullptr;
  if (args.Get(0, &socket_id_value) &&
      !socket_id_value->is_none()) {
    {
      auto temp = socket_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->socket_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const SocketInfo& socket_info) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((socket_info).ToValue()));

  return create_results;
}
}  // namespace GetInfo

namespace GetSockets {

std::vector<base::Value> Results::Create(const std::vector<SocketInfo>& socket_infos) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(json_schema_compiler::util::CreateValueFromArray(socket_infos)));

  return create_results;
}
}  // namespace GetSockets

//
// Events
//

namespace OnReceive {

const char kEventName[] = "sockets.tcp.onReceive";

std::vector<base::Value> Create(const ReceiveInfo& info) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((info).ToValue()));

  return create_results;
}

}  // namespace OnReceive

namespace OnReceiveError {

const char kEventName[] = "sockets.tcp.onReceiveError";

std::vector<base::Value> Create(const ReceiveErrorInfo& info) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((info).ToValue()));

  return create_results;
}

}  // namespace OnReceiveError

}  // namespace sockets_tcp
}  // namespace api
}  // namespace extensions

