// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/test.json
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "extensions/common/api/test.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace test {
//
// Functions
//

namespace GetConfig {

Results::TestConfig::FtpServer::FtpServer()
: port(0) {}

Results::TestConfig::FtpServer::~FtpServer() = default;
Results::TestConfig::FtpServer::FtpServer(FtpServer&& rhs) = default;
Results::TestConfig::FtpServer& Results::TestConfig::FtpServer::operator=(FtpServer&& rhs) = default;
std::unique_ptr<base::DictionaryValue> Results::TestConfig::FtpServer::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("port", std::make_unique<base::Value>(this->port));


  return to_value_result;
}


Results::TestConfig::TestServer::TestServer()
: port(0) {}

Results::TestConfig::TestServer::~TestServer() = default;
Results::TestConfig::TestServer::TestServer(TestServer&& rhs) = default;
Results::TestConfig::TestServer& Results::TestConfig::TestServer::operator=(TestServer&& rhs) = default;
std::unique_ptr<base::DictionaryValue> Results::TestConfig::TestServer::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("port", std::make_unique<base::Value>(this->port));


  return to_value_result;
}


Results::TestConfig::LoginStatus::LoginStatus()
 {}

Results::TestConfig::LoginStatus::~LoginStatus() = default;
Results::TestConfig::LoginStatus::LoginStatus(LoginStatus&& rhs) = default;
Results::TestConfig::LoginStatus& Results::TestConfig::LoginStatus::operator=(LoginStatus&& rhs) = default;
std::unique_ptr<base::DictionaryValue> Results::TestConfig::LoginStatus::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->is_logged_in.get()) {
    to_value_result->SetWithoutPathExpansion("isLoggedIn", std::make_unique<base::Value>(*this->is_logged_in));

  }
  if (this->is_screen_locked.get()) {
    to_value_result->SetWithoutPathExpansion("isScreenLocked", std::make_unique<base::Value>(*this->is_screen_locked));

  }

  return to_value_result;
}



Results::TestConfig::TestConfig()
 {}

Results::TestConfig::~TestConfig() = default;
Results::TestConfig::TestConfig(TestConfig&& rhs) = default;
Results::TestConfig& Results::TestConfig::operator=(TestConfig&& rhs) = default;
std::unique_ptr<base::DictionaryValue> Results::TestConfig::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->custom_arg.get()) {
    to_value_result->SetWithoutPathExpansion("customArg", std::make_unique<base::Value>(*this->custom_arg));

  }
  if (this->ftp_server.get()) {
    to_value_result->SetWithoutPathExpansion("ftpServer", (this->ftp_server)->ToValue());

  }
  if (this->test_server.get()) {
    to_value_result->SetWithoutPathExpansion("testServer", (this->test_server)->ToValue());

  }
  if (this->test_data_directory.get()) {
    to_value_result->SetWithoutPathExpansion("testDataDirectory", std::make_unique<base::Value>(*this->test_data_directory));

  }
  if (this->test_web_socket_port.get()) {
    to_value_result->SetWithoutPathExpansion("testWebSocketPort", std::make_unique<base::Value>(*this->test_web_socket_port));

  }
  if (this->login_status.get()) {
    to_value_result->SetWithoutPathExpansion("loginStatus", (this->login_status)->ToValue());

  }

  return to_value_result;
}


std::vector<base::Value> Results::Create(const TestConfig& test_config) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((test_config).ToValue()));

  return create_results;
}
}  // namespace GetConfig

namespace NotifyFail {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* message_value = nullptr;
  if (args.Get(0, &message_value) &&
      !message_value->is_none()) {
    {
      auto* temp = message_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->message = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace NotifyFail

namespace NotifyPass {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() > 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* message_value = nullptr;
  if (args.Get(0, &message_value) &&
      !message_value->is_none()) {
    {
      auto* temp = message_value->GetIfString();
      if (!temp) {
        params->message.reset();
        return std::unique_ptr<Params>();
      }
      params->message = std::make_unique<std::string>(*temp);
    }
  }

  return params;
}


}  // namespace NotifyPass

namespace Log {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* message_value = nullptr;
  if (args.Get(0, &message_value) &&
      !message_value->is_none()) {
    {
      auto* temp = message_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->message = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace Log

namespace PassMessage {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* message_value = nullptr;
  if (args.Get(0, &message_value) &&
      !message_value->is_none()) {
    {
      auto* temp = message_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->message = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const std::string& response) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(response)));

  return create_results;
}
}  // namespace PassMessage

namespace WaitForRoundTrip {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* message_value = nullptr;
  if (args.Get(0, &message_value) &&
      !message_value->is_none()) {
    {
      auto* temp = message_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->message = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const std::string& message) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(message)));

  return create_results;
}
}  // namespace WaitForRoundTrip

//
// Events
//

namespace OnMessage {

const char kEventName[] = "test.onMessage";

Info::Info()
: last_message(false) {}

Info::~Info() = default;
Info::Info(Info&& rhs) = default;
Info& Info::operator=(Info&& rhs) = default;
std::unique_ptr<base::DictionaryValue> Info::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("data", std::make_unique<base::Value>(this->data));

  to_value_result->SetWithoutPathExpansion("lastMessage", std::make_unique<base::Value>(this->last_message));


  return to_value_result;
}


std::vector<base::Value> Create(const Info& info) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((info).ToValue()));

  return create_results;
}

}  // namespace OnMessage

}  // namespace test
}  // namespace api
}  // namespace extensions

