// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/web_view_internal.json
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "extensions/common/api/web_view_internal.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"
#include "extensions/common/api/extension_types.h"


using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace web_view_internal {
//
// Properties
//

const int MAX_CAPTURE_VISIBLE_REGION_CALLS_PER_SECOND = 2;

//
// Types
//

DataTypeSet::DataTypeSet()
 {}

DataTypeSet::~DataTypeSet() = default;
DataTypeSet::DataTypeSet(DataTypeSet&& rhs) = default;
DataTypeSet& DataTypeSet::operator=(DataTypeSet&& rhs) = default;
// static
bool DataTypeSet::Populate(
    const base::Value& value, DataTypeSet* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* appcache_value = dict->FindKey("appcache");
  if (appcache_value) {
    {
      auto temp = appcache_value->GetIfBool();
      if (!temp.has_value()) {
        out->appcache.reset();
        return false;
      }
      out->appcache = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* cookies_value = dict->FindKey("cookies");
  if (cookies_value) {
    {
      auto temp = cookies_value->GetIfBool();
      if (!temp.has_value()) {
        out->cookies.reset();
        return false;
      }
      out->cookies = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* session_cookies_value = dict->FindKey("sessionCookies");
  if (session_cookies_value) {
    {
      auto temp = session_cookies_value->GetIfBool();
      if (!temp.has_value()) {
        out->session_cookies.reset();
        return false;
      }
      out->session_cookies = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* persistent_cookies_value = dict->FindKey("persistentCookies");
  if (persistent_cookies_value) {
    {
      auto temp = persistent_cookies_value->GetIfBool();
      if (!temp.has_value()) {
        out->persistent_cookies.reset();
        return false;
      }
      out->persistent_cookies = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* file_systems_value = dict->FindKey("fileSystems");
  if (file_systems_value) {
    {
      auto temp = file_systems_value->GetIfBool();
      if (!temp.has_value()) {
        out->file_systems.reset();
        return false;
      }
      out->file_systems = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* indexed_db_value = dict->FindKey("indexedDB");
  if (indexed_db_value) {
    {
      auto temp = indexed_db_value->GetIfBool();
      if (!temp.has_value()) {
        out->indexed_db.reset();
        return false;
      }
      out->indexed_db = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* local_storage_value = dict->FindKey("localStorage");
  if (local_storage_value) {
    {
      auto temp = local_storage_value->GetIfBool();
      if (!temp.has_value()) {
        out->local_storage.reset();
        return false;
      }
      out->local_storage = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* web_sql_value = dict->FindKey("webSQL");
  if (web_sql_value) {
    {
      auto temp = web_sql_value->GetIfBool();
      if (!temp.has_value()) {
        out->web_sql.reset();
        return false;
      }
      out->web_sql = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* cache_value = dict->FindKey("cache");
  if (cache_value) {
    {
      auto temp = cache_value->GetIfBool();
      if (!temp.has_value()) {
        out->cache.reset();
        return false;
      }
      out->cache = std::make_unique<bool>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<DataTypeSet> DataTypeSet::FromValue(const base::Value& value) {
  auto out = std::make_unique<DataTypeSet>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> DataTypeSet::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->appcache.get()) {
    to_value_result->SetWithoutPathExpansion("appcache", std::make_unique<base::Value>(*this->appcache));

  }
  if (this->cookies.get()) {
    to_value_result->SetWithoutPathExpansion("cookies", std::make_unique<base::Value>(*this->cookies));

  }
  if (this->session_cookies.get()) {
    to_value_result->SetWithoutPathExpansion("sessionCookies", std::make_unique<base::Value>(*this->session_cookies));

  }
  if (this->persistent_cookies.get()) {
    to_value_result->SetWithoutPathExpansion("persistentCookies", std::make_unique<base::Value>(*this->persistent_cookies));

  }
  if (this->file_systems.get()) {
    to_value_result->SetWithoutPathExpansion("fileSystems", std::make_unique<base::Value>(*this->file_systems));

  }
  if (this->indexed_db.get()) {
    to_value_result->SetWithoutPathExpansion("indexedDB", std::make_unique<base::Value>(*this->indexed_db));

  }
  if (this->local_storage.get()) {
    to_value_result->SetWithoutPathExpansion("localStorage", std::make_unique<base::Value>(*this->local_storage));

  }
  if (this->web_sql.get()) {
    to_value_result->SetWithoutPathExpansion("webSQL", std::make_unique<base::Value>(*this->web_sql));

  }
  if (this->cache.get()) {
    to_value_result->SetWithoutPathExpansion("cache", std::make_unique<base::Value>(*this->cache));

  }

  return to_value_result;
}


RemovalOptions::RemovalOptions()
 {}

RemovalOptions::~RemovalOptions() = default;
RemovalOptions::RemovalOptions(RemovalOptions&& rhs) = default;
RemovalOptions& RemovalOptions::operator=(RemovalOptions&& rhs) = default;
// static
bool RemovalOptions::Populate(
    const base::Value& value, RemovalOptions* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* since_value = dict->FindKey("since");
  if (since_value) {
    {
      auto temp = since_value->GetIfDouble();
      if (!temp.has_value()) {
        out->since.reset();
        return false;
      }
      out->since = std::make_unique<double>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<RemovalOptions> RemovalOptions::FromValue(const base::Value& value) {
  auto out = std::make_unique<RemovalOptions>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> RemovalOptions::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->since.get()) {
    to_value_result->SetWithoutPathExpansion("since", std::make_unique<base::Value>(*this->since));

  }

  return to_value_result;
}


const char* ToString(ZoomMode enum_param) {
  switch (enum_param) {
    case ZOOM_MODE_PER_ORIGIN:
      return "per-origin";
    case ZOOM_MODE_PER_VIEW:
      return "per-view";
    case ZOOM_MODE_DISABLED:
      return "disabled";
    case ZOOM_MODE_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

ZoomMode ParseZoomMode(const std::string& enum_string) {
  if (enum_string == "per-origin")
    return ZOOM_MODE_PER_ORIGIN;
  if (enum_string == "per-view")
    return ZOOM_MODE_PER_VIEW;
  if (enum_string == "disabled")
    return ZOOM_MODE_DISABLED;
  return ZOOM_MODE_NONE;
}


const char* ToString(StopFindingAction enum_param) {
  switch (enum_param) {
    case STOP_FINDING_ACTION_CLEAR:
      return "clear";
    case STOP_FINDING_ACTION_KEEP:
      return "keep";
    case STOP_FINDING_ACTION_ACTIVATE:
      return "activate";
    case STOP_FINDING_ACTION_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

StopFindingAction ParseStopFindingAction(const std::string& enum_string) {
  if (enum_string == "clear")
    return STOP_FINDING_ACTION_CLEAR;
  if (enum_string == "keep")
    return STOP_FINDING_ACTION_KEEP;
  if (enum_string == "activate")
    return STOP_FINDING_ACTION_ACTIVATE;
  return STOP_FINDING_ACTION_NONE;
}


const char* ToString(SetPermissionAction enum_param) {
  switch (enum_param) {
    case SET_PERMISSION_ACTION_ALLOW:
      return "allow";
    case SET_PERMISSION_ACTION_DENY:
      return "deny";
    case SET_PERMISSION_ACTION_DEFAULT:
      return "default";
    case SET_PERMISSION_ACTION_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

SetPermissionAction ParseSetPermissionAction(const std::string& enum_string) {
  if (enum_string == "allow")
    return SET_PERMISSION_ACTION_ALLOW;
  if (enum_string == "deny")
    return SET_PERMISSION_ACTION_DENY;
  if (enum_string == "default")
    return SET_PERMISSION_ACTION_DEFAULT;
  return SET_PERMISSION_ACTION_NONE;
}


InjectionItems::InjectionItems()
 {}

InjectionItems::~InjectionItems() = default;
InjectionItems::InjectionItems(InjectionItems&& rhs) = default;
InjectionItems& InjectionItems::operator=(InjectionItems&& rhs) = default;
// static
bool InjectionItems::Populate(
    const base::Value& value, InjectionItems* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* code_value = dict->FindKey("code");
  if (code_value) {
    {
      auto* temp = code_value->GetIfString();
      if (!temp) {
        out->code.reset();
        return false;
      }
      out->code = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* files_value = dict->FindKey("files");
  if (files_value) {
    {
      const base::ListValue* list = nullptr;
      if (!files_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->files)) {
          return false;
        }
      }
    }
  }

  return true;
}

// static
std::unique_ptr<InjectionItems> InjectionItems::FromValue(const base::Value& value) {
  auto out = std::make_unique<InjectionItems>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> InjectionItems::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->code.get()) {
    to_value_result->SetWithoutPathExpansion("code", std::make_unique<base::Value>(*this->code));

  }
  if (this->files.get()) {
    to_value_result->SetWithoutPathExpansion("files", json_schema_compiler::util::CreateValueFromArray(*this->files));

  }

  return to_value_result;
}


ContentScriptDetails::ContentScriptDetails()
: run_at(extension_types::RUN_AT_NONE) {}

ContentScriptDetails::~ContentScriptDetails() = default;
ContentScriptDetails::ContentScriptDetails(ContentScriptDetails&& rhs) = default;
ContentScriptDetails& ContentScriptDetails::operator=(ContentScriptDetails&& rhs) = default;
// static
bool ContentScriptDetails::Populate(
    const base::Value& value, ContentScriptDetails* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  out->run_at = extension_types::RUN_AT_NONE;
  const base::Value* name_value = dict->FindKey("name");
  if (!name_value) {
    return false;
  }
  {
    auto* temp = name_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->name = *temp;
  }

  const base::Value* matches_value = dict->FindKey("matches");
  if (!matches_value) {
    return false;
  }
  {
    const base::ListValue* list = nullptr;
    if (!matches_value->GetAsList(&list)) {
      return false;
    }
    else {
      if (!json_schema_compiler::util::PopulateArrayFromList(*list, &out->matches)) {
        return false;
      }
    }
  }

  const base::Value* exclude_matches_value = dict->FindKey("exclude_matches");
  if (exclude_matches_value) {
    {
      const base::ListValue* list = nullptr;
      if (!exclude_matches_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->exclude_matches)) {
          return false;
        }
      }
    }
  }

  const base::Value* match_about_blank_value = dict->FindKey("match_about_blank");
  if (match_about_blank_value) {
    {
      auto temp = match_about_blank_value->GetIfBool();
      if (!temp.has_value()) {
        out->match_about_blank.reset();
        return false;
      }
      out->match_about_blank = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* css_value = dict->FindKey("css");
  if (css_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!css_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<InjectionItems>();
        if (!InjectionItems::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->css = std::move(temp);
      }
    }
  }

  const base::Value* js_value = dict->FindKey("js");
  if (js_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!js_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<InjectionItems>();
        if (!InjectionItems::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->js = std::move(temp);
      }
    }
  }

  const base::Value* run_at_value = dict->FindKey("run_at");
  if (run_at_value) {
    {
      std::string run_at_as_string;
      if (!run_at_value->GetAsString(&run_at_as_string)) {
        return false;
      }
      out->run_at = extension_types::ParseRunAt(run_at_as_string);
      if (out->run_at == extension_types::RUN_AT_NONE) {
        return false;
      }
    }
    } else {
    out->run_at = extension_types::RUN_AT_NONE;
  }

  const base::Value* all_frames_value = dict->FindKey("all_frames");
  if (all_frames_value) {
    {
      auto temp = all_frames_value->GetIfBool();
      if (!temp.has_value()) {
        out->all_frames.reset();
        return false;
      }
      out->all_frames = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* include_globs_value = dict->FindKey("include_globs");
  if (include_globs_value) {
    {
      const base::ListValue* list = nullptr;
      if (!include_globs_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->include_globs)) {
          return false;
        }
      }
    }
  }

  const base::Value* exclude_globs_value = dict->FindKey("exclude_globs");
  if (exclude_globs_value) {
    {
      const base::ListValue* list = nullptr;
      if (!exclude_globs_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->exclude_globs)) {
          return false;
        }
      }
    }
  }

  return true;
}

// static
std::unique_ptr<ContentScriptDetails> ContentScriptDetails::FromValue(const base::Value& value) {
  auto out = std::make_unique<ContentScriptDetails>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ContentScriptDetails::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("name", std::make_unique<base::Value>(this->name));

  to_value_result->SetWithoutPathExpansion("matches", json_schema_compiler::util::CreateValueFromArray(this->matches));

  if (this->exclude_matches.get()) {
    to_value_result->SetWithoutPathExpansion("exclude_matches", json_schema_compiler::util::CreateValueFromArray(*this->exclude_matches));

  }
  if (this->match_about_blank.get()) {
    to_value_result->SetWithoutPathExpansion("match_about_blank", std::make_unique<base::Value>(*this->match_about_blank));

  }
  if (this->css.get()) {
    to_value_result->SetWithoutPathExpansion("css", (this->css)->ToValue());

  }
  if (this->js.get()) {
    to_value_result->SetWithoutPathExpansion("js", (this->js)->ToValue());

  }
  if (this->run_at != extension_types::RUN_AT_NONE) {
    to_value_result->SetWithoutPathExpansion("run_at", std::make_unique<base::Value>(extension_types::ToString(this->run_at)));

  }
  if (this->all_frames.get()) {
    to_value_result->SetWithoutPathExpansion("all_frames", std::make_unique<base::Value>(*this->all_frames));

  }
  if (this->include_globs.get()) {
    to_value_result->SetWithoutPathExpansion("include_globs", json_schema_compiler::util::CreateValueFromArray(*this->include_globs));

  }
  if (this->exclude_globs.get()) {
    to_value_result->SetWithoutPathExpansion("exclude_globs", json_schema_compiler::util::CreateValueFromArray(*this->exclude_globs));

  }

  return to_value_result;
}



//
// Functions
//

namespace GetAudioState {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* instance_id_value = nullptr;
  if (args.Get(0, &instance_id_value) &&
      !instance_id_value->is_none()) {
    {
      auto temp = instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(bool audible) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(audible)));

  return create_results;
}
}  // namespace GetAudioState

namespace SetAudioMuted {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* instance_id_value = nullptr;
  if (args.Get(0, &instance_id_value) &&
      !instance_id_value->is_none()) {
    {
      auto temp = instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* mute_value = nullptr;
  if (args.Get(1, &mute_value) &&
      !mute_value->is_none()) {
    {
      auto temp = mute_value->GetIfBool();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->mute = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace SetAudioMuted

namespace IsAudioMuted {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* instance_id_value = nullptr;
  if (args.Get(0, &instance_id_value) &&
      !instance_id_value->is_none()) {
    {
      auto temp = instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(bool muted) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(muted)));

  return create_results;
}
}  // namespace IsAudioMuted

namespace ExecuteScript {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 3) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* instance_id_value = nullptr;
  if (args.Get(0, &instance_id_value) &&
      !instance_id_value->is_none()) {
    {
      auto temp = instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* src_value = nullptr;
  if (args.Get(1, &src_value) &&
      !src_value->is_none()) {
    {
      auto* temp = src_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->src = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* details_value = nullptr;
  if (args.Get(2, &details_value) &&
      !details_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!details_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!extensions::api::extension_types::InjectDetails::Populate(*dictionary, &params->details)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const std::vector<std::unique_ptr<base::Value>>& result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(json_schema_compiler::util::CreateValueFromArray(result)));

  return create_results;
}
}  // namespace ExecuteScript

namespace InsertCSS {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 3) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* instance_id_value = nullptr;
  if (args.Get(0, &instance_id_value) &&
      !instance_id_value->is_none()) {
    {
      auto temp = instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* src_value = nullptr;
  if (args.Get(1, &src_value) &&
      !src_value->is_none()) {
    {
      auto* temp = src_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->src = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* details_value = nullptr;
  if (args.Get(2, &details_value) &&
      !details_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!details_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!extensions::api::extension_types::InjectDetails::Populate(*dictionary, &params->details)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace InsertCSS

namespace AddContentScripts {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* instance_id_value = nullptr;
  if (args.Get(0, &instance_id_value) &&
      !instance_id_value->is_none()) {
    {
      auto temp = instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* content_script_list_value = nullptr;
  if (args.Get(1, &content_script_list_value) &&
      !content_script_list_value->is_none()) {
    {
      const base::ListValue* list = nullptr;
      if (!content_script_list_value->GetAsList(&list)) {
        return std::unique_ptr<Params>();
      }
      else {
        if (!json_schema_compiler::util::PopulateArrayFromList(*list, &params->content_script_list)) {
          return std::unique_ptr<Params>();
        }
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace AddContentScripts

namespace RemoveContentScripts {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() < 1 || args.GetSize() > 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* instance_id_value = nullptr;
  if (args.Get(0, &instance_id_value) &&
      !instance_id_value->is_none()) {
    {
      auto temp = instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* script_name_list_value = nullptr;
  if (args.Get(1, &script_name_list_value) &&
      !script_name_list_value->is_none()) {
    {
      const base::ListValue* list = nullptr;
      if (!script_name_list_value->GetAsList(&list)) {
        return std::unique_ptr<Params>();
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &params->script_name_list)) {
          return std::unique_ptr<Params>();
        }
      }
    }
  }

  return params;
}


}  // namespace RemoveContentScripts

namespace SetZoom {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* instance_id_value = nullptr;
  if (args.Get(0, &instance_id_value) &&
      !instance_id_value->is_none()) {
    {
      auto temp = instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* zoom_factor_value = nullptr;
  if (args.Get(1, &zoom_factor_value) &&
      !zoom_factor_value->is_none()) {
    {
      auto temp = zoom_factor_value->GetIfDouble();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->zoom_factor = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace SetZoom

namespace GetZoom {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* instance_id_value = nullptr;
  if (args.Get(0, &instance_id_value) &&
      !instance_id_value->is_none()) {
    {
      auto temp = instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(double zoom_factor) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(zoom_factor)));

  return create_results;
}
}  // namespace GetZoom

namespace SetZoomMode {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* instance_id_value = nullptr;
  if (args.Get(0, &instance_id_value) &&
      !instance_id_value->is_none()) {
    {
      auto temp = instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* zoom_mode_value = nullptr;
  if (args.Get(1, &zoom_mode_value) &&
      !zoom_mode_value->is_none()) {
    {
      std::string zoom_mode_as_string;
      if (!zoom_mode_value->GetAsString(&zoom_mode_as_string)) {
        return std::unique_ptr<Params>();
      }
      params->zoom_mode = ParseZoomMode(zoom_mode_as_string);
      if (params->zoom_mode == ZOOM_MODE_NONE) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace SetZoomMode

namespace GetZoomMode {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* instance_id_value = nullptr;
  if (args.Get(0, &instance_id_value) &&
      !instance_id_value->is_none()) {
    {
      auto temp = instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const ZoomMode& zoom_mode) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(web_view_internal::ToString(zoom_mode))));

  return create_results;
}
}  // namespace GetZoomMode

namespace Find {

Params::Options::Options()
 {}

Params::Options::~Options() = default;
Params::Options::Options(Options&& rhs) = default;
Params::Options& Params::Options::operator=(Options&& rhs) = default;
// static
bool Params::Options::Populate(
    const base::Value& value, Options* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* backward_value = dict->FindKey("backward");
  if (backward_value) {
    {
      auto temp = backward_value->GetIfBool();
      if (!temp.has_value()) {
        out->backward.reset();
        return false;
      }
      out->backward = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* match_case_value = dict->FindKey("matchCase");
  if (match_case_value) {
    {
      auto temp = match_case_value->GetIfBool();
      if (!temp.has_value()) {
        out->match_case.reset();
        return false;
      }
      out->match_case = std::make_unique<bool>(temp.value());
    }
  }

  return true;
}


Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() < 2 || args.GetSize() > 3) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* instance_id_value = nullptr;
  if (args.Get(0, &instance_id_value) &&
      !instance_id_value->is_none()) {
    {
      auto temp = instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* search_text_value = nullptr;
  if (args.Get(1, &search_text_value) &&
      !search_text_value->is_none()) {
    {
      auto* temp = search_text_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->search_text = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* options_value = nullptr;
  if (args.Get(2, &options_value) &&
      !options_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!options_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      else {
        auto temp = std::make_unique<Options>();
        if (!Options::Populate(*dictionary, temp.get())) {
          return std::unique_ptr<Params>();
        }
        else
          params->options = std::move(temp);
      }
    }
  }

  return params;
}


Results::Results::SelectionRect::SelectionRect()
: left(0),
top(0),
width(0),
height(0) {}

Results::Results::SelectionRect::~SelectionRect() = default;
Results::Results::SelectionRect::SelectionRect(SelectionRect&& rhs) = default;
Results::Results::SelectionRect& Results::Results::SelectionRect::operator=(SelectionRect&& rhs) = default;
std::unique_ptr<base::DictionaryValue> Results::Results::SelectionRect::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("left", std::make_unique<base::Value>(this->left));

  to_value_result->SetWithoutPathExpansion("top", std::make_unique<base::Value>(this->top));

  to_value_result->SetWithoutPathExpansion("width", std::make_unique<base::Value>(this->width));

  to_value_result->SetWithoutPathExpansion("height", std::make_unique<base::Value>(this->height));


  return to_value_result;
}



Results::Results::Results()
: number_of_matches(0),
active_match_ordinal(0),
canceled(false) {}

Results::Results::~Results() = default;
Results::Results::Results(Results&& rhs) = default;
Results::Results& Results::Results::operator=(Results&& rhs) = default;
std::unique_ptr<base::DictionaryValue> Results::Results::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("numberOfMatches", std::make_unique<base::Value>(this->number_of_matches));

  to_value_result->SetWithoutPathExpansion("activeMatchOrdinal", std::make_unique<base::Value>(this->active_match_ordinal));

  to_value_result->SetWithoutPathExpansion("selectionRect", (this->selection_rect).ToValue());

  to_value_result->SetWithoutPathExpansion("canceled", std::make_unique<base::Value>(this->canceled));


  return to_value_result;
}


std::vector<base::Value> Results::Create(const Results& results) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((results).ToValue()));

  return create_results;
}
}  // namespace Find

namespace StopFinding {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() < 1 || args.GetSize() > 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());
  params->action = STOP_FINDING_ACTION_NONE;

  const base::Value* instance_id_value = nullptr;
  if (args.Get(0, &instance_id_value) &&
      !instance_id_value->is_none()) {
    {
      auto temp = instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* action_value = nullptr;
  if (args.Get(1, &action_value) &&
      !action_value->is_none()) {
    {
      std::string stop_finding_action_as_string;
      if (!action_value->GetAsString(&stop_finding_action_as_string)) {
        return std::unique_ptr<Params>();
      }
      params->action = ParseStopFindingAction(stop_finding_action_as_string);
      if (params->action == STOP_FINDING_ACTION_NONE) {
        return std::unique_ptr<Params>();
      }
    }
  }

  return params;
}


}  // namespace StopFinding

namespace LoadDataWithBaseUrl {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() < 3 || args.GetSize() > 4) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* instance_id_value = nullptr;
  if (args.Get(0, &instance_id_value) &&
      !instance_id_value->is_none()) {
    {
      auto temp = instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* data_url_value = nullptr;
  if (args.Get(1, &data_url_value) &&
      !data_url_value->is_none()) {
    {
      auto* temp = data_url_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->data_url = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* base_url_value = nullptr;
  if (args.Get(2, &base_url_value) &&
      !base_url_value->is_none()) {
    {
      auto* temp = base_url_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->base_url = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* virtual_url_value = nullptr;
  if (args.Get(3, &virtual_url_value) &&
      !virtual_url_value->is_none()) {
    {
      auto* temp = virtual_url_value->GetIfString();
      if (!temp) {
        params->virtual_url.reset();
        return std::unique_ptr<Params>();
      }
      params->virtual_url = std::make_unique<std::string>(*temp);
    }
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace LoadDataWithBaseUrl

namespace Go {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* instance_id_value = nullptr;
  if (args.Get(0, &instance_id_value) &&
      !instance_id_value->is_none()) {
    {
      auto temp = instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* relative_index_value = nullptr;
  if (args.Get(1, &relative_index_value) &&
      !relative_index_value->is_none()) {
    {
      auto temp = relative_index_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->relative_index = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(bool success) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(success)));

  return create_results;
}
}  // namespace Go

namespace OverrideUserAgent {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* instance_id_value = nullptr;
  if (args.Get(0, &instance_id_value) &&
      !instance_id_value->is_none()) {
    {
      auto temp = instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* user_agent_override_value = nullptr;
  if (args.Get(1, &user_agent_override_value) &&
      !user_agent_override_value->is_none()) {
    {
      auto* temp = user_agent_override_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->user_agent_override = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace OverrideUserAgent

namespace Reload {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* instance_id_value = nullptr;
  if (args.Get(0, &instance_id_value) &&
      !instance_id_value->is_none()) {
    {
      auto temp = instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace Reload

namespace SetAllowTransparency {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* instance_id_value = nullptr;
  if (args.Get(0, &instance_id_value) &&
      !instance_id_value->is_none()) {
    {
      auto temp = instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* allow_value = nullptr;
  if (args.Get(1, &allow_value) &&
      !allow_value->is_none()) {
    {
      auto temp = allow_value->GetIfBool();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->allow = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace SetAllowTransparency

namespace SetAllowScaling {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* instance_id_value = nullptr;
  if (args.Get(0, &instance_id_value) &&
      !instance_id_value->is_none()) {
    {
      auto temp = instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* allow_value = nullptr;
  if (args.Get(1, &allow_value) &&
      !allow_value->is_none()) {
    {
      auto temp = allow_value->GetIfBool();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->allow = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace SetAllowScaling

namespace SetName {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* instance_id_value = nullptr;
  if (args.Get(0, &instance_id_value) &&
      !instance_id_value->is_none()) {
    {
      auto temp = instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* frame_name_value = nullptr;
  if (args.Get(1, &frame_name_value) &&
      !frame_name_value->is_none()) {
    {
      auto* temp = frame_name_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->frame_name = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace SetName

namespace SetPermission {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() < 3 || args.GetSize() > 4) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* instance_id_value = nullptr;
  if (args.Get(0, &instance_id_value) &&
      !instance_id_value->is_none()) {
    {
      auto temp = instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* request_id_value = nullptr;
  if (args.Get(1, &request_id_value) &&
      !request_id_value->is_none()) {
    {
      auto temp = request_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->request_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* action_value = nullptr;
  if (args.Get(2, &action_value) &&
      !action_value->is_none()) {
    {
      std::string set_permission_action_as_string;
      if (!action_value->GetAsString(&set_permission_action_as_string)) {
        return std::unique_ptr<Params>();
      }
      params->action = ParseSetPermissionAction(set_permission_action_as_string);
      if (params->action == SET_PERMISSION_ACTION_NONE) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* user_input_value = nullptr;
  if (args.Get(3, &user_input_value) &&
      !user_input_value->is_none()) {
    {
      auto* temp = user_input_value->GetIfString();
      if (!temp) {
        params->user_input.reset();
        return std::unique_ptr<Params>();
      }
      params->user_input = std::make_unique<std::string>(*temp);
    }
  }

  return params;
}


std::vector<base::Value> Results::Create(bool allowed) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(allowed)));

  return create_results;
}
}  // namespace SetPermission

namespace Navigate {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* instance_id_value = nullptr;
  if (args.Get(0, &instance_id_value) &&
      !instance_id_value->is_none()) {
    {
      auto temp = instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* src_value = nullptr;
  if (args.Get(1, &src_value) &&
      !src_value->is_none()) {
    {
      auto* temp = src_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->src = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace Navigate

namespace Stop {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* instance_id_value = nullptr;
  if (args.Get(0, &instance_id_value) &&
      !instance_id_value->is_none()) {
    {
      auto temp = instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace Stop

namespace Terminate {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* instance_id_value = nullptr;
  if (args.Get(0, &instance_id_value) &&
      !instance_id_value->is_none()) {
    {
      auto temp = instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace Terminate

namespace CaptureVisibleRegion {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() < 1 || args.GetSize() > 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* instance_id_value = nullptr;
  if (args.Get(0, &instance_id_value) &&
      !instance_id_value->is_none()) {
    {
      auto temp = instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* options_value = nullptr;
  if (args.Get(1, &options_value) &&
      !options_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!options_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      else {
        auto temp = std::make_unique<extensions::api::extension_types::ImageDetails>();
        if (!extensions::api::extension_types::ImageDetails::Populate(*dictionary, temp.get())) {
          return std::unique_ptr<Params>();
        }
        else
          params->options = std::move(temp);
      }
    }
  }

  return params;
}


std::vector<base::Value> Results::Create(const std::string& data_url) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(data_url)));

  return create_results;
}
}  // namespace CaptureVisibleRegion

namespace SetSpatialNavigationEnabled {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* instance_id_value = nullptr;
  if (args.Get(0, &instance_id_value) &&
      !instance_id_value->is_none()) {
    {
      auto temp = instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* spatial_nav_enabled_value = nullptr;
  if (args.Get(1, &spatial_nav_enabled_value) &&
      !spatial_nav_enabled_value->is_none()) {
    {
      auto temp = spatial_nav_enabled_value->GetIfBool();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->spatial_nav_enabled = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace SetSpatialNavigationEnabled

namespace IsSpatialNavigationEnabled {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* instance_id_value = nullptr;
  if (args.Get(0, &instance_id_value) &&
      !instance_id_value->is_none()) {
    {
      auto temp = instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(bool spatial_nav_enabled) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(spatial_nav_enabled)));

  return create_results;
}
}  // namespace IsSpatialNavigationEnabled

namespace ClearData {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 3) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* instance_id_value = nullptr;
  if (args.Get(0, &instance_id_value) &&
      !instance_id_value->is_none()) {
    {
      auto temp = instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* options_value = nullptr;
  if (args.Get(1, &options_value) &&
      !options_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!options_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!RemovalOptions::Populate(*dictionary, &params->options)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* data_to_remove_value = nullptr;
  if (args.Get(2, &data_to_remove_value) &&
      !data_to_remove_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!data_to_remove_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!DataTypeSet::Populate(*dictionary, &params->data_to_remove)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace ClearData

}  // namespace web_view_internal
}  // namespace api
}  // namespace extensions

