// extensions/common/mojom/code_injection.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "extensions/common/mojom/code_injection.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/code_injection.mojom-params-data.h"
#include "extensions/common/mojom/code_injection.mojom-shared-message-ids.h"

#include "extensions/common/mojom/code_injection.mojom-import-headers.h"


#ifndef EXTENSIONS_COMMON_MOJOM_CODE_INJECTION_MOJOM_JUMBO_H_
#define EXTENSIONS_COMMON_MOJOM_CODE_INJECTION_MOJOM_JUMBO_H_
#endif
namespace extensions {
namespace mojom {
JSSource::JSSource()
    : code(),
      script_url() {}

JSSource::JSSource(
    const std::string& code_in,
    const ::GURL& script_url_in)
    : code(std::move(code_in)),
      script_url(std::move(script_url_in)) {}

JSSource::~JSSource() = default;

void JSSource::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "code"), this->code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "script_url"), this->script_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool JSSource::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CSSSource::CSSSource()
    : code(),
      key() {}

CSSSource::CSSSource(
    const std::string& code_in,
    const absl::optional<std::string>& key_in)
    : code(std::move(code_in)),
      key(std::move(key_in)) {}

CSSSource::~CSSSource() = default;

void CSSSource::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "code"), this->code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key"), this->key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CSSSource::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
JSInjection::JSInjection()
    : sources(),
      wants_result(),
      user_gesture() {}

JSInjection::JSInjection(
    std::vector<JSSourcePtr> sources_in,
    bool wants_result_in,
    bool user_gesture_in)
    : sources(std::move(sources_in)),
      wants_result(std::move(wants_result_in)),
      user_gesture(std::move(user_gesture_in)) {}

JSInjection::~JSInjection() = default;

void JSInjection::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sources"), this->sources,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<JSSourcePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wants_result"), this->wants_result,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_gesture"), this->user_gesture,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool JSInjection::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CSSInjection::CSSInjection()
    : sources(),
      css_origin(),
      operation() {}

CSSInjection::CSSInjection(
    std::vector<CSSSourcePtr> sources_in,
    ::extensions::mojom::CSSOrigin css_origin_in,
    CSSInjection::Operation operation_in)
    : sources(std::move(sources_in)),
      css_origin(std::move(css_origin_in)),
      operation(std::move(operation_in)) {}

CSSInjection::~CSSInjection() = default;

void CSSInjection::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sources"), this->sources,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<CSSSourcePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "css_origin"), this->css_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::extensions::mojom::CSSOrigin>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "operation"), this->operation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CSSInjection::Operation>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CSSInjection::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CodeInjection::CodeInjection() : tag_(Tag::CSS) {
  data_.css = new CSSInjectionPtr;
}

CodeInjection::~CodeInjection() {
  DestroyActive();
}


void CodeInjection::set_css(
    CSSInjectionPtr css) {
  if (tag_ == Tag::CSS) {
    *(data_.css) = std::move(css);
  } else {
    DestroyActive();
    tag_ = Tag::CSS;
    data_.css = new CSSInjectionPtr(
        std::move(css));
  }
}
void CodeInjection::set_js(
    JSInjectionPtr js) {
  if (tag_ == Tag::JS) {
    *(data_.js) = std::move(js);
  } else {
    DestroyActive();
    tag_ = Tag::JS;
    data_.js = new JSInjectionPtr(
        std::move(js));
  }
}

void CodeInjection::DestroyActive() {
  switch (tag_) {

    case Tag::CSS:

      delete data_.css;
      break;
    case Tag::JS:

      delete data_.js;
      break;
  }
}

bool CodeInjection::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
}  // namespace mojom
}  // namespace extensions

namespace mojo {


// static
bool StructTraits<::extensions::mojom::JSSource::DataView, ::extensions::mojom::JSSourcePtr>::Read(
    ::extensions::mojom::JSSource::DataView input,
    ::extensions::mojom::JSSourcePtr* output) {
  bool success = true;
  ::extensions::mojom::JSSourcePtr result(::extensions::mojom::JSSource::New());
  
      if (success && !input.ReadCode(&result->code))
        success = false;
      if (success && !input.ReadScriptUrl(&result->script_url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::extensions::mojom::CSSSource::DataView, ::extensions::mojom::CSSSourcePtr>::Read(
    ::extensions::mojom::CSSSource::DataView input,
    ::extensions::mojom::CSSSourcePtr* output) {
  bool success = true;
  ::extensions::mojom::CSSSourcePtr result(::extensions::mojom::CSSSource::New());
  
      if (success && !input.ReadCode(&result->code))
        success = false;
      if (success && !input.ReadKey(&result->key))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::extensions::mojom::JSInjection::DataView, ::extensions::mojom::JSInjectionPtr>::Read(
    ::extensions::mojom::JSInjection::DataView input,
    ::extensions::mojom::JSInjectionPtr* output) {
  bool success = true;
  ::extensions::mojom::JSInjectionPtr result(::extensions::mojom::JSInjection::New());
  
      if (success && !input.ReadSources(&result->sources))
        success = false;
      if (success)
        result->wants_result = input.wants_result();
      if (success)
        result->user_gesture = input.user_gesture();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::extensions::mojom::CSSInjection::DataView, ::extensions::mojom::CSSInjectionPtr>::Read(
    ::extensions::mojom::CSSInjection::DataView input,
    ::extensions::mojom::CSSInjectionPtr* output) {
  bool success = true;
  ::extensions::mojom::CSSInjectionPtr result(::extensions::mojom::CSSInjection::New());
  
      if (success && !input.ReadSources(&result->sources))
        success = false;
      if (success && !input.ReadCssOrigin(&result->css_origin))
        success = false;
      if (success && !input.ReadOperation(&result->operation))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::extensions::mojom::CodeInjection::DataView, ::extensions::mojom::CodeInjectionPtr>::Read(
    ::extensions::mojom::CodeInjection::DataView input,
    ::extensions::mojom::CodeInjectionPtr* output) {
  using UnionType = ::extensions::mojom::CodeInjection;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::CSS: {
      ::extensions::mojom::CSSInjectionPtr result_css;
      if (!input.ReadCss(&result_css))
        return false;

      *output = UnionType::NewCss(
          std::move(result_css));
      break;
    }
    case Tag::JS: {
      ::extensions::mojom::JSInjectionPtr result_js;
      if (!input.ReadJs(&result_js))
        return false;

      *output = UnionType::NewJs(
          std::move(result_js));
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif