// extensions/common/mojom/event_router.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "extensions/common/mojom/event_router.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/event_router.mojom-params-data.h"
#include "extensions/common/mojom/event_router.mojom-shared-message-ids.h"

#include "extensions/common/mojom/event_router.mojom-import-headers.h"


#ifndef EXTENSIONS_COMMON_MOJOM_EVENT_ROUTER_MOJOM_JUMBO_H_
#define EXTENSIONS_COMMON_MOJOM_EVENT_ROUTER_MOJOM_JUMBO_H_
#endif
namespace extensions {
namespace mojom {
EventListenerParam::EventListenerParam() : tag_(Tag::EXTENSION_ID) {
  data_.extension_id = new std::string;
}

EventListenerParam::~EventListenerParam() {
  DestroyActive();
}


void EventListenerParam::set_extension_id(
    const std::string& extension_id) {
  if (tag_ == Tag::EXTENSION_ID) {
    *(data_.extension_id) = std::move(extension_id);
  } else {
    DestroyActive();
    tag_ = Tag::EXTENSION_ID;
    data_.extension_id = new std::string(
        std::move(extension_id));
  }
}
void EventListenerParam::set_listener_url(
    const ::GURL& listener_url) {
  if (tag_ == Tag::LISTENER_URL) {
    *(data_.listener_url) = std::move(listener_url);
  } else {
    DestroyActive();
    tag_ = Tag::LISTENER_URL;
    data_.listener_url = new ::GURL(
        std::move(listener_url));
  }
}

void EventListenerParam::DestroyActive() {
  switch (tag_) {

    case Tag::EXTENSION_ID:

      delete data_.extension_id;
      break;
    case Tag::LISTENER_URL:

      delete data_.listener_url;
      break;
  }
}

bool EventListenerParam::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char EventRouter::Name_[] = "extensions.mojom.EventRouter";

EventRouterProxy::EventRouterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void EventRouterProxy::AddListenerForMainThread(
    EventListenerParamPtr in_param, const std::string& in_event_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::EventRouter::AddListenerForMainThread", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("param"), in_param,
                        "<value of type EventListenerParamPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_name"), in_event_name,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kEventRouter_AddListenerForMainThread_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::EventRouter_AddListenerForMainThread_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->param)>
      param_fragment(params.message());
  param_fragment.Claim(&params->param);
  mojo::internal::Serialize<::extensions::mojom::EventListenerParamDataView>(
      in_param, param_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->param.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null param in EventRouter.AddListenerForMainThread request");
  mojo::internal::MessageFragment<
      typename decltype(params->event_name)::BaseType> event_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_event_name, event_name_fragment);
  params->event_name.Set(
      event_name_fragment.is_null() ? nullptr : event_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->event_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null event_name in EventRouter.AddListenerForMainThread request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EventRouter::Name_);
  message.set_method_name("AddListenerForMainThread");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void EventRouterProxy::AddListenerForServiceWorker(
    const std::string& in_extension_id, const ::GURL& in_worker_scope_url, const std::string& in_event_name, int64_t in_service_worker_version_id, int32_t in_worker_thread_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::EventRouter::AddListenerForServiceWorker", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("worker_scope_url"), in_worker_scope_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_name"), in_event_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_version_id"), in_service_worker_version_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("worker_thread_id"), in_worker_thread_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kEventRouter_AddListenerForServiceWorker_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::EventRouter_AddListenerForServiceWorker_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in EventRouter.AddListenerForServiceWorker request");
  mojo::internal::MessageFragment<
      typename decltype(params->worker_scope_url)::BaseType> worker_scope_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_worker_scope_url, worker_scope_url_fragment);
  params->worker_scope_url.Set(
      worker_scope_url_fragment.is_null() ? nullptr : worker_scope_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->worker_scope_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null worker_scope_url in EventRouter.AddListenerForServiceWorker request");
  mojo::internal::MessageFragment<
      typename decltype(params->event_name)::BaseType> event_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_event_name, event_name_fragment);
  params->event_name.Set(
      event_name_fragment.is_null() ? nullptr : event_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->event_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null event_name in EventRouter.AddListenerForServiceWorker request");
  params->service_worker_version_id = in_service_worker_version_id;
  params->worker_thread_id = in_worker_thread_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EventRouter::Name_);
  message.set_method_name("AddListenerForServiceWorker");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void EventRouterProxy::AddLazyListenerForMainThread(
    const std::string& in_extension_id, const std::string& in_event_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::EventRouter::AddLazyListenerForMainThread", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_name"), in_event_name,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kEventRouter_AddLazyListenerForMainThread_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::EventRouter_AddLazyListenerForMainThread_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in EventRouter.AddLazyListenerForMainThread request");
  mojo::internal::MessageFragment<
      typename decltype(params->event_name)::BaseType> event_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_event_name, event_name_fragment);
  params->event_name.Set(
      event_name_fragment.is_null() ? nullptr : event_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->event_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null event_name in EventRouter.AddLazyListenerForMainThread request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EventRouter::Name_);
  message.set_method_name("AddLazyListenerForMainThread");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void EventRouterProxy::AddLazyListenerForServiceWorker(
    const std::string& in_extension_id, const ::GURL& in_worker_scope_url, const std::string& in_event_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::EventRouter::AddLazyListenerForServiceWorker", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("worker_scope_url"), in_worker_scope_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_name"), in_event_name,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kEventRouter_AddLazyListenerForServiceWorker_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::EventRouter_AddLazyListenerForServiceWorker_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in EventRouter.AddLazyListenerForServiceWorker request");
  mojo::internal::MessageFragment<
      typename decltype(params->worker_scope_url)::BaseType> worker_scope_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_worker_scope_url, worker_scope_url_fragment);
  params->worker_scope_url.Set(
      worker_scope_url_fragment.is_null() ? nullptr : worker_scope_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->worker_scope_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null worker_scope_url in EventRouter.AddLazyListenerForServiceWorker request");
  mojo::internal::MessageFragment<
      typename decltype(params->event_name)::BaseType> event_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_event_name, event_name_fragment);
  params->event_name.Set(
      event_name_fragment.is_null() ? nullptr : event_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->event_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null event_name in EventRouter.AddLazyListenerForServiceWorker request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EventRouter::Name_);
  message.set_method_name("AddLazyListenerForServiceWorker");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void EventRouterProxy::AddFilteredListenerForMainThread(
    const std::string& in_extension_id, const std::string& in_event_name, ::base::Value in_filter, bool in_add_lazy_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::EventRouter::AddFilteredListenerForMainThread", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_name"), in_event_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filter"), in_filter,
                        "<value of type ::base::Value>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("add_lazy_listener"), in_add_lazy_listener,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kEventRouter_AddFilteredListenerForMainThread_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::EventRouter_AddFilteredListenerForMainThread_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in EventRouter.AddFilteredListenerForMainThread request");
  mojo::internal::MessageFragment<
      typename decltype(params->event_name)::BaseType> event_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_event_name, event_name_fragment);
  params->event_name.Set(
      event_name_fragment.is_null() ? nullptr : event_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->event_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null event_name in EventRouter.AddFilteredListenerForMainThread request");
  mojo::internal::MessageFragment<
      typename decltype(params->filter)::BaseType> filter_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
      in_filter, filter_fragment);
  params->filter.Set(
      filter_fragment.is_null() ? nullptr : filter_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->filter.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null filter in EventRouter.AddFilteredListenerForMainThread request");
  params->add_lazy_listener = in_add_lazy_listener;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EventRouter::Name_);
  message.set_method_name("AddFilteredListenerForMainThread");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void EventRouterProxy::AddFilteredListenerForServiceWorker(
    const std::string& in_extension_id, const ::GURL& in_worker_scope_url, const std::string& in_event_name, int64_t in_service_worker_version_id, int32_t in_worker_thread_id, ::base::Value in_filter, bool in_add_lazy_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::EventRouter::AddFilteredListenerForServiceWorker", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("worker_scope_url"), in_worker_scope_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_name"), in_event_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_version_id"), in_service_worker_version_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("worker_thread_id"), in_worker_thread_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filter"), in_filter,
                        "<value of type ::base::Value>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("add_lazy_listener"), in_add_lazy_listener,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kEventRouter_AddFilteredListenerForServiceWorker_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::EventRouter_AddFilteredListenerForServiceWorker_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in EventRouter.AddFilteredListenerForServiceWorker request");
  mojo::internal::MessageFragment<
      typename decltype(params->worker_scope_url)::BaseType> worker_scope_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_worker_scope_url, worker_scope_url_fragment);
  params->worker_scope_url.Set(
      worker_scope_url_fragment.is_null() ? nullptr : worker_scope_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->worker_scope_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null worker_scope_url in EventRouter.AddFilteredListenerForServiceWorker request");
  mojo::internal::MessageFragment<
      typename decltype(params->event_name)::BaseType> event_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_event_name, event_name_fragment);
  params->event_name.Set(
      event_name_fragment.is_null() ? nullptr : event_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->event_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null event_name in EventRouter.AddFilteredListenerForServiceWorker request");
  params->service_worker_version_id = in_service_worker_version_id;
  params->worker_thread_id = in_worker_thread_id;
  mojo::internal::MessageFragment<
      typename decltype(params->filter)::BaseType> filter_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
      in_filter, filter_fragment);
  params->filter.Set(
      filter_fragment.is_null() ? nullptr : filter_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->filter.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null filter in EventRouter.AddFilteredListenerForServiceWorker request");
  params->add_lazy_listener = in_add_lazy_listener;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EventRouter::Name_);
  message.set_method_name("AddFilteredListenerForServiceWorker");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void EventRouterProxy::RemoveListenerForMainThread(
    EventListenerParamPtr in_param, const std::string& in_event_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::EventRouter::RemoveListenerForMainThread", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("param"), in_param,
                        "<value of type EventListenerParamPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_name"), in_event_name,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kEventRouter_RemoveListenerForMainThread_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::EventRouter_RemoveListenerForMainThread_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->param)>
      param_fragment(params.message());
  param_fragment.Claim(&params->param);
  mojo::internal::Serialize<::extensions::mojom::EventListenerParamDataView>(
      in_param, param_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->param.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null param in EventRouter.RemoveListenerForMainThread request");
  mojo::internal::MessageFragment<
      typename decltype(params->event_name)::BaseType> event_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_event_name, event_name_fragment);
  params->event_name.Set(
      event_name_fragment.is_null() ? nullptr : event_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->event_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null event_name in EventRouter.RemoveListenerForMainThread request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EventRouter::Name_);
  message.set_method_name("RemoveListenerForMainThread");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void EventRouterProxy::RemoveListenerForServiceWorker(
    const std::string& in_extension_id, const ::GURL& in_worker_scope_url, const std::string& in_event_name, int64_t in_service_worker_version_id, int32_t in_worker_thread_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::EventRouter::RemoveListenerForServiceWorker", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("worker_scope_url"), in_worker_scope_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_name"), in_event_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_version_id"), in_service_worker_version_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("worker_thread_id"), in_worker_thread_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kEventRouter_RemoveListenerForServiceWorker_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::EventRouter_RemoveListenerForServiceWorker_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in EventRouter.RemoveListenerForServiceWorker request");
  mojo::internal::MessageFragment<
      typename decltype(params->worker_scope_url)::BaseType> worker_scope_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_worker_scope_url, worker_scope_url_fragment);
  params->worker_scope_url.Set(
      worker_scope_url_fragment.is_null() ? nullptr : worker_scope_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->worker_scope_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null worker_scope_url in EventRouter.RemoveListenerForServiceWorker request");
  mojo::internal::MessageFragment<
      typename decltype(params->event_name)::BaseType> event_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_event_name, event_name_fragment);
  params->event_name.Set(
      event_name_fragment.is_null() ? nullptr : event_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->event_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null event_name in EventRouter.RemoveListenerForServiceWorker request");
  params->service_worker_version_id = in_service_worker_version_id;
  params->worker_thread_id = in_worker_thread_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EventRouter::Name_);
  message.set_method_name("RemoveListenerForServiceWorker");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void EventRouterProxy::RemoveLazyListenerForMainThread(
    const std::string& in_extension_id, const std::string& in_event_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::EventRouter::RemoveLazyListenerForMainThread", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_name"), in_event_name,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kEventRouter_RemoveLazyListenerForMainThread_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::EventRouter_RemoveLazyListenerForMainThread_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in EventRouter.RemoveLazyListenerForMainThread request");
  mojo::internal::MessageFragment<
      typename decltype(params->event_name)::BaseType> event_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_event_name, event_name_fragment);
  params->event_name.Set(
      event_name_fragment.is_null() ? nullptr : event_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->event_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null event_name in EventRouter.RemoveLazyListenerForMainThread request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EventRouter::Name_);
  message.set_method_name("RemoveLazyListenerForMainThread");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void EventRouterProxy::RemoveLazyListenerForServiceWorker(
    const std::string& in_extension_id, const ::GURL& in_worker_scope_url, const std::string& in_event_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::EventRouter::RemoveLazyListenerForServiceWorker", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("worker_scope_url"), in_worker_scope_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_name"), in_event_name,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kEventRouter_RemoveLazyListenerForServiceWorker_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::EventRouter_RemoveLazyListenerForServiceWorker_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in EventRouter.RemoveLazyListenerForServiceWorker request");
  mojo::internal::MessageFragment<
      typename decltype(params->worker_scope_url)::BaseType> worker_scope_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_worker_scope_url, worker_scope_url_fragment);
  params->worker_scope_url.Set(
      worker_scope_url_fragment.is_null() ? nullptr : worker_scope_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->worker_scope_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null worker_scope_url in EventRouter.RemoveLazyListenerForServiceWorker request");
  mojo::internal::MessageFragment<
      typename decltype(params->event_name)::BaseType> event_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_event_name, event_name_fragment);
  params->event_name.Set(
      event_name_fragment.is_null() ? nullptr : event_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->event_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null event_name in EventRouter.RemoveLazyListenerForServiceWorker request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EventRouter::Name_);
  message.set_method_name("RemoveLazyListenerForServiceWorker");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void EventRouterProxy::RemoveFilteredListenerForMainThread(
    const std::string& in_extension_id, const std::string& in_event_name, ::base::Value in_filter, bool in_remove_lazy_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::EventRouter::RemoveFilteredListenerForMainThread", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_name"), in_event_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filter"), in_filter,
                        "<value of type ::base::Value>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remove_lazy_listener"), in_remove_lazy_listener,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kEventRouter_RemoveFilteredListenerForMainThread_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::EventRouter_RemoveFilteredListenerForMainThread_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in EventRouter.RemoveFilteredListenerForMainThread request");
  mojo::internal::MessageFragment<
      typename decltype(params->event_name)::BaseType> event_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_event_name, event_name_fragment);
  params->event_name.Set(
      event_name_fragment.is_null() ? nullptr : event_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->event_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null event_name in EventRouter.RemoveFilteredListenerForMainThread request");
  mojo::internal::MessageFragment<
      typename decltype(params->filter)::BaseType> filter_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
      in_filter, filter_fragment);
  params->filter.Set(
      filter_fragment.is_null() ? nullptr : filter_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->filter.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null filter in EventRouter.RemoveFilteredListenerForMainThread request");
  params->remove_lazy_listener = in_remove_lazy_listener;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EventRouter::Name_);
  message.set_method_name("RemoveFilteredListenerForMainThread");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void EventRouterProxy::RemoveFilteredListenerForServiceWorker(
    const std::string& in_extension_id, const ::GURL& in_worker_scope_url, const std::string& in_event_name, int64_t in_service_worker_version_id, int32_t in_worker_thread_id, ::base::Value in_filter, bool in_remove_lazy_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::EventRouter::RemoveFilteredListenerForServiceWorker", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("worker_scope_url"), in_worker_scope_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_name"), in_event_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_version_id"), in_service_worker_version_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("worker_thread_id"), in_worker_thread_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filter"), in_filter,
                        "<value of type ::base::Value>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remove_lazy_listener"), in_remove_lazy_listener,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kEventRouter_RemoveFilteredListenerForServiceWorker_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::EventRouter_RemoveFilteredListenerForServiceWorker_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in EventRouter.RemoveFilteredListenerForServiceWorker request");
  mojo::internal::MessageFragment<
      typename decltype(params->worker_scope_url)::BaseType> worker_scope_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_worker_scope_url, worker_scope_url_fragment);
  params->worker_scope_url.Set(
      worker_scope_url_fragment.is_null() ? nullptr : worker_scope_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->worker_scope_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null worker_scope_url in EventRouter.RemoveFilteredListenerForServiceWorker request");
  mojo::internal::MessageFragment<
      typename decltype(params->event_name)::BaseType> event_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_event_name, event_name_fragment);
  params->event_name.Set(
      event_name_fragment.is_null() ? nullptr : event_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->event_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null event_name in EventRouter.RemoveFilteredListenerForServiceWorker request");
  params->service_worker_version_id = in_service_worker_version_id;
  params->worker_thread_id = in_worker_thread_id;
  mojo::internal::MessageFragment<
      typename decltype(params->filter)::BaseType> filter_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
      in_filter, filter_fragment);
  params->filter.Set(
      filter_fragment.is_null() ? nullptr : filter_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->filter.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null filter in EventRouter.RemoveFilteredListenerForServiceWorker request");
  params->remove_lazy_listener = in_remove_lazy_listener;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EventRouter::Name_);
  message.set_method_name("RemoveFilteredListenerForServiceWorker");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool EventRouterStubDispatch::Accept(
    EventRouter* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kEventRouter_AddListenerForMainThread_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::EventRouter::AddListenerForMainThread",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::EventRouter::AddListenerForMainThread");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::EventRouter_AddListenerForMainThread_Params_Data* params =
          reinterpret_cast<internal::EventRouter_AddListenerForMainThread_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      EventListenerParamPtr p_param{};
      std::string p_event_name{};
      EventRouter_AddListenerForMainThread_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParam(&p_param))
        success = false;
      if (success && !input_data_view.ReadEventName(&p_event_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EventRouter::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddListenerForMainThread(
std::move(p_param), 
std::move(p_event_name));
      return true;
    }
    case internal::kEventRouter_AddListenerForServiceWorker_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::EventRouter::AddListenerForServiceWorker",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::EventRouter::AddListenerForServiceWorker");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::EventRouter_AddListenerForServiceWorker_Params_Data* params =
          reinterpret_cast<internal::EventRouter_AddListenerForServiceWorker_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_extension_id{};
      ::GURL p_worker_scope_url{};
      std::string p_event_name{};
      int64_t p_service_worker_version_id{};
      int32_t p_worker_thread_id{};
      EventRouter_AddListenerForServiceWorker_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadWorkerScopeUrl(&p_worker_scope_url))
        success = false;
      if (success && !input_data_view.ReadEventName(&p_event_name))
        success = false;
      if (success)
        p_service_worker_version_id = input_data_view.service_worker_version_id();
      if (success)
        p_worker_thread_id = input_data_view.worker_thread_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EventRouter::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddListenerForServiceWorker(
std::move(p_extension_id), 
std::move(p_worker_scope_url), 
std::move(p_event_name), 
std::move(p_service_worker_version_id), 
std::move(p_worker_thread_id));
      return true;
    }
    case internal::kEventRouter_AddLazyListenerForMainThread_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::EventRouter::AddLazyListenerForMainThread",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::EventRouter::AddLazyListenerForMainThread");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::EventRouter_AddLazyListenerForMainThread_Params_Data* params =
          reinterpret_cast<internal::EventRouter_AddLazyListenerForMainThread_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_extension_id{};
      std::string p_event_name{};
      EventRouter_AddLazyListenerForMainThread_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadEventName(&p_event_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EventRouter::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddLazyListenerForMainThread(
std::move(p_extension_id), 
std::move(p_event_name));
      return true;
    }
    case internal::kEventRouter_AddLazyListenerForServiceWorker_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::EventRouter::AddLazyListenerForServiceWorker",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::EventRouter::AddLazyListenerForServiceWorker");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::EventRouter_AddLazyListenerForServiceWorker_Params_Data* params =
          reinterpret_cast<internal::EventRouter_AddLazyListenerForServiceWorker_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_extension_id{};
      ::GURL p_worker_scope_url{};
      std::string p_event_name{};
      EventRouter_AddLazyListenerForServiceWorker_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadWorkerScopeUrl(&p_worker_scope_url))
        success = false;
      if (success && !input_data_view.ReadEventName(&p_event_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EventRouter::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddLazyListenerForServiceWorker(
std::move(p_extension_id), 
std::move(p_worker_scope_url), 
std::move(p_event_name));
      return true;
    }
    case internal::kEventRouter_AddFilteredListenerForMainThread_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::EventRouter::AddFilteredListenerForMainThread",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::EventRouter::AddFilteredListenerForMainThread");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::EventRouter_AddFilteredListenerForMainThread_Params_Data* params =
          reinterpret_cast<internal::EventRouter_AddFilteredListenerForMainThread_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_extension_id{};
      std::string p_event_name{};
      ::base::Value p_filter{};
      bool p_add_lazy_listener{};
      EventRouter_AddFilteredListenerForMainThread_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadEventName(&p_event_name))
        success = false;
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (success)
        p_add_lazy_listener = input_data_view.add_lazy_listener();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EventRouter::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddFilteredListenerForMainThread(
std::move(p_extension_id), 
std::move(p_event_name), 
std::move(p_filter), 
std::move(p_add_lazy_listener));
      return true;
    }
    case internal::kEventRouter_AddFilteredListenerForServiceWorker_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::EventRouter::AddFilteredListenerForServiceWorker",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::EventRouter::AddFilteredListenerForServiceWorker");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::EventRouter_AddFilteredListenerForServiceWorker_Params_Data* params =
          reinterpret_cast<internal::EventRouter_AddFilteredListenerForServiceWorker_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_extension_id{};
      ::GURL p_worker_scope_url{};
      std::string p_event_name{};
      int64_t p_service_worker_version_id{};
      int32_t p_worker_thread_id{};
      ::base::Value p_filter{};
      bool p_add_lazy_listener{};
      EventRouter_AddFilteredListenerForServiceWorker_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadWorkerScopeUrl(&p_worker_scope_url))
        success = false;
      if (success && !input_data_view.ReadEventName(&p_event_name))
        success = false;
      if (success)
        p_service_worker_version_id = input_data_view.service_worker_version_id();
      if (success)
        p_worker_thread_id = input_data_view.worker_thread_id();
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (success)
        p_add_lazy_listener = input_data_view.add_lazy_listener();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EventRouter::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddFilteredListenerForServiceWorker(
std::move(p_extension_id), 
std::move(p_worker_scope_url), 
std::move(p_event_name), 
std::move(p_service_worker_version_id), 
std::move(p_worker_thread_id), 
std::move(p_filter), 
std::move(p_add_lazy_listener));
      return true;
    }
    case internal::kEventRouter_RemoveListenerForMainThread_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::EventRouter::RemoveListenerForMainThread",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::EventRouter::RemoveListenerForMainThread");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::EventRouter_RemoveListenerForMainThread_Params_Data* params =
          reinterpret_cast<internal::EventRouter_RemoveListenerForMainThread_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      EventListenerParamPtr p_param{};
      std::string p_event_name{};
      EventRouter_RemoveListenerForMainThread_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParam(&p_param))
        success = false;
      if (success && !input_data_view.ReadEventName(&p_event_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EventRouter::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveListenerForMainThread(
std::move(p_param), 
std::move(p_event_name));
      return true;
    }
    case internal::kEventRouter_RemoveListenerForServiceWorker_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::EventRouter::RemoveListenerForServiceWorker",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::EventRouter::RemoveListenerForServiceWorker");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::EventRouter_RemoveListenerForServiceWorker_Params_Data* params =
          reinterpret_cast<internal::EventRouter_RemoveListenerForServiceWorker_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_extension_id{};
      ::GURL p_worker_scope_url{};
      std::string p_event_name{};
      int64_t p_service_worker_version_id{};
      int32_t p_worker_thread_id{};
      EventRouter_RemoveListenerForServiceWorker_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadWorkerScopeUrl(&p_worker_scope_url))
        success = false;
      if (success && !input_data_view.ReadEventName(&p_event_name))
        success = false;
      if (success)
        p_service_worker_version_id = input_data_view.service_worker_version_id();
      if (success)
        p_worker_thread_id = input_data_view.worker_thread_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EventRouter::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveListenerForServiceWorker(
std::move(p_extension_id), 
std::move(p_worker_scope_url), 
std::move(p_event_name), 
std::move(p_service_worker_version_id), 
std::move(p_worker_thread_id));
      return true;
    }
    case internal::kEventRouter_RemoveLazyListenerForMainThread_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::EventRouter::RemoveLazyListenerForMainThread",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::EventRouter::RemoveLazyListenerForMainThread");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::EventRouter_RemoveLazyListenerForMainThread_Params_Data* params =
          reinterpret_cast<internal::EventRouter_RemoveLazyListenerForMainThread_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_extension_id{};
      std::string p_event_name{};
      EventRouter_RemoveLazyListenerForMainThread_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadEventName(&p_event_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EventRouter::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveLazyListenerForMainThread(
std::move(p_extension_id), 
std::move(p_event_name));
      return true;
    }
    case internal::kEventRouter_RemoveLazyListenerForServiceWorker_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::EventRouter::RemoveLazyListenerForServiceWorker",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::EventRouter::RemoveLazyListenerForServiceWorker");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::EventRouter_RemoveLazyListenerForServiceWorker_Params_Data* params =
          reinterpret_cast<internal::EventRouter_RemoveLazyListenerForServiceWorker_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_extension_id{};
      ::GURL p_worker_scope_url{};
      std::string p_event_name{};
      EventRouter_RemoveLazyListenerForServiceWorker_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadWorkerScopeUrl(&p_worker_scope_url))
        success = false;
      if (success && !input_data_view.ReadEventName(&p_event_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EventRouter::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveLazyListenerForServiceWorker(
std::move(p_extension_id), 
std::move(p_worker_scope_url), 
std::move(p_event_name));
      return true;
    }
    case internal::kEventRouter_RemoveFilteredListenerForMainThread_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::EventRouter::RemoveFilteredListenerForMainThread",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::EventRouter::RemoveFilteredListenerForMainThread");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::EventRouter_RemoveFilteredListenerForMainThread_Params_Data* params =
          reinterpret_cast<internal::EventRouter_RemoveFilteredListenerForMainThread_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_extension_id{};
      std::string p_event_name{};
      ::base::Value p_filter{};
      bool p_remove_lazy_listener{};
      EventRouter_RemoveFilteredListenerForMainThread_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadEventName(&p_event_name))
        success = false;
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (success)
        p_remove_lazy_listener = input_data_view.remove_lazy_listener();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EventRouter::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveFilteredListenerForMainThread(
std::move(p_extension_id), 
std::move(p_event_name), 
std::move(p_filter), 
std::move(p_remove_lazy_listener));
      return true;
    }
    case internal::kEventRouter_RemoveFilteredListenerForServiceWorker_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::EventRouter::RemoveFilteredListenerForServiceWorker",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::EventRouter::RemoveFilteredListenerForServiceWorker");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::EventRouter_RemoveFilteredListenerForServiceWorker_Params_Data* params =
          reinterpret_cast<internal::EventRouter_RemoveFilteredListenerForServiceWorker_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_extension_id{};
      ::GURL p_worker_scope_url{};
      std::string p_event_name{};
      int64_t p_service_worker_version_id{};
      int32_t p_worker_thread_id{};
      ::base::Value p_filter{};
      bool p_remove_lazy_listener{};
      EventRouter_RemoveFilteredListenerForServiceWorker_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadWorkerScopeUrl(&p_worker_scope_url))
        success = false;
      if (success && !input_data_view.ReadEventName(&p_event_name))
        success = false;
      if (success)
        p_service_worker_version_id = input_data_view.service_worker_version_id();
      if (success)
        p_worker_thread_id = input_data_view.worker_thread_id();
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (success)
        p_remove_lazy_listener = input_data_view.remove_lazy_listener();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EventRouter::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveFilteredListenerForServiceWorker(
std::move(p_extension_id), 
std::move(p_worker_scope_url), 
std::move(p_event_name), 
std::move(p_service_worker_version_id), 
std::move(p_worker_thread_id), 
std::move(p_filter), 
std::move(p_remove_lazy_listener));
      return true;
    }
  }
  return false;
}

// static
bool EventRouterStubDispatch::AcceptWithResponder(
    EventRouter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kEventRouter_AddListenerForMainThread_Name: {
      break;
    }
    case internal::kEventRouter_AddListenerForServiceWorker_Name: {
      break;
    }
    case internal::kEventRouter_AddLazyListenerForMainThread_Name: {
      break;
    }
    case internal::kEventRouter_AddLazyListenerForServiceWorker_Name: {
      break;
    }
    case internal::kEventRouter_AddFilteredListenerForMainThread_Name: {
      break;
    }
    case internal::kEventRouter_AddFilteredListenerForServiceWorker_Name: {
      break;
    }
    case internal::kEventRouter_RemoveListenerForMainThread_Name: {
      break;
    }
    case internal::kEventRouter_RemoveListenerForServiceWorker_Name: {
      break;
    }
    case internal::kEventRouter_RemoveLazyListenerForMainThread_Name: {
      break;
    }
    case internal::kEventRouter_RemoveLazyListenerForServiceWorker_Name: {
      break;
    }
    case internal::kEventRouter_RemoveFilteredListenerForMainThread_Name: {
      break;
    }
    case internal::kEventRouter_RemoveFilteredListenerForServiceWorker_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kEventRouterValidationInfo[] = {
    {internal::kEventRouter_AddListenerForMainThread_Name,
     {&internal::EventRouter_AddListenerForMainThread_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kEventRouter_AddListenerForServiceWorker_Name,
     {&internal::EventRouter_AddListenerForServiceWorker_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kEventRouter_AddLazyListenerForMainThread_Name,
     {&internal::EventRouter_AddLazyListenerForMainThread_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kEventRouter_AddLazyListenerForServiceWorker_Name,
     {&internal::EventRouter_AddLazyListenerForServiceWorker_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kEventRouter_AddFilteredListenerForMainThread_Name,
     {&internal::EventRouter_AddFilteredListenerForMainThread_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kEventRouter_AddFilteredListenerForServiceWorker_Name,
     {&internal::EventRouter_AddFilteredListenerForServiceWorker_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kEventRouter_RemoveListenerForMainThread_Name,
     {&internal::EventRouter_RemoveListenerForMainThread_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kEventRouter_RemoveListenerForServiceWorker_Name,
     {&internal::EventRouter_RemoveListenerForServiceWorker_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kEventRouter_RemoveLazyListenerForMainThread_Name,
     {&internal::EventRouter_RemoveLazyListenerForMainThread_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kEventRouter_RemoveLazyListenerForServiceWorker_Name,
     {&internal::EventRouter_RemoveLazyListenerForServiceWorker_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kEventRouter_RemoveFilteredListenerForMainThread_Name,
     {&internal::EventRouter_RemoveFilteredListenerForMainThread_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kEventRouter_RemoveFilteredListenerForServiceWorker_Name,
     {&internal::EventRouter_RemoveFilteredListenerForServiceWorker_Params_Data::Validate,
      nullptr /* no response */}},
};

bool EventRouterRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::extensions::mojom::EventRouter::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kEventRouterValidationInfo);
}

}  // namespace mojom
}  // namespace extensions

namespace mojo {

// static
bool UnionTraits<::extensions::mojom::EventListenerParam::DataView, ::extensions::mojom::EventListenerParamPtr>::Read(
    ::extensions::mojom::EventListenerParam::DataView input,
    ::extensions::mojom::EventListenerParamPtr* output) {
  using UnionType = ::extensions::mojom::EventListenerParam;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::EXTENSION_ID: {
      std::string result_extension_id;
      if (!input.ReadExtensionId(&result_extension_id))
        return false;

      *output = UnionType::NewExtensionId(
          std::move(result_extension_id));
      break;
    }
    case Tag::LISTENER_URL: {
      ::GURL result_listener_url;
      if (!input.ReadListenerUrl(&result_listener_url))
        return false;

      *output = UnionType::NewListenerUrl(
          std::move(result_listener_url));
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif