// extensions/common/mojom/feature_session_type.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "extensions/common/mojom/feature_session_type.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/feature_session_type.mojom-params-data.h"
namespace extensions {
namespace mojom {

static NOINLINE const char* FeatureSessionTypeToStringHelper(FeatureSessionType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FeatureSessionType::kInitial:
      return "kInitial";
    case FeatureSessionType::kUnknown:
      return "kUnknown";
    case FeatureSessionType::kRegular:
      return "kRegular";
    case FeatureSessionType::kKiosk:
      return "kKiosk";
    case FeatureSessionType::kAutolaunchedKiosk:
      return "kAutolaunchedKiosk";
    default:
      return nullptr;
  }
}

std::string FeatureSessionTypeToString(FeatureSessionType value) {
  const char *str = FeatureSessionTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FeatureSessionType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FeatureSessionType value) {
  return os << FeatureSessionTypeToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace extensions

namespace perfetto {

// static
void TraceFormatTraits<::extensions::mojom::FeatureSessionType>::WriteIntoTrace(
   perfetto::TracedValue context, ::extensions::mojom::FeatureSessionType value) {
  return std::move(context).WriteString(::extensions::mojom::FeatureSessionTypeToString(value));
}

} // namespace perfetto
