// extensions/common/mojom/frame.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "extensions/common/mojom/frame.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/frame.mojom-params-data.h"
namespace extensions {
namespace mojom {

namespace internal {


// static
bool ExecuteCodeParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ExecuteCodeParams_Data* object = static_cast<const ExecuteCodeParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->host_id, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->injection, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->injection, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->webview_src, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->webview_src, validation_context))
    return false;


  if (!::extensions::mojom::internal::RunLocation_Data
        ::Validate(object->run_at, validation_context))
    return false;

  return true;
}

ExecuteCodeParams_Data::ExecuteCodeParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RequestParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RequestParams_Data* object = static_cast<const RequestParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->arguments, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->arguments, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams extension_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->extension_id, validation_context,
                                         &extension_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_url, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_url, validation_context))
    return false;

  return true;
}

RequestParams_Data::RequestParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_SetFrameName_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_SetFrameName_Params_Data* object = static_cast<const LocalFrame_SetFrameName_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams frame_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->frame_name, validation_context,
                                         &frame_name_validate_params)) {
    return false;
  }

  return true;
}

LocalFrame_SetFrameName_Params_Data::LocalFrame_SetFrameName_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_SetSpatialNavigationEnabled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_SetSpatialNavigationEnabled_Params_Data* object = static_cast<const LocalFrame_SetSpatialNavigationEnabled_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrame_SetSpatialNavigationEnabled_Params_Data::LocalFrame_SetSpatialNavigationEnabled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_SetTabId_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_SetTabId_Params_Data* object = static_cast<const LocalFrame_SetTabId_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrame_SetTabId_Params_Data::LocalFrame_SetTabId_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_AppWindowClosed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_AppWindowClosed_Params_Data* object = static_cast<const LocalFrame_AppWindowClosed_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrame_AppWindowClosed_Params_Data::LocalFrame_AppWindowClosed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_NotifyRenderViewType_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_NotifyRenderViewType_Params_Data* object = static_cast<const LocalFrame_NotifyRenderViewType_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::extensions::mojom::internal::ViewType_Data
        ::Validate(object->view_type, validation_context))
    return false;

  return true;
}

LocalFrame_NotifyRenderViewType_Params_Data::LocalFrame_NotifyRenderViewType_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_MessageInvoke_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_MessageInvoke_Params_Data* object = static_cast<const LocalFrame_MessageInvoke_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams extension_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->extension_id, validation_context,
                                         &extension_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->module_name, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams module_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->module_name, validation_context,
                                         &module_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->function_name, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams function_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->function_name, validation_context,
                                         &function_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->args, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->args, validation_context))
    return false;

  return true;
}

LocalFrame_MessageInvoke_Params_Data::LocalFrame_MessageInvoke_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_ExecuteCode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_ExecuteCode_Params_Data* object = static_cast<const LocalFrame_ExecuteCode_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->param, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->param, validation_context))
    return false;

  return true;
}

LocalFrame_ExecuteCode_Params_Data::LocalFrame_ExecuteCode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_ExecuteCode_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_ExecuteCode_ResponseParams_Data* object = static_cast<const LocalFrame_ExecuteCode_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams error_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->error, validation_context,
                                         &error_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

LocalFrame_ExecuteCode_ResponseParams_Data::LocalFrame_ExecuteCode_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_ExecuteDeclarativeScript_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_ExecuteDeclarativeScript_Params_Data* object = static_cast<const LocalFrame_ExecuteDeclarativeScript_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams extension_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->extension_id, validation_context,
                                         &extension_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->script_id, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams script_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->script_id, validation_context,
                                         &script_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

LocalFrame_ExecuteDeclarativeScript_Params_Data::LocalFrame_ExecuteDeclarativeScript_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_RequestScriptInjectionPermission_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_RequestScriptInjectionPermission_Params_Data* object = static_cast<const LocalFrameHost_RequestScriptInjectionPermission_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams extension_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->extension_id, validation_context,
                                         &extension_id_validate_params)) {
    return false;
  }


  if (!::extensions::mojom::internal::InjectionType_Data
        ::Validate(object->script_type, validation_context))
    return false;


  if (!::extensions::mojom::internal::RunLocation_Data
        ::Validate(object->run_location, validation_context))
    return false;

  return true;
}

LocalFrameHost_RequestScriptInjectionPermission_Params_Data::LocalFrameHost_RequestScriptInjectionPermission_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_RequestScriptInjectionPermission_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_RequestScriptInjectionPermission_ResponseParams_Data* object = static_cast<const LocalFrameHost_RequestScriptInjectionPermission_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrameHost_RequestScriptInjectionPermission_ResponseParams_Data::LocalFrameHost_RequestScriptInjectionPermission_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_GetAppInstallState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_GetAppInstallState_Params_Data* object = static_cast<const LocalFrameHost_GetAppInstallState_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

LocalFrameHost_GetAppInstallState_Params_Data::LocalFrameHost_GetAppInstallState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_GetAppInstallState_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_GetAppInstallState_ResponseParams_Data* object = static_cast<const LocalFrameHost_GetAppInstallState_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->state, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams state_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->state, validation_context,
                                         &state_validate_params)) {
    return false;
  }

  return true;
}

LocalFrameHost_GetAppInstallState_ResponseParams_Data::LocalFrameHost_GetAppInstallState_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_Request_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_Request_Params_Data* object = static_cast<const LocalFrameHost_Request_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

LocalFrameHost_Request_Params_Data::LocalFrameHost_Request_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_Request_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_Request_ResponseParams_Data* object = static_cast<const LocalFrameHost_Request_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response_wrapper, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response_wrapper, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams error_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->error, validation_context,
                                         &error_validate_params)) {
    return false;
  }

  return true;
}

LocalFrameHost_Request_ResponseParams_Data::LocalFrameHost_Request_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_WatchedPageChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_WatchedPageChange_Params_Data* object = static_cast<const LocalFrameHost_WatchedPageChange_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->css_selectors, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams css_selectors_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->css_selectors, validation_context,
                                         &css_selectors_validate_params)) {
    return false;
  }

  return true;
}

LocalFrameHost_WatchedPageChange_Params_Data::LocalFrameHost_WatchedPageChange_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace extensions
