// extensions/common/mojom/frame.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "extensions/common/mojom/frame.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "extensions/common/mojom/code_injection.mojom.h"
#include "extensions/common/mojom/host_id.mojom.h"
#include "extensions/common/mojom/injection_type.mojom.h"
#include "extensions/common/mojom/run_location.mojom.h"
#include "extensions/common/mojom/view_type.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include "url/mojom/url.mojom.h"


#ifndef EXTENSIONS_COMMON_MOJOM_FRAME_MOJOM_JUMBO_H_
#define EXTENSIONS_COMMON_MOJOM_FRAME_MOJOM_JUMBO_H_
#endif


namespace extensions {
namespace mojom {


void LocalFrameInterceptorForTesting::SetFrameName(const std::string& frame_name) {
  GetForwardingInterface()->SetFrameName(std::move(frame_name));
}
void LocalFrameInterceptorForTesting::SetSpatialNavigationEnabled(bool spatial_nav_enabled) {
  GetForwardingInterface()->SetSpatialNavigationEnabled(std::move(spatial_nav_enabled));
}
void LocalFrameInterceptorForTesting::SetTabId(int32_t tab_id) {
  GetForwardingInterface()->SetTabId(std::move(tab_id));
}
void LocalFrameInterceptorForTesting::AppWindowClosed(bool send_onclosed) {
  GetForwardingInterface()->AppWindowClosed(std::move(send_onclosed));
}
void LocalFrameInterceptorForTesting::NotifyRenderViewType(::extensions::mojom::ViewType view_type) {
  GetForwardingInterface()->NotifyRenderViewType(std::move(view_type));
}
void LocalFrameInterceptorForTesting::MessageInvoke(const std::string& extension_id, const std::string& module_name, const std::string& function_name, ::base::Value args) {
  GetForwardingInterface()->MessageInvoke(std::move(extension_id), std::move(module_name), std::move(function_name), std::move(args));
}
void LocalFrameInterceptorForTesting::ExecuteCode(ExecuteCodeParamsPtr param, ExecuteCodeCallback callback) {
  GetForwardingInterface()->ExecuteCode(std::move(param), std::move(callback));
}
void LocalFrameInterceptorForTesting::ExecuteDeclarativeScript(int32_t tab_id, const std::string& extension_id, const std::string& script_id, const ::GURL& url) {
  GetForwardingInterface()->ExecuteDeclarativeScript(std::move(tab_id), std::move(extension_id), std::move(script_id), std::move(url));
}
LocalFrameAsyncWaiter::LocalFrameAsyncWaiter(
    LocalFrame* proxy) : proxy_(proxy) {}

LocalFrameAsyncWaiter::~LocalFrameAsyncWaiter() = default;

void LocalFrameAsyncWaiter::ExecuteCode(
    ExecuteCodeParamsPtr param, std::string* out_error, ::GURL* out_url, absl::optional<::base::Value>* out_result) {
  base::RunLoop loop;
  proxy_->ExecuteCode(std::move(param),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_error
,
             ::GURL* out_url
,
             absl::optional<::base::Value>* out_result
,
             const std::string& error,
             const ::GURL& url,
             absl::optional<::base::Value> result) {*out_error = std::move(error);*out_url = std::move(url);*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_error,
          out_url,
          out_result));
  loop.Run();
}



void LocalFrameHostInterceptorForTesting::RequestScriptInjectionPermission(const std::string& extension_id, ::extensions::mojom::InjectionType script_type, ::extensions::mojom::RunLocation run_location, RequestScriptInjectionPermissionCallback callback) {
  GetForwardingInterface()->RequestScriptInjectionPermission(std::move(extension_id), std::move(script_type), std::move(run_location), std::move(callback));
}
void LocalFrameHostInterceptorForTesting::GetAppInstallState(const ::GURL& url, GetAppInstallStateCallback callback) {
  GetForwardingInterface()->GetAppInstallState(std::move(url), std::move(callback));
}
void LocalFrameHostInterceptorForTesting::Request(RequestParamsPtr params, RequestCallback callback) {
  GetForwardingInterface()->Request(std::move(params), std::move(callback));
}
void LocalFrameHostInterceptorForTesting::WatchedPageChange(const std::vector<std::string>& css_selectors) {
  GetForwardingInterface()->WatchedPageChange(std::move(css_selectors));
}
LocalFrameHostAsyncWaiter::LocalFrameHostAsyncWaiter(
    LocalFrameHost* proxy) : proxy_(proxy) {}

LocalFrameHostAsyncWaiter::~LocalFrameHostAsyncWaiter() = default;

void LocalFrameHostAsyncWaiter::RequestScriptInjectionPermission(
    const std::string& extension_id, ::extensions::mojom::InjectionType script_type, ::extensions::mojom::RunLocation run_location, bool* out_granted) {
  base::RunLoop loop;
  proxy_->RequestScriptInjectionPermission(std::move(extension_id),std::move(script_type),std::move(run_location),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_granted
,
             bool granted) {*out_granted = std::move(granted);
            loop->Quit();
          },
          &loop,
          out_granted));
  loop.Run();
}
void LocalFrameHostAsyncWaiter::GetAppInstallState(
    const ::GURL& url, std::string* out_state) {
  base::RunLoop loop;
  proxy_->GetAppInstallState(std::move(url),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_state
,
             const std::string& state) {*out_state = std::move(state);
            loop->Quit();
          },
          &loop,
          out_state));
  loop.Run();
}
void LocalFrameHostAsyncWaiter::Request(
    RequestParamsPtr params, bool* out_success, ::base::Value* out_response_wrapper, std::string* out_error) {
  base::RunLoop loop;
  proxy_->Request(std::move(params),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             ::base::Value* out_response_wrapper
,
             std::string* out_error
,
             bool success,
             ::base::Value response_wrapper,
             const std::string& error) {*out_success = std::move(success);*out_response_wrapper = std::move(response_wrapper);*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_success,
          out_response_wrapper,
          out_error));
  loop.Run();
}





}  // namespace mojom
}  // namespace extensions

#if defined(__clang__)
#pragma clang diagnostic pop
#endif