// extensions/common/mojom/guest_view.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "extensions/common/mojom/guest_view.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/guest_view.mojom-params-data.h"
#include "extensions/common/mojom/guest_view.mojom-shared-message-ids.h"

#include "extensions/common/mojom/guest_view.mojom-import-headers.h"


#ifndef EXTENSIONS_COMMON_MOJOM_GUEST_VIEW_MOJOM_JUMBO_H_
#define EXTENSIONS_COMMON_MOJOM_GUEST_VIEW_MOJOM_JUMBO_H_
#endif
namespace extensions {
namespace mojom {
const char GuestView::Name_[] = "extensions.mojom.GuestView";

GuestViewProxy::GuestViewProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GuestViewProxy::ReadyToCreateMimeHandlerView(
    int32_t in_routing_id, bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::GuestView::ReadyToCreateMimeHandlerView", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("routing_id"), in_routing_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGuestView_ReadyToCreateMimeHandlerView_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::GuestView_ReadyToCreateMimeHandlerView_Params_Data> params(
          message);
  params.Allocate();
  params->routing_id = in_routing_id;
  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GuestView::Name_);
  message.set_method_name("ReadyToCreateMimeHandlerView");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool GuestViewStubDispatch::Accept(
    GuestView* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kGuestView_ReadyToCreateMimeHandlerView_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::GuestView::ReadyToCreateMimeHandlerView",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::GuestView::ReadyToCreateMimeHandlerView");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GuestView_ReadyToCreateMimeHandlerView_Params_Data* params =
          reinterpret_cast<internal::GuestView_ReadyToCreateMimeHandlerView_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_routing_id{};
      bool p_success{};
      GuestView_ReadyToCreateMimeHandlerView_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_routing_id = input_data_view.routing_id();
      if (success)
        p_success = input_data_view.success();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GuestView::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadyToCreateMimeHandlerView(
std::move(p_routing_id), 
std::move(p_success));
      return true;
    }
  }
  return false;
}

// static
bool GuestViewStubDispatch::AcceptWithResponder(
    GuestView* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kGuestView_ReadyToCreateMimeHandlerView_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGuestViewValidationInfo[] = {
    {internal::kGuestView_ReadyToCreateMimeHandlerView_Name,
     {&internal::GuestView_ReadyToCreateMimeHandlerView_Params_Data::Validate,
      nullptr /* no response */}},
};

bool GuestViewRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::extensions::mojom::GuestView::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kGuestViewValidationInfo);
}

const char MimeHandlerViewContainerManager::Name_[] = "extensions.mojom.MimeHandlerViewContainerManager";

class MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ForwardToCallback(
      MimeHandlerViewContainerManager::CreateBeforeUnloadControlCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  MimeHandlerViewContainerManager::CreateBeforeUnloadControlCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ForwardToCallback);
};

MimeHandlerViewContainerManagerProxy::MimeHandlerViewContainerManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MimeHandlerViewContainerManagerProxy::SetInternalId(
    const std::string& in_token_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::MimeHandlerViewContainerManager::SetInternalId", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token_id"), in_token_id,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMimeHandlerViewContainerManager_SetInternalId_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::MimeHandlerViewContainerManager_SetInternalId_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token_id)::BaseType> token_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_token_id, token_id_fragment);
  params->token_id.Set(
      token_id_fragment.is_null() ? nullptr : token_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->token_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null token_id in MimeHandlerViewContainerManager.SetInternalId request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MimeHandlerViewContainerManager::Name_);
  message.set_method_name("SetInternalId");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MimeHandlerViewContainerManagerProxy::CreateBeforeUnloadControl(
    CreateBeforeUnloadControlCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "extensions::mojom::MimeHandlerViewContainerManager::CreateBeforeUnloadControl");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMimeHandlerViewContainerManager_CreateBeforeUnloadControl_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::MimeHandlerViewContainerManager_CreateBeforeUnloadControl_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MimeHandlerViewContainerManager::Name_);
  message.set_method_name("CreateBeforeUnloadControl");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void MimeHandlerViewContainerManagerProxy::DestroyFrameContainer(
    int32_t in_element_instance_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::MimeHandlerViewContainerManager::DestroyFrameContainer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("element_instance_id"), in_element_instance_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMimeHandlerViewContainerManager_DestroyFrameContainer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::MimeHandlerViewContainerManager_DestroyFrameContainer_Params_Data> params(
          message);
  params.Allocate();
  params->element_instance_id = in_element_instance_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MimeHandlerViewContainerManager::Name_);
  message.set_method_name("DestroyFrameContainer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MimeHandlerViewContainerManagerProxy::DidLoad(
    int32_t in_mime_handler_view_guest_element_instance_id, const ::GURL& in_resource_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::MimeHandlerViewContainerManager::DidLoad", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mime_handler_view_guest_element_instance_id"), in_mime_handler_view_guest_element_instance_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resource_url"), in_resource_url,
                        "<value of type const ::GURL&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMimeHandlerViewContainerManager_DidLoad_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::MimeHandlerViewContainerManager_DidLoad_Params_Data> params(
          message);
  params.Allocate();
  params->mime_handler_view_guest_element_instance_id = in_mime_handler_view_guest_element_instance_id;
  mojo::internal::MessageFragment<
      typename decltype(params->resource_url)::BaseType> resource_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_resource_url, resource_url_fragment);
  params->resource_url.Set(
      resource_url_fragment.is_null() ? nullptr : resource_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->resource_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resource_url in MimeHandlerViewContainerManager.DidLoad request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MimeHandlerViewContainerManager::Name_);
  message.set_method_name("DidLoad");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ProxyToResponder {
 public:
  static MimeHandlerViewContainerManager::CreateBeforeUnloadControlCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ProxyToResponder> proxy(
        new MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "MimeHandlerViewContainerManager::CreateBeforeUnloadControlCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingRemote<::extensions::mime_handler::BeforeUnloadControl> in_before_unload_control);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ProxyToResponder);
};

bool MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "extensions::mojom::MimeHandlerViewContainerManager::CreateBeforeUnloadControlCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::mojo::PendingRemote<::extensions::mime_handler::BeforeUnloadControl> p_before_unload_control{};
  MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_before_unload_control =
        input_data_view.TakeBeforeUnloadControl<decltype(p_before_unload_control)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MimeHandlerViewContainerManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_before_unload_control));
  return true;
}

void MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ProxyToResponder::Run(
    ::mojo::PendingRemote<::extensions::mime_handler::BeforeUnloadControl> in_before_unload_control) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)extensions::mojom::MimeHandlerViewContainerManager::CreateBeforeUnloadControlCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("before_unload_control"), in_before_unload_control,
                        "<value of type ::mojo::PendingRemote<::extensions::mime_handler::BeforeUnloadControl>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMimeHandlerViewContainerManager_CreateBeforeUnloadControl_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::extensions::mime_handler::BeforeUnloadControlInterfaceBase>>(
      in_before_unload_control, &params->before_unload_control, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->before_unload_control),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid before_unload_control in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)extensions::mojom::MimeHandlerViewContainerManager::CreateBeforeUnloadControlCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MimeHandlerViewContainerManager::Name_);
  message.set_method_name("CreateBeforeUnloadControl");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool MimeHandlerViewContainerManagerStubDispatch::Accept(
    MimeHandlerViewContainerManager* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kMimeHandlerViewContainerManager_SetInternalId_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::MimeHandlerViewContainerManager::SetInternalId",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::MimeHandlerViewContainerManager::SetInternalId");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MimeHandlerViewContainerManager_SetInternalId_Params_Data* params =
          reinterpret_cast<internal::MimeHandlerViewContainerManager_SetInternalId_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_token_id{};
      MimeHandlerViewContainerManager_SetInternalId_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTokenId(&p_token_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MimeHandlerViewContainerManager::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetInternalId(
std::move(p_token_id));
      return true;
    }
    case internal::kMimeHandlerViewContainerManager_CreateBeforeUnloadControl_Name: {
      break;
    }
    case internal::kMimeHandlerViewContainerManager_DestroyFrameContainer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::MimeHandlerViewContainerManager::DestroyFrameContainer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::MimeHandlerViewContainerManager::DestroyFrameContainer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MimeHandlerViewContainerManager_DestroyFrameContainer_Params_Data* params =
          reinterpret_cast<internal::MimeHandlerViewContainerManager_DestroyFrameContainer_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_element_instance_id{};
      MimeHandlerViewContainerManager_DestroyFrameContainer_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_element_instance_id = input_data_view.element_instance_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MimeHandlerViewContainerManager::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DestroyFrameContainer(
std::move(p_element_instance_id));
      return true;
    }
    case internal::kMimeHandlerViewContainerManager_DidLoad_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::MimeHandlerViewContainerManager::DidLoad",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::MimeHandlerViewContainerManager::DidLoad");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MimeHandlerViewContainerManager_DidLoad_Params_Data* params =
          reinterpret_cast<internal::MimeHandlerViewContainerManager_DidLoad_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_mime_handler_view_guest_element_instance_id{};
      ::GURL p_resource_url{};
      MimeHandlerViewContainerManager_DidLoad_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_mime_handler_view_guest_element_instance_id = input_data_view.mime_handler_view_guest_element_instance_id();
      if (success && !input_data_view.ReadResourceUrl(&p_resource_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MimeHandlerViewContainerManager::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidLoad(
std::move(p_mime_handler_view_guest_element_instance_id), 
std::move(p_resource_url));
      return true;
    }
  }
  return false;
}

// static
bool MimeHandlerViewContainerManagerStubDispatch::AcceptWithResponder(
    MimeHandlerViewContainerManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kMimeHandlerViewContainerManager_SetInternalId_Name: {
      break;
    }
    case internal::kMimeHandlerViewContainerManager_CreateBeforeUnloadControl_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::MimeHandlerViewContainerManager::CreateBeforeUnloadControl",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::MimeHandlerViewContainerManager::CreateBeforeUnloadControl");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::MimeHandlerViewContainerManager_CreateBeforeUnloadControl_Params_Data* params =
          reinterpret_cast<
              internal::MimeHandlerViewContainerManager_CreateBeforeUnloadControl_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MimeHandlerViewContainerManager::Name_, 1, false);
        return false;
      }
      MimeHandlerViewContainerManager::CreateBeforeUnloadControlCallback callback =
          MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateBeforeUnloadControl(std::move(callback));
      return true;
    }
    case internal::kMimeHandlerViewContainerManager_DestroyFrameContainer_Name: {
      break;
    }
    case internal::kMimeHandlerViewContainerManager_DidLoad_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kMimeHandlerViewContainerManagerValidationInfo[] = {
    {internal::kMimeHandlerViewContainerManager_SetInternalId_Name,
     {&internal::MimeHandlerViewContainerManager_SetInternalId_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMimeHandlerViewContainerManager_CreateBeforeUnloadControl_Name,
     {&internal::MimeHandlerViewContainerManager_CreateBeforeUnloadControl_Params_Data::Validate,
      &internal::MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ResponseParams_Data::Validate}},
    {internal::kMimeHandlerViewContainerManager_DestroyFrameContainer_Name,
     {&internal::MimeHandlerViewContainerManager_DestroyFrameContainer_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMimeHandlerViewContainerManager_DidLoad_Name,
     {&internal::MimeHandlerViewContainerManager_DidLoad_Params_Data::Validate,
      nullptr /* no response */}},
};

bool MimeHandlerViewContainerManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::extensions::mojom::MimeHandlerViewContainerManager::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kMimeHandlerViewContainerManagerValidationInfo);
}

bool MimeHandlerViewContainerManagerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::extensions::mojom::MimeHandlerViewContainerManager::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kMimeHandlerViewContainerManagerValidationInfo);

}
}  // namespace mojom
}  // namespace extensions

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif