// extensions/common/mojom/host_id.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "extensions/common/mojom/host_id.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/host_id.mojom-params-data.h"
namespace extensions {
namespace mojom {

static NOINLINE const char* HostID_HostTypeToStringHelper(HostID_HostType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case HostID_HostType::kExtensions:
      return "kExtensions";
    case HostID_HostType::kWebUi:
      return "kWebUi";
    default:
      return nullptr;
  }
}

std::string HostID_HostTypeToString(HostID_HostType value) {
  const char *str = HostID_HostTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown HostID_HostType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, HostID_HostType value) {
  return os << HostID_HostTypeToString(value);
}

namespace internal {


// static
bool HostID_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HostID_Data* object = static_cast<const HostID_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::extensions::mojom::internal::HostID_HostType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

HostID_Data::HostID_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace extensions

namespace perfetto {

// static
void TraceFormatTraits<::extensions::mojom::HostID_HostType>::WriteIntoTrace(
   perfetto::TracedValue context, ::extensions::mojom::HostID_HostType value) {
  return std::move(context).WriteString(::extensions::mojom::HostID_HostTypeToString(value));
}

} // namespace perfetto
