// extensions/common/mojom/renderer.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "extensions/common/mojom/renderer.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/renderer.mojom-params-data.h"
#include "extensions/common/mojom/renderer.mojom-shared-message-ids.h"

#include "extensions/common/mojom/renderer.mojom-import-headers.h"


#ifndef EXTENSIONS_COMMON_MOJOM_RENDERER_MOJOM_JUMBO_H_
#define EXTENSIONS_COMMON_MOJOM_RENDERER_MOJOM_JUMBO_H_
#endif
namespace extensions {
namespace mojom {
ExtensionLoadedParams::ExtensionLoadedParams()
    : manifest(),
      location(),
      path(),
      active_permissions(),
      withheld_permissions(),
      tab_specific_permissions(),
      policy_blocked_hosts(),
      policy_allowed_hosts(),
      uses_default_policy_blocked_allowed_hosts(),
      id(),
      worker_activation_sequence(),
      creation_flags(),
      guid() {}

ExtensionLoadedParams::ExtensionLoadedParams(
    ::base::Value manifest_in,
    ::extensions::mojom::ManifestLocation location_in,
    const ::base::FilePath& path_in,
    ::extensions::PermissionSet active_permissions_in,
    ::extensions::PermissionSet withheld_permissions_in,
    base::flat_map<int32_t, ::extensions::PermissionSet> tab_specific_permissions_in,
    ::extensions::URLPatternSet policy_blocked_hosts_in,
    ::extensions::URLPatternSet policy_allowed_hosts_in,
    bool uses_default_policy_blocked_allowed_hosts_in,
    const std::string& id_in,
    const absl::optional<::extensions::ActivationSequence>& worker_activation_sequence_in,
    int32_t creation_flags_in,
    const std::string& guid_in)
    : manifest(std::move(manifest_in)),
      location(std::move(location_in)),
      path(std::move(path_in)),
      active_permissions(std::move(active_permissions_in)),
      withheld_permissions(std::move(withheld_permissions_in)),
      tab_specific_permissions(std::move(tab_specific_permissions_in)),
      policy_blocked_hosts(std::move(policy_blocked_hosts_in)),
      policy_allowed_hosts(std::move(policy_allowed_hosts_in)),
      uses_default_policy_blocked_allowed_hosts(std::move(uses_default_policy_blocked_allowed_hosts_in)),
      id(std::move(id_in)),
      worker_activation_sequence(std::move(worker_activation_sequence_in)),
      creation_flags(std::move(creation_flags_in)),
      guid(std::move(guid_in)) {}

ExtensionLoadedParams::~ExtensionLoadedParams() = default;

void ExtensionLoadedParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "manifest"), this->manifest,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Value>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "location"), this->location,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::extensions::mojom::ManifestLocation>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "path"), this->path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::FilePath&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "active_permissions"), this->active_permissions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::extensions::PermissionSet>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "withheld_permissions"), this->withheld_permissions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::extensions::PermissionSet>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tab_specific_permissions"), this->tab_specific_permissions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type base::flat_map<int32_t, ::extensions::PermissionSet>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "policy_blocked_hosts"), this->policy_blocked_hosts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::extensions::URLPatternSet>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "policy_allowed_hosts"), this->policy_allowed_hosts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::extensions::URLPatternSet>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uses_default_policy_blocked_allowed_hosts"), this->uses_default_policy_blocked_allowed_hosts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "worker_activation_sequence"), this->worker_activation_sequence,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::extensions::ActivationSequence>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "creation_flags"), this->creation_flags,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "guid"), this->guid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ExtensionLoadedParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char Renderer::Name_[] = "extensions.mojom.Renderer";

class Renderer_SuspendExtension_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Renderer_SuspendExtension_ForwardToCallback(
      Renderer::SuspendExtensionCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Renderer::SuspendExtensionCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Renderer_SuspendExtension_ForwardToCallback);
};

class Renderer_ShouldSuspend_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Renderer_ShouldSuspend_ForwardToCallback(
      Renderer::ShouldSuspendCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Renderer::ShouldSuspendCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Renderer_ShouldSuspend_ForwardToCallback);
};

class Renderer_TransferBlobs_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Renderer_TransferBlobs_ForwardToCallback(
      Renderer::TransferBlobsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Renderer::TransferBlobsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Renderer_TransferBlobs_ForwardToCallback);
};

RendererProxy::RendererProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RendererProxy::ActivateExtension(
    const std::string& in_extension_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::Renderer::ActivateExtension", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderer_ActivateExtension_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_ActivateExtension_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in Renderer.ActivateExtension request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("ActivateExtension");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::SetActivityLoggingEnabled(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::Renderer::SetActivityLoggingEnabled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderer_SetActivityLoggingEnabled_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_SetActivityLoggingEnabled_Params_Data> params(
          message);
  params.Allocate();
  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetActivityLoggingEnabled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::LoadExtensions(
    std::vector<ExtensionLoadedParamsPtr> in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::Renderer::LoadExtensions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type std::vector<ExtensionLoadedParamsPtr>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderer_LoadExtensions_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_LoadExtensions_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType>
      params_fragment(params.message());
  const mojo::internal::ContainerValidateParams params_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::extensions::mojom::ExtensionLoadedParamsDataView>>(
      in_params, params_fragment, &params_validate_params);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in Renderer.LoadExtensions request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("LoadExtensions");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::UnloadExtension(
    const std::string& in_extension_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::Renderer::UnloadExtension", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderer_UnloadExtension_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_UnloadExtension_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in Renderer.UnloadExtension request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("UnloadExtension");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::SuspendExtension(
    const std::string& in_extension_id, SuspendExtensionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::Renderer::SuspendExtension", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderer_SuspendExtension_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_SuspendExtension_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in Renderer.SuspendExtension request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SuspendExtension");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Renderer_SuspendExtension_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void RendererProxy::CancelSuspendExtension(
    const std::string& in_extension_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::Renderer::CancelSuspendExtension", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderer_CancelSuspendExtension_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_CancelSuspendExtension_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in Renderer.CancelSuspendExtension request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("CancelSuspendExtension");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::SetSessionInfo(
    version_info::Channel in_channel, ::extensions::mojom::FeatureSessionType in_session, bool in_is_lock_screen_context) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::Renderer::SetSessionInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("channel"), in_channel,
                        "<value of type version_info::Channel>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session"), in_session,
                        "<value of type ::extensions::mojom::FeatureSessionType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_lock_screen_context"), in_is_lock_screen_context,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderer_SetSessionInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_SetSessionInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::extensions::mojom::Channel>(
      in_channel, &params->channel);
  mojo::internal::Serialize<::extensions::mojom::FeatureSessionType>(
      in_session, &params->session);
  params->is_lock_screen_context = in_is_lock_screen_context;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetSessionInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::SetSystemFont(
    const std::string& in_font_family, const std::string& in_font_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::Renderer::SetSystemFont", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("font_family"), in_font_family,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("font_size"), in_font_size,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderer_SetSystemFont_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_SetSystemFont_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->font_family)::BaseType> font_family_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_font_family, font_family_fragment);
  params->font_family.Set(
      font_family_fragment.is_null() ? nullptr : font_family_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->font_family.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null font_family in Renderer.SetSystemFont request");
  mojo::internal::MessageFragment<
      typename decltype(params->font_size)::BaseType> font_size_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_font_size, font_size_fragment);
  params->font_size.Set(
      font_size_fragment.is_null() ? nullptr : font_size_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->font_size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null font_size in Renderer.SetSystemFont request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetSystemFont");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::SetWebViewPartitionID(
    const std::string& in_partition_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::Renderer::SetWebViewPartitionID", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("partition_id"), in_partition_id,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderer_SetWebViewPartitionID_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_SetWebViewPartitionID_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->partition_id)::BaseType> partition_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_partition_id, partition_id_fragment);
  params->partition_id.Set(
      partition_id_fragment.is_null() ? nullptr : partition_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->partition_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null partition_id in Renderer.SetWebViewPartitionID request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetWebViewPartitionID");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::SetScriptingAllowlist(
    const std::vector<std::string>& in_extension_ids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::Renderer::SetScriptingAllowlist", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_ids"), in_extension_ids,
                        "<value of type const std::vector<std::string>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderer_SetScriptingAllowlist_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_SetScriptingAllowlist_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_ids)::BaseType>
      extension_ids_fragment(params.message());
  const mojo::internal::ContainerValidateParams extension_ids_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_extension_ids, extension_ids_fragment, &extension_ids_validate_params);
  params->extension_ids.Set(
      extension_ids_fragment.is_null() ? nullptr : extension_ids_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_ids.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_ids in Renderer.SetScriptingAllowlist request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetScriptingAllowlist");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::ShouldSuspend(
    ShouldSuspendCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "extensions::mojom::Renderer::ShouldSuspend");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderer_ShouldSuspend_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_ShouldSuspend_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("ShouldSuspend");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Renderer_ShouldSuspend_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void RendererProxy::TransferBlobs(
    TransferBlobsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "extensions::mojom::Renderer::TransferBlobs");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderer_TransferBlobs_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_TransferBlobs_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("TransferBlobs");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Renderer_TransferBlobs_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void RendererProxy::UpdatePermissions(
    const std::string& in_extension_id, ::extensions::PermissionSet in_active_permissions, ::extensions::PermissionSet in_withheld_permissions, ::extensions::URLPatternSet in_policy_blocked_hosts, ::extensions::URLPatternSet in_policy_allowed_hosts, bool in_uses_default_policy_host_restrictions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::Renderer::UpdatePermissions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("active_permissions"), in_active_permissions,
                        "<value of type ::extensions::PermissionSet>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("withheld_permissions"), in_withheld_permissions,
                        "<value of type ::extensions::PermissionSet>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy_blocked_hosts"), in_policy_blocked_hosts,
                        "<value of type ::extensions::URLPatternSet>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy_allowed_hosts"), in_policy_allowed_hosts,
                        "<value of type ::extensions::URLPatternSet>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uses_default_policy_host_restrictions"), in_uses_default_policy_host_restrictions,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderer_UpdatePermissions_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_UpdatePermissions_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in Renderer.UpdatePermissions request");
  mojo::internal::MessageFragment<
      typename decltype(params->active_permissions)::BaseType> active_permissions_fragment(
          params.message());
  mojo::internal::Serialize<::extensions::mojom::PermissionSetDataView>(
      in_active_permissions, active_permissions_fragment);
  params->active_permissions.Set(
      active_permissions_fragment.is_null() ? nullptr : active_permissions_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->active_permissions.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null active_permissions in Renderer.UpdatePermissions request");
  mojo::internal::MessageFragment<
      typename decltype(params->withheld_permissions)::BaseType> withheld_permissions_fragment(
          params.message());
  mojo::internal::Serialize<::extensions::mojom::PermissionSetDataView>(
      in_withheld_permissions, withheld_permissions_fragment);
  params->withheld_permissions.Set(
      withheld_permissions_fragment.is_null() ? nullptr : withheld_permissions_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->withheld_permissions.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null withheld_permissions in Renderer.UpdatePermissions request");
  mojo::internal::MessageFragment<
      typename decltype(params->policy_blocked_hosts)::BaseType> policy_blocked_hosts_fragment(
          params.message());
  mojo::internal::Serialize<::extensions::mojom::URLPatternSetDataView>(
      in_policy_blocked_hosts, policy_blocked_hosts_fragment);
  params->policy_blocked_hosts.Set(
      policy_blocked_hosts_fragment.is_null() ? nullptr : policy_blocked_hosts_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->policy_blocked_hosts.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null policy_blocked_hosts in Renderer.UpdatePermissions request");
  mojo::internal::MessageFragment<
      typename decltype(params->policy_allowed_hosts)::BaseType> policy_allowed_hosts_fragment(
          params.message());
  mojo::internal::Serialize<::extensions::mojom::URLPatternSetDataView>(
      in_policy_allowed_hosts, policy_allowed_hosts_fragment);
  params->policy_allowed_hosts.Set(
      policy_allowed_hosts_fragment.is_null() ? nullptr : policy_allowed_hosts_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->policy_allowed_hosts.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null policy_allowed_hosts in Renderer.UpdatePermissions request");
  params->uses_default_policy_host_restrictions = in_uses_default_policy_host_restrictions;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("UpdatePermissions");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::UpdateDefaultPolicyHostRestrictions(
    ::extensions::URLPatternSet in_default_policy_blocked_hosts, ::extensions::URLPatternSet in_default_policy_allowed_hosts) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::Renderer::UpdateDefaultPolicyHostRestrictions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("default_policy_blocked_hosts"), in_default_policy_blocked_hosts,
                        "<value of type ::extensions::URLPatternSet>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("default_policy_allowed_hosts"), in_default_policy_allowed_hosts,
                        "<value of type ::extensions::URLPatternSet>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderer_UpdateDefaultPolicyHostRestrictions_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_UpdateDefaultPolicyHostRestrictions_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->default_policy_blocked_hosts)::BaseType> default_policy_blocked_hosts_fragment(
          params.message());
  mojo::internal::Serialize<::extensions::mojom::URLPatternSetDataView>(
      in_default_policy_blocked_hosts, default_policy_blocked_hosts_fragment);
  params->default_policy_blocked_hosts.Set(
      default_policy_blocked_hosts_fragment.is_null() ? nullptr : default_policy_blocked_hosts_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->default_policy_blocked_hosts.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null default_policy_blocked_hosts in Renderer.UpdateDefaultPolicyHostRestrictions request");
  mojo::internal::MessageFragment<
      typename decltype(params->default_policy_allowed_hosts)::BaseType> default_policy_allowed_hosts_fragment(
          params.message());
  mojo::internal::Serialize<::extensions::mojom::URLPatternSetDataView>(
      in_default_policy_allowed_hosts, default_policy_allowed_hosts_fragment);
  params->default_policy_allowed_hosts.Set(
      default_policy_allowed_hosts_fragment.is_null() ? nullptr : default_policy_allowed_hosts_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->default_policy_allowed_hosts.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null default_policy_allowed_hosts in Renderer.UpdateDefaultPolicyHostRestrictions request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("UpdateDefaultPolicyHostRestrictions");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::UpdateTabSpecificPermissions(
    const std::string& in_extension_id, ::extensions::URLPatternSet in_new_hosts, int32_t in_tab_id, bool in_update_origin_whitelist) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::Renderer::UpdateTabSpecificPermissions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_hosts"), in_new_hosts,
                        "<value of type ::extensions::URLPatternSet>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("update_origin_whitelist"), in_update_origin_whitelist,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderer_UpdateTabSpecificPermissions_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_UpdateTabSpecificPermissions_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in Renderer.UpdateTabSpecificPermissions request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_hosts)::BaseType> new_hosts_fragment(
          params.message());
  mojo::internal::Serialize<::extensions::mojom::URLPatternSetDataView>(
      in_new_hosts, new_hosts_fragment);
  params->new_hosts.Set(
      new_hosts_fragment.is_null() ? nullptr : new_hosts_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->new_hosts.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null new_hosts in Renderer.UpdateTabSpecificPermissions request");
  params->tab_id = in_tab_id;
  params->update_origin_whitelist = in_update_origin_whitelist;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("UpdateTabSpecificPermissions");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::UpdateUserScripts(
    ::base::ReadOnlySharedMemoryRegion in_region, ::extensions::mojom::HostIDPtr in_owner) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::Renderer::UpdateUserScripts", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("region"), in_region,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("owner"), in_owner,
                        "<value of type ::extensions::mojom::HostIDPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderer_UpdateUserScripts_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_UpdateUserScripts_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->region)::BaseType> region_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
      in_region, region_fragment);
  params->region.Set(
      region_fragment.is_null() ? nullptr : region_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->region.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null region in Renderer.UpdateUserScripts request");
  mojo::internal::MessageFragment<
      typename decltype(params->owner)::BaseType> owner_fragment(
          params.message());
  mojo::internal::Serialize<::extensions::mojom::HostIDDataView>(
      in_owner, owner_fragment);
  params->owner.Set(
      owner_fragment.is_null() ? nullptr : owner_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->owner.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null owner in Renderer.UpdateUserScripts request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("UpdateUserScripts");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::ClearTabSpecificPermissions(
    const std::vector<std::string>& in_extension_ids, int32_t in_tab_id, bool in_update_origin_whitelist) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::Renderer::ClearTabSpecificPermissions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_ids"), in_extension_ids,
                        "<value of type const std::vector<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("update_origin_whitelist"), in_update_origin_whitelist,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderer_ClearTabSpecificPermissions_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_ClearTabSpecificPermissions_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_ids)::BaseType>
      extension_ids_fragment(params.message());
  const mojo::internal::ContainerValidateParams extension_ids_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_extension_ids, extension_ids_fragment, &extension_ids_validate_params);
  params->extension_ids.Set(
      extension_ids_fragment.is_null() ? nullptr : extension_ids_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_ids.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_ids in Renderer.ClearTabSpecificPermissions request");
  params->tab_id = in_tab_id;
  params->update_origin_whitelist = in_update_origin_whitelist;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("ClearTabSpecificPermissions");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::WatchPages(
    const std::vector<std::string>& in_css_selectors) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::Renderer::WatchPages", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("css_selectors"), in_css_selectors,
                        "<value of type const std::vector<std::string>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderer_WatchPages_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_WatchPages_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->css_selectors)::BaseType>
      css_selectors_fragment(params.message());
  const mojo::internal::ContainerValidateParams css_selectors_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_css_selectors, css_selectors_fragment, &css_selectors_validate_params);
  params->css_selectors.Set(
      css_selectors_fragment.is_null() ? nullptr : css_selectors_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->css_selectors.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null css_selectors in Renderer.WatchPages request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("WatchPages");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class Renderer_SuspendExtension_ProxyToResponder {
 public:
  static Renderer::SuspendExtensionCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Renderer_SuspendExtension_ProxyToResponder> proxy(
        new Renderer_SuspendExtension_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Renderer_SuspendExtension_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Renderer_SuspendExtension_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Renderer_SuspendExtension_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Renderer::SuspendExtensionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Renderer_SuspendExtension_ProxyToResponder);
};

bool Renderer_SuspendExtension_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "extensions::mojom::Renderer::SuspendExtensionCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Renderer_SuspendExtension_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Renderer_SuspendExtension_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  Renderer_SuspendExtension_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Renderer::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void Renderer_SuspendExtension_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)extensions::mojom::Renderer::SuspendExtensionCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderer_SuspendExtension_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_SuspendExtension_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)extensions::mojom::Renderer::SuspendExtensionCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SuspendExtension");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Renderer_ShouldSuspend_ProxyToResponder {
 public:
  static Renderer::ShouldSuspendCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Renderer_ShouldSuspend_ProxyToResponder> proxy(
        new Renderer_ShouldSuspend_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Renderer_ShouldSuspend_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Renderer_ShouldSuspend_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Renderer_ShouldSuspend_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Renderer::ShouldSuspendCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Renderer_ShouldSuspend_ProxyToResponder);
};

bool Renderer_ShouldSuspend_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "extensions::mojom::Renderer::ShouldSuspendCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Renderer_ShouldSuspend_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Renderer_ShouldSuspend_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  Renderer_ShouldSuspend_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Renderer::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void Renderer_ShouldSuspend_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)extensions::mojom::Renderer::ShouldSuspendCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderer_ShouldSuspend_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_ShouldSuspend_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)extensions::mojom::Renderer::ShouldSuspendCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("ShouldSuspend");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Renderer_TransferBlobs_ProxyToResponder {
 public:
  static Renderer::TransferBlobsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Renderer_TransferBlobs_ProxyToResponder> proxy(
        new Renderer_TransferBlobs_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Renderer_TransferBlobs_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Renderer_TransferBlobs_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Renderer_TransferBlobs_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Renderer::TransferBlobsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Renderer_TransferBlobs_ProxyToResponder);
};

bool Renderer_TransferBlobs_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "extensions::mojom::Renderer::TransferBlobsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Renderer_TransferBlobs_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Renderer_TransferBlobs_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  Renderer_TransferBlobs_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Renderer::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void Renderer_TransferBlobs_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)extensions::mojom::Renderer::TransferBlobsCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderer_TransferBlobs_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_TransferBlobs_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)extensions::mojom::Renderer::TransferBlobsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("TransferBlobs");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool RendererStubDispatch::Accept(
    Renderer* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kRenderer_ActivateExtension_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::Renderer::ActivateExtension",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::Renderer::ActivateExtension");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_ActivateExtension_Params_Data* params =
          reinterpret_cast<internal::Renderer_ActivateExtension_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_extension_id{};
      Renderer_ActivateExtension_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ActivateExtension(
std::move(p_extension_id));
      return true;
    }
    case internal::kRenderer_SetActivityLoggingEnabled_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::Renderer::SetActivityLoggingEnabled",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::Renderer::SetActivityLoggingEnabled");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_SetActivityLoggingEnabled_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetActivityLoggingEnabled_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_enabled{};
      Renderer_SetActivityLoggingEnabled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetActivityLoggingEnabled(
std::move(p_enabled));
      return true;
    }
    case internal::kRenderer_LoadExtensions_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::Renderer::LoadExtensions",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::Renderer::LoadExtensions");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_LoadExtensions_Params_Data* params =
          reinterpret_cast<internal::Renderer_LoadExtensions_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<ExtensionLoadedParamsPtr> p_params{};
      Renderer_LoadExtensions_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LoadExtensions(
std::move(p_params));
      return true;
    }
    case internal::kRenderer_UnloadExtension_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::Renderer::UnloadExtension",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::Renderer::UnloadExtension");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_UnloadExtension_Params_Data* params =
          reinterpret_cast<internal::Renderer_UnloadExtension_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_extension_id{};
      Renderer_UnloadExtension_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UnloadExtension(
std::move(p_extension_id));
      return true;
    }
    case internal::kRenderer_SuspendExtension_Name: {
      break;
    }
    case internal::kRenderer_CancelSuspendExtension_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::Renderer::CancelSuspendExtension",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::Renderer::CancelSuspendExtension");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_CancelSuspendExtension_Params_Data* params =
          reinterpret_cast<internal::Renderer_CancelSuspendExtension_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_extension_id{};
      Renderer_CancelSuspendExtension_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelSuspendExtension(
std::move(p_extension_id));
      return true;
    }
    case internal::kRenderer_SetSessionInfo_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::Renderer::SetSessionInfo",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::Renderer::SetSessionInfo");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_SetSessionInfo_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetSessionInfo_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      version_info::Channel p_channel{};
      ::extensions::mojom::FeatureSessionType p_session{};
      bool p_is_lock_screen_context{};
      Renderer_SetSessionInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadChannel(&p_channel))
        success = false;
      if (success && !input_data_view.ReadSession(&p_session))
        success = false;
      if (success)
        p_is_lock_screen_context = input_data_view.is_lock_screen_context();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSessionInfo(
std::move(p_channel), 
std::move(p_session), 
std::move(p_is_lock_screen_context));
      return true;
    }
    case internal::kRenderer_SetSystemFont_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::Renderer::SetSystemFont",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::Renderer::SetSystemFont");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_SetSystemFont_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetSystemFont_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_font_family{};
      std::string p_font_size{};
      Renderer_SetSystemFont_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFontFamily(&p_font_family))
        success = false;
      if (success && !input_data_view.ReadFontSize(&p_font_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSystemFont(
std::move(p_font_family), 
std::move(p_font_size));
      return true;
    }
    case internal::kRenderer_SetWebViewPartitionID_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::Renderer::SetWebViewPartitionID",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::Renderer::SetWebViewPartitionID");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_SetWebViewPartitionID_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetWebViewPartitionID_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_partition_id{};
      Renderer_SetWebViewPartitionID_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPartitionId(&p_partition_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetWebViewPartitionID(
std::move(p_partition_id));
      return true;
    }
    case internal::kRenderer_SetScriptingAllowlist_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::Renderer::SetScriptingAllowlist",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::Renderer::SetScriptingAllowlist");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_SetScriptingAllowlist_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetScriptingAllowlist_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<std::string> p_extension_ids{};
      Renderer_SetScriptingAllowlist_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionIds(&p_extension_ids))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetScriptingAllowlist(
std::move(p_extension_ids));
      return true;
    }
    case internal::kRenderer_ShouldSuspend_Name: {
      break;
    }
    case internal::kRenderer_TransferBlobs_Name: {
      break;
    }
    case internal::kRenderer_UpdatePermissions_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::Renderer::UpdatePermissions",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::Renderer::UpdatePermissions");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_UpdatePermissions_Params_Data* params =
          reinterpret_cast<internal::Renderer_UpdatePermissions_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_extension_id{};
      ::extensions::PermissionSet p_active_permissions{};
      ::extensions::PermissionSet p_withheld_permissions{};
      ::extensions::URLPatternSet p_policy_blocked_hosts{};
      ::extensions::URLPatternSet p_policy_allowed_hosts{};
      bool p_uses_default_policy_host_restrictions{};
      Renderer_UpdatePermissions_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadActivePermissions(&p_active_permissions))
        success = false;
      if (success && !input_data_view.ReadWithheldPermissions(&p_withheld_permissions))
        success = false;
      if (success && !input_data_view.ReadPolicyBlockedHosts(&p_policy_blocked_hosts))
        success = false;
      if (success && !input_data_view.ReadPolicyAllowedHosts(&p_policy_allowed_hosts))
        success = false;
      if (success)
        p_uses_default_policy_host_restrictions = input_data_view.uses_default_policy_host_restrictions();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdatePermissions(
std::move(p_extension_id), 
std::move(p_active_permissions), 
std::move(p_withheld_permissions), 
std::move(p_policy_blocked_hosts), 
std::move(p_policy_allowed_hosts), 
std::move(p_uses_default_policy_host_restrictions));
      return true;
    }
    case internal::kRenderer_UpdateDefaultPolicyHostRestrictions_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::Renderer::UpdateDefaultPolicyHostRestrictions",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::Renderer::UpdateDefaultPolicyHostRestrictions");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_UpdateDefaultPolicyHostRestrictions_Params_Data* params =
          reinterpret_cast<internal::Renderer_UpdateDefaultPolicyHostRestrictions_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::extensions::URLPatternSet p_default_policy_blocked_hosts{};
      ::extensions::URLPatternSet p_default_policy_allowed_hosts{};
      Renderer_UpdateDefaultPolicyHostRestrictions_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDefaultPolicyBlockedHosts(&p_default_policy_blocked_hosts))
        success = false;
      if (success && !input_data_view.ReadDefaultPolicyAllowedHosts(&p_default_policy_allowed_hosts))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateDefaultPolicyHostRestrictions(
std::move(p_default_policy_blocked_hosts), 
std::move(p_default_policy_allowed_hosts));
      return true;
    }
    case internal::kRenderer_UpdateTabSpecificPermissions_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::Renderer::UpdateTabSpecificPermissions",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::Renderer::UpdateTabSpecificPermissions");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_UpdateTabSpecificPermissions_Params_Data* params =
          reinterpret_cast<internal::Renderer_UpdateTabSpecificPermissions_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_extension_id{};
      ::extensions::URLPatternSet p_new_hosts{};
      int32_t p_tab_id{};
      bool p_update_origin_whitelist{};
      Renderer_UpdateTabSpecificPermissions_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadNewHosts(&p_new_hosts))
        success = false;
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (success)
        p_update_origin_whitelist = input_data_view.update_origin_whitelist();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateTabSpecificPermissions(
std::move(p_extension_id), 
std::move(p_new_hosts), 
std::move(p_tab_id), 
std::move(p_update_origin_whitelist));
      return true;
    }
    case internal::kRenderer_UpdateUserScripts_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::Renderer::UpdateUserScripts",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::Renderer::UpdateUserScripts");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_UpdateUserScripts_Params_Data* params =
          reinterpret_cast<internal::Renderer_UpdateUserScripts_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::ReadOnlySharedMemoryRegion p_region{};
      ::extensions::mojom::HostIDPtr p_owner{};
      Renderer_UpdateUserScripts_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRegion(&p_region))
        success = false;
      if (success && !input_data_view.ReadOwner(&p_owner))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateUserScripts(
std::move(p_region), 
std::move(p_owner));
      return true;
    }
    case internal::kRenderer_ClearTabSpecificPermissions_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::Renderer::ClearTabSpecificPermissions",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::Renderer::ClearTabSpecificPermissions");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_ClearTabSpecificPermissions_Params_Data* params =
          reinterpret_cast<internal::Renderer_ClearTabSpecificPermissions_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<std::string> p_extension_ids{};
      int32_t p_tab_id{};
      bool p_update_origin_whitelist{};
      Renderer_ClearTabSpecificPermissions_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionIds(&p_extension_ids))
        success = false;
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (success)
        p_update_origin_whitelist = input_data_view.update_origin_whitelist();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearTabSpecificPermissions(
std::move(p_extension_ids), 
std::move(p_tab_id), 
std::move(p_update_origin_whitelist));
      return true;
    }
    case internal::kRenderer_WatchPages_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::Renderer::WatchPages",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::Renderer::WatchPages");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_WatchPages_Params_Data* params =
          reinterpret_cast<internal::Renderer_WatchPages_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<std::string> p_css_selectors{};
      Renderer_WatchPages_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCssSelectors(&p_css_selectors))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WatchPages(
std::move(p_css_selectors));
      return true;
    }
  }
  return false;
}

// static
bool RendererStubDispatch::AcceptWithResponder(
    Renderer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRenderer_ActivateExtension_Name: {
      break;
    }
    case internal::kRenderer_SetActivityLoggingEnabled_Name: {
      break;
    }
    case internal::kRenderer_LoadExtensions_Name: {
      break;
    }
    case internal::kRenderer_UnloadExtension_Name: {
      break;
    }
    case internal::kRenderer_SuspendExtension_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::Renderer::SuspendExtension",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::Renderer::SuspendExtension");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Renderer_SuspendExtension_Params_Data* params =
          reinterpret_cast<
              internal::Renderer_SuspendExtension_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_extension_id{};
      Renderer_SuspendExtension_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 4, false);
        return false;
      }
      Renderer::SuspendExtensionCallback callback =
          Renderer_SuspendExtension_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SuspendExtension(
std::move(p_extension_id), std::move(callback));
      return true;
    }
    case internal::kRenderer_CancelSuspendExtension_Name: {
      break;
    }
    case internal::kRenderer_SetSessionInfo_Name: {
      break;
    }
    case internal::kRenderer_SetSystemFont_Name: {
      break;
    }
    case internal::kRenderer_SetWebViewPartitionID_Name: {
      break;
    }
    case internal::kRenderer_SetScriptingAllowlist_Name: {
      break;
    }
    case internal::kRenderer_ShouldSuspend_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::Renderer::ShouldSuspend",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::Renderer::ShouldSuspend");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Renderer_ShouldSuspend_Params_Data* params =
          reinterpret_cast<
              internal::Renderer_ShouldSuspend_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      Renderer_ShouldSuspend_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 10, false);
        return false;
      }
      Renderer::ShouldSuspendCallback callback =
          Renderer_ShouldSuspend_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShouldSuspend(std::move(callback));
      return true;
    }
    case internal::kRenderer_TransferBlobs_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::Renderer::TransferBlobs",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::Renderer::TransferBlobs");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Renderer_TransferBlobs_Params_Data* params =
          reinterpret_cast<
              internal::Renderer_TransferBlobs_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      Renderer_TransferBlobs_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 11, false);
        return false;
      }
      Renderer::TransferBlobsCallback callback =
          Renderer_TransferBlobs_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TransferBlobs(std::move(callback));
      return true;
    }
    case internal::kRenderer_UpdatePermissions_Name: {
      break;
    }
    case internal::kRenderer_UpdateDefaultPolicyHostRestrictions_Name: {
      break;
    }
    case internal::kRenderer_UpdateTabSpecificPermissions_Name: {
      break;
    }
    case internal::kRenderer_UpdateUserScripts_Name: {
      break;
    }
    case internal::kRenderer_ClearTabSpecificPermissions_Name: {
      break;
    }
    case internal::kRenderer_WatchPages_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRendererValidationInfo[] = {
    {internal::kRenderer_ActivateExtension_Name,
     {&internal::Renderer_ActivateExtension_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_SetActivityLoggingEnabled_Name,
     {&internal::Renderer_SetActivityLoggingEnabled_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_LoadExtensions_Name,
     {&internal::Renderer_LoadExtensions_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_UnloadExtension_Name,
     {&internal::Renderer_UnloadExtension_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_SuspendExtension_Name,
     {&internal::Renderer_SuspendExtension_Params_Data::Validate,
      &internal::Renderer_SuspendExtension_ResponseParams_Data::Validate}},
    {internal::kRenderer_CancelSuspendExtension_Name,
     {&internal::Renderer_CancelSuspendExtension_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_SetSessionInfo_Name,
     {&internal::Renderer_SetSessionInfo_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_SetSystemFont_Name,
     {&internal::Renderer_SetSystemFont_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_SetWebViewPartitionID_Name,
     {&internal::Renderer_SetWebViewPartitionID_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_SetScriptingAllowlist_Name,
     {&internal::Renderer_SetScriptingAllowlist_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_ShouldSuspend_Name,
     {&internal::Renderer_ShouldSuspend_Params_Data::Validate,
      &internal::Renderer_ShouldSuspend_ResponseParams_Data::Validate}},
    {internal::kRenderer_TransferBlobs_Name,
     {&internal::Renderer_TransferBlobs_Params_Data::Validate,
      &internal::Renderer_TransferBlobs_ResponseParams_Data::Validate}},
    {internal::kRenderer_UpdatePermissions_Name,
     {&internal::Renderer_UpdatePermissions_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_UpdateDefaultPolicyHostRestrictions_Name,
     {&internal::Renderer_UpdateDefaultPolicyHostRestrictions_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_UpdateTabSpecificPermissions_Name,
     {&internal::Renderer_UpdateTabSpecificPermissions_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_UpdateUserScripts_Name,
     {&internal::Renderer_UpdateUserScripts_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_ClearTabSpecificPermissions_Name,
     {&internal::Renderer_ClearTabSpecificPermissions_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_WatchPages_Name,
     {&internal::Renderer_WatchPages_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RendererRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::extensions::mojom::Renderer::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRendererValidationInfo);
}

bool RendererResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::extensions::mojom::Renderer::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kRendererValidationInfo);

}
}  // namespace mojom
}  // namespace extensions

namespace mojo {


// static
bool StructTraits<::extensions::mojom::ExtensionLoadedParams::DataView, ::extensions::mojom::ExtensionLoadedParamsPtr>::Read(
    ::extensions::mojom::ExtensionLoadedParams::DataView input,
    ::extensions::mojom::ExtensionLoadedParamsPtr* output) {
  bool success = true;
  ::extensions::mojom::ExtensionLoadedParamsPtr result(::extensions::mojom::ExtensionLoadedParams::New());
  
      if (success && !input.ReadManifest(&result->manifest))
        success = false;
      if (success && !input.ReadLocation(&result->location))
        success = false;
      if (success && !input.ReadPath(&result->path))
        success = false;
      if (success && !input.ReadActivePermissions(&result->active_permissions))
        success = false;
      if (success && !input.ReadWithheldPermissions(&result->withheld_permissions))
        success = false;
      if (success && !input.ReadTabSpecificPermissions(&result->tab_specific_permissions))
        success = false;
      if (success && !input.ReadPolicyBlockedHosts(&result->policy_blocked_hosts))
        success = false;
      if (success && !input.ReadPolicyAllowedHosts(&result->policy_allowed_hosts))
        success = false;
      if (success)
        result->uses_default_policy_blocked_allowed_hosts = input.uses_default_policy_blocked_allowed_hosts();
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadWorkerActivationSequence(&result->worker_activation_sequence))
        success = false;
      if (success)
        result->creation_flags = input.creation_flags();
      if (success && !input.ReadGuid(&result->guid))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif