// gpu/ipc/common/gpu_channel.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "gpu/ipc/common/gpu_channel.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "gpu/ipc/common/capabilities.mojom.h"
#include "gpu/ipc/common/context_result.mojom.h"
#include "gpu/ipc/common/mailbox.mojom.h"
#include "gpu/ipc/common/surface_handle.mojom.h"
#include "gpu/ipc/common/sync_token.mojom.h"
#include "gpu/ipc/common/vulkan_ycbcr_info.mojom.h"
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "mojo/public/mojom/base/generic_pending_associated_receiver.mojom.h"
#include "services/viz/public/mojom/compositing/resource_format.mojom.h"
#include "skia/public/mojom/image_info.mojom.h"
#include "skia/public/mojom/surface_origin.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/buffer_types.mojom.h"
#include "ui/gfx/mojom/color_space.mojom.h"
#include "ui/gfx/mojom/gpu_fence_handle.mojom.h"
#include "ui/gfx/mojom/presentation_feedback.mojom.h"
#include "ui/gl/mojom/gpu_preference.mojom.h"
#include "url/mojom/url.mojom.h"


#ifndef GPU_IPC_COMMON_GPU_CHANNEL_MOJOM_JUMBO_H_
#define GPU_IPC_COMMON_GPU_CHANNEL_MOJOM_JUMBO_H_
#endif


namespace gpu {
namespace mojom {


void GpuChannelInterceptorForTesting::CrashForTesting() {
  GetForwardingInterface()->CrashForTesting();
}
void GpuChannelInterceptorForTesting::TerminateForTesting() {
  GetForwardingInterface()->TerminateForTesting();
}
void GpuChannelInterceptorForTesting::GetChannelToken(GetChannelTokenCallback callback) {
  GetForwardingInterface()->GetChannelToken(std::move(callback));
}
void GpuChannelInterceptorForTesting::Flush(FlushCallback callback) {
  GetForwardingInterface()->Flush(std::move(callback));
}
void GpuChannelInterceptorForTesting::CreateCommandBuffer(CreateCommandBufferParamsPtr params, int32_t routing_id, ::base::UnsafeSharedMemoryRegion shared_state, ::mojo::PendingAssociatedReceiver<CommandBuffer> receiver, ::mojo::PendingAssociatedRemote<CommandBufferClient> client, CreateCommandBufferCallback callback) {
  GetForwardingInterface()->CreateCommandBuffer(std::move(params), std::move(routing_id), std::move(shared_state), std::move(receiver), std::move(client), std::move(callback));
}
void GpuChannelInterceptorForTesting::DestroyCommandBuffer(int32_t routing_id, DestroyCommandBufferCallback callback) {
  GetForwardingInterface()->DestroyCommandBuffer(std::move(routing_id), std::move(callback));
}
void GpuChannelInterceptorForTesting::ScheduleImageDecode(ScheduleImageDecodeParamsPtr params, uint64_t decode_release_count) {
  GetForwardingInterface()->ScheduleImageDecode(std::move(params), std::move(decode_release_count));
}
void GpuChannelInterceptorForTesting::FlushDeferredRequests(std::vector<DeferredRequestPtr> requests) {
  GetForwardingInterface()->FlushDeferredRequests(std::move(requests));
}
void GpuChannelInterceptorForTesting::WaitForTokenInRange(int32_t routing_id, int32_t start, int32_t end, WaitForTokenInRangeCallback callback) {
  GetForwardingInterface()->WaitForTokenInRange(std::move(routing_id), std::move(start), std::move(end), std::move(callback));
}
void GpuChannelInterceptorForTesting::WaitForGetOffsetInRange(int32_t routing_id, uint32_t set_get_buffer_count, int32_t start, int32_t end, WaitForGetOffsetInRangeCallback callback) {
  GetForwardingInterface()->WaitForGetOffsetInRange(std::move(routing_id), std::move(set_get_buffer_count), std::move(start), std::move(end), std::move(callback));
}
GpuChannelAsyncWaiter::GpuChannelAsyncWaiter(
    GpuChannel* proxy) : proxy_(proxy) {}

GpuChannelAsyncWaiter::~GpuChannelAsyncWaiter() = default;

void GpuChannelAsyncWaiter::GetChannelToken(
    ::base::UnguessableToken* out_token) {
  base::RunLoop loop;
  proxy_->GetChannelToken(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::UnguessableToken* out_token
,
             const ::base::UnguessableToken& token) {*out_token = std::move(token);
            loop->Quit();
          },
          &loop,
          out_token));
  loop.Run();
}
void GpuChannelAsyncWaiter::Flush(
    ) {
  base::RunLoop loop;
  proxy_->Flush(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void GpuChannelAsyncWaiter::CreateCommandBuffer(
    CreateCommandBufferParamsPtr params, int32_t routing_id, ::base::UnsafeSharedMemoryRegion shared_state, ::mojo::PendingAssociatedReceiver<CommandBuffer> receiver, ::mojo::PendingAssociatedRemote<CommandBufferClient> client, ::gpu::ContextResult* out_result, ::gpu::Capabilities* out_capabilties) {
  base::RunLoop loop;
  proxy_->CreateCommandBuffer(std::move(params),std::move(routing_id),std::move(shared_state),std::move(receiver),std::move(client),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::gpu::ContextResult* out_result
,
             ::gpu::Capabilities* out_capabilties
,
             ::gpu::ContextResult result,
             const ::gpu::Capabilities& capabilties) {*out_result = std::move(result);*out_capabilties = std::move(capabilties);
            loop->Quit();
          },
          &loop,
          out_result,
          out_capabilties));
  loop.Run();
}
void GpuChannelAsyncWaiter::DestroyCommandBuffer(
    int32_t routing_id) {
  base::RunLoop loop;
  proxy_->DestroyCommandBuffer(std::move(routing_id),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void GpuChannelAsyncWaiter::WaitForTokenInRange(
    int32_t routing_id, int32_t start, int32_t end, ::gpu::CommandBuffer::State* out_state) {
  base::RunLoop loop;
  proxy_->WaitForTokenInRange(std::move(routing_id),std::move(start),std::move(end),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::gpu::CommandBuffer::State* out_state
,
             const ::gpu::CommandBuffer::State& state) {*out_state = std::move(state);
            loop->Quit();
          },
          &loop,
          out_state));
  loop.Run();
}
void GpuChannelAsyncWaiter::WaitForGetOffsetInRange(
    int32_t routing_id, uint32_t set_get_buffer_count, int32_t start, int32_t end, ::gpu::CommandBuffer::State* out_state) {
  base::RunLoop loop;
  proxy_->WaitForGetOffsetInRange(std::move(routing_id),std::move(set_get_buffer_count),std::move(start),std::move(end),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::gpu::CommandBuffer::State* out_state
,
             const ::gpu::CommandBuffer::State& state) {*out_state = std::move(state);
            loop->Quit();
          },
          &loop,
          out_state));
  loop.Run();
}



void CommandBufferInterceptorForTesting::SetGetBuffer(int32_t shm_id) {
  GetForwardingInterface()->SetGetBuffer(std::move(shm_id));
}
void CommandBufferInterceptorForTesting::RegisterTransferBuffer(int32_t id, ::base::UnsafeSharedMemoryRegion buffer) {
  GetForwardingInterface()->RegisterTransferBuffer(std::move(id), std::move(buffer));
}
void CommandBufferInterceptorForTesting::CreateGpuFenceFromHandle(uint32_t gpu_fence_id, ::gfx::GpuFenceHandle fence_handle) {
  GetForwardingInterface()->CreateGpuFenceFromHandle(std::move(gpu_fence_id), std::move(fence_handle));
}
void CommandBufferInterceptorForTesting::GetGpuFenceHandle(uint32_t id, GetGpuFenceHandleCallback callback) {
  GetForwardingInterface()->GetGpuFenceHandle(std::move(id), std::move(callback));
}
void CommandBufferInterceptorForTesting::CreateImage(CreateImageParamsPtr params) {
  GetForwardingInterface()->CreateImage(std::move(params));
}
void CommandBufferInterceptorForTesting::DestroyImage(int32_t id) {
  GetForwardingInterface()->DestroyImage(std::move(id));
}
void CommandBufferInterceptorForTesting::SignalSyncToken(const ::gpu::SyncToken& sync_token, uint32_t signal_id) {
  GetForwardingInterface()->SignalSyncToken(std::move(sync_token), std::move(signal_id));
}
void CommandBufferInterceptorForTesting::SignalQuery(uint32_t query, uint32_t signal_id) {
  GetForwardingInterface()->SignalQuery(std::move(query), std::move(signal_id));
}
void CommandBufferInterceptorForTesting::BindMediaReceiver(::mojo::GenericPendingAssociatedReceiver receiver, BindMediaReceiverCallback callback) {
  GetForwardingInterface()->BindMediaReceiver(std::move(receiver), std::move(callback));
}
CommandBufferAsyncWaiter::CommandBufferAsyncWaiter(
    CommandBuffer* proxy) : proxy_(proxy) {}

CommandBufferAsyncWaiter::~CommandBufferAsyncWaiter() = default;

void CommandBufferAsyncWaiter::GetGpuFenceHandle(
    uint32_t id, ::gfx::GpuFenceHandle* out_fence_handle) {
  base::RunLoop loop;
  proxy_->GetGpuFenceHandle(std::move(id),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::gfx::GpuFenceHandle* out_fence_handle
,
             ::gfx::GpuFenceHandle fence_handle) {*out_fence_handle = std::move(fence_handle);
            loop->Quit();
          },
          &loop,
          out_fence_handle));
  loop.Run();
}
void CommandBufferAsyncWaiter::BindMediaReceiver(
    ::mojo::GenericPendingAssociatedReceiver receiver) {
  base::RunLoop loop;
  proxy_->BindMediaReceiver(std::move(receiver),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void CommandBufferClientInterceptorForTesting::OnConsoleMessage(const std::string& message) {
  GetForwardingInterface()->OnConsoleMessage(std::move(message));
}
void CommandBufferClientInterceptorForTesting::OnGpuSwitched(::gl::GpuPreference active_gpu_heuristic) {
  GetForwardingInterface()->OnGpuSwitched(std::move(active_gpu_heuristic));
}
void CommandBufferClientInterceptorForTesting::OnDestroyed(::gpu::error::ContextLostReason reason, ::gpu::error::Error error) {
  GetForwardingInterface()->OnDestroyed(std::move(reason), std::move(error));
}
void CommandBufferClientInterceptorForTesting::OnSwapBuffersCompleted(const ::gpu::SwapBuffersCompleteParams& params) {
  GetForwardingInterface()->OnSwapBuffersCompleted(std::move(params));
}
void CommandBufferClientInterceptorForTesting::OnBufferPresented(uint64_t swap_id, const ::gfx::PresentationFeedback& feedback) {
  GetForwardingInterface()->OnBufferPresented(std::move(swap_id), std::move(feedback));
}
void CommandBufferClientInterceptorForTesting::OnReturnData(const std::vector<uint8_t>& data) {
  GetForwardingInterface()->OnReturnData(std::move(data));
}
void CommandBufferClientInterceptorForTesting::OnSignalAck(uint32_t signal_id, const ::gpu::CommandBuffer::State& state) {
  GetForwardingInterface()->OnSignalAck(std::move(signal_id), std::move(state));
}
CommandBufferClientAsyncWaiter::CommandBufferClientAsyncWaiter(
    CommandBufferClient* proxy) : proxy_(proxy) {}

CommandBufferClientAsyncWaiter::~CommandBufferClientAsyncWaiter() = default;






}  // namespace mojom
}  // namespace gpu

#if defined(__clang__)
#pragma clang diagnostic pop
#endif