// media/learning/mojo/public/mojom/learning_task_controller.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "media/learning/mojo/public/mojom/learning_task_controller.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "media/learning/mojo/public/mojom/learning_types.mojom.h"


#ifndef MEDIA_LEARNING_MOJO_PUBLIC_MOJOM_LEARNING_TASK_CONTROLLER_MOJOM_JUMBO_H_
#define MEDIA_LEARNING_MOJO_PUBLIC_MOJOM_LEARNING_TASK_CONTROLLER_MOJOM_JUMBO_H_
#endif


namespace media {
namespace learning {
namespace mojom {


void LearningTaskControllerInterceptorForTesting::BeginObservation(const ::base::UnguessableToken& id, const std::vector<::media::learning::FeatureValue>& features, const absl::optional<::media::learning::TargetValue>& default_target) {
  GetForwardingInterface()->BeginObservation(std::move(id), std::move(features), std::move(default_target));
}
void LearningTaskControllerInterceptorForTesting::CompleteObservation(const ::base::UnguessableToken& id, const ::media::learning::ObservationCompletion& completion) {
  GetForwardingInterface()->CompleteObservation(std::move(id), std::move(completion));
}
void LearningTaskControllerInterceptorForTesting::CancelObservation(const ::base::UnguessableToken& id) {
  GetForwardingInterface()->CancelObservation(std::move(id));
}
void LearningTaskControllerInterceptorForTesting::UpdateDefaultTarget(const ::base::UnguessableToken& id, const absl::optional<::media::learning::TargetValue>& default_target) {
  GetForwardingInterface()->UpdateDefaultTarget(std::move(id), std::move(default_target));
}
void LearningTaskControllerInterceptorForTesting::PredictDistribution(const std::vector<::media::learning::FeatureValue>& features, PredictDistributionCallback callback) {
  GetForwardingInterface()->PredictDistribution(std::move(features), std::move(callback));
}
LearningTaskControllerAsyncWaiter::LearningTaskControllerAsyncWaiter(
    LearningTaskController* proxy) : proxy_(proxy) {}

LearningTaskControllerAsyncWaiter::~LearningTaskControllerAsyncWaiter() = default;

void LearningTaskControllerAsyncWaiter::PredictDistribution(
    const std::vector<::media::learning::FeatureValue>& features, absl::optional<::media::learning::TargetHistogram>* out_predicted) {
  base::RunLoop loop;
  proxy_->PredictDistribution(std::move(features),
      base::BindOnce(
          [](base::RunLoop* loop,
             absl::optional<::media::learning::TargetHistogram>* out_predicted
,
             const absl::optional<::media::learning::TargetHistogram>& predicted) {*out_predicted = std::move(predicted);
            loop->Quit();
          },
          &loop,
          out_predicted));
  loop.Run();
}





}  // namespace mojom
}  // namespace learning
}  // namespace media

#if defined(__clang__)
#pragma clang diagnostic pop
#endif