// media/mojo/mojom/audio_decoder.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/audio_decoder.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/audio_decoder.mojom-params-data.h"
#include "media/mojo/mojom/audio_decoder.mojom-shared-message-ids.h"

#include "media/mojo/mojom/audio_decoder.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef MEDIA_MOJO_MOJOM_AUDIO_DECODER_MOJOM_BLINK_JUMBO_H_
#define MEDIA_MOJO_MOJOM_AUDIO_DECODER_MOJOM_BLINK_JUMBO_H_
#endif
namespace media {
namespace mojom {
namespace blink {
const char AudioDecoder::Name_[] = "media.mojom.AudioDecoder";

class AudioDecoder_Initialize_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AudioDecoder_Initialize_ForwardToCallback(
      AudioDecoder::InitializeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  AudioDecoder::InitializeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(AudioDecoder_Initialize_ForwardToCallback);
};

class AudioDecoder_Decode_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AudioDecoder_Decode_ForwardToCallback(
      AudioDecoder::DecodeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  AudioDecoder::DecodeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(AudioDecoder_Decode_ForwardToCallback);
};

class AudioDecoder_Reset_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AudioDecoder_Reset_ForwardToCallback(
      AudioDecoder::ResetCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  AudioDecoder::ResetCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(AudioDecoder_Reset_ForwardToCallback);
};

AudioDecoderProxy::AudioDecoderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioDecoderProxy::Construct(
    ::mojo::PendingAssociatedRemote<AudioDecoderClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::AudioDecoder::Construct", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<AudioDecoderClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAudioDecoder_Construct_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioDecoder_Construct_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::AudioDecoderClientAssociatedPtrInfoDataView>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid client in AudioDecoder.Construct request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioDecoder::Name_);
  message.set_method_name("Construct");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AudioDecoderProxy::Initialize(
    ::media::mojom::blink::AudioDecoderConfigPtr in_config, const absl::optional<::base::UnguessableToken>& in_cdm_id, InitializeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::AudioDecoder::Initialize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type ::media::mojom::blink::AudioDecoderConfigPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cdm_id"), in_cdm_id,
                        "<value of type const absl::optional<::base::UnguessableToken>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAudioDecoder_Initialize_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioDecoder_Initialize_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::AudioDecoderConfigDataView>(
      in_config, config_fragment);
  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null config in AudioDecoder.Initialize request");
  mojo::internal::MessageFragment<
      typename decltype(params->cdm_id)::BaseType> cdm_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_cdm_id, cdm_id_fragment);
  params->cdm_id.Set(
      cdm_id_fragment.is_null() ? nullptr : cdm_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioDecoder::Name_);
  message.set_method_name("Initialize");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AudioDecoder_Initialize_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void AudioDecoderProxy::SetDataSource(
    ::mojo::ScopedDataPipeConsumerHandle in_receive_pipe) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::AudioDecoder::SetDataSource", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receive_pipe"), in_receive_pipe,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAudioDecoder_SetDataSource_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioDecoder_SetDataSource_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_receive_pipe, &params->receive_pipe, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receive_pipe),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receive_pipe in AudioDecoder.SetDataSource request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioDecoder::Name_);
  message.set_method_name("SetDataSource");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AudioDecoderProxy::Decode(
    ::media::mojom::blink::DecoderBufferPtr in_buffer, DecodeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::AudioDecoder::Decode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type ::media::mojom::blink::DecoderBufferPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAudioDecoder_Decode_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioDecoder_Decode_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->buffer)::BaseType> buffer_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::DecoderBufferDataView>(
      in_buffer, buffer_fragment);
  params->buffer.Set(
      buffer_fragment.is_null() ? nullptr : buffer_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->buffer.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null buffer in AudioDecoder.Decode request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioDecoder::Name_);
  message.set_method_name("Decode");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AudioDecoder_Decode_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void AudioDecoderProxy::Reset(
    ResetCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::AudioDecoder::Reset");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAudioDecoder_Reset_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioDecoder_Reset_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioDecoder::Name_);
  message.set_method_name("Reset");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AudioDecoder_Reset_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class AudioDecoder_Initialize_ProxyToResponder {
 public:
  static AudioDecoder::InitializeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<AudioDecoder_Initialize_ProxyToResponder> proxy(
        new AudioDecoder_Initialize_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&AudioDecoder_Initialize_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AudioDecoder_Initialize_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  AudioDecoder_Initialize_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "AudioDecoder::InitializeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::media::mojom::blink::StatusPtr in_success, bool in_needs_bitstream_conversion, ::media::mojom::blink::AudioDecoderType in_decoder_type);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(AudioDecoder_Initialize_ProxyToResponder);
};

bool AudioDecoder_Initialize_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::AudioDecoder::InitializeCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::AudioDecoder_Initialize_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AudioDecoder_Initialize_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::media::mojom::blink::StatusPtr p_success{};
  bool p_needs_bitstream_conversion{};
  ::media::mojom::blink::AudioDecoderType p_decoder_type{};
  AudioDecoder_Initialize_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSuccess(&p_success))
    success = false;
  if (success)
    p_needs_bitstream_conversion = input_data_view.needs_bitstream_conversion();
  if (success && !input_data_view.ReadDecoderType(&p_decoder_type))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AudioDecoder::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_needs_bitstream_conversion), 
std::move(p_decoder_type));
  return true;
}

void AudioDecoder_Initialize_ProxyToResponder::Run(
    ::media::mojom::blink::StatusPtr in_success, bool in_needs_bitstream_conversion, ::media::mojom::blink::AudioDecoderType in_decoder_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::AudioDecoder::InitializeCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type ::media::mojom::blink::StatusPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("needs_bitstream_conversion"), in_needs_bitstream_conversion,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("decoder_type"), in_decoder_type,
                        "<value of type ::media::mojom::blink::AudioDecoderType>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAudioDecoder_Initialize_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioDecoder_Initialize_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->success)::BaseType> success_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::StatusDataView>(
      in_success, success_fragment);
  params->success.Set(
      success_fragment.is_null() ? nullptr : success_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->success.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null success in ");
  params->needs_bitstream_conversion = in_needs_bitstream_conversion;
  mojo::internal::Serialize<::media::mojom::AudioDecoderType>(
      in_decoder_type, &params->decoder_type);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::AudioDecoder::InitializeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioDecoder::Name_);
  message.set_method_name("Initialize");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AudioDecoder_Decode_ProxyToResponder {
 public:
  static AudioDecoder::DecodeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<AudioDecoder_Decode_ProxyToResponder> proxy(
        new AudioDecoder_Decode_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&AudioDecoder_Decode_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AudioDecoder_Decode_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  AudioDecoder_Decode_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "AudioDecoder::DecodeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::media::mojom::blink::StatusPtr in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(AudioDecoder_Decode_ProxyToResponder);
};

bool AudioDecoder_Decode_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::AudioDecoder::DecodeCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::AudioDecoder_Decode_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AudioDecoder_Decode_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::media::mojom::blink::StatusPtr p_status{};
  AudioDecoder_Decode_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AudioDecoder::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void AudioDecoder_Decode_ProxyToResponder::Run(
    ::media::mojom::blink::StatusPtr in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::AudioDecoder::DecodeCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::media::mojom::blink::StatusPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAudioDecoder_Decode_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioDecoder_Decode_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::StatusDataView>(
      in_status, status_fragment);
  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->status.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null status in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::AudioDecoder::DecodeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioDecoder::Name_);
  message.set_method_name("Decode");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AudioDecoder_Reset_ProxyToResponder {
 public:
  static AudioDecoder::ResetCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<AudioDecoder_Reset_ProxyToResponder> proxy(
        new AudioDecoder_Reset_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&AudioDecoder_Reset_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AudioDecoder_Reset_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  AudioDecoder_Reset_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "AudioDecoder::ResetCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(AudioDecoder_Reset_ProxyToResponder);
};

bool AudioDecoder_Reset_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::AudioDecoder::ResetCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::AudioDecoder_Reset_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AudioDecoder_Reset_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  AudioDecoder_Reset_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AudioDecoder::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void AudioDecoder_Reset_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)media::mojom::AudioDecoder::ResetCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAudioDecoder_Reset_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioDecoder_Reset_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::AudioDecoder::ResetCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioDecoder::Name_);
  message.set_method_name("Reset");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AudioDecoderStubDispatch::Accept(
    AudioDecoder* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kAudioDecoder_Construct_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::AudioDecoder::Construct",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::AudioDecoder::Construct");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AudioDecoder_Construct_Params_Data* params =
          reinterpret_cast<internal::AudioDecoder_Construct_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedRemote<AudioDecoderClient> p_client{};
      AudioDecoder_Construct_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioDecoder::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Construct(
std::move(p_client));
      return true;
    }
    case internal::kAudioDecoder_Initialize_Name: {
      break;
    }
    case internal::kAudioDecoder_SetDataSource_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::AudioDecoder::SetDataSource",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::AudioDecoder::SetDataSource");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AudioDecoder_SetDataSource_Params_Data* params =
          reinterpret_cast<internal::AudioDecoder_SetDataSource_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::ScopedDataPipeConsumerHandle p_receive_pipe{};
      AudioDecoder_SetDataSource_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_receive_pipe = input_data_view.TakeReceivePipe();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioDecoder::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDataSource(
std::move(p_receive_pipe));
      return true;
    }
    case internal::kAudioDecoder_Decode_Name: {
      break;
    }
    case internal::kAudioDecoder_Reset_Name: {
      break;
    }
  }
  return false;
}

// static
bool AudioDecoderStubDispatch::AcceptWithResponder(
    AudioDecoder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kAudioDecoder_Construct_Name: {
      break;
    }
    case internal::kAudioDecoder_Initialize_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::AudioDecoder::Initialize",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::AudioDecoder::Initialize");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::AudioDecoder_Initialize_Params_Data* params =
          reinterpret_cast<
              internal::AudioDecoder_Initialize_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::media::mojom::blink::AudioDecoderConfigPtr p_config{};
      absl::optional<::base::UnguessableToken> p_cdm_id{};
      AudioDecoder_Initialize_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfig(&p_config))
        success = false;
      if (success && !input_data_view.ReadCdmId(&p_cdm_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioDecoder::Name_, 1, false);
        return false;
      }
      AudioDecoder::InitializeCallback callback =
          AudioDecoder_Initialize_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Initialize(
std::move(p_config), 
std::move(p_cdm_id), std::move(callback));
      return true;
    }
    case internal::kAudioDecoder_SetDataSource_Name: {
      break;
    }
    case internal::kAudioDecoder_Decode_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::AudioDecoder::Decode",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::AudioDecoder::Decode");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::AudioDecoder_Decode_Params_Data* params =
          reinterpret_cast<
              internal::AudioDecoder_Decode_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::media::mojom::blink::DecoderBufferPtr p_buffer{};
      AudioDecoder_Decode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioDecoder::Name_, 3, false);
        return false;
      }
      AudioDecoder::DecodeCallback callback =
          AudioDecoder_Decode_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Decode(
std::move(p_buffer), std::move(callback));
      return true;
    }
    case internal::kAudioDecoder_Reset_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::AudioDecoder::Reset",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::AudioDecoder::Reset");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::AudioDecoder_Reset_Params_Data* params =
          reinterpret_cast<
              internal::AudioDecoder_Reset_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      AudioDecoder_Reset_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioDecoder::Name_, 4, false);
        return false;
      }
      AudioDecoder::ResetCallback callback =
          AudioDecoder_Reset_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Reset(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAudioDecoderValidationInfo[] = {
    {internal::kAudioDecoder_Construct_Name,
     {&internal::AudioDecoder_Construct_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAudioDecoder_Initialize_Name,
     {&internal::AudioDecoder_Initialize_Params_Data::Validate,
      &internal::AudioDecoder_Initialize_ResponseParams_Data::Validate}},
    {internal::kAudioDecoder_SetDataSource_Name,
     {&internal::AudioDecoder_SetDataSource_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAudioDecoder_Decode_Name,
     {&internal::AudioDecoder_Decode_Params_Data::Validate,
      &internal::AudioDecoder_Decode_ResponseParams_Data::Validate}},
    {internal::kAudioDecoder_Reset_Name,
     {&internal::AudioDecoder_Reset_Params_Data::Validate,
      &internal::AudioDecoder_Reset_ResponseParams_Data::Validate}},
};

bool AudioDecoderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::AudioDecoder::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kAudioDecoderValidationInfo);
}

bool AudioDecoderResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::AudioDecoder::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kAudioDecoderValidationInfo);

}
const char AudioDecoderClient::Name_[] = "media.mojom.AudioDecoderClient";

AudioDecoderClientProxy::AudioDecoderClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioDecoderClientProxy::OnBufferDecoded(
    ::media::mojom::blink::AudioBufferPtr in_buffer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::AudioDecoderClient::OnBufferDecoded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type ::media::mojom::blink::AudioBufferPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAudioDecoderClient_OnBufferDecoded_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioDecoderClient_OnBufferDecoded_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->buffer)::BaseType> buffer_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::AudioBufferDataView>(
      in_buffer, buffer_fragment);
  params->buffer.Set(
      buffer_fragment.is_null() ? nullptr : buffer_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->buffer.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null buffer in AudioDecoderClient.OnBufferDecoded request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioDecoderClient::Name_);
  message.set_method_name("OnBufferDecoded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AudioDecoderClientProxy::OnWaiting(
    ::media::mojom::blink::WaitingReason in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::AudioDecoderClient::OnWaiting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ::media::mojom::blink::WaitingReason>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAudioDecoderClient_OnWaiting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioDecoderClient_OnWaiting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::WaitingReason>(
      in_reason, &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioDecoderClient::Name_);
  message.set_method_name("OnWaiting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool AudioDecoderClientStubDispatch::Accept(
    AudioDecoderClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kAudioDecoderClient_OnBufferDecoded_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::AudioDecoderClient::OnBufferDecoded",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::AudioDecoderClient::OnBufferDecoded");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AudioDecoderClient_OnBufferDecoded_Params_Data* params =
          reinterpret_cast<internal::AudioDecoderClient_OnBufferDecoded_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::mojom::blink::AudioBufferPtr p_buffer{};
      AudioDecoderClient_OnBufferDecoded_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioDecoderClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBufferDecoded(
std::move(p_buffer));
      return true;
    }
    case internal::kAudioDecoderClient_OnWaiting_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::AudioDecoderClient::OnWaiting",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::AudioDecoderClient::OnWaiting");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AudioDecoderClient_OnWaiting_Params_Data* params =
          reinterpret_cast<internal::AudioDecoderClient_OnWaiting_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::mojom::blink::WaitingReason p_reason{};
      AudioDecoderClient_OnWaiting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioDecoderClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnWaiting(
std::move(p_reason));
      return true;
    }
  }
  return false;
}

// static
bool AudioDecoderClientStubDispatch::AcceptWithResponder(
    AudioDecoderClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kAudioDecoderClient_OnBufferDecoded_Name: {
      break;
    }
    case internal::kAudioDecoderClient_OnWaiting_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAudioDecoderClientValidationInfo[] = {
    {internal::kAudioDecoderClient_OnBufferDecoded_Name,
     {&internal::AudioDecoderClient_OnBufferDecoded_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAudioDecoderClient_OnWaiting_Name,
     {&internal::AudioDecoderClient_OnWaiting_Params_Data::Validate,
      nullptr /* no response */}},
};

bool AudioDecoderClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::AudioDecoderClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kAudioDecoderClientValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace media

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif