// media/mojo/mojom/content_decryption_module.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "media/mojo/mojom/content_decryption_module.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "media/mojo/mojom/decryptor.mojom.h"
#include "media/mojo/mojom/media_types.mojom.h"
#include "url/mojom/url.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"


#ifndef MEDIA_MOJO_MOJOM_CONTENT_DECRYPTION_MODULE_MOJOM_JUMBO_H_
#define MEDIA_MOJO_MOJOM_CONTENT_DECRYPTION_MODULE_MOJOM_JUMBO_H_
#endif


namespace media {
namespace mojom {


void ContentDecryptionModuleInterceptorForTesting::SetClient(::mojo::PendingAssociatedRemote<ContentDecryptionModuleClient> client) {
  GetForwardingInterface()->SetClient(std::move(client));
}
void ContentDecryptionModuleInterceptorForTesting::SetServerCertificate(const std::vector<uint8_t>& certificate_data, SetServerCertificateCallback callback) {
  GetForwardingInterface()->SetServerCertificate(std::move(certificate_data), std::move(callback));
}
void ContentDecryptionModuleInterceptorForTesting::GetStatusForPolicy(::media::HdcpVersion min_hdcp_version, GetStatusForPolicyCallback callback) {
  GetForwardingInterface()->GetStatusForPolicy(std::move(min_hdcp_version), std::move(callback));
}
void ContentDecryptionModuleInterceptorForTesting::CreateSessionAndGenerateRequest(::media::CdmSessionType session_type, ::media::EmeInitDataType init_data_type, const std::vector<uint8_t>& init_data, CreateSessionAndGenerateRequestCallback callback) {
  GetForwardingInterface()->CreateSessionAndGenerateRequest(std::move(session_type), std::move(init_data_type), std::move(init_data), std::move(callback));
}
void ContentDecryptionModuleInterceptorForTesting::LoadSession(::media::CdmSessionType session_type, const std::string& session_id, LoadSessionCallback callback) {
  GetForwardingInterface()->LoadSession(std::move(session_type), std::move(session_id), std::move(callback));
}
void ContentDecryptionModuleInterceptorForTesting::UpdateSession(const std::string& session_id, const std::vector<uint8_t>& response, UpdateSessionCallback callback) {
  GetForwardingInterface()->UpdateSession(std::move(session_id), std::move(response), std::move(callback));
}
void ContentDecryptionModuleInterceptorForTesting::CloseSession(const std::string& session_id, CloseSessionCallback callback) {
  GetForwardingInterface()->CloseSession(std::move(session_id), std::move(callback));
}
void ContentDecryptionModuleInterceptorForTesting::RemoveSession(const std::string& session_id, RemoveSessionCallback callback) {
  GetForwardingInterface()->RemoveSession(std::move(session_id), std::move(callback));
}
ContentDecryptionModuleAsyncWaiter::ContentDecryptionModuleAsyncWaiter(
    ContentDecryptionModule* proxy) : proxy_(proxy) {}

ContentDecryptionModuleAsyncWaiter::~ContentDecryptionModuleAsyncWaiter() = default;

void ContentDecryptionModuleAsyncWaiter::SetServerCertificate(
    const std::vector<uint8_t>& certificate_data, CdmPromiseResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->SetServerCertificate(std::move(certificate_data),
      base::BindOnce(
          [](base::RunLoop* loop,
             CdmPromiseResultPtr* out_result
,
             CdmPromiseResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}
void ContentDecryptionModuleAsyncWaiter::GetStatusForPolicy(
    ::media::HdcpVersion min_hdcp_version, CdmPromiseResultPtr* out_result, ::media::CdmKeyInformation::KeyStatus* out_key_status) {
  base::RunLoop loop;
  proxy_->GetStatusForPolicy(std::move(min_hdcp_version),
      base::BindOnce(
          [](base::RunLoop* loop,
             CdmPromiseResultPtr* out_result
,
             ::media::CdmKeyInformation::KeyStatus* out_key_status
,
             CdmPromiseResultPtr result,
             ::media::CdmKeyInformation::KeyStatus key_status) {*out_result = std::move(result);*out_key_status = std::move(key_status);
            loop->Quit();
          },
          &loop,
          out_result,
          out_key_status));
  loop.Run();
}
void ContentDecryptionModuleAsyncWaiter::CreateSessionAndGenerateRequest(
    ::media::CdmSessionType session_type, ::media::EmeInitDataType init_data_type, const std::vector<uint8_t>& init_data, CdmPromiseResultPtr* out_result, std::string* out_session_id) {
  base::RunLoop loop;
  proxy_->CreateSessionAndGenerateRequest(std::move(session_type),std::move(init_data_type),std::move(init_data),
      base::BindOnce(
          [](base::RunLoop* loop,
             CdmPromiseResultPtr* out_result
,
             std::string* out_session_id
,
             CdmPromiseResultPtr result,
             const std::string& session_id) {*out_result = std::move(result);*out_session_id = std::move(session_id);
            loop->Quit();
          },
          &loop,
          out_result,
          out_session_id));
  loop.Run();
}
void ContentDecryptionModuleAsyncWaiter::LoadSession(
    ::media::CdmSessionType session_type, const std::string& session_id, CdmPromiseResultPtr* out_result, std::string* out_session_id) {
  base::RunLoop loop;
  proxy_->LoadSession(std::move(session_type),std::move(session_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             CdmPromiseResultPtr* out_result
,
             std::string* out_session_id
,
             CdmPromiseResultPtr result,
             const std::string& session_id) {*out_result = std::move(result);*out_session_id = std::move(session_id);
            loop->Quit();
          },
          &loop,
          out_result,
          out_session_id));
  loop.Run();
}
void ContentDecryptionModuleAsyncWaiter::UpdateSession(
    const std::string& session_id, const std::vector<uint8_t>& response, CdmPromiseResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->UpdateSession(std::move(session_id),std::move(response),
      base::BindOnce(
          [](base::RunLoop* loop,
             CdmPromiseResultPtr* out_result
,
             CdmPromiseResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}
void ContentDecryptionModuleAsyncWaiter::CloseSession(
    const std::string& session_id, CdmPromiseResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->CloseSession(std::move(session_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             CdmPromiseResultPtr* out_result
,
             CdmPromiseResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}
void ContentDecryptionModuleAsyncWaiter::RemoveSession(
    const std::string& session_id, CdmPromiseResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->RemoveSession(std::move(session_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             CdmPromiseResultPtr* out_result
,
             CdmPromiseResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}



void ContentDecryptionModuleClientInterceptorForTesting::OnSessionMessage(const std::string& session_id, ::media::CdmMessageType message_type, const std::vector<uint8_t>& message) {
  GetForwardingInterface()->OnSessionMessage(std::move(session_id), std::move(message_type), std::move(message));
}
void ContentDecryptionModuleClientInterceptorForTesting::OnSessionClosed(const std::string& session_id, ::media::CdmSessionClosedReason reason) {
  GetForwardingInterface()->OnSessionClosed(std::move(session_id), std::move(reason));
}
void ContentDecryptionModuleClientInterceptorForTesting::OnSessionKeysChange(const std::string& session_id, bool has_additional_usable_key, std::vector<::std::unique_ptr<::media::CdmKeyInformation>> keys_info) {
  GetForwardingInterface()->OnSessionKeysChange(std::move(session_id), std::move(has_additional_usable_key), std::move(keys_info));
}
void ContentDecryptionModuleClientInterceptorForTesting::OnSessionExpirationUpdate(const std::string& session_id, double new_expiry_time_sec) {
  GetForwardingInterface()->OnSessionExpirationUpdate(std::move(session_id), std::move(new_expiry_time_sec));
}
ContentDecryptionModuleClientAsyncWaiter::ContentDecryptionModuleClientAsyncWaiter(
    ContentDecryptionModuleClient* proxy) : proxy_(proxy) {}

ContentDecryptionModuleClientAsyncWaiter::~ContentDecryptionModuleClientAsyncWaiter() = default;




void CdmFactoryInterceptorForTesting::CreateCdm(const std::string& key_system, const ::media::CdmConfig& cdm_config, CreateCdmCallback callback) {
  GetForwardingInterface()->CreateCdm(std::move(key_system), std::move(cdm_config), std::move(callback));
}
CdmFactoryAsyncWaiter::CdmFactoryAsyncWaiter(
    CdmFactory* proxy) : proxy_(proxy) {}

CdmFactoryAsyncWaiter::~CdmFactoryAsyncWaiter() = default;

void CdmFactoryAsyncWaiter::CreateCdm(
    const std::string& key_system, const ::media::CdmConfig& cdm_config, ::mojo::PendingRemote<ContentDecryptionModule>* out_cdm, CdmContextPtr* out_cdm_context, std::string* out_error_message) {
  base::RunLoop loop;
  proxy_->CreateCdm(std::move(key_system),std::move(cdm_config),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingRemote<ContentDecryptionModule>* out_cdm
,
             CdmContextPtr* out_cdm_context
,
             std::string* out_error_message
,
             ::mojo::PendingRemote<ContentDecryptionModule> cdm,
             CdmContextPtr cdm_context,
             const std::string& error_message) {*out_cdm = std::move(cdm);*out_cdm_context = std::move(cdm_context);*out_error_message = std::move(error_message);
            loop->Quit();
          },
          &loop,
          out_cdm,
          out_cdm_context,
          out_error_message));
  loop.Run();
}





}  // namespace mojom
}  // namespace media

#if defined(__clang__)
#pragma clang diagnostic pop
#endif