// media/mojo/mojom/interface_factory.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/interface_factory.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/interface_factory.mojom-params-data.h"
#include "media/mojo/mojom/interface_factory.mojom-shared-message-ids.h"

#include "media/mojo/mojom/interface_factory.mojom-import-headers.h"


#ifndef MEDIA_MOJO_MOJOM_INTERFACE_FACTORY_MOJOM_JUMBO_H_
#define MEDIA_MOJO_MOJOM_INTERFACE_FACTORY_MOJOM_JUMBO_H_
#endif
namespace media {
namespace mojom {
const char InterfaceFactory::Name_[] = "media.mojom.InterfaceFactory";

class InterfaceFactory_CreateCdm_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  InterfaceFactory_CreateCdm_ForwardToCallback(
      InterfaceFactory::CreateCdmCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  InterfaceFactory::CreateCdmCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(InterfaceFactory_CreateCdm_ForwardToCallback);
};

InterfaceFactoryProxy::InterfaceFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void InterfaceFactoryProxy::CreateAudioDecoder(
    ::mojo::PendingReceiver<::media::mojom::AudioDecoder> in_audio_decoder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::InterfaceFactory::CreateAudioDecoder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio_decoder"), in_audio_decoder,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::AudioDecoder>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kInterfaceFactory_CreateAudioDecoder_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::InterfaceFactory_CreateAudioDecoder_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::AudioDecoderInterfaceBase>>(
      in_audio_decoder, &params->audio_decoder, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->audio_decoder),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid audio_decoder in InterfaceFactory.CreateAudioDecoder request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InterfaceFactory::Name_);
  message.set_method_name("CreateAudioDecoder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void InterfaceFactoryProxy::CreateVideoDecoder(
    ::mojo::PendingReceiver<::media::mojom::VideoDecoder> in_video_decoder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::InterfaceFactory::CreateVideoDecoder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("video_decoder"), in_video_decoder,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::VideoDecoder>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kInterfaceFactory_CreateVideoDecoder_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::InterfaceFactory_CreateVideoDecoder_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::VideoDecoderInterfaceBase>>(
      in_video_decoder, &params->video_decoder, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->video_decoder),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid video_decoder in InterfaceFactory.CreateVideoDecoder request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InterfaceFactory::Name_);
  message.set_method_name("CreateVideoDecoder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void InterfaceFactoryProxy::CreateDefaultRenderer(
    const std::string& in_audio_device_id, ::mojo::PendingReceiver<::media::mojom::Renderer> in_renderer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::InterfaceFactory::CreateDefaultRenderer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio_device_id"), in_audio_device_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("renderer"), in_renderer,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::Renderer>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kInterfaceFactory_CreateDefaultRenderer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::InterfaceFactory_CreateDefaultRenderer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->audio_device_id)::BaseType> audio_device_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_audio_device_id, audio_device_id_fragment);
  params->audio_device_id.Set(
      audio_device_id_fragment.is_null() ? nullptr : audio_device_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->audio_device_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null audio_device_id in InterfaceFactory.CreateDefaultRenderer request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::RendererInterfaceBase>>(
      in_renderer, &params->renderer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->renderer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid renderer in InterfaceFactory.CreateDefaultRenderer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InterfaceFactory::Name_);
  message.set_method_name("CreateDefaultRenderer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void InterfaceFactoryProxy::CreateCdm(
    const std::string& in_key_system, const ::media::CdmConfig& in_cdm_config, CreateCdmCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::InterfaceFactory::CreateCdm", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_system"), in_key_system,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cdm_config"), in_cdm_config,
                        "<value of type const ::media::CdmConfig&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kInterfaceFactory_CreateCdm_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::InterfaceFactory_CreateCdm_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key_system)::BaseType> key_system_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_key_system, key_system_fragment);
  params->key_system.Set(
      key_system_fragment.is_null() ? nullptr : key_system_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key_system.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_system in InterfaceFactory.CreateCdm request");
  mojo::internal::MessageFragment<
      typename decltype(params->cdm_config)::BaseType> cdm_config_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::CdmConfigDataView>(
      in_cdm_config, cdm_config_fragment);
  params->cdm_config.Set(
      cdm_config_fragment.is_null() ? nullptr : cdm_config_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cdm_config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cdm_config in InterfaceFactory.CreateCdm request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InterfaceFactory::Name_);
  message.set_method_name("CreateCdm");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new InterfaceFactory_CreateCdm_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class InterfaceFactory_CreateCdm_ProxyToResponder {
 public:
  static InterfaceFactory::CreateCdmCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<InterfaceFactory_CreateCdm_ProxyToResponder> proxy(
        new InterfaceFactory_CreateCdm_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&InterfaceFactory_CreateCdm_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~InterfaceFactory_CreateCdm_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  InterfaceFactory_CreateCdm_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "InterfaceFactory::CreateCdmCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingRemote<::media::mojom::ContentDecryptionModule> in_cdm, ::media::mojom::CdmContextPtr in_cdm_context, const std::string& in_error_message);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(InterfaceFactory_CreateCdm_ProxyToResponder);
};

bool InterfaceFactory_CreateCdm_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::InterfaceFactory::CreateCdmCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::InterfaceFactory_CreateCdm_ResponseParams_Data* params =
      reinterpret_cast<
          internal::InterfaceFactory_CreateCdm_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::mojo::PendingRemote<::media::mojom::ContentDecryptionModule> p_cdm{};
  ::media::mojom::CdmContextPtr p_cdm_context{};
  std::string p_error_message{};
  InterfaceFactory_CreateCdm_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_cdm =
        input_data_view.TakeCdm<decltype(p_cdm)>();
  }
  if (success && !input_data_view.ReadCdmContext(&p_cdm_context))
    success = false;
  if (success && !input_data_view.ReadErrorMessage(&p_error_message))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        InterfaceFactory::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_cdm), 
std::move(p_cdm_context), 
std::move(p_error_message));
  return true;
}

void InterfaceFactory_CreateCdm_ProxyToResponder::Run(
    ::mojo::PendingRemote<::media::mojom::ContentDecryptionModule> in_cdm, ::media::mojom::CdmContextPtr in_cdm_context, const std::string& in_error_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::InterfaceFactory::CreateCdmCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cdm"), in_cdm,
                        "<value of type ::mojo::PendingRemote<::media::mojom::ContentDecryptionModule>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cdm_context"), in_cdm_context,
                        "<value of type ::media::mojom::CdmContextPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message,
                        "<value of type const std::string&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kInterfaceFactory_CreateCdm_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::InterfaceFactory_CreateCdm_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::ContentDecryptionModuleInterfaceBase>>(
      in_cdm, &params->cdm, &params.message());
  mojo::internal::MessageFragment<
      typename decltype(params->cdm_context)::BaseType> cdm_context_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::CdmContextDataView>(
      in_cdm_context, cdm_context_fragment);
  params->cdm_context.Set(
      cdm_context_fragment.is_null() ? nullptr : cdm_context_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error_message, error_message_fragment);
  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error_message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error_message in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::InterfaceFactory::CreateCdmCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InterfaceFactory::Name_);
  message.set_method_name("CreateCdm");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool InterfaceFactoryStubDispatch::Accept(
    InterfaceFactory* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kInterfaceFactory_CreateAudioDecoder_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::InterfaceFactory::CreateAudioDecoder",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::InterfaceFactory::CreateAudioDecoder");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::InterfaceFactory_CreateAudioDecoder_Params_Data* params =
          reinterpret_cast<internal::InterfaceFactory_CreateAudioDecoder_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::AudioDecoder> p_audio_decoder{};
      InterfaceFactory_CreateAudioDecoder_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_audio_decoder =
            input_data_view.TakeAudioDecoder<decltype(p_audio_decoder)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            InterfaceFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateAudioDecoder(
std::move(p_audio_decoder));
      return true;
    }
    case internal::kInterfaceFactory_CreateVideoDecoder_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::InterfaceFactory::CreateVideoDecoder",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::InterfaceFactory::CreateVideoDecoder");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::InterfaceFactory_CreateVideoDecoder_Params_Data* params =
          reinterpret_cast<internal::InterfaceFactory_CreateVideoDecoder_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::VideoDecoder> p_video_decoder{};
      InterfaceFactory_CreateVideoDecoder_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_video_decoder =
            input_data_view.TakeVideoDecoder<decltype(p_video_decoder)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            InterfaceFactory::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateVideoDecoder(
std::move(p_video_decoder));
      return true;
    }
    case internal::kInterfaceFactory_CreateDefaultRenderer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::InterfaceFactory::CreateDefaultRenderer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::InterfaceFactory::CreateDefaultRenderer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::InterfaceFactory_CreateDefaultRenderer_Params_Data* params =
          reinterpret_cast<internal::InterfaceFactory_CreateDefaultRenderer_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_audio_device_id{};
      ::mojo::PendingReceiver<::media::mojom::Renderer> p_renderer{};
      InterfaceFactory_CreateDefaultRenderer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAudioDeviceId(&p_audio_device_id))
        success = false;
      if (success) {
        p_renderer =
            input_data_view.TakeRenderer<decltype(p_renderer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            InterfaceFactory::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateDefaultRenderer(
std::move(p_audio_device_id), 
std::move(p_renderer));
      return true;
    }
    case internal::kInterfaceFactory_CreateCdm_Name: {
      break;
    }
  }
  return false;
}

// static
bool InterfaceFactoryStubDispatch::AcceptWithResponder(
    InterfaceFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kInterfaceFactory_CreateAudioDecoder_Name: {
      break;
    }
    case internal::kInterfaceFactory_CreateVideoDecoder_Name: {
      break;
    }
    case internal::kInterfaceFactory_CreateDefaultRenderer_Name: {
      break;
    }
    case internal::kInterfaceFactory_CreateCdm_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::InterfaceFactory::CreateCdm",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::InterfaceFactory::CreateCdm");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::InterfaceFactory_CreateCdm_Params_Data* params =
          reinterpret_cast<
              internal::InterfaceFactory_CreateCdm_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_key_system{};
      ::media::CdmConfig p_cdm_config{};
      InterfaceFactory_CreateCdm_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKeySystem(&p_key_system))
        success = false;
      if (success && !input_data_view.ReadCdmConfig(&p_cdm_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            InterfaceFactory::Name_, 3, false);
        return false;
      }
      InterfaceFactory::CreateCdmCallback callback =
          InterfaceFactory_CreateCdm_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateCdm(
std::move(p_key_system), 
std::move(p_cdm_config), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kInterfaceFactoryValidationInfo[] = {
    {internal::kInterfaceFactory_CreateAudioDecoder_Name,
     {&internal::InterfaceFactory_CreateAudioDecoder_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kInterfaceFactory_CreateVideoDecoder_Name,
     {&internal::InterfaceFactory_CreateVideoDecoder_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kInterfaceFactory_CreateDefaultRenderer_Name,
     {&internal::InterfaceFactory_CreateDefaultRenderer_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kInterfaceFactory_CreateCdm_Name,
     {&internal::InterfaceFactory_CreateCdm_Params_Data::Validate,
      &internal::InterfaceFactory_CreateCdm_ResponseParams_Data::Validate}},
};

bool InterfaceFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::InterfaceFactory::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kInterfaceFactoryValidationInfo);
}

bool InterfaceFactoryResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::InterfaceFactory::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kInterfaceFactoryValidationInfo);

}
}  // namespace mojom
}  // namespace media

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif