// media/mojo/mojom/media_log.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/media_log.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/media_log.mojom-params-data.h"
#include "media/mojo/mojom/media_log.mojom-shared-message-ids.h"

#include "media/mojo/mojom/media_log.mojom-import-headers.h"


#ifndef MEDIA_MOJO_MOJOM_MEDIA_LOG_MOJOM_JUMBO_H_
#define MEDIA_MOJO_MOJOM_MEDIA_LOG_MOJOM_JUMBO_H_
#endif
namespace media {
namespace mojom {
const char MediaLog::Name_[] = "media.mojom.MediaLog";

MediaLogProxy::MediaLogProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaLogProxy::AddLogRecord(
    const ::media::MediaLogRecord& in_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaLog::AddLogRecord", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type const ::media::MediaLogRecord&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaLog_AddLogRecord_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaLog_AddLogRecord_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::MediaLogRecordDataView>(
      in_event, event_fragment);
  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->event.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null event in MediaLog.AddLogRecord request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaLog::Name_);
  message.set_method_name("AddLogRecord");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool MediaLogStubDispatch::Accept(
    MediaLog* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kMediaLog_AddLogRecord_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaLog::AddLogRecord",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaLog::AddLogRecord");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaLog_AddLogRecord_Params_Data* params =
          reinterpret_cast<internal::MediaLog_AddLogRecord_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::MediaLogRecord p_event{};
      MediaLog_AddLogRecord_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaLog::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddLogRecord(
std::move(p_event));
      return true;
    }
  }
  return false;
}

// static
bool MediaLogStubDispatch::AcceptWithResponder(
    MediaLog* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kMediaLog_AddLogRecord_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kMediaLogValidationInfo[] = {
    {internal::kMediaLog_AddLogRecord_Name,
     {&internal::MediaLog_AddLogRecord_Params_Data::Validate,
      nullptr /* no response */}},
};

bool MediaLogRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::MediaLog::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kMediaLogValidationInfo);
}

}  // namespace mojom
}  // namespace media

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif