// media/mojo/mojom/remoting.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/mojo/mojom/remoting.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/remoting.mojom-params-data.h"
namespace media {
namespace mojom {

namespace internal {


// static
bool RemoterFactory_Create_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoterFactory_Create_Params_Data* object = static_cast<const RemoterFactory_Create_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->source, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->source,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->remoter, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->remoter,
                                                 validation_context)) {
    return false;
  }

  return true;
}

RemoterFactory_Create_Params_Data::RemoterFactory_Create_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemotingDataStreamSender_SendFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemotingDataStreamSender_SendFrame_Params_Data* object = static_cast<const RemotingDataStreamSender_SendFrame_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RemotingDataStreamSender_SendFrame_Params_Data::RemotingDataStreamSender_SendFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemotingDataStreamSender_CancelInFlightData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemotingDataStreamSender_CancelInFlightData_Params_Data* object = static_cast<const RemotingDataStreamSender_CancelInFlightData_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RemotingDataStreamSender_CancelInFlightData_Params_Data::RemotingDataStreamSender_CancelInFlightData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Remoter_Start_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Remoter_Start_Params_Data* object = static_cast<const Remoter_Start_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Remoter_Start_Params_Data::Remoter_Start_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Remoter_StartDataStreams_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Remoter_StartDataStreams_Params_Data* object = static_cast<const Remoter_StartDataStreams_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterface(object->audio_pipe,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->video_pipe,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->audio_sender,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->video_sender,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Remoter_StartDataStreams_Params_Data::Remoter_StartDataStreams_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Remoter_Stop_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Remoter_Stop_Params_Data* object = static_cast<const Remoter_Stop_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::media::mojom::internal::RemotingStopReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  return true;
}

Remoter_Stop_Params_Data::Remoter_Stop_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Remoter_SendMessageToSink_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Remoter_SendMessageToSink_Params_Data* object = static_cast<const Remoter_SendMessageToSink_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams message_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

Remoter_SendMessageToSink_Params_Data::Remoter_SendMessageToSink_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Remoter_EstimateTransmissionCapacity_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Remoter_EstimateTransmissionCapacity_Params_Data* object = static_cast<const Remoter_EstimateTransmissionCapacity_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Remoter_EstimateTransmissionCapacity_Params_Data::Remoter_EstimateTransmissionCapacity_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Remoter_EstimateTransmissionCapacity_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Remoter_EstimateTransmissionCapacity_ResponseParams_Data* object = static_cast<const Remoter_EstimateTransmissionCapacity_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Remoter_EstimateTransmissionCapacity_ResponseParams_Data::Remoter_EstimateTransmissionCapacity_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemotingSource_OnSinkAvailable_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemotingSource_OnSinkAvailable_Params_Data* object = static_cast<const RemotingSource_OnSinkAvailable_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->metadata, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->metadata, validation_context))
    return false;

  return true;
}

RemotingSource_OnSinkAvailable_Params_Data::RemotingSource_OnSinkAvailable_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemotingSource_OnSinkGone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemotingSource_OnSinkGone_Params_Data* object = static_cast<const RemotingSource_OnSinkGone_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RemotingSource_OnSinkGone_Params_Data::RemotingSource_OnSinkGone_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemotingSource_OnStarted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemotingSource_OnStarted_Params_Data* object = static_cast<const RemotingSource_OnStarted_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RemotingSource_OnStarted_Params_Data::RemotingSource_OnStarted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemotingSource_OnStartFailed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemotingSource_OnStartFailed_Params_Data* object = static_cast<const RemotingSource_OnStartFailed_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::media::mojom::internal::RemotingStartFailReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  return true;
}

RemotingSource_OnStartFailed_Params_Data::RemotingSource_OnStartFailed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemotingSource_OnMessageFromSink_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemotingSource_OnMessageFromSink_Params_Data* object = static_cast<const RemotingSource_OnMessageFromSink_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams message_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

RemotingSource_OnMessageFromSink_Params_Data::RemotingSource_OnMessageFromSink_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemotingSource_OnStopped_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemotingSource_OnStopped_Params_Data* object = static_cast<const RemotingSource_OnStopped_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::media::mojom::internal::RemotingStopReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  return true;
}

RemotingSource_OnStopped_Params_Data::RemotingSource_OnStopped_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Remotee_OnRemotingSinkReady_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Remotee_OnRemotingSinkReady_Params_Data* object = static_cast<const Remotee_OnRemotingSinkReady_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->sink, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->sink,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Remotee_OnRemotingSinkReady_Params_Data::Remotee_OnRemotingSinkReady_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Remotee_SendMessageToSource_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Remotee_SendMessageToSource_Params_Data* object = static_cast<const Remotee_SendMessageToSource_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams message_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

Remotee_SendMessageToSource_Params_Data::Remotee_SendMessageToSource_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Remotee_StartDataStreams_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Remotee_StartDataStreams_Params_Data* object = static_cast<const Remotee_StartDataStreams_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterface(object->audio_stream,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->video_stream,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Remotee_StartDataStreams_Params_Data::Remotee_StartDataStreams_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Remotee_OnFlushUntil_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Remotee_OnFlushUntil_Params_Data* object = static_cast<const Remotee_OnFlushUntil_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Remotee_OnFlushUntil_Params_Data::Remotee_OnFlushUntil_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Remotee_OnVideoNaturalSizeChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Remotee_OnVideoNaturalSizeChange_Params_Data* object = static_cast<const Remotee_OnVideoNaturalSizeChange_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->size, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->size, validation_context))
    return false;

  return true;
}

Remotee_OnVideoNaturalSizeChange_Params_Data::Remotee_OnVideoNaturalSizeChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemotingSink_OnMessageFromSource_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemotingSink_OnMessageFromSource_Params_Data* object = static_cast<const RemotingSink_OnMessageFromSource_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams message_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

RemotingSink_OnMessageFromSource_Params_Data::RemotingSink_OnMessageFromSource_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemotingDataStreamReceiver_InitializeDataPipe_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemotingDataStreamReceiver_InitializeDataPipe_Params_Data* object = static_cast<const RemotingDataStreamReceiver_InitializeDataPipe_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->data_pipe, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->data_pipe,
                                                 validation_context)) {
    return false;
  }

  return true;
}

RemotingDataStreamReceiver_InitializeDataPipe_Params_Data::RemotingDataStreamReceiver_InitializeDataPipe_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemotingDataStreamReceiver_ReceiveFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemotingDataStreamReceiver_ReceiveFrame_Params_Data* object = static_cast<const RemotingDataStreamReceiver_ReceiveFrame_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->buffer, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->buffer, validation_context))
    return false;

  return true;
}

RemotingDataStreamReceiver_ReceiveFrame_Params_Data::RemotingDataStreamReceiver_ReceiveFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemotingDataStreamReceiver_FlushUntil_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemotingDataStreamReceiver_FlushUntil_Params_Data* object = static_cast<const RemotingDataStreamReceiver_FlushUntil_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RemotingDataStreamReceiver_FlushUntil_Params_Data::RemotingDataStreamReceiver_FlushUntil_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media
