// media/mojo/mojom/remoting.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "media/mojo/mojom/remoting.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "media/mojo/mojom/media_types.mojom.h"
#include "media/mojo/mojom/remoting_common.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"


#ifndef MEDIA_MOJO_MOJOM_REMOTING_MOJOM_JUMBO_H_
#define MEDIA_MOJO_MOJOM_REMOTING_MOJOM_JUMBO_H_
#endif


namespace media {
namespace mojom {


void RemoterFactoryInterceptorForTesting::Create(::mojo::PendingRemote<RemotingSource> source, ::mojo::PendingReceiver<Remoter> remoter) {
  GetForwardingInterface()->Create(std::move(source), std::move(remoter));
}
RemoterFactoryAsyncWaiter::RemoterFactoryAsyncWaiter(
    RemoterFactory* proxy) : proxy_(proxy) {}

RemoterFactoryAsyncWaiter::~RemoterFactoryAsyncWaiter() = default;




void RemotingDataStreamSenderInterceptorForTesting::SendFrame(uint32_t frame_size) {
  GetForwardingInterface()->SendFrame(std::move(frame_size));
}
void RemotingDataStreamSenderInterceptorForTesting::CancelInFlightData() {
  GetForwardingInterface()->CancelInFlightData();
}
RemotingDataStreamSenderAsyncWaiter::RemotingDataStreamSenderAsyncWaiter(
    RemotingDataStreamSender* proxy) : proxy_(proxy) {}

RemotingDataStreamSenderAsyncWaiter::~RemotingDataStreamSenderAsyncWaiter() = default;




void RemoterInterceptorForTesting::Start() {
  GetForwardingInterface()->Start();
}
void RemoterInterceptorForTesting::StartDataStreams(::mojo::ScopedDataPipeConsumerHandle audio_pipe, ::mojo::ScopedDataPipeConsumerHandle video_pipe, ::mojo::PendingReceiver<RemotingDataStreamSender> audio_sender, ::mojo::PendingReceiver<RemotingDataStreamSender> video_sender) {
  GetForwardingInterface()->StartDataStreams(std::move(audio_pipe), std::move(video_pipe), std::move(audio_sender), std::move(video_sender));
}
void RemoterInterceptorForTesting::Stop(::media::mojom::RemotingStopReason reason) {
  GetForwardingInterface()->Stop(std::move(reason));
}
void RemoterInterceptorForTesting::SendMessageToSink(const std::vector<uint8_t>& message) {
  GetForwardingInterface()->SendMessageToSink(std::move(message));
}
void RemoterInterceptorForTesting::EstimateTransmissionCapacity(EstimateTransmissionCapacityCallback callback) {
  GetForwardingInterface()->EstimateTransmissionCapacity(std::move(callback));
}
RemoterAsyncWaiter::RemoterAsyncWaiter(
    Remoter* proxy) : proxy_(proxy) {}

RemoterAsyncWaiter::~RemoterAsyncWaiter() = default;

void RemoterAsyncWaiter::EstimateTransmissionCapacity(
    double* out_rate) {
  base::RunLoop loop;
  proxy_->EstimateTransmissionCapacity(
      base::BindOnce(
          [](base::RunLoop* loop,
             double* out_rate
,
             double rate) {*out_rate = std::move(rate);
            loop->Quit();
          },
          &loop,
          out_rate));
  loop.Run();
}



void RemotingSourceInterceptorForTesting::OnSinkAvailable(::media::mojom::RemotingSinkMetadataPtr metadata) {
  GetForwardingInterface()->OnSinkAvailable(std::move(metadata));
}
void RemotingSourceInterceptorForTesting::OnSinkGone() {
  GetForwardingInterface()->OnSinkGone();
}
void RemotingSourceInterceptorForTesting::OnStarted() {
  GetForwardingInterface()->OnStarted();
}
void RemotingSourceInterceptorForTesting::OnStartFailed(::media::mojom::RemotingStartFailReason reason) {
  GetForwardingInterface()->OnStartFailed(std::move(reason));
}
void RemotingSourceInterceptorForTesting::OnMessageFromSink(const std::vector<uint8_t>& message) {
  GetForwardingInterface()->OnMessageFromSink(std::move(message));
}
void RemotingSourceInterceptorForTesting::OnStopped(::media::mojom::RemotingStopReason reason) {
  GetForwardingInterface()->OnStopped(std::move(reason));
}
RemotingSourceAsyncWaiter::RemotingSourceAsyncWaiter(
    RemotingSource* proxy) : proxy_(proxy) {}

RemotingSourceAsyncWaiter::~RemotingSourceAsyncWaiter() = default;




void RemoteeInterceptorForTesting::OnRemotingSinkReady(::mojo::PendingRemote<RemotingSink> sink) {
  GetForwardingInterface()->OnRemotingSinkReady(std::move(sink));
}
void RemoteeInterceptorForTesting::SendMessageToSource(const std::vector<uint8_t>& message) {
  GetForwardingInterface()->SendMessageToSource(std::move(message));
}
void RemoteeInterceptorForTesting::StartDataStreams(::mojo::PendingRemote<RemotingDataStreamReceiver> audio_stream, ::mojo::PendingRemote<RemotingDataStreamReceiver> video_stream) {
  GetForwardingInterface()->StartDataStreams(std::move(audio_stream), std::move(video_stream));
}
void RemoteeInterceptorForTesting::OnFlushUntil(uint32_t audio_frame_count, uint32_t video_frame_count) {
  GetForwardingInterface()->OnFlushUntil(std::move(audio_frame_count), std::move(video_frame_count));
}
void RemoteeInterceptorForTesting::OnVideoNaturalSizeChange(const ::gfx::Size& size) {
  GetForwardingInterface()->OnVideoNaturalSizeChange(std::move(size));
}
RemoteeAsyncWaiter::RemoteeAsyncWaiter(
    Remotee* proxy) : proxy_(proxy) {}

RemoteeAsyncWaiter::~RemoteeAsyncWaiter() = default;




void RemotingSinkInterceptorForTesting::OnMessageFromSource(const std::vector<uint8_t>& message) {
  GetForwardingInterface()->OnMessageFromSource(std::move(message));
}
RemotingSinkAsyncWaiter::RemotingSinkAsyncWaiter(
    RemotingSink* proxy) : proxy_(proxy) {}

RemotingSinkAsyncWaiter::~RemotingSinkAsyncWaiter() = default;




void RemotingDataStreamReceiverInterceptorForTesting::InitializeDataPipe(::mojo::ScopedDataPipeConsumerHandle data_pipe) {
  GetForwardingInterface()->InitializeDataPipe(std::move(data_pipe));
}
void RemotingDataStreamReceiverInterceptorForTesting::ReceiveFrame(uint32_t frame_count, ::media::mojom::DecoderBufferPtr buffer) {
  GetForwardingInterface()->ReceiveFrame(std::move(frame_count), std::move(buffer));
}
void RemotingDataStreamReceiverInterceptorForTesting::FlushUntil(uint32_t frame_count) {
  GetForwardingInterface()->FlushUntil(std::move(frame_count));
}
RemotingDataStreamReceiverAsyncWaiter::RemotingDataStreamReceiverAsyncWaiter(
    RemotingDataStreamReceiver* proxy) : proxy_(proxy) {}

RemotingDataStreamReceiverAsyncWaiter::~RemotingDataStreamReceiverAsyncWaiter() = default;






}  // namespace mojom
}  // namespace media

#if defined(__clang__)
#pragma clang diagnostic pop
#endif